'\"
'\" Copyright (c) 2018 Alastair D'Silva
'\" (alastair@d-silva.org)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package.
'\" InfernoEmbedded Softdevices
'\"
'\" Free for all use. No warranty. None. Use at your own risk.
'\"
.TH InfernoEmbedded 3  2018 "OWFS Manpage" "One-Wire File System"
.SH NAME
.TP
.B InfernoEmbedded Softdevices
\- RGBW Controllers
\- Switch Masters
\- Firmware Updater
.SH SYNOPSIS
Software-implemented devices based on https://github.com/InfernoEmbedded/onewire-softdevice
.PP
.B ED
[.]XXXXXXXXXXXX[XX][/[
.B device
|
.B version
|
.B status
|
.B enter_firmware_update
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I ED
.SH GENERIC PROPERTIES
These properties are applicable to all Inferno Embedded softdevices.
.SS device
.I read-only, ascii text
.br
The type of InfernoEmbedded Softdevice detected.
.SS version
.I read-only, integer
.br
The version number reported by the device.
.SS status
.I read-only, integer
.br
The 64 bit status register of the device.
.SS enter_firmware_update
.I write-only, yes-no
.br
Write anything to reboot the device into the bootloader for firmware update. This may also be forced if you have physical access to the device by shorting SWCLK to ground on the device's programming header when powering up the device.

.SH FIRMWARE UPDATER PROPERTIES
These properties are available when the device has entered firmware update mode.

.SS firmware_bootloader_size
.I read-only, integer
.br
The reserved size for the bootloader.
.SS firmware_range
.I read-only, ascii text
.br
The range of addresses available for the application (0xNNNN-0xNNNN).
.SS erase_firmware
.I write-only, yes-no
.br
Write anything to erase the current application and prepare the device to accept a new firmware.
.SS update_firmware
.I write-only, binary data
.br
Write the binary data for a firmware update here to reprogram the device after erasing.
.SS exit_firmware_update
.I write-only, yes-no
.br
Write anything to exit firmware update and start the application.

.SH RGBW CONTROLLER PROPERTIES
These controllers control a number of channels of RGBW lights.
.SS rgbw_all_off
.I write-only, yes-no
.br
Write anything to turn off all channels
.SS rgbw_channels
.I read-only, integer
.br
The number of RGBW channels supported by this device.
.SS rgbw_channelNN
.I read-write, ascii text
.br
Set the current value of channel NN, as:
RRR,GGG,BBB,WWW,nnn  where:
  RRR,GGG,BBB,WWW is the red, green, blue values respectively (0-255)
  nnn is the time to fade from the current colour to the new one, in milliseconds (0-16M). On read, this is time remaining for the current fade to complete.

.SH SWITCH MASTERS
These devices have a number of indicator LEDs, switch inputs and relay outputs. Each are grouped into ports of a certain number of channels.

.SS switch_ports
.I read-only, integer
.br
The number of switch ports available.
.SS switch_channels
.I read-only, integer
.br
The number of channels available per switch port.
.SS switch_refresh_activations
.I write-only, yes-no
.br
Write anything here to update the values of all switch ports from the device.
.SS switch_portN
.I read-only, ascii text
.br
The last fetched state for the port (use switch_refresh_activations to fetch the state). Formatted as "channel0,channel1...channelN", where each channel is '0' or '1' depending on whether it is activated.
.SS set_switch_type
.I write-only, ascii text
.br
Sets the type of switch connected to the device. Format "port,channel,type" where port and channel are integer IDs, and type is:
.br
  0 Toggle switch to VCC with pull-downs enabled on the device
  1 Toggle switch to Gnd with pull-ups enabled on the device
  2 Momentary switch to VCC with pull-downs enabled on the device
  3 Momentary switch to Gnd with pull-ups enabled on the device
.SS led_ports
.I read-only, integer
.br
The number of LED ports available.
.SS led_channels
.I read-only, integer
.br
The number of channels available per LED port.
.SS led_portN
.I read-write, ascii text
.br
The state for the port. Formatted as "channel0,channel1...channelN", where each channel is '0' or '1' depending on whether the LED is lit.
.SS relay_ports
.I read-only, integer
.br
The number of relay ports available.
.SS relay_channels
.I read-only, integer
.br
The number of channels available per relay port.
.SS relay_portN
.I read-write, ascii text
.br
The state for the port. Formatted as "channel0,channel1...channelN", where each channel is '0' or '1' depending on whether the relay is activated.
.SS relay_modeN
.I read-write, ascii text
.br
The mode for each relay on the port. Formatted as "channel0,channel1...channelN", where each channel is one of the following modes:
.br
  0 Channel operates independently
  1 Channel operates as a member of an even/odd pair
.br
If the channels are operated as pairs, the even numbered relay is activated when the even numbered channel is turned on, and the odd numbered relay is activated when the even numbered channel is turned off. The odd numbered channel has no effect. This is useful when controlling devices such as roller shutters, projector screens and air conditioning dampers, which require one relay to be activated to open, and another to close.
.SS relay_timeoutN
.I read-write, ascii text
.br
The timeout for each relay on the port. Formatted as "channel0,channel1...channelN", where each channel is an integer (0-255) representing the number of seconds the relay will remain activated when operating as an even/odd pair. 

.SH ADDRESSING
.so man3/addressing.3so
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
https://github.com/InfernoEmbedded/onewire-softdevice
.SH AUTHOR
Alastair D'Silva (alastair@d-silva.org)
