// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AVTCURVEMETADATA_H
#define AVTCURVEMETADATA_H
#include <dbatts_exports.h>
#include <string>
#include <avtVarMetaData.h>


// ****************************************************************************
// Class: avtCurveMetaData
//
// Purpose:
//    Contains curve metadata attributes
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class DBATTS_API avtCurveMetaData : public avtVarMetaData
{
public:
    // These constructors are for objects of this class
    avtCurveMetaData();
    avtCurveMetaData(const avtCurveMetaData &obj);
protected:
    // These constructors are for objects derived from this class
    avtCurveMetaData(private_tmfs_t tmfs);
    avtCurveMetaData(const avtCurveMetaData &obj, private_tmfs_t tmfs);
public:
    virtual ~avtCurveMetaData();

    virtual avtCurveMetaData& operator = (const avtCurveMetaData &obj);
    virtual bool operator == (const avtCurveMetaData &obj) const;
    virtual bool operator != (const avtCurveMetaData &obj) const;
private:
    void Init();
    void Copy(const avtCurveMetaData &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    avtCurveMetaData(const std::string &n);
    avtCurveMetaData(const std::string &n, double minS, double maxS, double minE, double maxE);
    void SetSpatialExtents(const double *);
    void UnsetSpatialExtents();
    void SetDataExtents(const double *);
    void UnsetDataExtents();
    void Print(ostream &, int = 0) const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_xUnits = avtVarMetaData::ID__LAST,
        ID_xLabel,
        ID_yUnits,
        ID_yLabel,
        ID_hasSpatialExtents,
        ID_minSpatialExtents,
        ID_maxSpatialExtents,
        ID_from1DScalarName,
        ID__LAST
    };

public:
    std::string xUnits;
    std::string xLabel;
    std::string yUnits;
    std::string yLabel;
    bool        hasSpatialExtents;
    double      minSpatialExtents;
    double      maxSpatialExtents;
    std::string from1DScalarName;

private:
    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AVTCURVEMETADATA_TMFS AVTVARMETADATA_TMFS "ssssbdds"

#endif
