#include "seq.h"

typedef struct rbsr_stretch_s {
	rbsr_map_t map;
	rnd_coord_t fromx, fromy, tox, toy;
	grbs_line_t *gline; /* line being stretched */
	int acceptable;

	grbs_point_t *jump_over_pt; /* point we are jumping over in jump-over mode */
	grbs_arc_t *jump_over_consider; /* arc being considered in jump-over mode */
	pcb_any_obj_t *remove_obj;

	grbs_snapshot_t *snap_reset; /* snapshot to restore to get the initial state */
	grbs_snapshot_t *snap_cmp;   /* if not NULL: snapshot to compare to for install */

	unsigned permit_straight:1;    /* accept straight-line solution (arc stretch: remove arc) */
} rbsr_stretch_t;



/* Start stretching a routing line; returns 0 on success */
int rbsr_stretch_any_begin(rbsr_stretch_t *rbss, pcb_board_t *pcb, rnd_coord_t x, rnd_coord_t y);
int rbsr_stretch_accept(rbsr_stretch_t *rbss);
int rbsr_stretch_cancel(rbsr_stretch_t *rbss);

/* Alternative _begin entries */
int rbsr_stretch_line_begin(rbsr_stretch_t *rbss, pcb_board_t *pcb, pcb_line_t *line);
int rbsr_stretch_rat_begin(rbsr_stretch_t *rbss, pcb_board_t *pcb, pcb_rat_t *rat);


/* Stretch the current line so it goes around tx;ty */
int rbsr_stretch_line_to_coords(rbsr_stretch_t *rbss, rnd_coord_t tx, rnd_coord_t ty);

/* Update stretch to crosshair; returns 1 if redraw is needed */
int rbsr_stretch_to_coords(rbsr_stretch_t *rbss);


