# == Class: vmms::config
#
# This class is used to manage arbitrary vmms configurations.
#
# === Parameters
#
# [*vmms_config*]
#   (optional) Allow configuration of arbitrary vmms configurations.
#   The value is an hash of vmms_config resources. Example:
#   { 'DEFAULT/foo' => { value => 'fooValue'},
#     'DEFAULT/bar' => { value => 'barValue'}
#   }
#   In yaml format, Example:
#   vmms_config:
#     DEFAULT/foo:
#       value: fooValue
#     DEFAULT/bar:
#       value: barValue
#
#   NOTE: The configuration MUST NOT be already handled by this module
#   or Puppet catalog compilation will fail with duplicate resources.
#
class vmms::config (
  Hash $vmms_config = {},
) {

  include vmms::deps

  create_resources('vmms_config', $vmms_config)
}
