require 'spec_helper'

describe 'collectd::plugin::intel_rdt', type: :class do
  on_supported_os(baseline_os_hash).each do |os, facts|
    context "on #{os} " do
      let :facts do
        facts
      end

      options = os_specific_options(facts)
      context 'default' do
        it 'defaults' do
          content = <<EOS
# Generated by Puppet
<LoadPlugin intel_rdt>
  Globals false
</LoadPlugin>

<Plugin "intel_rdt">
  Cores ""
</Plugin>

EOS

          is_expected.to compile.with_all_deps
          is_expected.to contain_file('intel_rdt.load').with(
            content: content,
            path: "#{options[:plugin_conf_dir]}/10-intel_rdt.conf"
          )
        end
      end

      options = os_specific_options(facts)
      context 'multiple instances' do
        let :params do
          {
            'cores' => ['0-2', '3,4,6', '8-10,15']
          }
        end

        it 'overrides defaults' do
          content = <<EOS
# Generated by Puppet
<LoadPlugin intel_rdt>
  Globals false
</LoadPlugin>

<Plugin "intel_rdt">
  Cores "0-2" "3,4,6" "8-10,15"
</Plugin>

EOS

          is_expected.to compile.with_all_deps
          is_expected.to contain_class('collectd')
          is_expected.to contain_file('intel_rdt.load').with(
            content: content,
            path: "#{options[:plugin_conf_dir]}/10-intel_rdt.conf"
          )
        end
      end
    end
  end
end
