# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AppRole(Model):
    """AppRole.

    :param id: Unique role identifier inside the appRoles collection.
    :type id: str
    :param allowed_member_types: Specifies whether this app role definition
     can be assigned to users and groups by setting to 'User', or to other
     applications (that are accessing this application in daemon service
     scenarios) by setting to 'Application', or to both.
    :type allowed_member_types: list[str]
    :param description: Permission help text that appears in the admin app
     assignment and consent experiences.
    :type description: str
    :param display_name: Display name for the permission that appears in the
     admin consent and app assignment experiences.
    :type display_name: str
    :param is_enabled: When creating or updating a role definition, this must
     be set to true (which is the default). To delete a role, this must first
     be set to false. At that point, in a subsequent call, this role may be
     removed.
    :type is_enabled: bool
    :param value: Specifies the value of the roles claim that the application
     should expect in the authentication and access tokens.
    :type value: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'allowed_member_types': {'key': 'allowedMemberTypes', 'type': '[str]'},
        'description': {'key': 'description', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AppRole, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.allowed_member_types = kwargs.get('allowed_member_types', None)
        self.description = kwargs.get('description', None)
        self.display_name = kwargs.get('display_name', None)
        self.is_enabled = kwargs.get('is_enabled', None)
        self.value = kwargs.get('value', None)
