# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.azurestackhci import AzureStackHCIClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-azurestackhci
# USAGE
    python put_updates.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = AzureStackHCIClient(
        credential=DefaultAzureCredential(),
        subscription_id="b8d594e5-51f3-4c11-9c54-a7771b81c712",
    )

    response = client.updates.put(
        resource_group_name="testrg",
        cluster_name="testcluster",
        update_name="Microsoft4.2203.2.32",
        update_properties={
            "properties": {
                "additionalProperties": "additional properties",
                "availabilityType": "Local",
                "description": "AzS Update 4.2203.2.32",
                "displayName": "AzS Update - 4.2203.2.32",
                "installedDate": "2022-04-06T14:08:18.254Z",
                "packagePath": "\\\\SU1FileServer\\SU1_Infrastructure_2\\Updates\\Packages\\Microsoft4.2203.2.32",
                "packageSizeInMb": 18858,
                "packageType": "Infrastructure",
                "prerequisites": [
                    {
                        "packageName": "update package name",
                        "updateType": "update type",
                        "version": "prerequisite version",
                    }
                ],
                "publisher": "Microsoft",
                "releaseLink": "https://docs.microsoft.com/azure-stack/operator/release-notes?view=azs-2203",
                "state": "Installed",
                "updateStateProperties": {
                    "notifyMessage": "Brief message with instructions for updates of AvailabilityType Notify",
                    "progressPercentage": 0,
                },
                "version": "4.2203.2.32",
            }
        },
    )
    print(response)


# x-ms-original-file: specification/azurestackhci/resource-manager/Microsoft.AzureStackHCI/StackHCI/stable/2024-04-01/examples/PutUpdates.json
if __name__ == "__main__":
    main()
