# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    """


class Addon(ProxyResource):
    """An addon resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.AddonProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AddonProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AddonProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.avs.models.AddonProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AddonProperties(_serialization.Model):
    """The properties of an addon.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AddonArcProperties, AddonHcxProperties, AddonSrmProperties, AddonVrProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar addon_type: Addon type. Required. Known values are: "SRM", "VR", "HCX", and "Arc".
    :vartype addon_type: str or ~azure.mgmt.avs.models.AddonType
    :ivar provisioning_state: The state of the addon provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    """

    _validation = {
        "addon_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "addon_type": {"key": "addonType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    _subtype_map = {
        "addon_type": {
            "Arc": "AddonArcProperties",
            "HCX": "AddonHcxProperties",
            "SRM": "AddonSrmProperties",
            "VR": "AddonVrProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.addon_type: Optional[str] = None
        self.provisioning_state = None


class AddonArcProperties(AddonProperties):
    """The properties of an Arc addon.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar addon_type: Addon type. Required. Known values are: "SRM", "VR", "HCX", and "Arc".
    :vartype addon_type: str or ~azure.mgmt.avs.models.AddonType
    :ivar provisioning_state: The state of the addon provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    :ivar v_center: The VMware vCenter resource ID.
    :vartype v_center: str
    """

    _validation = {
        "addon_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "addon_type": {"key": "addonType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "v_center": {"key": "vCenter", "type": "str"},
    }

    def __init__(self, *, v_center: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword v_center: The VMware vCenter resource ID.
        :paramtype v_center: str
        """
        super().__init__(**kwargs)
        self.addon_type: str = "Arc"
        self.v_center = v_center


class AddonHcxProperties(AddonProperties):
    """The properties of an HCX addon.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar addon_type: Addon type. Required. Known values are: "SRM", "VR", "HCX", and "Arc".
    :vartype addon_type: str or ~azure.mgmt.avs.models.AddonType
    :ivar provisioning_state: The state of the addon provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    :ivar offer: The HCX offer, example VMware MaaS Cloud Provider (Enterprise). Required.
    :vartype offer: str
    """

    _validation = {
        "addon_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "offer": {"required": True},
    }

    _attribute_map = {
        "addon_type": {"key": "addonType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "offer": {"key": "offer", "type": "str"},
    }

    def __init__(self, *, offer: str, **kwargs: Any) -> None:
        """
        :keyword offer: The HCX offer, example VMware MaaS Cloud Provider (Enterprise). Required.
        :paramtype offer: str
        """
        super().__init__(**kwargs)
        self.addon_type: str = "HCX"
        self.offer = offer


class AddonList(_serialization.Model):
    """The response of a Addon list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The Addon items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.Addon]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Addon]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Addon"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Addon items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.Addon]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AddonSrmProperties(AddonProperties):
    """The properties of a Site Recovery Manager (SRM) addon.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar addon_type: Addon type. Required. Known values are: "SRM", "VR", "HCX", and "Arc".
    :vartype addon_type: str or ~azure.mgmt.avs.models.AddonType
    :ivar provisioning_state: The state of the addon provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    :ivar license_key: The Site Recovery Manager (SRM) license.
    :vartype license_key: str
    """

    _validation = {
        "addon_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "addon_type": {"key": "addonType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "license_key": {"key": "licenseKey", "type": "str"},
    }

    def __init__(self, *, license_key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword license_key: The Site Recovery Manager (SRM) license.
        :paramtype license_key: str
        """
        super().__init__(**kwargs)
        self.addon_type: str = "SRM"
        self.license_key = license_key


class AddonVrProperties(AddonProperties):
    """The properties of a vSphere Replication (VR) addon.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar addon_type: Addon type. Required. Known values are: "SRM", "VR", "HCX", and "Arc".
    :vartype addon_type: str or ~azure.mgmt.avs.models.AddonType
    :ivar provisioning_state: The state of the addon provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.AddonProvisioningState
    :ivar vrs_count: The vSphere Replication Server (VRS) count. Required.
    :vartype vrs_count: int
    """

    _validation = {
        "addon_type": {"required": True},
        "provisioning_state": {"readonly": True},
        "vrs_count": {"required": True},
    }

    _attribute_map = {
        "addon_type": {"key": "addonType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "vrs_count": {"key": "vrsCount", "type": "int"},
    }

    def __init__(self, *, vrs_count: int, **kwargs: Any) -> None:
        """
        :keyword vrs_count: The vSphere Replication Server (VRS) count. Required.
        :paramtype vrs_count: int
        """
        super().__init__(**kwargs)
        self.addon_type: str = "VR"
        self.vrs_count = vrs_count


class AdminCredentials(_serialization.Model):
    """Administrative credentials for accessing vCenter and NSX-T.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nsxt_username: NSX-T Manager username.
    :vartype nsxt_username: str
    :ivar nsxt_password: NSX-T Manager password.
    :vartype nsxt_password: str
    :ivar vcenter_username: vCenter admin username.
    :vartype vcenter_username: str
    :ivar vcenter_password: vCenter admin password.
    :vartype vcenter_password: str
    """

    _validation = {
        "nsxt_username": {"readonly": True},
        "nsxt_password": {"readonly": True},
        "vcenter_username": {"readonly": True},
        "vcenter_password": {"readonly": True},
    }

    _attribute_map = {
        "nsxt_username": {"key": "nsxtUsername", "type": "str"},
        "nsxt_password": {"key": "nsxtPassword", "type": "str"},
        "vcenter_username": {"key": "vcenterUsername", "type": "str"},
        "vcenter_password": {"key": "vcenterPassword", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.nsxt_username = None
        self.nsxt_password = None
        self.vcenter_username = None
        self.vcenter_password = None


class AvailabilityProperties(_serialization.Model):
    """The properties describing private cloud availability zone distribution.

    :ivar strategy: The availability strategy for the private cloud. Known values are: "SingleZone"
     and "DualZone".
    :vartype strategy: str or ~azure.mgmt.avs.models.AvailabilityStrategy
    :ivar zone: The primary availability zone for the private cloud.
    :vartype zone: int
    :ivar secondary_zone: The secondary availability zone for the private cloud.
    :vartype secondary_zone: int
    """

    _attribute_map = {
        "strategy": {"key": "strategy", "type": "str"},
        "zone": {"key": "zone", "type": "int"},
        "secondary_zone": {"key": "secondaryZone", "type": "int"},
    }

    def __init__(
        self,
        *,
        strategy: Optional[Union[str, "_models.AvailabilityStrategy"]] = None,
        zone: Optional[int] = None,
        secondary_zone: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword strategy: The availability strategy for the private cloud. Known values are:
         "SingleZone" and "DualZone".
        :paramtype strategy: str or ~azure.mgmt.avs.models.AvailabilityStrategy
        :keyword zone: The primary availability zone for the private cloud.
        :paramtype zone: int
        :keyword secondary_zone: The secondary availability zone for the private cloud.
        :paramtype secondary_zone: int
        """
        super().__init__(**kwargs)
        self.strategy = strategy
        self.zone = zone
        self.secondary_zone = secondary_zone


class Circuit(_serialization.Model):
    """An ExpressRoute Circuit.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_subnet: CIDR of primary subnet.
    :vartype primary_subnet: str
    :ivar secondary_subnet: CIDR of secondary subnet.
    :vartype secondary_subnet: str
    :ivar express_route_id: Identifier of the ExpressRoute Circuit (Microsoft Colo only).
    :vartype express_route_id: str
    :ivar express_route_private_peering_id: ExpressRoute Circuit private peering identifier.
    :vartype express_route_private_peering_id: str
    """

    _validation = {
        "primary_subnet": {"readonly": True},
        "secondary_subnet": {"readonly": True},
        "express_route_id": {"readonly": True},
        "express_route_private_peering_id": {"readonly": True},
    }

    _attribute_map = {
        "primary_subnet": {"key": "primarySubnet", "type": "str"},
        "secondary_subnet": {"key": "secondarySubnet", "type": "str"},
        "express_route_id": {"key": "expressRouteID", "type": "str"},
        "express_route_private_peering_id": {"key": "expressRoutePrivatePeeringID", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.primary_subnet = None
        self.secondary_subnet = None
        self.express_route_id = None
        self.express_route_private_peering_id = None


class CloudLink(ProxyResource):
    """A cloud link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.CloudLinkProvisioningState
    :ivar status: The state of the cloud link. Known values are: "Active", "Building", "Deleting",
     "Failed", and "Disconnected".
    :vartype status: str or ~azure.mgmt.avs.models.CloudLinkStatus
    :ivar linked_cloud: Identifier of the other private cloud participating in the link.
    :vartype linked_cloud: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "linked_cloud": {"key": "properties.linkedCloud", "type": "str"},
    }

    def __init__(self, *, linked_cloud: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword linked_cloud: Identifier of the other private cloud participating in the link.
        :paramtype linked_cloud: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.status = None
        self.linked_cloud = linked_cloud


class CloudLinkList(_serialization.Model):
    """The response of a CloudLink list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The CloudLink items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.CloudLink]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CloudLink]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CloudLink"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The CloudLink items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.CloudLink]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Cluster(ProxyResource):
    """A cluster resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource. Required.
    :vartype sku: ~azure.mgmt.avs.models.Sku
    :ivar cluster_size: The cluster size.
    :vartype cluster_size: int
    :ivar provisioning_state: The state of the cluster provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ClusterProvisioningState
    :ivar cluster_id: The identity.
    :vartype cluster_id: int
    :ivar hosts: The hosts.
    :vartype hosts: list[str]
    :ivar vsan_datastore_name: Name of the vsan datastore associated with the cluster.
    :vartype vsan_datastore_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "sku": {"required": True},
        "provisioning_state": {"readonly": True},
        "cluster_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "sku": {"key": "sku", "type": "Sku"},
        "cluster_size": {"key": "properties.clusterSize", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "cluster_id": {"key": "properties.clusterId", "type": "int"},
        "hosts": {"key": "properties.hosts", "type": "[str]"},
        "vsan_datastore_name": {"key": "properties.vsanDatastoreName", "type": "str"},
    }

    def __init__(
        self,
        *,
        sku: "_models.Sku",
        cluster_size: Optional[int] = None,
        hosts: Optional[List[str]] = None,
        vsan_datastore_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: The SKU (Stock Keeping Unit) assigned to this resource. Required.
        :paramtype sku: ~azure.mgmt.avs.models.Sku
        :keyword cluster_size: The cluster size.
        :paramtype cluster_size: int
        :keyword hosts: The hosts.
        :paramtype hosts: list[str]
        :keyword vsan_datastore_name: Name of the vsan datastore associated with the cluster.
        :paramtype vsan_datastore_name: str
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.cluster_size = cluster_size
        self.provisioning_state = None
        self.cluster_id = None
        self.hosts = hosts
        self.vsan_datastore_name = vsan_datastore_name


class ClusterList(_serialization.Model):
    """The response of a Cluster list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The Cluster items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.Cluster]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Cluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Cluster"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Cluster items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.Cluster]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ClusterUpdate(_serialization.Model):
    """An update of a cluster resource.

    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource.
    :vartype sku: ~azure.mgmt.avs.models.Sku
    :ivar cluster_size: The cluster size.
    :vartype cluster_size: int
    :ivar hosts: The hosts.
    :vartype hosts: list[str]
    """

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "cluster_size": {"key": "properties.clusterSize", "type": "int"},
        "hosts": {"key": "properties.hosts", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.Sku"] = None,
        cluster_size: Optional[int] = None,
        hosts: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: The SKU (Stock Keeping Unit) assigned to this resource.
        :paramtype sku: ~azure.mgmt.avs.models.Sku
        :keyword cluster_size: The cluster size.
        :paramtype cluster_size: int
        :keyword hosts: The hosts.
        :paramtype hosts: list[str]
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.cluster_size = cluster_size
        self.hosts = hosts


class ClusterZone(_serialization.Model):
    """Zone and associated hosts info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hosts: List of hosts belonging to the availability zone in a cluster.
    :vartype hosts: list[str]
    :ivar zone: Availability zone identifier.
    :vartype zone: str
    """

    _validation = {
        "hosts": {"readonly": True},
        "zone": {"readonly": True},
    }

    _attribute_map = {
        "hosts": {"key": "hosts", "type": "[str]"},
        "zone": {"key": "zone", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.hosts = None
        self.zone = None


class ClusterZoneList(_serialization.Model):
    """List of all zones and associated hosts for a cluster.

    :ivar zones: Zone and associated hosts info.
    :vartype zones: list[~azure.mgmt.avs.models.ClusterZone]
    """

    _attribute_map = {
        "zones": {"key": "zones", "type": "[ClusterZone]"},
    }

    def __init__(self, *, zones: Optional[List["_models.ClusterZone"]] = None, **kwargs: Any) -> None:
        """
        :keyword zones: Zone and associated hosts info.
        :paramtype zones: list[~azure.mgmt.avs.models.ClusterZone]
        """
        super().__init__(**kwargs)
        self.zones = zones


class Datastore(ProxyResource):
    """A datastore resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar provisioning_state: The state of the datastore provisioning. Known values are:
     "Succeeded", "Failed", "Canceled", "Cancelled", "Pending", "Creating", "Updating", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.DatastoreProvisioningState
    :ivar net_app_volume: An Azure NetApp Files volume.
    :vartype net_app_volume: ~azure.mgmt.avs.models.NetAppVolume
    :ivar disk_pool_volume: An iSCSI volume.
    :vartype disk_pool_volume: ~azure.mgmt.avs.models.DiskPoolVolume
    :ivar elastic_san_volume: An Elastic SAN volume.
    :vartype elastic_san_volume: ~azure.mgmt.avs.models.ElasticSanVolume
    :ivar status: The operational status of the datastore. Known values are: "Unknown",
     "Accessible", "Inaccessible", "Attached", "Detached", "LostCommunication", and "DeadOrError".
    :vartype status: str or ~azure.mgmt.avs.models.DatastoreStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "net_app_volume": {"key": "properties.netAppVolume", "type": "NetAppVolume"},
        "disk_pool_volume": {"key": "properties.diskPoolVolume", "type": "DiskPoolVolume"},
        "elastic_san_volume": {"key": "properties.elasticSanVolume", "type": "ElasticSanVolume"},
        "status": {"key": "properties.status", "type": "str"},
    }

    def __init__(
        self,
        *,
        net_app_volume: Optional["_models.NetAppVolume"] = None,
        disk_pool_volume: Optional["_models.DiskPoolVolume"] = None,
        elastic_san_volume: Optional["_models.ElasticSanVolume"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword net_app_volume: An Azure NetApp Files volume.
        :paramtype net_app_volume: ~azure.mgmt.avs.models.NetAppVolume
        :keyword disk_pool_volume: An iSCSI volume.
        :paramtype disk_pool_volume: ~azure.mgmt.avs.models.DiskPoolVolume
        :keyword elastic_san_volume: An Elastic SAN volume.
        :paramtype elastic_san_volume: ~azure.mgmt.avs.models.ElasticSanVolume
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.net_app_volume = net_app_volume
        self.disk_pool_volume = disk_pool_volume
        self.elastic_san_volume = elastic_san_volume
        self.status = None


class DatastoreList(_serialization.Model):
    """The response of a Datastore list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The Datastore items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.Datastore]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Datastore]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Datastore"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Datastore items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.Datastore]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DiskPoolVolume(_serialization.Model):
    """An iSCSI volume from Microsoft.StoragePool provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar target_id: Azure resource ID of the iSCSI target. Required.
    :vartype target_id: str
    :ivar lun_name: Name of the LUN to be used for datastore. Required.
    :vartype lun_name: str
    :ivar mount_option: Mode that describes whether the LUN has to be mounted as a datastore or
     attached as a LUN. Known values are: "MOUNT" and "ATTACH".
    :vartype mount_option: str or ~azure.mgmt.avs.models.MountOptionEnum
    :ivar path: Device path.
    :vartype path: str
    """

    _validation = {
        "target_id": {"required": True},
        "lun_name": {"required": True},
        "path": {"readonly": True},
    }

    _attribute_map = {
        "target_id": {"key": "targetId", "type": "str"},
        "lun_name": {"key": "lunName", "type": "str"},
        "mount_option": {"key": "mountOption", "type": "str"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_id: str,
        lun_name: str,
        mount_option: Union[str, "_models.MountOptionEnum"] = "MOUNT",
        **kwargs: Any
    ) -> None:
        """
        :keyword target_id: Azure resource ID of the iSCSI target. Required.
        :paramtype target_id: str
        :keyword lun_name: Name of the LUN to be used for datastore. Required.
        :paramtype lun_name: str
        :keyword mount_option: Mode that describes whether the LUN has to be mounted as a datastore or
         attached as a LUN. Known values are: "MOUNT" and "ATTACH".
        :paramtype mount_option: str or ~azure.mgmt.avs.models.MountOptionEnum
        """
        super().__init__(**kwargs)
        self.target_id = target_id
        self.lun_name = lun_name
        self.mount_option = mount_option
        self.path = None


class ElasticSanVolume(_serialization.Model):
    """An Elastic SAN volume from Microsoft.ElasticSan provider.

    All required parameters must be populated in order to send to server.

    :ivar target_id: Azure resource ID of the Elastic SAN Volume. Required.
    :vartype target_id: str
    """

    _validation = {
        "target_id": {"required": True},
    }

    _attribute_map = {
        "target_id": {"key": "targetId", "type": "str"},
    }

    def __init__(self, *, target_id: str, **kwargs: Any) -> None:
        """
        :keyword target_id: Azure resource ID of the Elastic SAN Volume. Required.
        :paramtype target_id: str
        """
        super().__init__(**kwargs)
        self.target_id = target_id


class Encryption(_serialization.Model):
    """The properties of customer managed encryption key.

    :ivar status: Status of customer managed encryption key. Known values are: "Enabled" and
     "Disabled".
    :vartype status: str or ~azure.mgmt.avs.models.EncryptionState
    :ivar key_vault_properties: The key vault where the encryption key is stored.
    :vartype key_vault_properties: ~azure.mgmt.avs.models.EncryptionKeyVaultProperties
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "key_vault_properties": {"key": "keyVaultProperties", "type": "EncryptionKeyVaultProperties"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.EncryptionState"]] = None,
        key_vault_properties: Optional["_models.EncryptionKeyVaultProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of customer managed encryption key. Known values are: "Enabled" and
         "Disabled".
        :paramtype status: str or ~azure.mgmt.avs.models.EncryptionState
        :keyword key_vault_properties: The key vault where the encryption key is stored.
        :paramtype key_vault_properties: ~azure.mgmt.avs.models.EncryptionKeyVaultProperties
        """
        super().__init__(**kwargs)
        self.status = status
        self.key_vault_properties = key_vault_properties


class EncryptionKeyVaultProperties(_serialization.Model):
    """An Encryption Key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_name: The name of the key.
    :vartype key_name: str
    :ivar key_version: The version of the key.
    :vartype key_version: str
    :ivar auto_detected_key_version: The auto-detected version of the key if versionType is
     auto-detected.
    :vartype auto_detected_key_version: str
    :ivar key_vault_url: The URL of the vault.
    :vartype key_vault_url: str
    :ivar key_state: The state of key provided. Known values are: "Connected" and "AccessDenied".
    :vartype key_state: str or ~azure.mgmt.avs.models.EncryptionKeyStatus
    :ivar version_type: Property of the key if user provided or auto detected. Known values are:
     "Fixed" and "AutoDetected".
    :vartype version_type: str or ~azure.mgmt.avs.models.EncryptionVersionType
    """

    _validation = {
        "auto_detected_key_version": {"readonly": True},
        "key_state": {"readonly": True},
        "version_type": {"readonly": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
        "key_version": {"key": "keyVersion", "type": "str"},
        "auto_detected_key_version": {"key": "autoDetectedKeyVersion", "type": "str"},
        "key_vault_url": {"key": "keyVaultUrl", "type": "str"},
        "key_state": {"key": "keyState", "type": "str"},
        "version_type": {"key": "versionType", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        key_vault_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_name: The name of the key.
        :paramtype key_name: str
        :keyword key_version: The version of the key.
        :paramtype key_version: str
        :keyword key_vault_url: The URL of the vault.
        :paramtype key_vault_url: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name
        self.key_version = key_version
        self.auto_detected_key_version = None
        self.key_vault_url = key_vault_url
        self.key_state = None
        self.version_type = None


class Endpoints(_serialization.Model):
    """Endpoint addresses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nsxt_manager: Endpoint FQDN for the NSX-T Data Center manager.
    :vartype nsxt_manager: str
    :ivar vcsa: Endpoint FQDN for Virtual Center Server Appliance.
    :vartype vcsa: str
    :ivar hcx_cloud_manager: Endpoint FQDN for the HCX Cloud Manager.
    :vartype hcx_cloud_manager: str
    :ivar nsxt_manager_ip: Endpoint IP for the NSX-T Data Center manager.
    :vartype nsxt_manager_ip: str
    :ivar vcenter_ip: Endpoint IP for Virtual Center Server Appliance.
    :vartype vcenter_ip: str
    :ivar hcx_cloud_manager_ip: Endpoint IP for the HCX Cloud Manager.
    :vartype hcx_cloud_manager_ip: str
    """

    _validation = {
        "nsxt_manager": {"readonly": True},
        "vcsa": {"readonly": True},
        "hcx_cloud_manager": {"readonly": True},
        "nsxt_manager_ip": {"readonly": True},
        "vcenter_ip": {"readonly": True},
        "hcx_cloud_manager_ip": {"readonly": True},
    }

    _attribute_map = {
        "nsxt_manager": {"key": "nsxtManager", "type": "str"},
        "vcsa": {"key": "vcsa", "type": "str"},
        "hcx_cloud_manager": {"key": "hcxCloudManager", "type": "str"},
        "nsxt_manager_ip": {"key": "nsxtManagerIp", "type": "str"},
        "vcenter_ip": {"key": "vcenterIp", "type": "str"},
        "hcx_cloud_manager_ip": {"key": "hcxCloudManagerIp", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.nsxt_manager = None
        self.vcsa = None
        self.hcx_cloud_manager = None
        self.nsxt_manager_ip = None
        self.vcenter_ip = None
        self.hcx_cloud_manager_ip = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.avs.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.avs.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.avs.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.avs.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExpressRouteAuthorization(ProxyResource):
    """ExpressRoute Circuit Authorization.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar provisioning_state: The state of the ExpressRoute Circuit Authorization provisioning.
     Known values are: "Succeeded", "Failed", "Canceled", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.ExpressRouteAuthorizationProvisioningState
    :ivar express_route_authorization_id: The ID of the ExpressRoute Circuit Authorization.
    :vartype express_route_authorization_id: str
    :ivar express_route_authorization_key: The key of the ExpressRoute Circuit Authorization.
    :vartype express_route_authorization_key: str
    :ivar express_route_id: The ID of the ExpressRoute Circuit.
    :vartype express_route_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "express_route_authorization_id": {"readonly": True},
        "express_route_authorization_key": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "express_route_authorization_id": {"key": "properties.expressRouteAuthorizationId", "type": "str"},
        "express_route_authorization_key": {"key": "properties.expressRouteAuthorizationKey", "type": "str"},
        "express_route_id": {"key": "properties.expressRouteId", "type": "str"},
    }

    def __init__(self, *, express_route_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword express_route_id: The ID of the ExpressRoute Circuit.
        :paramtype express_route_id: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.express_route_authorization_id = None
        self.express_route_authorization_key = None
        self.express_route_id = express_route_id


class ExpressRouteAuthorizationList(_serialization.Model):
    """The response of a ExpressRouteAuthorization list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The ExpressRouteAuthorization items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.ExpressRouteAuthorization]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteAuthorization]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.ExpressRouteAuthorization"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The ExpressRouteAuthorization items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.ExpressRouteAuthorization]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GlobalReachConnection(ProxyResource):
    """A global reach connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar provisioning_state: The state of the  ExpressRoute Circuit Authorization provisioning.
     Known values are: "Succeeded", "Failed", "Canceled", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.GlobalReachConnectionProvisioningState
    :ivar address_prefix: The network used for global reach carved out from the original network
     block
     provided for the private cloud.
    :vartype address_prefix: str
    :ivar authorization_key: Authorization key from the peer express route used for the global
     reach
     connection.
    :vartype authorization_key: str
    :ivar circuit_connection_status: The connection status of the global reach connection. Known
     values are: "Connected", "Connecting", and "Disconnected".
    :vartype circuit_connection_status: str or ~azure.mgmt.avs.models.GlobalReachConnectionStatus
    :ivar peer_express_route_circuit: Identifier of the ExpressRoute Circuit to peer with in the
     global reach
     connection.
    :vartype peer_express_route_circuit: str
    :ivar express_route_id: The ID of the Private Cloud's ExpressRoute Circuit that is
     participating in the
     global reach connection.
    :vartype express_route_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "address_prefix": {"readonly": True},
        "circuit_connection_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "circuit_connection_status": {"key": "properties.circuitConnectionStatus", "type": "str"},
        "peer_express_route_circuit": {"key": "properties.peerExpressRouteCircuit", "type": "str"},
        "express_route_id": {"key": "properties.expressRouteId", "type": "str"},
    }

    def __init__(
        self,
        *,
        authorization_key: Optional[str] = None,
        peer_express_route_circuit: Optional[str] = None,
        express_route_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authorization_key: Authorization key from the peer express route used for the global
         reach
         connection.
        :paramtype authorization_key: str
        :keyword peer_express_route_circuit: Identifier of the ExpressRoute Circuit to peer with in the
         global reach
         connection.
        :paramtype peer_express_route_circuit: str
        :keyword express_route_id: The ID of the Private Cloud's ExpressRoute Circuit that is
         participating in the
         global reach connection.
        :paramtype express_route_id: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.address_prefix = None
        self.authorization_key = authorization_key
        self.circuit_connection_status = None
        self.peer_express_route_circuit = peer_express_route_circuit
        self.express_route_id = express_route_id


class GlobalReachConnectionList(_serialization.Model):
    """The response of a GlobalReachConnection list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The GlobalReachConnection items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.GlobalReachConnection]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GlobalReachConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.GlobalReachConnection"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The GlobalReachConnection items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.GlobalReachConnection]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class HcxEnterpriseSite(ProxyResource):
    """An HCX Enterprise Site resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.HcxEnterpriseSiteProvisioningState
    :ivar activation_key: The activation key.
    :vartype activation_key: str
    :ivar status: The status of the HCX Enterprise Site. Known values are: "Available", "Consumed",
     "Deactivated", and "Deleted".
    :vartype status: str or ~azure.mgmt.avs.models.HcxEnterpriseSiteStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "activation_key": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "activation_key": {"key": "properties.activationKey", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.activation_key = None
        self.status = None


class HcxEnterpriseSiteList(_serialization.Model):
    """The response of a HcxEnterpriseSite list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The HcxEnterpriseSite items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.HcxEnterpriseSite]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HcxEnterpriseSite]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.HcxEnterpriseSite"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The HcxEnterpriseSite items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.HcxEnterpriseSite]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IdentitySource(_serialization.Model):
    """vCenter Single Sign On Identity Source.

    :ivar name: The name of the identity source.
    :vartype name: str
    :ivar alias: The domain's NetBIOS name.
    :vartype alias: str
    :ivar domain: The domain's dns name.
    :vartype domain: str
    :ivar base_user_dn: The base distinguished name for users.
    :vartype base_user_dn: str
    :ivar base_group_dn: The base distinguished name for groups.
    :vartype base_group_dn: str
    :ivar primary_server: Primary server URL.
    :vartype primary_server: str
    :ivar secondary_server: Secondary server URL.
    :vartype secondary_server: str
    :ivar ssl: Protect LDAP communication using SSL certificate (LDAPS). Known values are:
     "Enabled" and "Disabled".
    :vartype ssl: str or ~azure.mgmt.avs.models.SslEnum
    :ivar username: The ID of an Active Directory user with a minimum of read-only access to Base
     DN for users and group.
    :vartype username: str
    :ivar password: The password of the Active Directory user with a minimum of read-only access to
     Base DN for users and groups.
    :vartype password: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "alias": {"key": "alias", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "base_user_dn": {"key": "baseUserDN", "type": "str"},
        "base_group_dn": {"key": "baseGroupDN", "type": "str"},
        "primary_server": {"key": "primaryServer", "type": "str"},
        "secondary_server": {"key": "secondaryServer", "type": "str"},
        "ssl": {"key": "ssl", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        alias: Optional[str] = None,
        domain: Optional[str] = None,
        base_user_dn: Optional[str] = None,
        base_group_dn: Optional[str] = None,
        primary_server: Optional[str] = None,
        secondary_server: Optional[str] = None,
        ssl: Optional[Union[str, "_models.SslEnum"]] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the identity source.
        :paramtype name: str
        :keyword alias: The domain's NetBIOS name.
        :paramtype alias: str
        :keyword domain: The domain's dns name.
        :paramtype domain: str
        :keyword base_user_dn: The base distinguished name for users.
        :paramtype base_user_dn: str
        :keyword base_group_dn: The base distinguished name for groups.
        :paramtype base_group_dn: str
        :keyword primary_server: Primary server URL.
        :paramtype primary_server: str
        :keyword secondary_server: Secondary server URL.
        :paramtype secondary_server: str
        :keyword ssl: Protect LDAP communication using SSL certificate (LDAPS). Known values are:
         "Enabled" and "Disabled".
        :paramtype ssl: str or ~azure.mgmt.avs.models.SslEnum
        :keyword username: The ID of an Active Directory user with a minimum of read-only access to
         Base
         DN for users and group.
        :paramtype username: str
        :keyword password: The password of the Active Directory user with a minimum of read-only access
         to
         Base DN for users and groups.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.alias = alias
        self.domain = domain
        self.base_user_dn = base_user_dn
        self.base_group_dn = base_group_dn
        self.primary_server = primary_server
        self.secondary_server = secondary_server
        self.ssl = ssl
        self.username = username
        self.password = password


class IscsiPath(ProxyResource):
    """An iSCSI path resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar provisioning_state: The state of the iSCSI path provisioning. Known values are:
     "Succeeded", "Failed", "Canceled", "Pending", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.IscsiPathProvisioningState
    :ivar network_block: CIDR Block for iSCSI path.
    :vartype network_block: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "network_block": {"key": "properties.networkBlock", "type": "str"},
    }

    def __init__(self, *, network_block: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword network_block: CIDR Block for iSCSI path.
        :paramtype network_block: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.network_block = network_block


class IscsiPathListResult(_serialization.Model):
    """The response of a IscsiPath list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The IscsiPath items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.IscsiPath]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IscsiPath]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.IscsiPath"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The IscsiPath items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.IscsiPath]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ManagementCluster(_serialization.Model):
    """The properties of a management cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cluster_size: The cluster size.
    :vartype cluster_size: int
    :ivar provisioning_state: The state of the cluster provisioning. Known values are: "Succeeded",
     "Failed", "Canceled", "Cancelled", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ClusterProvisioningState
    :ivar cluster_id: The identity.
    :vartype cluster_id: int
    :ivar hosts: The hosts.
    :vartype hosts: list[str]
    :ivar vsan_datastore_name: Name of the vsan datastore associated with the cluster.
    :vartype vsan_datastore_name: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "cluster_id": {"readonly": True},
    }

    _attribute_map = {
        "cluster_size": {"key": "clusterSize", "type": "int"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "cluster_id": {"key": "clusterId", "type": "int"},
        "hosts": {"key": "hosts", "type": "[str]"},
        "vsan_datastore_name": {"key": "vsanDatastoreName", "type": "str"},
    }

    def __init__(
        self,
        *,
        cluster_size: Optional[int] = None,
        hosts: Optional[List[str]] = None,
        vsan_datastore_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cluster_size: The cluster size.
        :paramtype cluster_size: int
        :keyword hosts: The hosts.
        :paramtype hosts: list[str]
        :keyword vsan_datastore_name: Name of the vsan datastore associated with the cluster.
        :paramtype vsan_datastore_name: str
        """
        super().__init__(**kwargs)
        self.cluster_size = cluster_size
        self.provisioning_state = None
        self.cluster_id = None
        self.hosts = hosts
        self.vsan_datastore_name = vsan_datastore_name


class NetAppVolume(_serialization.Model):
    """An Azure NetApp Files volume from Microsoft.NetApp provider.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource ID of the NetApp volume. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Azure resource ID of the NetApp volume. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.avs.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.avs.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.avs.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.avs.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.avs.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PlacementPoliciesList(_serialization.Model):
    """The response of a PlacementPolicy list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The PlacementPolicy items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.PlacementPolicy]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PlacementPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.PlacementPolicy"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The PlacementPolicy items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.PlacementPolicy]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PlacementPolicy(ProxyResource):
    """A vSphere Distributed Resource Scheduler (DRS) placement policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.PlacementPolicyProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PlacementPolicyProperties"},
    }

    def __init__(self, *, properties: Optional["_models.PlacementPolicyProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.avs.models.PlacementPolicyProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PlacementPolicyProperties(_serialization.Model):
    """Abstract placement policy properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    VmHostPlacementPolicyProperties, VmPlacementPolicyProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: Placement Policy type. Required. Known values are: "VmVm" and "VmHost".
    :vartype type: str or ~azure.mgmt.avs.models.PlacementPolicyType
    :ivar state: Whether the placement policy is enabled or disabled. Known values are: "Enabled"
     and "Disabled".
    :vartype state: str or ~azure.mgmt.avs.models.PlacementPolicyState
    :ivar display_name: Display name of the placement policy.
    :vartype display_name: str
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PlacementPolicyProvisioningState
    """

    _validation = {
        "type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    _subtype_map = {"type": {"VmHost": "VmHostPlacementPolicyProperties", "VmVm": "VmPlacementPolicyProperties"}}

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.PlacementPolicyState"]] = None,
        display_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Whether the placement policy is enabled or disabled. Known values are:
         "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.avs.models.PlacementPolicyState
        :keyword display_name: Display name of the placement policy.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.state = state
        self.display_name = display_name
        self.provisioning_state = None


class PlacementPolicyUpdate(_serialization.Model):
    """An update of a DRS placement policy resource.

    :ivar state: Whether the placement policy is enabled or disabled. Known values are: "Enabled"
     and "Disabled".
    :vartype state: str or ~azure.mgmt.avs.models.PlacementPolicyState
    :ivar vm_members: Virtual machine members list.
    :vartype vm_members: list[str]
    :ivar host_members: Host members list.
    :vartype host_members: list[str]
    :ivar affinity_strength: vm-host placement policy affinity strength (should/must). Known values
     are: "Should" and "Must".
    :vartype affinity_strength: str or ~azure.mgmt.avs.models.AffinityStrength
    :ivar azure_hybrid_benefit_type: placement policy azure hybrid benefit opt-in type. Known
     values are: "SqlHost" and "None".
    :vartype azure_hybrid_benefit_type: str or ~azure.mgmt.avs.models.AzureHybridBenefitType
    """

    _attribute_map = {
        "state": {"key": "properties.state", "type": "str"},
        "vm_members": {"key": "properties.vmMembers", "type": "[str]"},
        "host_members": {"key": "properties.hostMembers", "type": "[str]"},
        "affinity_strength": {"key": "properties.affinityStrength", "type": "str"},
        "azure_hybrid_benefit_type": {"key": "properties.azureHybridBenefitType", "type": "str"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.PlacementPolicyState"]] = None,
        vm_members: Optional[List[str]] = None,
        host_members: Optional[List[str]] = None,
        affinity_strength: Optional[Union[str, "_models.AffinityStrength"]] = None,
        azure_hybrid_benefit_type: Optional[Union[str, "_models.AzureHybridBenefitType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Whether the placement policy is enabled or disabled. Known values are:
         "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.avs.models.PlacementPolicyState
        :keyword vm_members: Virtual machine members list.
        :paramtype vm_members: list[str]
        :keyword host_members: Host members list.
        :paramtype host_members: list[str]
        :keyword affinity_strength: vm-host placement policy affinity strength (should/must). Known
         values are: "Should" and "Must".
        :paramtype affinity_strength: str or ~azure.mgmt.avs.models.AffinityStrength
        :keyword azure_hybrid_benefit_type: placement policy azure hybrid benefit opt-in type. Known
         values are: "SqlHost" and "None".
        :paramtype azure_hybrid_benefit_type: str or ~azure.mgmt.avs.models.AzureHybridBenefitType
        """
        super().__init__(**kwargs)
        self.state = state
        self.vm_members = vm_members
        self.host_members = host_members
        self.affinity_strength = affinity_strength
        self.azure_hybrid_benefit_type = azure_hybrid_benefit_type


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class PrivateCloud(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """A private cloud resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource. Required.
    :vartype sku: ~azure.mgmt.avs.models.Sku
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.avs.models.PrivateCloudIdentity
    :ivar management_cluster: The default cluster used for management.
    :vartype management_cluster: ~azure.mgmt.avs.models.ManagementCluster
    :ivar internet: Connectivity to internet is enabled or disabled. Known values are: "Enabled"
     and "Disabled".
    :vartype internet: str or ~azure.mgmt.avs.models.InternetEnum
    :ivar identity_sources: vCenter Single Sign On Identity Sources.
    :vartype identity_sources: list[~azure.mgmt.avs.models.IdentitySource]
    :ivar availability: Properties describing how the cloud is distributed across availability
     zones.
    :vartype availability: ~azure.mgmt.avs.models.AvailabilityProperties
    :ivar encryption: Customer managed key encryption, can be enabled or disabled.
    :vartype encryption: ~azure.mgmt.avs.models.Encryption
    :ivar extended_network_blocks: Array of additional networks noncontiguous with networkBlock.
     Networks must be
     unique and non-overlapping across VNet in your subscription, on-premise, and
     this privateCloud networkBlock attribute. Make sure the CIDR format conforms to
     (A.B.C.D/X).
    :vartype extended_network_blocks: list[str]
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Cancelled", "Pending", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PrivateCloudProvisioningState
    :ivar circuit: An ExpressRoute Circuit.
    :vartype circuit: ~azure.mgmt.avs.models.Circuit
    :ivar endpoints: The endpoints.
    :vartype endpoints: ~azure.mgmt.avs.models.Endpoints
    :ivar network_block: The block of addresses should be unique across VNet in your subscription
     as
     well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where
     A,B,C,D are between 0 and 255, and X is between 0 and 22.
    :vartype network_block: str
    :ivar management_network: Network used to access vCenter Server and NSX-T Manager.
    :vartype management_network: str
    :ivar provisioning_network: Used for virtual machine cold migration, cloning, and snapshot
     migration.
    :vartype provisioning_network: str
    :ivar vmotion_network: Used for live migration of virtual machines.
    :vartype vmotion_network: str
    :ivar vcenter_password: Optionally, set the vCenter admin password when the private cloud is
     created.
    :vartype vcenter_password: str
    :ivar nsxt_password: Optionally, set the NSX-T Manager password when the private cloud is
     created.
    :vartype nsxt_password: str
    :ivar vcenter_certificate_thumbprint: Thumbprint of the vCenter Server SSL certificate.
    :vartype vcenter_certificate_thumbprint: str
    :ivar nsxt_certificate_thumbprint: Thumbprint of the NSX-T Manager SSL certificate.
    :vartype nsxt_certificate_thumbprint: str
    :ivar external_cloud_links: Array of cloud link IDs from other clouds that connect to this one.
    :vartype external_cloud_links: list[str]
    :ivar secondary_circuit: A secondary expressRoute circuit from a separate AZ. Only present in a
     stretched private cloud.
    :vartype secondary_circuit: ~azure.mgmt.avs.models.Circuit
    :ivar nsx_public_ip_quota_raised: Flag to indicate whether the private cloud has the quota for
     provisioned NSX
     Public IP count raised from 64 to 1024. Known values are: "Enabled" and "Disabled".
    :vartype nsx_public_ip_quota_raised: str or ~azure.mgmt.avs.models.NsxPublicIpQuotaRaisedEnum
    :ivar virtual_network_id: Azure resource ID of the virtual network.
    :vartype virtual_network_id: str
    :ivar dns_zone_type: The type of DNS zone to use. Known values are: "Public" and "Private".
    :vartype dns_zone_type: str or ~azure.mgmt.avs.models.DnsZoneType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "sku": {"required": True},
        "provisioning_state": {"readonly": True},
        "endpoints": {"readonly": True},
        "management_network": {"readonly": True},
        "provisioning_network": {"readonly": True},
        "vmotion_network": {"readonly": True},
        "vcenter_certificate_thumbprint": {"readonly": True},
        "nsxt_certificate_thumbprint": {"readonly": True},
        "external_cloud_links": {"readonly": True},
        "nsx_public_ip_quota_raised": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "PrivateCloudIdentity"},
        "management_cluster": {"key": "properties.managementCluster", "type": "ManagementCluster"},
        "internet": {"key": "properties.internet", "type": "str"},
        "identity_sources": {"key": "properties.identitySources", "type": "[IdentitySource]"},
        "availability": {"key": "properties.availability", "type": "AvailabilityProperties"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "extended_network_blocks": {"key": "properties.extendedNetworkBlocks", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "circuit": {"key": "properties.circuit", "type": "Circuit"},
        "endpoints": {"key": "properties.endpoints", "type": "Endpoints"},
        "network_block": {"key": "properties.networkBlock", "type": "str"},
        "management_network": {"key": "properties.managementNetwork", "type": "str"},
        "provisioning_network": {"key": "properties.provisioningNetwork", "type": "str"},
        "vmotion_network": {"key": "properties.vmotionNetwork", "type": "str"},
        "vcenter_password": {"key": "properties.vcenterPassword", "type": "str"},
        "nsxt_password": {"key": "properties.nsxtPassword", "type": "str"},
        "vcenter_certificate_thumbprint": {"key": "properties.vcenterCertificateThumbprint", "type": "str"},
        "nsxt_certificate_thumbprint": {"key": "properties.nsxtCertificateThumbprint", "type": "str"},
        "external_cloud_links": {"key": "properties.externalCloudLinks", "type": "[str]"},
        "secondary_circuit": {"key": "properties.secondaryCircuit", "type": "Circuit"},
        "nsx_public_ip_quota_raised": {"key": "properties.nsxPublicIpQuotaRaised", "type": "str"},
        "virtual_network_id": {"key": "properties.virtualNetworkId", "type": "str"},
        "dns_zone_type": {"key": "properties.dnsZoneType", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.PrivateCloudIdentity"] = None,
        management_cluster: Optional["_models.ManagementCluster"] = None,
        internet: Optional[Union[str, "_models.InternetEnum"]] = None,
        identity_sources: Optional[List["_models.IdentitySource"]] = None,
        availability: Optional["_models.AvailabilityProperties"] = None,
        encryption: Optional["_models.Encryption"] = None,
        extended_network_blocks: Optional[List[str]] = None,
        circuit: Optional["_models.Circuit"] = None,
        network_block: Optional[str] = None,
        vcenter_password: Optional[str] = None,
        nsxt_password: Optional[str] = None,
        secondary_circuit: Optional["_models.Circuit"] = None,
        virtual_network_id: Optional[str] = None,
        dns_zone_type: Optional[Union[str, "_models.DnsZoneType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: The SKU (Stock Keeping Unit) assigned to this resource. Required.
        :paramtype sku: ~azure.mgmt.avs.models.Sku
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.avs.models.PrivateCloudIdentity
        :keyword management_cluster: The default cluster used for management.
        :paramtype management_cluster: ~azure.mgmt.avs.models.ManagementCluster
        :keyword internet: Connectivity to internet is enabled or disabled. Known values are: "Enabled"
         and "Disabled".
        :paramtype internet: str or ~azure.mgmt.avs.models.InternetEnum
        :keyword identity_sources: vCenter Single Sign On Identity Sources.
        :paramtype identity_sources: list[~azure.mgmt.avs.models.IdentitySource]
        :keyword availability: Properties describing how the cloud is distributed across availability
         zones.
        :paramtype availability: ~azure.mgmt.avs.models.AvailabilityProperties
        :keyword encryption: Customer managed key encryption, can be enabled or disabled.
        :paramtype encryption: ~azure.mgmt.avs.models.Encryption
        :keyword extended_network_blocks: Array of additional networks noncontiguous with networkBlock.
         Networks must be
         unique and non-overlapping across VNet in your subscription, on-premise, and
         this privateCloud networkBlock attribute. Make sure the CIDR format conforms to
         (A.B.C.D/X).
        :paramtype extended_network_blocks: list[str]
        :keyword circuit: An ExpressRoute Circuit.
        :paramtype circuit: ~azure.mgmt.avs.models.Circuit
        :keyword network_block: The block of addresses should be unique across VNet in your
         subscription as
         well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where
         A,B,C,D are between 0 and 255, and X is between 0 and 22.
        :paramtype network_block: str
        :keyword vcenter_password: Optionally, set the vCenter admin password when the private cloud is
         created.
        :paramtype vcenter_password: str
        :keyword nsxt_password: Optionally, set the NSX-T Manager password when the private cloud is
         created.
        :paramtype nsxt_password: str
        :keyword secondary_circuit: A secondary expressRoute circuit from a separate AZ. Only present
         in a
         stretched private cloud.
        :paramtype secondary_circuit: ~azure.mgmt.avs.models.Circuit
        :keyword virtual_network_id: Azure resource ID of the virtual network.
        :paramtype virtual_network_id: str
        :keyword dns_zone_type: The type of DNS zone to use. Known values are: "Public" and "Private".
        :paramtype dns_zone_type: str or ~azure.mgmt.avs.models.DnsZoneType
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.identity = identity
        self.management_cluster = management_cluster
        self.internet = internet
        self.identity_sources = identity_sources
        self.availability = availability
        self.encryption = encryption
        self.extended_network_blocks = extended_network_blocks
        self.provisioning_state = None
        self.circuit = circuit
        self.endpoints = None
        self.network_block = network_block
        self.management_network = None
        self.provisioning_network = None
        self.vmotion_network = None
        self.vcenter_password = vcenter_password
        self.nsxt_password = nsxt_password
        self.vcenter_certificate_thumbprint = None
        self.nsxt_certificate_thumbprint = None
        self.external_cloud_links = None
        self.secondary_circuit = secondary_circuit
        self.nsx_public_ip_quota_raised = None
        self.virtual_network_id = virtual_network_id
        self.dns_zone_type = dns_zone_type


class PrivateCloudIdentity(_serialization.Model):
    """Managed service identity (either system assigned, or none).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (either system assigned, or none). Required. Known
     values are: "None" and "SystemAssigned".
    :vartype type: str or ~azure.mgmt.avs.models.ResourceIdentityType
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Union[str, "_models.ResourceIdentityType"], **kwargs: Any) -> None:
        """
        :keyword type: Type of managed service identity (either system assigned, or none). Required.
         Known values are: "None" and "SystemAssigned".
        :paramtype type: str or ~azure.mgmt.avs.models.ResourceIdentityType
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class PrivateCloudList(_serialization.Model):
    """The response of a PrivateCloud list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The PrivateCloud items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.PrivateCloud]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateCloud]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.PrivateCloud"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The PrivateCloud items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.PrivateCloud]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateCloudUpdate(_serialization.Model):
    """An update to a private cloud resource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource.
    :vartype sku: ~azure.mgmt.avs.models.Sku
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.avs.models.PrivateCloudIdentity
    :ivar management_cluster: The default cluster used for management.
    :vartype management_cluster: ~azure.mgmt.avs.models.ManagementCluster
    :ivar internet: Connectivity to internet is enabled or disabled. Known values are: "Enabled"
     and "Disabled".
    :vartype internet: str or ~azure.mgmt.avs.models.InternetEnum
    :ivar identity_sources: vCenter Single Sign On Identity Sources.
    :vartype identity_sources: list[~azure.mgmt.avs.models.IdentitySource]
    :ivar availability: Properties describing how the cloud is distributed across availability
     zones.
    :vartype availability: ~azure.mgmt.avs.models.AvailabilityProperties
    :ivar encryption: Customer managed key encryption, can be enabled or disabled.
    :vartype encryption: ~azure.mgmt.avs.models.Encryption
    :ivar extended_network_blocks: Array of additional networks noncontiguous with networkBlock.
     Networks must be
     unique and non-overlapping across VNet in your subscription, on-premise, and
     this privateCloud networkBlock attribute. Make sure the CIDR format conforms to
     (A.B.C.D/X).
    :vartype extended_network_blocks: list[str]
    :ivar dns_zone_type: The type of DNS zone to use. Known values are: "Public" and "Private".
    :vartype dns_zone_type: str or ~azure.mgmt.avs.models.DnsZoneType
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "PrivateCloudIdentity"},
        "management_cluster": {"key": "properties.managementCluster", "type": "ManagementCluster"},
        "internet": {"key": "properties.internet", "type": "str"},
        "identity_sources": {"key": "properties.identitySources", "type": "[IdentitySource]"},
        "availability": {"key": "properties.availability", "type": "AvailabilityProperties"},
        "encryption": {"key": "properties.encryption", "type": "Encryption"},
        "extended_network_blocks": {"key": "properties.extendedNetworkBlocks", "type": "[str]"},
        "dns_zone_type": {"key": "properties.dnsZoneType", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.PrivateCloudIdentity"] = None,
        management_cluster: Optional["_models.ManagementCluster"] = None,
        internet: Optional[Union[str, "_models.InternetEnum"]] = None,
        identity_sources: Optional[List["_models.IdentitySource"]] = None,
        availability: Optional["_models.AvailabilityProperties"] = None,
        encryption: Optional["_models.Encryption"] = None,
        extended_network_blocks: Optional[List[str]] = None,
        dns_zone_type: Optional[Union[str, "_models.DnsZoneType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU (Stock Keeping Unit) assigned to this resource.
        :paramtype sku: ~azure.mgmt.avs.models.Sku
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.avs.models.PrivateCloudIdentity
        :keyword management_cluster: The default cluster used for management.
        :paramtype management_cluster: ~azure.mgmt.avs.models.ManagementCluster
        :keyword internet: Connectivity to internet is enabled or disabled. Known values are: "Enabled"
         and "Disabled".
        :paramtype internet: str or ~azure.mgmt.avs.models.InternetEnum
        :keyword identity_sources: vCenter Single Sign On Identity Sources.
        :paramtype identity_sources: list[~azure.mgmt.avs.models.IdentitySource]
        :keyword availability: Properties describing how the cloud is distributed across availability
         zones.
        :paramtype availability: ~azure.mgmt.avs.models.AvailabilityProperties
        :keyword encryption: Customer managed key encryption, can be enabled or disabled.
        :paramtype encryption: ~azure.mgmt.avs.models.Encryption
        :keyword extended_network_blocks: Array of additional networks noncontiguous with networkBlock.
         Networks must be
         unique and non-overlapping across VNet in your subscription, on-premise, and
         this privateCloud networkBlock attribute. Make sure the CIDR format conforms to
         (A.B.C.D/X).
        :paramtype extended_network_blocks: list[str]
        :keyword dns_zone_type: The type of DNS zone to use. Known values are: "Public" and "Private".
        :paramtype dns_zone_type: str or ~azure.mgmt.avs.models.DnsZoneType
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.identity = identity
        self.management_cluster = management_cluster
        self.internet = internet
        self.identity_sources = identity_sources
        self.availability = availability
        self.encryption = encryption
        self.extended_network_blocks = extended_network_blocks
        self.dns_zone_type = dns_zone_type


class ScriptExecutionParameter(_serialization.Model):
    """The arguments passed in to the execution.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    PSCredentialExecutionParameter, ScriptSecureStringExecutionParameter,
    ScriptStringExecutionParameter

    All required parameters must be populated in order to send to server.

    :ivar type: script execution parameter type. Required. Known values are: "Value",
     "SecureValue", and "Credential".
    :vartype type: str or ~azure.mgmt.avs.models.ScriptExecutionParameterType
    :ivar name: The parameter name. Required.
    :vartype name: str
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "Credential": "PSCredentialExecutionParameter",
            "SecureValue": "ScriptSecureStringExecutionParameter",
            "Value": "ScriptStringExecutionParameter",
        }
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: The parameter name. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.name = name


class PSCredentialExecutionParameter(ScriptExecutionParameter):
    """a powershell credential object.

    All required parameters must be populated in order to send to server.

    :ivar type: script execution parameter type. Required. Known values are: "Value",
     "SecureValue", and "Credential".
    :vartype type: str or ~azure.mgmt.avs.models.ScriptExecutionParameterType
    :ivar name: The parameter name. Required.
    :vartype name: str
    :ivar username: username for login.
    :vartype username: str
    :ivar password: password for login.
    :vartype password: str
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
    }

    def __init__(
        self, *, name: str, username: Optional[str] = None, password: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The parameter name. Required.
        :paramtype name: str
        :keyword username: username for login.
        :paramtype username: str
        :keyword password: password for login.
        :paramtype password: str
        """
        super().__init__(name=name, **kwargs)
        self.type: str = "Credential"
        self.username = username
        self.password = password


class Quota(_serialization.Model):
    """Subscription quotas.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hosts_remaining: Remaining hosts quota by sku type.
    :vartype hosts_remaining: dict[str, int]
    :ivar quota_enabled: Host quota is active for current subscription. Known values are: "Enabled"
     and "Disabled".
    :vartype quota_enabled: str or ~azure.mgmt.avs.models.QuotaEnabled
    """

    _validation = {
        "hosts_remaining": {"readonly": True},
        "quota_enabled": {"readonly": True},
    }

    _attribute_map = {
        "hosts_remaining": {"key": "hostsRemaining", "type": "{int}"},
        "quota_enabled": {"key": "quotaEnabled", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.hosts_remaining = None
        self.quota_enabled = None


class ScriptCmdlet(ProxyResource):
    """A cmdlet available for script execution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ScriptCmdletProvisioningState
    :ivar description: Description of the scripts functionality.
    :vartype description: str
    :ivar timeout: Recommended time limit for execution.
    :vartype timeout: str
    :ivar audience: Specifies whether a script cmdlet is intended to be invoked only through
     automation or visible to customers. Known values are: "Automation" and "Any".
    :vartype audience: str or ~azure.mgmt.avs.models.ScriptCmdletAudience
    :ivar parameters: Parameters the script will accept.
    :vartype parameters: list[~azure.mgmt.avs.models.ScriptParameter]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "description": {"readonly": True},
        "timeout": {"readonly": True},
        "audience": {"readonly": True},
        "parameters": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "timeout": {"key": "properties.timeout", "type": "str"},
        "audience": {"key": "properties.audience", "type": "str"},
        "parameters": {"key": "properties.parameters", "type": "[ScriptParameter]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.description = None
        self.timeout = None
        self.audience = None
        self.parameters = None


class ScriptCmdletsList(_serialization.Model):
    """The response of a ScriptCmdlet list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The ScriptCmdlet items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.ScriptCmdlet]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ScriptCmdlet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ScriptCmdlet"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The ScriptCmdlet items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.ScriptCmdlet]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ScriptExecution(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """An instance of a script executed by a user - custom or AVS.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar script_cmdlet_id: A reference to the script cmdlet resource if user is running a AVS
     script.
    :vartype script_cmdlet_id: str
    :ivar parameters: Parameters the script will accept.
    :vartype parameters: list[~azure.mgmt.avs.models.ScriptExecutionParameter]
    :ivar hidden_parameters: Parameters that will be hidden/not visible to ARM, such as passwords
     and
     credentials.
    :vartype hidden_parameters: list[~azure.mgmt.avs.models.ScriptExecutionParameter]
    :ivar failure_reason: Error message if the script was able to run, but if the script itself had
     errors or powershell threw an exception.
    :vartype failure_reason: str
    :ivar timeout: Time limit for execution.
    :vartype timeout: str
    :ivar retention: Time to live for the resource. If not provided, will be available for 60 days.
    :vartype retention: str
    :ivar submitted_at: Time the script execution was submitted.
    :vartype submitted_at: ~datetime.datetime
    :ivar started_at: Time the script execution was started.
    :vartype started_at: ~datetime.datetime
    :ivar finished_at: Time the script execution was finished.
    :vartype finished_at: ~datetime.datetime
    :ivar provisioning_state: The state of the script execution resource. Known values are:
     "Succeeded", "Failed", "Canceled", "Pending", "Running", "Cancelling", "Cancelled", and
     "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ScriptExecutionProvisioningState
    :ivar output: Standard output stream from the powershell execution.
    :vartype output: list[str]
    :ivar named_outputs: User-defined dictionary.
    :vartype named_outputs: dict[str, JSON]
    :ivar information: Standard information out stream from the powershell execution.
    :vartype information: list[str]
    :ivar warnings: Standard warning out stream from the powershell execution.
    :vartype warnings: list[str]
    :ivar errors: Standard error output stream from the powershell execution.
    :vartype errors: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "submitted_at": {"readonly": True},
        "started_at": {"readonly": True},
        "finished_at": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "information": {"readonly": True},
        "warnings": {"readonly": True},
        "errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "script_cmdlet_id": {"key": "properties.scriptCmdletId", "type": "str"},
        "parameters": {"key": "properties.parameters", "type": "[ScriptExecutionParameter]"},
        "hidden_parameters": {"key": "properties.hiddenParameters", "type": "[ScriptExecutionParameter]"},
        "failure_reason": {"key": "properties.failureReason", "type": "str"},
        "timeout": {"key": "properties.timeout", "type": "str"},
        "retention": {"key": "properties.retention", "type": "str"},
        "submitted_at": {"key": "properties.submittedAt", "type": "iso-8601"},
        "started_at": {"key": "properties.startedAt", "type": "iso-8601"},
        "finished_at": {"key": "properties.finishedAt", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "output": {"key": "properties.output", "type": "[str]"},
        "named_outputs": {"key": "properties.namedOutputs", "type": "{object}"},
        "information": {"key": "properties.information", "type": "[str]"},
        "warnings": {"key": "properties.warnings", "type": "[str]"},
        "errors": {"key": "properties.errors", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        script_cmdlet_id: Optional[str] = None,
        parameters: Optional[List["_models.ScriptExecutionParameter"]] = None,
        hidden_parameters: Optional[List["_models.ScriptExecutionParameter"]] = None,
        failure_reason: Optional[str] = None,
        timeout: Optional[str] = None,
        retention: Optional[str] = None,
        output: Optional[List[str]] = None,
        named_outputs: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword script_cmdlet_id: A reference to the script cmdlet resource if user is running a AVS
         script.
        :paramtype script_cmdlet_id: str
        :keyword parameters: Parameters the script will accept.
        :paramtype parameters: list[~azure.mgmt.avs.models.ScriptExecutionParameter]
        :keyword hidden_parameters: Parameters that will be hidden/not visible to ARM, such as
         passwords and
         credentials.
        :paramtype hidden_parameters: list[~azure.mgmt.avs.models.ScriptExecutionParameter]
        :keyword failure_reason: Error message if the script was able to run, but if the script itself
         had
         errors or powershell threw an exception.
        :paramtype failure_reason: str
        :keyword timeout: Time limit for execution.
        :paramtype timeout: str
        :keyword retention: Time to live for the resource. If not provided, will be available for 60
         days.
        :paramtype retention: str
        :keyword output: Standard output stream from the powershell execution.
        :paramtype output: list[str]
        :keyword named_outputs: User-defined dictionary.
        :paramtype named_outputs: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.script_cmdlet_id = script_cmdlet_id
        self.parameters = parameters
        self.hidden_parameters = hidden_parameters
        self.failure_reason = failure_reason
        self.timeout = timeout
        self.retention = retention
        self.submitted_at = None
        self.started_at = None
        self.finished_at = None
        self.provisioning_state = None
        self.output = output
        self.named_outputs = named_outputs
        self.information = None
        self.warnings = None
        self.errors = None


class ScriptExecutionsList(_serialization.Model):
    """The response of a ScriptExecution list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The ScriptExecution items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.ScriptExecution]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ScriptExecution]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.ScriptExecution"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The ScriptExecution items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.ScriptExecution]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ScriptPackage(ProxyResource):
    """Script Package resources available for execution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.ScriptPackageProvisioningState
    :ivar description: User friendly description of the package.
    :vartype description: str
    :ivar version: Module version.
    :vartype version: str
    :ivar company: Company that created and supports the package.
    :vartype company: str
    :ivar uri: Link to support by the package vendor.
    :vartype uri: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "description": {"readonly": True},
        "version": {"readonly": True},
        "company": {"readonly": True},
        "uri": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "company": {"key": "properties.company", "type": "str"},
        "uri": {"key": "properties.uri", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.description = None
        self.version = None
        self.company = None
        self.uri = None


class ScriptPackagesList(_serialization.Model):
    """The response of a ScriptPackage list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The ScriptPackage items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.ScriptPackage]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ScriptPackage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ScriptPackage"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The ScriptPackage items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.ScriptPackage]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ScriptParameter(_serialization.Model):
    """An parameter that the script will accept.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of parameter the script is expecting. psCredential is a
     PSCredentialObject. Known values are: "String", "SecureString", "Credential", "Int", "Bool",
     "Float", and "Int".
    :vartype type: str or ~azure.mgmt.avs.models.ScriptParameterTypes
    :ivar name: The parameter name that the script will expect a parameter value for.
    :vartype name: str
    :ivar description: User friendly description of the parameter.
    :vartype description: str
    :ivar visibility: Should this parameter be visible to arm and passed in the parameters argument
     when executing. Known values are: "Visible" and "Hidden".
    :vartype visibility: str or ~azure.mgmt.avs.models.VisibilityParameterEnum
    :ivar optional: Is this parameter required or optional. Known values are: "Optional" and
     "Required".
    :vartype optional: str or ~azure.mgmt.avs.models.OptionalParamEnum
    """

    _validation = {
        "type": {"readonly": True},
        "description": {"readonly": True},
        "visibility": {"readonly": True},
        "optional": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "visibility": {"key": "visibility", "type": "str"},
        "optional": {"key": "optional", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The parameter name that the script will expect a parameter value for.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = None
        self.name = name
        self.description = None
        self.visibility = None
        self.optional = None


class ScriptSecureStringExecutionParameter(ScriptExecutionParameter):
    """a plain text value execution parameter.

    All required parameters must be populated in order to send to server.

    :ivar type: script execution parameter type. Required. Known values are: "Value",
     "SecureValue", and "Credential".
    :vartype type: str or ~azure.mgmt.avs.models.ScriptExecutionParameterType
    :ivar name: The parameter name. Required.
    :vartype name: str
    :ivar secure_value: A secure value for the passed parameter, not to be stored in logs.
    :vartype secure_value: str
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "secure_value": {"key": "secureValue", "type": "str"},
    }

    def __init__(self, *, name: str, secure_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The parameter name. Required.
        :paramtype name: str
        :keyword secure_value: A secure value for the passed parameter, not to be stored in logs.
        :paramtype secure_value: str
        """
        super().__init__(name=name, **kwargs)
        self.type: str = "SecureValue"
        self.secure_value = secure_value


class ScriptStringExecutionParameter(ScriptExecutionParameter):
    """a plain text value execution parameter.

    All required parameters must be populated in order to send to server.

    :ivar type: script execution parameter type. Required. Known values are: "Value",
     "SecureValue", and "Credential".
    :vartype type: str or ~azure.mgmt.avs.models.ScriptExecutionParameterType
    :ivar name: The parameter name. Required.
    :vartype name: str
    :ivar value: The value for the passed parameter.
    :vartype value: str
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: str, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The parameter name. Required.
        :paramtype name: str
        :keyword value: The value for the passed parameter.
        :paramtype value: str
        """
        super().__init__(name=name, **kwargs)
        self.type: str = "Value"
        self.value = value


class Sku(_serialization.Model):
    """The resource model definition representing SKU.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the SKU. E.g. P3. It is typically a letter+number code. Required.
    :vartype name: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Known values are: "Free", "Basic",
     "Standard", and "Premium".
    :vartype tier: str or ~azure.mgmt.avs.models.SkuTier
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the SKU. E.g. P3. It is typically a letter+number code. Required.
        :paramtype name: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Known values are: "Free", "Basic",
         "Standard", and "Premium".
        :paramtype tier: str or ~azure.mgmt.avs.models.SkuTier
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword capacity: If the SKU supports scale out/in then the capacity integer should be
         included. If scale out/in is not possible for the resource this may be omitted.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.avs.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.avs.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.avs.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.avs.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Trial(_serialization.Model):
    """Subscription trial availability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Trial status. Known values are: "TrialAvailable", "TrialUsed", and
     "TrialDisabled".
    :vartype status: str or ~azure.mgmt.avs.models.TrialStatus
    :ivar available_hosts: Number of trial hosts available.
    :vartype available_hosts: int
    """

    _validation = {
        "status": {"readonly": True},
        "available_hosts": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "available_hosts": {"key": "availableHosts", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.available_hosts = None


class VirtualMachine(ProxyResource):
    """Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.VirtualMachineProvisioningState
    :ivar display_name: Display name of the VM.
    :vartype display_name: str
    :ivar mo_ref_id: Virtual machine managed object reference id.
    :vartype mo_ref_id: str
    :ivar folder_path: Path to virtual machine's folder starting from datacenter virtual machine
     folder.
    :vartype folder_path: str
    :ivar restrict_movement: Whether VM DRS-driven movement is restricted (enabled) or not
     (disabled). Known values are: "Enabled" and "Disabled".
    :vartype restrict_movement: str or ~azure.mgmt.avs.models.VirtualMachineRestrictMovementState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "display_name": {"readonly": True},
        "mo_ref_id": {"readonly": True},
        "folder_path": {"readonly": True},
        "restrict_movement": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "mo_ref_id": {"key": "properties.moRefId", "type": "str"},
        "folder_path": {"key": "properties.folderPath", "type": "str"},
        "restrict_movement": {"key": "properties.restrictMovement", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.display_name = None
        self.mo_ref_id = None
        self.folder_path = None
        self.restrict_movement = None


class VirtualMachineRestrictMovement(_serialization.Model):
    """Set VM DRS-driven movement to restricted (enabled) or not (disabled).

    :ivar restrict_movement: Whether VM DRS-driven movement is restricted (enabled) or not
     (disabled). Known values are: "Enabled" and "Disabled".
    :vartype restrict_movement: str or ~azure.mgmt.avs.models.VirtualMachineRestrictMovementState
    """

    _attribute_map = {
        "restrict_movement": {"key": "restrictMovement", "type": "str"},
    }

    def __init__(
        self,
        *,
        restrict_movement: Optional[Union[str, "_models.VirtualMachineRestrictMovementState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword restrict_movement: Whether VM DRS-driven movement is restricted (enabled) or not
         (disabled). Known values are: "Enabled" and "Disabled".
        :paramtype restrict_movement: str or ~azure.mgmt.avs.models.VirtualMachineRestrictMovementState
        """
        super().__init__(**kwargs)
        self.restrict_movement = restrict_movement


class VirtualMachinesList(_serialization.Model):
    """The response of a VirtualMachine list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The VirtualMachine items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.VirtualMachine]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualMachine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VirtualMachine"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The VirtualMachine items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.VirtualMachine]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VmHostPlacementPolicyProperties(PlacementPolicyProperties):
    """VM-Host placement policy properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: Placement Policy type. Required. Known values are: "VmVm" and "VmHost".
    :vartype type: str or ~azure.mgmt.avs.models.PlacementPolicyType
    :ivar state: Whether the placement policy is enabled or disabled. Known values are: "Enabled"
     and "Disabled".
    :vartype state: str or ~azure.mgmt.avs.models.PlacementPolicyState
    :ivar display_name: Display name of the placement policy.
    :vartype display_name: str
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PlacementPolicyProvisioningState
    :ivar vm_members: Virtual machine members list. Required.
    :vartype vm_members: list[str]
    :ivar host_members: Host members list. Required.
    :vartype host_members: list[str]
    :ivar affinity_type: placement policy affinity type. Required. Known values are: "Affinity" and
     "AntiAffinity".
    :vartype affinity_type: str or ~azure.mgmt.avs.models.AffinityType
    :ivar affinity_strength: vm-host placement policy affinity strength (should/must). Known values
     are: "Should" and "Must".
    :vartype affinity_strength: str or ~azure.mgmt.avs.models.AffinityStrength
    :ivar azure_hybrid_benefit_type: placement policy azure hybrid benefit opt-in type. Known
     values are: "SqlHost" and "None".
    :vartype azure_hybrid_benefit_type: str or ~azure.mgmt.avs.models.AzureHybridBenefitType
    """

    _validation = {
        "type": {"required": True},
        "provisioning_state": {"readonly": True},
        "vm_members": {"required": True},
        "host_members": {"required": True},
        "affinity_type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "vm_members": {"key": "vmMembers", "type": "[str]"},
        "host_members": {"key": "hostMembers", "type": "[str]"},
        "affinity_type": {"key": "affinityType", "type": "str"},
        "affinity_strength": {"key": "affinityStrength", "type": "str"},
        "azure_hybrid_benefit_type": {"key": "azureHybridBenefitType", "type": "str"},
    }

    def __init__(
        self,
        *,
        vm_members: List[str],
        host_members: List[str],
        affinity_type: Union[str, "_models.AffinityType"],
        state: Optional[Union[str, "_models.PlacementPolicyState"]] = None,
        display_name: Optional[str] = None,
        affinity_strength: Optional[Union[str, "_models.AffinityStrength"]] = None,
        azure_hybrid_benefit_type: Optional[Union[str, "_models.AzureHybridBenefitType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Whether the placement policy is enabled or disabled. Known values are:
         "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.avs.models.PlacementPolicyState
        :keyword display_name: Display name of the placement policy.
        :paramtype display_name: str
        :keyword vm_members: Virtual machine members list. Required.
        :paramtype vm_members: list[str]
        :keyword host_members: Host members list. Required.
        :paramtype host_members: list[str]
        :keyword affinity_type: placement policy affinity type. Required. Known values are: "Affinity"
         and "AntiAffinity".
        :paramtype affinity_type: str or ~azure.mgmt.avs.models.AffinityType
        :keyword affinity_strength: vm-host placement policy affinity strength (should/must). Known
         values are: "Should" and "Must".
        :paramtype affinity_strength: str or ~azure.mgmt.avs.models.AffinityStrength
        :keyword azure_hybrid_benefit_type: placement policy azure hybrid benefit opt-in type. Known
         values are: "SqlHost" and "None".
        :paramtype azure_hybrid_benefit_type: str or ~azure.mgmt.avs.models.AzureHybridBenefitType
        """
        super().__init__(state=state, display_name=display_name, **kwargs)
        self.type: str = "VmHost"
        self.vm_members = vm_members
        self.host_members = host_members
        self.affinity_type = affinity_type
        self.affinity_strength = affinity_strength
        self.azure_hybrid_benefit_type = azure_hybrid_benefit_type


class VmPlacementPolicyProperties(PlacementPolicyProperties):
    """VM-VM placement policy properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: Placement Policy type. Required. Known values are: "VmVm" and "VmHost".
    :vartype type: str or ~azure.mgmt.avs.models.PlacementPolicyType
    :ivar state: Whether the placement policy is enabled or disabled. Known values are: "Enabled"
     and "Disabled".
    :vartype state: str or ~azure.mgmt.avs.models.PlacementPolicyState
    :ivar display_name: Display name of the placement policy.
    :vartype display_name: str
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.PlacementPolicyProvisioningState
    :ivar vm_members: Virtual machine members list. Required.
    :vartype vm_members: list[str]
    :ivar affinity_type: placement policy affinity type. Required. Known values are: "Affinity" and
     "AntiAffinity".
    :vartype affinity_type: str or ~azure.mgmt.avs.models.AffinityType
    """

    _validation = {
        "type": {"required": True},
        "provisioning_state": {"readonly": True},
        "vm_members": {"required": True},
        "affinity_type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "vm_members": {"key": "vmMembers", "type": "[str]"},
        "affinity_type": {"key": "affinityType", "type": "str"},
    }

    def __init__(
        self,
        *,
        vm_members: List[str],
        affinity_type: Union[str, "_models.AffinityType"],
        state: Optional[Union[str, "_models.PlacementPolicyState"]] = None,
        display_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Whether the placement policy is enabled or disabled. Known values are:
         "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.avs.models.PlacementPolicyState
        :keyword display_name: Display name of the placement policy.
        :paramtype display_name: str
        :keyword vm_members: Virtual machine members list. Required.
        :paramtype vm_members: list[str]
        :keyword affinity_type: placement policy affinity type. Required. Known values are: "Affinity"
         and "AntiAffinity".
        :paramtype affinity_type: str or ~azure.mgmt.avs.models.AffinityType
        """
        super().__init__(state=state, display_name=display_name, **kwargs)
        self.type: str = "VmVm"
        self.vm_members = vm_members
        self.affinity_type = affinity_type


class WorkloadNetwork(ProxyResource):
    """Workload Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None


class WorkloadNetworkDhcp(ProxyResource):
    """NSX DHCP.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.avs.models.WorkloadNetworkDhcpEntity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "WorkloadNetworkDhcpEntity"},
    }

    def __init__(self, *, properties: Optional["_models.WorkloadNetworkDhcpEntity"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.avs.models.WorkloadNetworkDhcpEntity
        """
        super().__init__(**kwargs)
        self.properties = properties


class WorkloadNetworkDhcpEntity(_serialization.Model):
    """Base class for WorkloadNetworkDhcpServer and WorkloadNetworkDhcpRelay to
    inherit from.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    WorkloadNetworkDhcpRelay, WorkloadNetworkDhcpServer

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar dhcp_type: Type of DHCP: SERVER or RELAY. Required. Known values are: "SERVER" and
     "RELAY".
    :vartype dhcp_type: str or ~azure.mgmt.avs.models.DhcpTypeEnum
    :ivar display_name: Display name of the DHCP entity.
    :vartype display_name: str
    :ivar segments: NSX Segments consuming DHCP.
    :vartype segments: list[str]
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkDhcpProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    """

    _validation = {
        "dhcp_type": {"required": True},
        "segments": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "dhcp_type": {"key": "dhcpType", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "segments": {"key": "segments", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "revision": {"key": "revision", "type": "int"},
    }

    _subtype_map = {"dhcp_type": {"RELAY": "WorkloadNetworkDhcpRelay", "SERVER": "WorkloadNetworkDhcpServer"}}

    def __init__(self, *, display_name: Optional[str] = None, revision: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword display_name: Display name of the DHCP entity.
        :paramtype display_name: str
        :keyword revision: NSX revision number.
        :paramtype revision: int
        """
        super().__init__(**kwargs)
        self.dhcp_type: Optional[str] = None
        self.display_name = display_name
        self.segments = None
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkDhcpList(_serialization.Model):
    """The response of a WorkloadNetworkDhcp list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The WorkloadNetworkDhcp items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkDhcp]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkloadNetworkDhcp]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.WorkloadNetworkDhcp"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The WorkloadNetworkDhcp items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.WorkloadNetworkDhcp]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkloadNetworkDhcpRelay(WorkloadNetworkDhcpEntity):
    """NSX DHCP Relay.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar dhcp_type: Type of DHCP: SERVER or RELAY. Required. Known values are: "SERVER" and
     "RELAY".
    :vartype dhcp_type: str or ~azure.mgmt.avs.models.DhcpTypeEnum
    :ivar display_name: Display name of the DHCP entity.
    :vartype display_name: str
    :ivar segments: NSX Segments consuming DHCP.
    :vartype segments: list[str]
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkDhcpProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    :ivar server_addresses: DHCP Relay Addresses. Max 3.
    :vartype server_addresses: list[str]
    """

    _validation = {
        "dhcp_type": {"required": True},
        "segments": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "server_addresses": {"max_items": 3, "min_items": 1},
    }

    _attribute_map = {
        "dhcp_type": {"key": "dhcpType", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "segments": {"key": "segments", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "revision": {"key": "revision", "type": "int"},
        "server_addresses": {"key": "serverAddresses", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        revision: Optional[int] = None,
        server_addresses: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Display name of the DHCP entity.
        :paramtype display_name: str
        :keyword revision: NSX revision number.
        :paramtype revision: int
        :keyword server_addresses: DHCP Relay Addresses. Max 3.
        :paramtype server_addresses: list[str]
        """
        super().__init__(display_name=display_name, revision=revision, **kwargs)
        self.dhcp_type: str = "RELAY"
        self.server_addresses = server_addresses


class WorkloadNetworkDhcpServer(WorkloadNetworkDhcpEntity):
    """NSX DHCP Server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar dhcp_type: Type of DHCP: SERVER or RELAY. Required. Known values are: "SERVER" and
     "RELAY".
    :vartype dhcp_type: str or ~azure.mgmt.avs.models.DhcpTypeEnum
    :ivar display_name: Display name of the DHCP entity.
    :vartype display_name: str
    :ivar segments: NSX Segments consuming DHCP.
    :vartype segments: list[str]
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkDhcpProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    :ivar server_address: DHCP Server Address.
    :vartype server_address: str
    :ivar lease_time: DHCP Server Lease Time.
    :vartype lease_time: int
    """

    _validation = {
        "dhcp_type": {"required": True},
        "segments": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "dhcp_type": {"key": "dhcpType", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "segments": {"key": "segments", "type": "[str]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "revision": {"key": "revision", "type": "int"},
        "server_address": {"key": "serverAddress", "type": "str"},
        "lease_time": {"key": "leaseTime", "type": "int"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        revision: Optional[int] = None,
        server_address: Optional[str] = None,
        lease_time: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Display name of the DHCP entity.
        :paramtype display_name: str
        :keyword revision: NSX revision number.
        :paramtype revision: int
        :keyword server_address: DHCP Server Address.
        :paramtype server_address: str
        :keyword lease_time: DHCP Server Lease Time.
        :paramtype lease_time: int
        """
        super().__init__(display_name=display_name, revision=revision, **kwargs)
        self.dhcp_type: str = "SERVER"
        self.server_address = server_address
        self.lease_time = lease_time


class WorkloadNetworkDnsService(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """NSX DNS Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar display_name: Display name of the DNS Service.
    :vartype display_name: str
    :ivar dns_service_ip: DNS service IP of the DNS Service.
    :vartype dns_service_ip: str
    :ivar default_dns_zone: Default DNS zone of the DNS Service.
    :vartype default_dns_zone: str
    :ivar fqdn_zones: FQDN zones of the DNS Service.
    :vartype fqdn_zones: list[str]
    :ivar log_level: DNS Service log level. Known values are: "DEBUG", "INFO", "WARNING", "ERROR",
     and "FATAL".
    :vartype log_level: str or ~azure.mgmt.avs.models.DnsServiceLogLevelEnum
    :ivar status: DNS Service status. Known values are: "SUCCESS" and "FAILURE".
    :vartype status: str or ~azure.mgmt.avs.models.DnsServiceStatusEnum
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkDnsServiceProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "status": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "dns_service_ip": {"key": "properties.dnsServiceIp", "type": "str"},
        "default_dns_zone": {"key": "properties.defaultDnsZone", "type": "str"},
        "fqdn_zones": {"key": "properties.fqdnZones", "type": "[str]"},
        "log_level": {"key": "properties.logLevel", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "revision": {"key": "properties.revision", "type": "int"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        dns_service_ip: Optional[str] = None,
        default_dns_zone: Optional[str] = None,
        fqdn_zones: Optional[List[str]] = None,
        log_level: Optional[Union[str, "_models.DnsServiceLogLevelEnum"]] = None,
        revision: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Display name of the DNS Service.
        :paramtype display_name: str
        :keyword dns_service_ip: DNS service IP of the DNS Service.
        :paramtype dns_service_ip: str
        :keyword default_dns_zone: Default DNS zone of the DNS Service.
        :paramtype default_dns_zone: str
        :keyword fqdn_zones: FQDN zones of the DNS Service.
        :paramtype fqdn_zones: list[str]
        :keyword log_level: DNS Service log level. Known values are: "DEBUG", "INFO", "WARNING",
         "ERROR", and "FATAL".
        :paramtype log_level: str or ~azure.mgmt.avs.models.DnsServiceLogLevelEnum
        :keyword revision: NSX revision number.
        :paramtype revision: int
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.dns_service_ip = dns_service_ip
        self.default_dns_zone = default_dns_zone
        self.fqdn_zones = fqdn_zones
        self.log_level = log_level
        self.status = None
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkDnsServicesList(_serialization.Model):
    """The response of a WorkloadNetworkDnsService list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The WorkloadNetworkDnsService items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkDnsService]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkloadNetworkDnsService]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.WorkloadNetworkDnsService"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The WorkloadNetworkDnsService items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.WorkloadNetworkDnsService]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkloadNetworkDnsZone(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """NSX DNS Zone.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar display_name: Display name of the DNS Zone.
    :vartype display_name: str
    :ivar domain: Domain names of the DNS Zone.
    :vartype domain: list[str]
    :ivar dns_server_ips: DNS Server IP array of the DNS Zone.
    :vartype dns_server_ips: list[str]
    :ivar source_ip: Source IP of the DNS Zone.
    :vartype source_ip: str
    :ivar dns_services: Number of DNS Services using the DNS zone.
    :vartype dns_services: int
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkDnsZoneProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "domain": {"key": "properties.domain", "type": "[str]"},
        "dns_server_ips": {"key": "properties.dnsServerIps", "type": "[str]"},
        "source_ip": {"key": "properties.sourceIp", "type": "str"},
        "dns_services": {"key": "properties.dnsServices", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "revision": {"key": "properties.revision", "type": "int"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        domain: Optional[List[str]] = None,
        dns_server_ips: Optional[List[str]] = None,
        source_ip: Optional[str] = None,
        dns_services: Optional[int] = None,
        revision: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Display name of the DNS Zone.
        :paramtype display_name: str
        :keyword domain: Domain names of the DNS Zone.
        :paramtype domain: list[str]
        :keyword dns_server_ips: DNS Server IP array of the DNS Zone.
        :paramtype dns_server_ips: list[str]
        :keyword source_ip: Source IP of the DNS Zone.
        :paramtype source_ip: str
        :keyword dns_services: Number of DNS Services using the DNS zone.
        :paramtype dns_services: int
        :keyword revision: NSX revision number.
        :paramtype revision: int
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.domain = domain
        self.dns_server_ips = dns_server_ips
        self.source_ip = source_ip
        self.dns_services = dns_services
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkDnsZonesList(_serialization.Model):
    """The response of a WorkloadNetworkDnsZone list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The WorkloadNetworkDnsZone items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkDnsZone]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkloadNetworkDnsZone]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.WorkloadNetworkDnsZone"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The WorkloadNetworkDnsZone items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.WorkloadNetworkDnsZone]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkloadNetworkGateway(ProxyResource):
    """NSX Gateway.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkProvisioningState
    :ivar display_name: Display name of the DHCP entity.
    :vartype display_name: str
    :ivar path: NSX Gateway Path.
    :vartype path: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "path": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "path": {"key": "properties.path", "type": "str"},
    }

    def __init__(self, *, display_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword display_name: Display name of the DHCP entity.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.display_name = display_name
        self.path = None


class WorkloadNetworkGatewayList(_serialization.Model):
    """The response of a WorkloadNetworkGateway list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The WorkloadNetworkGateway items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkGateway]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkloadNetworkGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.WorkloadNetworkGateway"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The WorkloadNetworkGateway items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.WorkloadNetworkGateway]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkloadNetworkList(_serialization.Model):
    """The response of a WorkloadNetwork list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The WorkloadNetwork items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetwork]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkloadNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.WorkloadNetwork"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The WorkloadNetwork items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.WorkloadNetwork]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkloadNetworkPortMirroring(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """NSX Port Mirroring.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar display_name: Display name of the port mirroring profile.
    :vartype display_name: str
    :ivar direction: Direction of port mirroring profile. Known values are: "INGRESS", "EGRESS",
     and "BIDIRECTIONAL".
    :vartype direction: str or ~azure.mgmt.avs.models.PortMirroringDirectionEnum
    :ivar source: Source VM Group.
    :vartype source: str
    :ivar destination: Destination VM Group.
    :vartype destination: str
    :ivar status: Port Mirroring Status. Known values are: "SUCCESS" and "FAILURE".
    :vartype status: str or ~azure.mgmt.avs.models.PortMirroringStatusEnum
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkPortMirroringProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "status": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "direction": {"key": "properties.direction", "type": "str"},
        "source": {"key": "properties.source", "type": "str"},
        "destination": {"key": "properties.destination", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "revision": {"key": "properties.revision", "type": "int"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        direction: Optional[Union[str, "_models.PortMirroringDirectionEnum"]] = None,
        source: Optional[str] = None,
        destination: Optional[str] = None,
        revision: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Display name of the port mirroring profile.
        :paramtype display_name: str
        :keyword direction: Direction of port mirroring profile. Known values are: "INGRESS", "EGRESS",
         and "BIDIRECTIONAL".
        :paramtype direction: str or ~azure.mgmt.avs.models.PortMirroringDirectionEnum
        :keyword source: Source VM Group.
        :paramtype source: str
        :keyword destination: Destination VM Group.
        :paramtype destination: str
        :keyword revision: NSX revision number.
        :paramtype revision: int
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.direction = direction
        self.source = source
        self.destination = destination
        self.status = None
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkPortMirroringList(_serialization.Model):
    """The response of a WorkloadNetworkPortMirroring list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The WorkloadNetworkPortMirroring items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkPortMirroring]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkloadNetworkPortMirroring]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.WorkloadNetworkPortMirroring"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The WorkloadNetworkPortMirroring items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.WorkloadNetworkPortMirroring]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkloadNetworkPublicIP(ProxyResource):
    """NSX Public IP Block.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar display_name: Display name of the Public IP Block.
    :vartype display_name: str
    :ivar number_of_public_i_ps: Number of Public IPs requested.
    :vartype number_of_public_i_ps: int
    :ivar public_ip_block: CIDR Block of the Public IP Block.
    :vartype public_ip_block: str
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkPublicIPProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "public_ip_block": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "number_of_public_i_ps": {"key": "properties.numberOfPublicIPs", "type": "int"},
        "public_ip_block": {"key": "properties.publicIPBlock", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self, *, display_name: Optional[str] = None, number_of_public_i_ps: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Display name of the Public IP Block.
        :paramtype display_name: str
        :keyword number_of_public_i_ps: Number of Public IPs requested.
        :paramtype number_of_public_i_ps: int
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.number_of_public_i_ps = number_of_public_i_ps
        self.public_ip_block = None
        self.provisioning_state = None


class WorkloadNetworkPublicIPsList(_serialization.Model):
    """The response of a WorkloadNetworkPublicIP list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The WorkloadNetworkPublicIP items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkPublicIP]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkloadNetworkPublicIP]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.WorkloadNetworkPublicIP"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The WorkloadNetworkPublicIP items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.WorkloadNetworkPublicIP]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkloadNetworkSegment(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """NSX Segment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar display_name: Display name of the segment.
    :vartype display_name: str
    :ivar connected_gateway: Gateway which to connect segment to.
    :vartype connected_gateway: str
    :ivar subnet: Subnet which to connect segment to.
    :vartype subnet: ~azure.mgmt.avs.models.WorkloadNetworkSegmentSubnet
    :ivar port_vif: Port Vif which segment is associated with.
    :vartype port_vif: list[~azure.mgmt.avs.models.WorkloadNetworkSegmentPortVif]
    :ivar status: Segment status. Known values are: "SUCCESS" and "FAILURE".
    :vartype status: str or ~azure.mgmt.avs.models.SegmentStatusEnum
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkSegmentProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "port_vif": {"readonly": True},
        "status": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "connected_gateway": {"key": "properties.connectedGateway", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "WorkloadNetworkSegmentSubnet"},
        "port_vif": {"key": "properties.portVif", "type": "[WorkloadNetworkSegmentPortVif]"},
        "status": {"key": "properties.status", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "revision": {"key": "properties.revision", "type": "int"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        connected_gateway: Optional[str] = None,
        subnet: Optional["_models.WorkloadNetworkSegmentSubnet"] = None,
        revision: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Display name of the segment.
        :paramtype display_name: str
        :keyword connected_gateway: Gateway which to connect segment to.
        :paramtype connected_gateway: str
        :keyword subnet: Subnet which to connect segment to.
        :paramtype subnet: ~azure.mgmt.avs.models.WorkloadNetworkSegmentSubnet
        :keyword revision: NSX revision number.
        :paramtype revision: int
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.connected_gateway = connected_gateway
        self.subnet = subnet
        self.port_vif = None
        self.status = None
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkSegmentPortVif(_serialization.Model):
    """Ports and any VIF attached to segment.

    :ivar port_name: Name of port or VIF attached to segment.
    :vartype port_name: str
    """

    _attribute_map = {
        "port_name": {"key": "portName", "type": "str"},
    }

    def __init__(self, *, port_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword port_name: Name of port or VIF attached to segment.
        :paramtype port_name: str
        """
        super().__init__(**kwargs)
        self.port_name = port_name


class WorkloadNetworkSegmentsList(_serialization.Model):
    """The response of a WorkloadNetworkSegment list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The WorkloadNetworkSegment items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkSegment]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkloadNetworkSegment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.WorkloadNetworkSegment"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The WorkloadNetworkSegment items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.WorkloadNetworkSegment]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkloadNetworkSegmentSubnet(_serialization.Model):
    """Subnet configuration for segment.

    :ivar dhcp_ranges: DHCP Range assigned for subnet.
    :vartype dhcp_ranges: list[str]
    :ivar gateway_address: Gateway address.
    :vartype gateway_address: str
    """

    _attribute_map = {
        "dhcp_ranges": {"key": "dhcpRanges", "type": "[str]"},
        "gateway_address": {"key": "gatewayAddress", "type": "str"},
    }

    def __init__(
        self, *, dhcp_ranges: Optional[List[str]] = None, gateway_address: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword dhcp_ranges: DHCP Range assigned for subnet.
        :paramtype dhcp_ranges: list[str]
        :keyword gateway_address: Gateway address.
        :paramtype gateway_address: str
        """
        super().__init__(**kwargs)
        self.dhcp_ranges = dhcp_ranges
        self.gateway_address = gateway_address


class WorkloadNetworkVirtualMachine(ProxyResource):
    """NSX Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Failed", "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.avs.models.WorkloadNetworkProvisioningState
    :ivar display_name: Display name of the VM.
    :vartype display_name: str
    :ivar vm_type: Virtual machine type. Known values are: "REGULAR", "EDGE", and "SERVICE".
    :vartype vm_type: str or ~azure.mgmt.avs.models.VMTypeEnum
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "vm_type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "vm_type": {"key": "properties.vmType", "type": "str"},
    }

    def __init__(self, *, display_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword display_name: Display name of the VM.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.display_name = display_name
        self.vm_type = None


class WorkloadNetworkVirtualMachinesList(_serialization.Model):
    """The response of a WorkloadNetworkVirtualMachine list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The WorkloadNetworkVirtualMachine items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkVirtualMachine]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkloadNetworkVirtualMachine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.WorkloadNetworkVirtualMachine"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The WorkloadNetworkVirtualMachine items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.WorkloadNetworkVirtualMachine]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkloadNetworkVMGroup(ProxyResource):
    """NSX VM Group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.avs.models.SystemData
    :ivar display_name: Display name of the VM group.
    :vartype display_name: str
    :ivar members: Virtual machine members of this group.
    :vartype members: list[str]
    :ivar status: VM Group status. Known values are: "SUCCESS" and "FAILURE".
    :vartype status: str or ~azure.mgmt.avs.models.VMGroupStatusEnum
    :ivar provisioning_state: The provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Building", "Deleting", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.avs.models.WorkloadNetworkVMGroupProvisioningState
    :ivar revision: NSX revision number.
    :vartype revision: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "status": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "members": {"key": "properties.members", "type": "[str]"},
        "status": {"key": "properties.status", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "revision": {"key": "properties.revision", "type": "int"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        members: Optional[List[str]] = None,
        revision: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Display name of the VM group.
        :paramtype display_name: str
        :keyword members: Virtual machine members of this group.
        :paramtype members: list[str]
        :keyword revision: NSX revision number.
        :paramtype revision: int
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.members = members
        self.status = None
        self.provisioning_state = None
        self.revision = revision


class WorkloadNetworkVMGroupsList(_serialization.Model):
    """The response of a WorkloadNetworkVMGroup list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The WorkloadNetworkVMGroup items on this page. Required.
    :vartype value: list[~azure.mgmt.avs.models.WorkloadNetworkVMGroup]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkloadNetworkVMGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.WorkloadNetworkVMGroup"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The WorkloadNetworkVMGroup items on this page. Required.
        :paramtype value: list[~azure.mgmt.avs.models.WorkloadNetworkVMGroup]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link
