# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobErrorItem(Model):
    """The job error items.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar recommendations: The recommended actions.
    :vartype recommendations: list[str]
    :ivar code: The code intended for programmatic access.
    :vartype code: str
    :ivar message: The message that describes the error in detail.
    :vartype message: str
    """

    _validation = {
        'recommendations': {'readonly': True},
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobErrorItem, self).__init__(**kwargs)
        self.recommendations = None
        self.code = None
        self.message = None
