# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AzureSku(_serialization.Model):
    """AzureSku.

    All required parameters must be populated in order to send to server.

    :ivar name: SKU name. Required. "S1"
    :vartype name: str or ~azure.mgmt.powerbiembedded.models.AzureSkuName
    :ivar tier: SKU tier. Required. "Standard"
    :vartype tier: str or ~azure.mgmt.powerbiembedded.models.AzureSkuTier
    """

    _validation = {
        "name": {"required": True},
        "tier": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self, *, name: Union[str, "_models.AzureSkuName"], tier: Union[str, "_models.AzureSkuTier"], **kwargs: Any
    ) -> None:
        """
        :keyword name: SKU name. Required. "S1"
        :paramtype name: str or ~azure.mgmt.powerbiembedded.models.AzureSkuName
        :keyword tier: SKU tier. Required. "Standard"
        :paramtype tier: str or ~azure.mgmt.powerbiembedded.models.AzureSkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class CheckNameRequest(_serialization.Model):
    """CheckNameRequest.

    :ivar name: Workspace collection name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, type: str = "Microsoft.PowerBI/workspaceCollections", **kwargs: Any
    ) -> None:
        """
        :keyword name: Workspace collection name.
        :paramtype name: str
        :keyword type: Resource type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameResponse(_serialization.Model):
    """CheckNameResponse.

    :ivar name_available: Specifies a Boolean value that indicates whether the specified Power BI
     Workspace Collection name is available to use.
    :vartype name_available: bool
    :ivar reason: Reason why the workspace collection name cannot be used. Known values are:
     "Unavailable" and "Invalid".
    :vartype reason: str or ~azure.mgmt.powerbiembedded.models.CheckNameReason
    :ivar message: Message indicating an unavailable name due to a conflict, or a description of
     the naming rules that are violated.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.CheckNameReason"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Specifies a Boolean value that indicates whether the specified Power
         BI Workspace Collection name is available to use.
        :paramtype name_available: bool
        :keyword reason: Reason why the workspace collection name cannot be used. Known values are:
         "Unavailable" and "Invalid".
        :paramtype reason: str or ~azure.mgmt.powerbiembedded.models.CheckNameReason
        :keyword message: Message indicating an unavailable name due to a conflict, or a description of
         the naming rules that are violated.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class CreateWorkspaceCollectionRequest(_serialization.Model):
    """CreateWorkspaceCollectionRequest.

    :ivar location: Azure location.
    :vartype location: str
    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar sku:
    :vartype sku: ~azure.mgmt.powerbiembedded.models.AzureSku
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "AzureSku"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.AzureSku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Azure location.
        :paramtype location: str
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword sku:
        :paramtype sku: ~azure.mgmt.powerbiembedded.models.AzureSku
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.sku = sku


class Display(_serialization.Model):
    """Display.

    :ivar provider: The localized friendly form of the resource provider name. This form is also
     expected to include the publisher/company responsible. Use Title Casing. Begin with "Microsoft"
     for 1st party services.
    :vartype provider: str
    :ivar resource: The localized friendly form of the resource type related to this
     action/operation. This form should match the public documentation for the resource provider.
     Use Title Casing. For examples, refer to the "name" section.
    :vartype resource: str
    :ivar operation: The localized friendly name for the operation as shown to the user. This name
     should be concise (to fit in drop downs), but clear (self-documenting). Use Title Casing and
     include the entity/resource to which it applies.
    :vartype operation: str
    :ivar description: The localized friendly description for the operation as shown to the user.
     This description should be thorough, yet concise. It will be used in tool-tips and detailed
     views.
    :vartype description: str
    :ivar origin: The intended executor of the operation; governs the display of the operation in
     the RBAC UX and the audit logs UX. Default value is 'user,system'.
    :vartype origin: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        origin: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: The localized friendly form of the resource provider name. This form is also
         expected to include the publisher/company responsible. Use Title Casing. Begin with "Microsoft"
         for 1st party services.
        :paramtype provider: str
        :keyword resource: The localized friendly form of the resource type related to this
         action/operation. This form should match the public documentation for the resource provider.
         Use Title Casing. For examples, refer to the "name" section.
        :paramtype resource: str
        :keyword operation: The localized friendly name for the operation as shown to the user. This
         name should be concise (to fit in drop downs), but clear (self-documenting). Use Title Casing
         and include the entity/resource to which it applies.
        :paramtype operation: str
        :keyword description: The localized friendly description for the operation as shown to the
         user. This description should be thorough, yet concise. It will be used in tool-tips and
         detailed views.
        :paramtype description: str
        :keyword origin: The intended executor of the operation; governs the display of the operation
         in the RBAC UX and the audit logs UX. Default value is 'user,system'.
        :paramtype origin: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description
        self.origin = origin


class Error(_serialization.Model):
    """Error.

    :ivar code:
    :vartype code: str
    :ivar message:
    :vartype message: str
    :ivar target:
    :vartype target: str
    :ivar details:
    :vartype details: list[~azure.mgmt.powerbiembedded.models.ErrorDetail]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.ErrorDetail"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code:
        :paramtype code: str
        :keyword message:
        :paramtype message: str
        :keyword target:
        :paramtype target: str
        :keyword details:
        :paramtype details: list[~azure.mgmt.powerbiembedded.models.ErrorDetail]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ErrorDetail(_serialization.Model):
    """ErrorDetail.

    :ivar code:
    :vartype code: str
    :ivar message:
    :vartype message: str
    :ivar target:
    :vartype target: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, message: Optional[str] = None, target: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code:
        :paramtype code: str
        :keyword message:
        :paramtype message: str
        :keyword target:
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class MigrateWorkspaceCollectionRequest(_serialization.Model):
    """MigrateWorkspaceCollectionRequest.

    :ivar target_resource_group: Name of the resource group the Power BI workspace collections will
     be migrated to.
    :vartype target_resource_group: str
    :ivar resources:
    :vartype resources: list[str]
    """

    _attribute_map = {
        "target_resource_group": {"key": "targetResourceGroup", "type": "str"},
        "resources": {"key": "resources", "type": "[str]"},
    }

    def __init__(
        self, *, target_resource_group: Optional[str] = None, resources: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword target_resource_group: Name of the resource group the Power BI workspace collections
         will be migrated to.
        :paramtype target_resource_group: str
        :keyword resources:
        :paramtype resources: list[str]
        """
        super().__init__(**kwargs)
        self.target_resource_group = target_resource_group
        self.resources = resources


class Operation(_serialization.Model):
    """Operation.

    :ivar name: The name of the operation being performed on this particular object. This name
     should match the action name that appears in RBAC / the event service.
    :vartype name: str
    :ivar display:
    :vartype display: ~azure.mgmt.powerbiembedded.models.Display
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "Display"},
    }

    def __init__(
        self, *, name: Optional[str] = None, display: Optional["_models.Display"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the operation being performed on this particular object. This name
         should match the action name that appears in RBAC / the event service.
        :paramtype name: str
        :keyword display:
        :paramtype display: ~azure.mgmt.powerbiembedded.models.Display
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationList(_serialization.Model):
    """OperationList.

    :ivar value:
    :vartype value: list[~azure.mgmt.powerbiembedded.models.Operation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.powerbiembedded.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value


class UpdateWorkspaceCollectionRequest(_serialization.Model):
    """UpdateWorkspaceCollectionRequest.

    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar sku:
    :vartype sku: ~azure.mgmt.powerbiembedded.models.AzureSku
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "AzureSku"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, sku: Optional["_models.AzureSku"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword sku:
        :paramtype sku: ~azure.mgmt.powerbiembedded.models.AzureSku
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.sku = sku


class Workspace(_serialization.Model):
    """Workspace.

    :ivar id: Workspace id.
    :vartype id: str
    :ivar name: Workspace name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Property bag.
    :vartype properties: JSON
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        properties: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Workspace id.
        :paramtype id: str
        :keyword name: Workspace name.
        :paramtype name: str
        :keyword type: Resource type.
        :paramtype type: str
        :keyword properties: Property bag.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.properties = properties


class WorkspaceCollection(_serialization.Model):
    """WorkspaceCollection.

    :ivar id: Resource id.
    :vartype id: str
    :ivar name: Workspace collection name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Azure location.
    :vartype location: str
    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar sku:
    :vartype sku: ~azure.mgmt.powerbiembedded.models.AzureSku
    :ivar properties: Properties.
    :vartype properties: JSON
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "AzureSku"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.AzureSku"] = None,
        properties: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource id.
        :paramtype id: str
        :keyword name: Workspace collection name.
        :paramtype name: str
        :keyword type: Resource type.
        :paramtype type: str
        :keyword location: Azure location.
        :paramtype location: str
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword sku:
        :paramtype sku: ~azure.mgmt.powerbiembedded.models.AzureSku
        :keyword properties: Properties.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.location = location
        self.tags = tags
        self.sku = sku
        self.properties = properties


class WorkspaceCollectionAccessKey(_serialization.Model):
    """WorkspaceCollectionAccessKey.

    :ivar key_name: Key name. Known values are: "key1" and "key2".
    :vartype key_name: str or ~azure.mgmt.powerbiembedded.models.AccessKeyName
    """

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
    }

    def __init__(self, *, key_name: Optional[Union[str, "_models.AccessKeyName"]] = None, **kwargs: Any) -> None:
        """
        :keyword key_name: Key name. Known values are: "key1" and "key2".
        :paramtype key_name: str or ~azure.mgmt.powerbiembedded.models.AccessKeyName
        """
        super().__init__(**kwargs)
        self.key_name = key_name


class WorkspaceCollectionAccessKeys(_serialization.Model):
    """WorkspaceCollectionAccessKeys.

    :ivar key1: Access key 1.
    :vartype key1: str
    :ivar key2: Access key 2.
    :vartype key2: str
    """

    _attribute_map = {
        "key1": {"key": "key1", "type": "str"},
        "key2": {"key": "key2", "type": "str"},
    }

    def __init__(self, *, key1: Optional[str] = None, key2: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key1: Access key 1.
        :paramtype key1: str
        :keyword key2: Access key 2.
        :paramtype key2: str
        """
        super().__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class WorkspaceCollectionList(_serialization.Model):
    """WorkspaceCollectionList.

    :ivar value:
    :vartype value: list[~azure.mgmt.powerbiembedded.models.WorkspaceCollection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkspaceCollection]"},
    }

    def __init__(self, *, value: Optional[List["_models.WorkspaceCollection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.powerbiembedded.models.WorkspaceCollection]
        """
        super().__init__(**kwargs)
        self.value = value


class WorkspaceList(_serialization.Model):
    """WorkspaceList.

    :ivar value:
    :vartype value: list[~azure.mgmt.powerbiembedded.models.Workspace]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Workspace]"},
    }

    def __init__(self, *, value: Optional[List["_models.Workspace"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.powerbiembedded.models.Workspace]
        """
        super().__init__(**kwargs)
        self.value = value
