# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, List, Optional, TYPE_CHECKING

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models


class FeatureOperationsListResult(_serialization.Model):
    """List of previewed features.

    :ivar value: The array of features.
    :vartype value: list[~azure.mgmt.resource.features.v2015_12_01.models.FeatureResult]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[FeatureResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.FeatureResult"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The array of features.
        :paramtype value: list[~azure.mgmt.resource.features.v2015_12_01.models.FeatureResult]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FeatureProperties(_serialization.Model):
    """Information about feature.

    :ivar state: The registration state of the feature for the subscription.
    :vartype state: str
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword state: The registration state of the feature for the subscription.
        :paramtype state: str
        """
        super().__init__(**kwargs)
        self.state = state


class FeatureResult(_serialization.Model):
    """Previewed feature information.

    :ivar name: The name of the feature.
    :vartype name: str
    :ivar properties: Properties of the previewed feature.
    :vartype properties: ~azure.mgmt.resource.features.v2015_12_01.models.FeatureProperties
    :ivar id: The resource ID of the feature.
    :vartype id: str
    :ivar type: The resource type of the feature.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "FeatureProperties"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.FeatureProperties"] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the feature.
        :paramtype name: str
        :keyword properties: Properties of the previewed feature.
        :paramtype properties: ~azure.mgmt.resource.features.v2015_12_01.models.FeatureProperties
        :keyword id: The resource ID of the feature.
        :paramtype id: str
        :keyword type: The resource type of the feature.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties
        self.id = id
        self.type = type


class Operation(_serialization.Model):
    """Microsoft.Features operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.resource.features.v2015_12_01.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(
        self, *, name: Optional[str] = None, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.resource.features.v2015_12_01.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.Features.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft.Features.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Profile, endpoint, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationListResult(_serialization.Model):
    """Result of the request to list Microsoft.Features operations. It contains a list of operations
    and a URL link to get the next set of results.

    :ivar value: List of Microsoft.Features operations.
    :vartype value: list[~azure.mgmt.resource.features.v2015_12_01.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Microsoft.Features operations.
        :paramtype value: list[~azure.mgmt.resource.features.v2015_12_01.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link
