# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.servicebus.v2021_11_01 import ServiceBusManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestServiceBusManagementQueuesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ServiceBusManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_queues_list_authorization_rules(self, resource_group):
        response = self.client.queues.list_authorization_rules(
            resource_group_name=resource_group.name,
            namespace_name="str",
            queue_name="str",
            api_version="2021-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_queues_create_or_update_authorization_rule(self, resource_group):
        response = self.client.queues.create_or_update_authorization_rule(
            resource_group_name=resource_group.name,
            namespace_name="str",
            queue_name="str",
            authorization_rule_name="str",
            parameters={
                "id": "str",
                "location": "str",
                "name": "str",
                "rights": ["str"],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_queues_delete_authorization_rule(self, resource_group):
        response = self.client.queues.delete_authorization_rule(
            resource_group_name=resource_group.name,
            namespace_name="str",
            queue_name="str",
            authorization_rule_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_queues_get_authorization_rule(self, resource_group):
        response = self.client.queues.get_authorization_rule(
            resource_group_name=resource_group.name,
            namespace_name="str",
            queue_name="str",
            authorization_rule_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_queues_list_keys(self, resource_group):
        response = self.client.queues.list_keys(
            resource_group_name=resource_group.name,
            namespace_name="str",
            queue_name="str",
            authorization_rule_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_queues_regenerate_keys(self, resource_group):
        response = self.client.queues.regenerate_keys(
            resource_group_name=resource_group.name,
            namespace_name="str",
            queue_name="str",
            authorization_rule_name="str",
            parameters={"keyType": "str", "key": "str"},
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_queues_list_by_namespace(self, resource_group):
        response = self.client.queues.list_by_namespace(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2021-11-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_queues_create_or_update(self, resource_group):
        response = self.client.queues.create_or_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            queue_name="str",
            parameters={
                "accessedAt": "2020-02-20 00:00:00",
                "autoDeleteOnIdle": "1 day, 0:00:00",
                "countDetails": {
                    "activeMessageCount": 0,
                    "deadLetterMessageCount": 0,
                    "scheduledMessageCount": 0,
                    "transferDeadLetterMessageCount": 0,
                    "transferMessageCount": 0,
                },
                "createdAt": "2020-02-20 00:00:00",
                "deadLetteringOnMessageExpiration": bool,
                "defaultMessageTimeToLive": "1 day, 0:00:00",
                "duplicateDetectionHistoryTimeWindow": "1 day, 0:00:00",
                "enableBatchedOperations": bool,
                "enableExpress": bool,
                "enablePartitioning": bool,
                "forwardDeadLetteredMessagesTo": "str",
                "forwardTo": "str",
                "id": "str",
                "location": "str",
                "lockDuration": "1 day, 0:00:00",
                "maxDeliveryCount": 0,
                "maxMessageSizeInKilobytes": 0,
                "maxSizeInMegabytes": 0,
                "messageCount": 0,
                "name": "str",
                "requiresDuplicateDetection": bool,
                "requiresSession": bool,
                "sizeInBytes": 0,
                "status": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
                "updatedAt": "2020-02-20 00:00:00",
            },
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_queues_delete(self, resource_group):
        response = self.client.queues.delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
            queue_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_queues_get(self, resource_group):
        response = self.client.queues.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            queue_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...
