# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementGatewayOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gateway_list_by_service(self, resource_group):
        response = self.client.gateway.list_by_service(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gateway_get_entity_tag(self, resource_group):
        response = self.client.gateway.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            gateway_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gateway_get(self, resource_group):
        response = self.client.gateway.get(
            resource_group_name=resource_group.name,
            service_name="str",
            gateway_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gateway_create_or_update(self, resource_group):
        response = self.client.gateway.create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            gateway_id="str",
            parameters={
                "description": "str",
                "id": "str",
                "locationData": {"name": "str", "city": "str", "countryOrRegion": "str", "district": "str"},
                "name": "str",
                "type": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gateway_update(self, resource_group):
        response = self.client.gateway.update(
            resource_group_name=resource_group.name,
            service_name="str",
            gateway_id="str",
            if_match="str",
            parameters={
                "description": "str",
                "id": "str",
                "locationData": {"name": "str", "city": "str", "countryOrRegion": "str", "district": "str"},
                "name": "str",
                "type": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gateway_delete(self, resource_group):
        response = self.client.gateway.delete(
            resource_group_name=resource_group.name,
            service_name="str",
            gateway_id="str",
            if_match="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gateway_list_keys(self, resource_group):
        response = self.client.gateway.list_keys(
            resource_group_name=resource_group.name,
            service_name="str",
            gateway_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gateway_regenerate_key(self, resource_group):
        response = self.client.gateway.regenerate_key(
            resource_group_name=resource_group.name,
            service_name="str",
            gateway_id="str",
            parameters={"keyType": "str"},
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gateway_generate_token(self, resource_group):
        response = self.client.gateway.generate_token(
            resource_group_name=resource_group.name,
            service_name="str",
            gateway_id="str",
            parameters={"expiry": "2020-02-20 00:00:00", "keyType": "str"},
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gateway_invalidate_debug_credentials(self, resource_group):
        response = self.client.gateway.invalidate_debug_credentials(
            resource_group_name=resource_group.name,
            service_name="str",
            gateway_id="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gateway_list_debug_credentials(self, resource_group):
        response = self.client.gateway.list_debug_credentials(
            resource_group_name=resource_group.name,
            service_name="str",
            gateway_id="str",
            parameters={"apiId": "str", "purposes": ["str"], "credentialsExpireAfter": "1 day, 0:00:00"},
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_gateway_list_trace(self, resource_group):
        response = self.client.gateway.list_trace(
            resource_group_name=resource_group.name,
            service_name="str",
            gateway_id="str",
            parameters={"traceId": "str"},
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
