# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.azurestackhci import AzureStackHCIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAzureStackHCIExtensionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AzureStackHCIClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_arc_setting(self, resource_group):
        response = self.client.extensions.list_by_arc_setting(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            api_version="2024-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.extensions.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            extension_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create(self, resource_group):
        response = self.client.extensions.begin_create(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            extension_name="str",
            extension={
                "aggregateState": "str",
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                "forceUpdateTag": "str",
                "id": "str",
                "managedBy": "str",
                "name": "str",
                "perNodeExtensionDetails": [
                    {
                        "extension": "str",
                        "instanceView": {
                            "name": "str",
                            "status": {
                                "code": "str",
                                "displayStatus": "str",
                                "level": "str",
                                "message": "str",
                                "time": "2020-02-20 00:00:00",
                            },
                            "type": "str",
                            "typeHandlerVersion": "str",
                        },
                        "name": "str",
                        "state": "str",
                        "typeHandlerVersion": "str",
                    }
                ],
                "protectedSettings": {},
                "provisioningState": "str",
                "publisher": "str",
                "settings": {},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
                "typeHandlerVersion": "str",
            },
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_update(self, resource_group):
        response = self.client.extensions.begin_update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            extension_name="str",
            extension={
                "extensionParameters": {
                    "enableAutomaticUpgrade": bool,
                    "protectedSettings": {},
                    "settings": {},
                    "typeHandlerVersion": "str",
                }
            },
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.extensions.begin_delete(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            extension_name="str",
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_upgrade(self, resource_group):
        response = self.client.extensions.begin_upgrade(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            extension_name="str",
            extension_upgrade_parameters={"targetVersion": "str"},
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
