# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import MatchingPolicyKind

if TYPE_CHECKING:
    from .. import models as _models


class AnswersFromTextOptions(_Model):
    """The question and text record parameters to answer.

    :ivar question: User question to query against the given text records. Required.
    :vartype question: str
    :ivar text_documents: Text records to be searched for given question. Required.
    :vartype text_documents: list[~azure.ai.language.questionanswering.models.TextDocument]
    :ivar language: Language of the text records. This is BCP-47 representation of a language. For
     example, use "en" for English; "es" for Spanish etc. If not set, use "en" for
     English as default.
    :vartype language: str
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text
     Elements (Graphemes) according to Unicode v8.0.0. For additional information
     see `https://aka.ms/text-analytics-offsets <https://aka.ms/text-analytics-offsets>`_. Known
     values are: "TextElements_v8", "UnicodeCodePoint", and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.language.questionanswering.models.StringIndexType
    """

    question: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """User question to query against the given text records. Required."""
    text_documents: list["_models.TextDocument"] = rest_field(
        name="records", visibility=["read", "create", "update", "delete", "query"]
    )
    """Text records to be searched for given question. Required."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Language of the text records. This is BCP-47 representation of a language. For
     example, use \"en\" for English; \"es\" for Spanish etc. If not set, use \"en\" for
     English as default."""
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the method used to interpret string offsets.  Defaults to Text
     Elements (Graphemes) according to Unicode v8.0.0. For additional information
     see `https://aka.ms/text-analytics-offsets <https://aka.ms/text-analytics-offsets>`_. Known
     values are: \"TextElements_v8\", \"UnicodeCodePoint\", and \"Utf16CodeUnit\"."""

    @overload
    def __init__(
        self,
        *,
        question: str,
        text_documents: list["_models.TextDocument"],
        language: Optional[str] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnswersFromTextResult(_Model):
    """Represents the answer results.

    :ivar answers: Represents the answer results.
    :vartype answers: list[~azure.ai.language.questionanswering.models.TextAnswer]
    """

    answers: Optional[list["_models.TextAnswer"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the answer results."""

    @overload
    def __init__(
        self,
        *,
        answers: Optional[list["_models.TextAnswer"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnswersOptions(_Model):
    """Parameters to query a knowledge base.

    :ivar qna_id: Exact QnA ID to fetch from the knowledge base, this field takes priority over
     question.
    :vartype qna_id: int
    :ivar question: User question to query against the knowledge base.
    :vartype question: str
    :ivar top: Max number of answers to be returned for the question.
    :vartype top: int
    :ivar user_id: Unique identifier for the user.
    :vartype user_id: str
    :ivar confidence_threshold: Minimum threshold score for answers, value ranges from 0 to 1.
    :vartype confidence_threshold: float
    :ivar answer_context: Context object with previous QnA's information.
    :vartype answer_context: ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerContext
    :ivar ranker_kind: Type of ranker to be used. Known values are: "QuestionOnly" and "Default".
    :vartype ranker_kind: str or ~azure.ai.language.questionanswering.models.RankerKind
    :ivar filters: Filter QnAs based on given metadata list and knowledge base sources.
    :vartype filters: ~azure.ai.language.questionanswering.models.QueryFilters
    :ivar short_answer_options: To configure Answer span prediction feature.
    :vartype short_answer_options: ~azure.ai.language.questionanswering.models.ShortAnswerOptions
    :ivar include_unstructured_sources: (Optional) Flag to enable Query over Unstructured Sources.
    :vartype include_unstructured_sources: bool
    :ivar query_preferences: To fine tune query results.
    :vartype query_preferences: ~azure.ai.language.questionanswering.models.QueryPreferences
    """

    qna_id: Optional[int] = rest_field(name="qnaId", visibility=["read", "create", "update", "delete", "query"])
    """Exact QnA ID to fetch from the knowledge base, this field takes priority over
     question."""
    question: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """User question to query against the knowledge base."""
    top: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Max number of answers to be returned for the question."""
    user_id: Optional[str] = rest_field(name="userId", visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the user."""
    confidence_threshold: Optional[float] = rest_field(
        name="confidenceScoreThreshold", visibility=["read", "create", "update", "delete", "query"]
    )
    """Minimum threshold score for answers, value ranges from 0 to 1."""
    answer_context: Optional["_models.KnowledgeBaseAnswerContext"] = rest_field(
        name="context", visibility=["read", "create", "update", "delete", "query"]
    )
    """Context object with previous QnA's information."""
    ranker_kind: Optional[Union[str, "_models.RankerKind"]] = rest_field(
        name="rankerType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of ranker to be used. Known values are: \"QuestionOnly\" and \"Default\"."""
    filters: Optional["_models.QueryFilters"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Filter QnAs based on given metadata list and knowledge base sources."""
    short_answer_options: Optional["_models.ShortAnswerOptions"] = rest_field(
        name="answerSpanRequest", visibility=["read", "create", "update", "delete", "query"]
    )
    """To configure Answer span prediction feature."""
    include_unstructured_sources: Optional[bool] = rest_field(
        name="includeUnstructuredSources", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Optional) Flag to enable Query over Unstructured Sources."""
    query_preferences: Optional["_models.QueryPreferences"] = rest_field(
        name="queryPreferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """To fine tune query results."""

    @overload
    def __init__(
        self,
        *,
        qna_id: Optional[int] = None,
        question: Optional[str] = None,
        top: Optional[int] = None,
        user_id: Optional[str] = None,
        confidence_threshold: Optional[float] = None,
        answer_context: Optional["_models.KnowledgeBaseAnswerContext"] = None,
        ranker_kind: Optional[Union[str, "_models.RankerKind"]] = None,
        filters: Optional["_models.QueryFilters"] = None,
        short_answer_options: Optional["_models.ShortAnswerOptions"] = None,
        include_unstructured_sources: Optional[bool] = None,
        query_preferences: Optional["_models.QueryPreferences"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnswerSpan(_Model):
    """Answer span object of QnA.

    :ivar text: Predicted text of answer span.
    :vartype text: str
    :ivar confidence: Predicted score of answer span, value ranges from 0 to 1.
    :vartype confidence: float
    :ivar offset: The answer span offset from the start of answer.
    :vartype offset: int
    :ivar length: The length of the answer span.
    :vartype length: int
    """

    text: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Predicted text of answer span."""
    confidence: Optional[float] = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Predicted score of answer span, value ranges from 0 to 1."""
    offset: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The answer span offset from the start of answer."""
    length: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length of the answer span."""

    @overload
    def __init__(
        self,
        *,
        text: Optional[str] = None,
        confidence: Optional[float] = None,
        offset: Optional[int] = None,
        length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnswersResult(_Model):
    """Represents List of Question Answers.

    :ivar answers: Represents Answer Result list.
    :vartype answers: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswer]
    """

    answers: Optional[list["_models.KnowledgeBaseAnswer"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents Answer Result list."""

    @overload
    def __init__(
        self,
        *,
        answers: Optional[list["_models.KnowledgeBaseAnswer"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Error(_Model):
    """The error response object returned when the service encounters some errors during processing
    the request.

    :ivar code: One of a server-defined set of error codes. Required. Known values are:
     "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
     "ProjectNotFound", "OperationNotFound", "AzureCognitiveSearchNotFound",
     "AzureCognitiveSearchIndexNotFound", "TooManyRequests", "AzureCognitiveSearchThrottling",
     "AzureCognitiveSearchIndexLimitReached", "InternalServerError", "ServiceUnavailable",
     "Timeout", "QuotaExceeded", "Conflict", and "Warning".
    :vartype code: str or ~azure.ai.language.questionanswering.models.ErrorCode
    :ivar message: A human-readable representation of the error. Required.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.ai.language.questionanswering.models.Error]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
    """

    code: Union[str, "_models.ErrorCode"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """One of a server-defined set of error codes. Required. Known values are: \"InvalidRequest\",
     \"InvalidArgument\", \"Unauthorized\", \"Forbidden\", \"NotFound\", \"ProjectNotFound\",
     \"OperationNotFound\", \"AzureCognitiveSearchNotFound\", \"AzureCognitiveSearchIndexNotFound\",
     \"TooManyRequests\", \"AzureCognitiveSearchThrottling\",
     \"AzureCognitiveSearchIndexLimitReached\", \"InternalServerError\", \"ServiceUnavailable\",
     \"Timeout\", \"QuotaExceeded\", \"Conflict\", and \"Warning\"."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human-readable representation of the error. Required."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target of the error."""
    details: Optional[list["_models.Error"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An array of details about specific errors that led to this reported error."""
    innererror: Optional["_models.InnerErrorModel"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An object containing more specific information than the current object about the error."""

    @overload
    def __init__(
        self,
        *,
        code: Union[str, "_models.ErrorCode"],
        message: str,
        target: Optional[str] = None,
        details: Optional[list["_models.Error"]] = None,
        innererror: Optional["_models.InnerErrorModel"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object. Required.
    :vartype error: ~azure.ai.language.questionanswering.models.Error
    """

    error: "_models.Error" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object. Required."""

    @overload
    def __init__(
        self,
        *,
        error: "_models.Error",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InnerErrorModel(_Model):
    """An object containing more specific information about the error. As per
    Microsoft One API guidelines -
    `https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses
    <https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses>`_.

    :ivar code: One of a server-defined set of error codes. Required. Known values are:
     "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
     "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure",
     "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputDocuments", "InvalidDocument",
     "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode", and
     "InvalidCountryHint".
    :vartype code: str or ~azure.ai.language.questionanswering.models.InnerErrorCode
    :ivar message: Error message. Required.
    :vartype message: str
    :ivar details: Error details.
    :vartype details: dict[str, str]
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
    """

    code: Union[str, "_models.InnerErrorCode"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """One of a server-defined set of error codes. Required. Known values are: \"InvalidRequest\",
     \"InvalidParameterValue\", \"KnowledgeBaseNotFound\", \"AzureCognitiveSearchNotFound\",
     \"AzureCognitiveSearchThrottling\", \"ExtractionFailure\", \"InvalidRequestBodyFormat\",
     \"EmptyRequest\", \"MissingInputDocuments\", \"InvalidDocument\", \"ModelVersionIncorrect\",
     \"InvalidDocumentBatch\", \"UnsupportedLanguageCode\", and \"InvalidCountryHint\"."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error message. Required."""
    details: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error details."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error target."""
    innererror: Optional["_models.InnerErrorModel"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An object containing more specific information than the current object about
     the error."""

    @overload
    def __init__(
        self,
        *,
        code: Union[str, "_models.InnerErrorCode"],
        message: str,
        details: Optional[dict[str, str]] = None,
        target: Optional[str] = None,
        innererror: Optional["_models.InnerErrorModel"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseAnswer(_Model):
    """Represents knowledge base answer.

    :ivar questions: List of questions associated with the answer.
    :vartype questions: list[str]
    :ivar answer: Answer text.
    :vartype answer: str
    :ivar confidence: Answer confidence score, value ranges from 0 to 1.
    :vartype confidence: float
    :ivar qna_id: ID of the QnA result.
    :vartype qna_id: int
    :ivar source: Source of QnA result.
    :vartype source: str
    :ivar metadata: Metadata associated with the answer, useful to categorize or filter question
     answers.
    :vartype metadata: dict[str, str]
    :ivar dialog: Dialog associated with Answer.
    :vartype dialog: ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerDialog
    :ivar short_answer: Answer span object of QnA with respect to user's question.
    :vartype short_answer: ~azure.ai.language.questionanswering.models.AnswerSpan
    """

    questions: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of questions associated with the answer."""
    answer: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Answer text."""
    confidence: Optional[float] = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Answer confidence score, value ranges from 0 to 1."""
    qna_id: Optional[int] = rest_field(name="id", visibility=["read", "create", "update", "delete", "query"])
    """ID of the QnA result."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Source of QnA result."""
    metadata: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata associated with the answer, useful to categorize or filter question
     answers."""
    dialog: Optional["_models.KnowledgeBaseAnswerDialog"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Dialog associated with Answer."""
    short_answer: Optional["_models.AnswerSpan"] = rest_field(
        name="answerSpan", visibility=["read", "create", "update", "delete", "query"]
    )
    """Answer span object of QnA with respect to user's question."""

    @overload
    def __init__(
        self,
        *,
        questions: Optional[list[str]] = None,
        answer: Optional[str] = None,
        confidence: Optional[float] = None,
        qna_id: Optional[int] = None,
        source: Optional[str] = None,
        metadata: Optional[dict[str, str]] = None,
        dialog: Optional["_models.KnowledgeBaseAnswerDialog"] = None,
        short_answer: Optional["_models.AnswerSpan"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseAnswerContext(_Model):
    """Context object with previous QnA's information.

    :ivar previous_qna_id: Previous turn top answer result QnA ID. Required.
    :vartype previous_qna_id: int
    :ivar previous_question: Previous user query.
    :vartype previous_question: str
    """

    previous_qna_id: int = rest_field(name="previousQnaId", visibility=["read", "create", "update", "delete", "query"])
    """Previous turn top answer result QnA ID. Required."""
    previous_question: Optional[str] = rest_field(
        name="previousUserQuery", visibility=["read", "create", "update", "delete", "query"]
    )
    """Previous user query."""

    @overload
    def __init__(
        self,
        *,
        previous_qna_id: int,
        previous_question: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseAnswerDialog(_Model):
    """Dialog associated with Answer.

    :ivar is_context_only: To mark if a prompt is relevant only with a previous question or not. If
     true,
     do not include this QnA as search result for queries without context;
     otherwise, if false, ignores context and includes this QnA in search result.
    :vartype is_context_only: bool
    :ivar prompts: List of prompts associated with the answer.
    :vartype prompts: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerPrompt]
    """

    is_context_only: Optional[bool] = rest_field(
        name="isContextOnly", visibility=["read", "create", "update", "delete", "query"]
    )
    """To mark if a prompt is relevant only with a previous question or not. If true,
     do not include this QnA as search result for queries without context;
     otherwise, if false, ignores context and includes this QnA in search result."""
    prompts: Optional[list["_models.KnowledgeBaseAnswerPrompt"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of prompts associated with the answer."""

    @overload
    def __init__(
        self,
        *,
        is_context_only: Optional[bool] = None,
        prompts: Optional[list["_models.KnowledgeBaseAnswerPrompt"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseAnswerPrompt(_Model):
    """Prompt for an answer.

    :ivar display_order: Index of the prompt - used in ordering of the prompts.
    :vartype display_order: int
    :ivar qna_id: QnA ID corresponding to the prompt.
    :vartype qna_id: int
    :ivar display_text: Text displayed to represent a follow up question prompt.
    :vartype display_text: str
    """

    display_order: Optional[int] = rest_field(
        name="displayOrder", visibility=["read", "create", "update", "delete", "query"]
    )
    """Index of the prompt - used in ordering of the prompts."""
    qna_id: Optional[int] = rest_field(name="qnaId", visibility=["read", "create", "update", "delete", "query"])
    """QnA ID corresponding to the prompt."""
    display_text: Optional[str] = rest_field(
        name="displayText", visibility=["read", "create", "update", "delete", "query"]
    )
    """Text displayed to represent a follow up question prompt."""

    @overload
    def __init__(
        self,
        *,
        display_order: Optional[int] = None,
        qna_id: Optional[int] = None,
        display_text: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MatchingPolicy(_Model):
    """Specify parameters for query matching.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    PrebuiltQueryMatchingPolicy

    :ivar kind: Kind of matching policy to be applied. Required. "Prebuilt"
    :vartype kind: str or ~azure.ai.language.questionanswering.models.MatchingPolicyKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Kind of matching policy to be applied. Required. \"Prebuilt\""""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetadataFilter(_Model):
    """Find QnAs that are associated with the given list of metadata.

    :ivar metadata: Dictionary of string.
    :vartype metadata: list[~azure.ai.language.questionanswering.models.MetadataRecord]
    :ivar logical_operation: Operation used to join metadata filters. Known values are: "AND" and
     "OR".
    :vartype logical_operation: str or
     ~azure.ai.language.questionanswering.models.LogicalOperationKind
    """

    metadata: Optional[list["_models.MetadataRecord"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Dictionary of string."""
    logical_operation: Optional[Union[str, "_models.LogicalOperationKind"]] = rest_field(
        name="logicalOperation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Operation used to join metadata filters. Known values are: \"AND\" and \"OR\"."""

    @overload
    def __init__(
        self,
        *,
        metadata: Optional[list["_models.MetadataRecord"]] = None,
        logical_operation: Optional[Union[str, "_models.LogicalOperationKind"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetadataRecord(_Model):
    """Object to provide the key value pair for each metadata.

    :ivar key: Metadata Key from Metadata dictionary used in the QnA. Required.
    :vartype key: str
    :ivar value: Metadata Value from Metadata dictionary used in the QnA. Required.
    :vartype value: str
    """

    key: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata Key from Metadata dictionary used in the QnA. Required."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata Value from Metadata dictionary used in the QnA. Required."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrebuiltQueryMatchingPolicy(MatchingPolicy, discriminator="Prebuilt"):
    """Represents fields for Prebuilt query matching. Prebuilt weights will be used for giving
    preference to question and answer columns when quering AI search.

    :ivar kind: Matching policy kind. Required. Prebuilt weights will be used for giving preference
     to question and answer columns when quering AI search
    :vartype kind: str or ~azure.ai.language.questionanswering.models.PREBUILT
    :ivar fields: List of fields to filter during query. For ex if only "questions" is used then
     query will be filtered on that column.
    :vartype fields: list[str or
     ~azure.ai.language.questionanswering.models.MatchingPolicyFieldsType]
    :ivar disable_full_match: Disabling full match on query. Enabling this will give preference to
     qna pairs that have exact match.
    :vartype disable_full_match: bool
    """

    kind: Literal[MatchingPolicyKind.PREBUILT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Matching policy kind. Required. Prebuilt weights will be used for giving preference to question
     and answer columns when quering AI search"""
    fields: Optional[list[Union[str, "_models.MatchingPolicyFieldsType"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of fields to filter during query. For ex if only \"questions\" is used then query will be
     filtered on that column."""
    disable_full_match: Optional[bool] = rest_field(
        name="disableFullMatch", visibility=["read", "create", "update", "delete", "query"]
    )
    """Disabling full match on query. Enabling this will give preference to qna pairs that have exact
     match."""

    @overload
    def __init__(
        self,
        *,
        fields: Optional[list[Union[str, "_models.MatchingPolicyFieldsType"]]] = None,
        disable_full_match: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=MatchingPolicyKind.PREBUILT, **kwargs)


class QueryFilters(_Model):
    """filters over knowledge base.

    :ivar metadata_filter: Find QnAs that are associated with the given list of metadata.
    :vartype metadata_filter: ~azure.ai.language.questionanswering.models.MetadataFilter
    :ivar source_filter: Find QnAs that are associated with any of the given list of sources in
     knowledge base.
    :vartype source_filter: list[str]
    :ivar logical_operation: Logical operation used to join metadata filter with source filter.
     Known values are: "AND" and "OR".
    :vartype logical_operation: str or
     ~azure.ai.language.questionanswering.models.LogicalOperationKind
    """

    metadata_filter: Optional["_models.MetadataFilter"] = rest_field(
        name="metadataFilter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Find QnAs that are associated with the given list of metadata."""
    source_filter: Optional[list[str]] = rest_field(
        name="sourceFilter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Find QnAs that are associated with any of the given list of sources in
     knowledge base."""
    logical_operation: Optional[Union[str, "_models.LogicalOperationKind"]] = rest_field(
        name="logicalOperation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Logical operation used to join metadata filter with source filter. Known values are: \"AND\"
     and \"OR\"."""

    @overload
    def __init__(
        self,
        *,
        metadata_filter: Optional["_models.MetadataFilter"] = None,
        source_filter: Optional[list[str]] = None,
        logical_operation: Optional[Union[str, "_models.LogicalOperationKind"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QueryPreferences(_Model):
    """Additional properties to fine tune query results.

    :ivar scorer: To specify what scoring algorithm is preferred. Known values are: "Classic",
     "Transformer", and "Semantic".
    :vartype scorer: str or ~azure.ai.language.questionanswering.models.Scorer
    :ivar matching_policy: Policy for controling exact query match behavior.
    :vartype matching_policy: ~azure.ai.language.questionanswering.models.MatchingPolicy
    """

    scorer: Optional[Union[str, "_models.Scorer"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """To specify what scoring algorithm is preferred. Known values are: \"Classic\", \"Transformer\",
     and \"Semantic\"."""
    matching_policy: Optional["_models.MatchingPolicy"] = rest_field(
        name="matchingPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Policy for controling exact query match behavior."""

    @overload
    def __init__(
        self,
        *,
        scorer: Optional[Union[str, "_models.Scorer"]] = None,
        matching_policy: Optional["_models.MatchingPolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ShortAnswerOptions(_Model):
    """To configure Answer span prediction feature.

    :ivar enable: Enable or disable Answer Span prediction. Required.
    :vartype enable: bool
    :ivar confidence_threshold: Minimum threshold score required to include an answer span, value
     ranges from 0
     to 1.
    :vartype confidence_threshold: float
    :ivar top: Number of Top answers to be considered for span prediction from 1 to 10.
    :vartype top: int
    """

    enable: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Enable or disable Answer Span prediction. Required."""
    confidence_threshold: Optional[float] = rest_field(
        name="confidenceScoreThreshold", visibility=["read", "create", "update", "delete", "query"]
    )
    """Minimum threshold score required to include an answer span, value ranges from 0
     to 1."""
    top: Optional[int] = rest_field(
        name="topAnswersWithSpan", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of Top answers to be considered for span prediction from 1 to 10."""

    @overload
    def __init__(
        self,
        *,
        enable: bool,
        confidence_threshold: Optional[float] = None,
        top: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TextAnswer(_Model):
    """Represents answer result.

    :ivar answer: Answer.
    :vartype answer: str
    :ivar confidence: answer confidence score, value ranges from 0 to 1.
    :vartype confidence: float
    :ivar id: record ID.
    :vartype id: str
    :ivar short_answer: Answer span object with respect to user's question.
    :vartype short_answer: ~azure.ai.language.questionanswering.models.AnswerSpan
    :ivar offset: The sentence offset from the start of the document.
    :vartype offset: int
    :ivar length: The length of the sentence.
    :vartype length: int
    """

    answer: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Answer."""
    confidence: Optional[float] = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """answer confidence score, value ranges from 0 to 1."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """record ID."""
    short_answer: Optional["_models.AnswerSpan"] = rest_field(
        name="answerSpan", visibility=["read", "create", "update", "delete", "query"]
    )
    """Answer span object with respect to user's question."""
    offset: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sentence offset from the start of the document."""
    length: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length of the sentence."""

    @overload
    def __init__(
        self,
        *,
        answer: Optional[str] = None,
        confidence: Optional[float] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        short_answer: Optional["_models.AnswerSpan"] = None,
        offset: Optional[int] = None,
        length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TextDocument(_Model):
    """Represent input text record to be queried.

    :ivar id: Unique identifier for the text record. Required.
    :vartype id: str
    :ivar text: Text contents of the record. Required.
    :vartype text: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the text record. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Text contents of the record. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
