# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AgentProfile(_Model):
    """Agent profile for the Fleet hub.

    :ivar subnet_id: The ID of the subnet which the Fleet hub node will join on startup. If this is
     not specified, a vnet and subnet will be generated and used.
    :vartype subnet_id: str
    :ivar vm_size: The virtual machine size of the Fleet hub.
    :vartype vm_size: str
    """

    subnet_id: Optional[str] = rest_field(name="subnetId", visibility=["read", "create"])
    """The ID of the subnet which the Fleet hub node will join on startup. If this is not specified, a
     vnet and subnet will be generated and used."""
    vm_size: Optional[str] = rest_field(name="vmSize", visibility=["read", "create"])
    """The virtual machine size of the Fleet hub."""

    @overload
    def __init__(
        self,
        *,
        subnet_id: Optional[str] = None,
        vm_size: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class APIServerAccessProfile(_Model):
    """Access profile for the Fleet hub API server.

    :ivar enable_private_cluster: Whether to create the Fleet hub as a private cluster or not.
    :vartype enable_private_cluster: bool
    :ivar enable_vnet_integration: Whether to enable apiserver vnet integration for the Fleet hub
     or not.
    :vartype enable_vnet_integration: bool
    :ivar subnet_id: The subnet to be used when apiserver vnet integration is enabled. It is
     required when creating a new Fleet with BYO vnet.
    :vartype subnet_id: str
    """

    enable_private_cluster: Optional[bool] = rest_field(name="enablePrivateCluster", visibility=["read", "create"])
    """Whether to create the Fleet hub as a private cluster or not."""
    enable_vnet_integration: Optional[bool] = rest_field(name="enableVnetIntegration", visibility=["read", "create"])
    """Whether to enable apiserver vnet integration for the Fleet hub or not."""
    subnet_id: Optional[str] = rest_field(name="subnetId", visibility=["read", "create"])
    """The subnet to be used when apiserver vnet integration is enabled. It is required when creating
     a new Fleet with BYO vnet."""

    @overload
    def __init__(
        self,
        *,
        enable_private_cluster: Optional[bool] = None,
        enable_vnet_integration: Optional[bool] = None,
        subnet_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutoUpgradeNodeImageSelection(_Model):
    """The node image upgrade to be applied to the target clusters in auto upgrade.

    :ivar type: The node image upgrade type. Required. Known values are: "Latest" and "Consistent".
    :vartype type: str or
     ~azure.mgmt.containerservicefleet.models.AutoUpgradeNodeImageSelectionType
    """

    type: Union[str, "_models.AutoUpgradeNodeImageSelectionType"] = rest_field(visibility=["read", "create"])
    """The node image upgrade type. Required. Known values are: \"Latest\" and \"Consistent\"."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.AutoUpgradeNodeImageSelectionType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.models.SystemData
    """


class AutoUpgradeProfile(ProxyResource):
    """The AutoUpgradeProfile resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.containerservicefleet.models.AutoUpgradeProfileProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.AutoUpgradeProfileProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    __flattened_items = [
        "provisioning_state",
        "update_strategy_id",
        "channel",
        "node_image_selection",
        "disabled",
        "auto_upgrade_profile_status",
        "target_kubernetes_version",
        "long_term_support",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.AutoUpgradeProfileProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class AutoUpgradeProfileProperties(_Model):
    """The properties of the AutoUpgradeProfile.

    :ivar provisioning_state: The provisioning state of the AutoUpgradeProfile resource. Known
     values are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservicefleet.models.AutoUpgradeProfileProvisioningState
    :ivar update_strategy_id: The resource id of the UpdateStrategy resource to reference. If not
     specified, the auto upgrade will run on all clusters which are members of the fleet.
    :vartype update_strategy_id: str
    :ivar channel: Configures how auto-upgrade will be run. Required. Known values are: "Stable",
     "Rapid", "NodeImage", and "TargetKubernetesVersion".
    :vartype channel: str or ~azure.mgmt.containerservicefleet.models.UpgradeChannel
    :ivar node_image_selection: The node image upgrade to be applied to the target clusters in auto
     upgrade.
    :vartype node_image_selection:
     ~azure.mgmt.containerservicefleet.models.AutoUpgradeNodeImageSelection
    :ivar disabled: If set to False: the auto upgrade has effect - target managed clusters will be
     upgraded on schedule.
     If set to True: the auto upgrade has no effect - no upgrade will be run on the target managed
     clusters.
     This is a boolean and not an enum because enabled/disabled are all available states of the auto
     upgrade profile.
     By default, this is set to False.
    :vartype disabled: bool
    :ivar auto_upgrade_profile_status: The status of the auto upgrade profile.
    :vartype auto_upgrade_profile_status:
     ~azure.mgmt.containerservicefleet.models.AutoUpgradeProfileStatus
    :ivar target_kubernetes_version:   This is the target Kubernetes version for auto-upgrade. The
     format must be ``{major version}.{minor version}``. For example, "1.30".
       By default, this is empty.
       If upgrade channel is set to TargetKubernetesVersion, this field must not be empty.
       If upgrade channel is Rapid, Stable or NodeImage, this field must be empty.
    :vartype target_kubernetes_version: str
    :ivar long_term_support:   If upgrade channel is not TargetKubernetesVersion, this field must
     be False.
       If set to True: Fleet auto upgrade will continue generate update runs for patches of minor
     versions earlier than N-2
       (where N is the latest supported minor version) if those minor versions support Long-Term
     Support (LTS).
       By default, this is set to False.
       For more information on AKS LTS, please see
     `https://learn.microsoft.com/en-us/azure/aks/long-term-support
     <https://learn.microsoft.com/en-us/azure/aks/long-term-support>`_.
    :vartype long_term_support: bool
    """

    provisioning_state: Optional[Union[str, "_models.AutoUpgradeProfileProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the AutoUpgradeProfile resource. Known values are: \"Succeeded\",
     \"Failed\", and \"Canceled\"."""
    update_strategy_id: Optional[str] = rest_field(name="updateStrategyId", visibility=["read", "create"])
    """The resource id of the UpdateStrategy resource to reference. If not specified, the auto upgrade
     will run on all clusters which are members of the fleet."""
    channel: Union[str, "_models.UpgradeChannel"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configures how auto-upgrade will be run. Required. Known values are: \"Stable\", \"Rapid\",
     \"NodeImage\", and \"TargetKubernetesVersion\"."""
    node_image_selection: Optional["_models.AutoUpgradeNodeImageSelection"] = rest_field(
        name="nodeImageSelection", visibility=["read", "create", "update", "delete", "query"]
    )
    """The node image upgrade to be applied to the target clusters in auto upgrade."""
    disabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If set to False: the auto upgrade has effect - target managed clusters will be upgraded on
     schedule.
     If set to True: the auto upgrade has no effect - no upgrade will be run on the target managed
     clusters.
     This is a boolean and not an enum because enabled/disabled are all available states of the auto
     upgrade profile.
     By default, this is set to False."""
    auto_upgrade_profile_status: Optional["_models.AutoUpgradeProfileStatus"] = rest_field(
        name="autoUpgradeProfileStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the auto upgrade profile."""
    target_kubernetes_version: Optional[str] = rest_field(
        name="targetKubernetesVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """  This is the target Kubernetes version for auto-upgrade. The format must be ``{major
     version}.{minor version}``. For example, \"1.30\".
       By default, this is empty.
       If upgrade channel is set to TargetKubernetesVersion, this field must not be empty.
       If upgrade channel is Rapid, Stable or NodeImage, this field must be empty."""
    long_term_support: Optional[bool] = rest_field(
        name="longTermSupport", visibility=["read", "create", "update", "delete", "query"]
    )
    """  If upgrade channel is not TargetKubernetesVersion, this field must be False.
       If set to True: Fleet auto upgrade will continue generate update runs for patches of minor
     versions earlier than N-2
       (where N is the latest supported minor version) if those minor versions support Long-Term
     Support (LTS).
       By default, this is set to False.
       For more information on AKS LTS, please see
     `https://learn.microsoft.com/en-us/azure/aks/long-term-support
     <https://learn.microsoft.com/en-us/azure/aks/long-term-support>`_."""

    @overload
    def __init__(
        self,
        *,
        channel: Union[str, "_models.UpgradeChannel"],
        update_strategy_id: Optional[str] = None,
        node_image_selection: Optional["_models.AutoUpgradeNodeImageSelection"] = None,
        disabled: Optional[bool] = None,
        auto_upgrade_profile_status: Optional["_models.AutoUpgradeProfileStatus"] = None,
        target_kubernetes_version: Optional[str] = None,
        long_term_support: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutoUpgradeProfileStatus(_Model):
    """AutoUpgradeProfileStatus is the status of an auto upgrade profile.

    :ivar last_triggered_at: The UTC time of the last attempt to automatically create and start an
     UpdateRun as triggered by the release of new versions.
    :vartype last_triggered_at: ~datetime.datetime
    :ivar last_trigger_status: The status of the last AutoUpgrade trigger. Known values are:
     "Succeeded" and "Failed".
    :vartype last_trigger_status: str or
     ~azure.mgmt.containerservicefleet.models.AutoUpgradeLastTriggerStatus
    :ivar last_trigger_error: The error details of the last trigger.
    :vartype last_trigger_error: ~azure.mgmt.containerservicefleet.models.ErrorDetail
    :ivar last_trigger_upgrade_versions: The target Kubernetes version or node image versions of
     the last trigger.
    :vartype last_trigger_upgrade_versions: list[str]
    """

    last_triggered_at: Optional[datetime.datetime] = rest_field(
        name="lastTriggeredAt", visibility=["read"], format="rfc3339"
    )
    """The UTC time of the last attempt to automatically create and start an UpdateRun as triggered by
     the release of new versions."""
    last_trigger_status: Optional[Union[str, "_models.AutoUpgradeLastTriggerStatus"]] = rest_field(
        name="lastTriggerStatus", visibility=["read"]
    )
    """The status of the last AutoUpgrade trigger. Known values are: \"Succeeded\" and \"Failed\"."""
    last_trigger_error: Optional["_models.ErrorDetail"] = rest_field(name="lastTriggerError", visibility=["read"])
    """The error details of the last trigger."""
    last_trigger_upgrade_versions: Optional[List[str]] = rest_field(
        name="lastTriggerUpgradeVersions", visibility=["read"]
    )
    """The target Kubernetes version or node image versions of the last trigger."""


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.containerservicefleet.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.containerservicefleet.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.containerservicefleet.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Fleet(TrackedResource):
    """The Fleet resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.containerservicefleet.models.FleetProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    :ivar identity: Managed identity.
    :vartype identity: ~azure.mgmt.containerservicefleet.models.ManagedServiceIdentity
    """

    properties: Optional["_models.FleetProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed identity."""

    __flattened_items = ["provisioning_state", "hub_profile", "status"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.FleetProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class FleetCredentialResult(_Model):
    """One credential result item.

    :ivar name: The name of the credential.
    :vartype name: str
    :ivar value: Base64-encoded Kubernetes configuration file.
    :vartype value: bytes
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the credential."""
    value: Optional[bytes] = rest_field(visibility=["read"], format="base64")
    """Base64-encoded Kubernetes configuration file."""


class FleetCredentialResults(_Model):
    """The Credential results response.

    :ivar kubeconfigs: Array of base64-encoded Kubernetes configuration files.
    :vartype kubeconfigs: list[~azure.mgmt.containerservicefleet.models.FleetCredentialResult]
    """

    kubeconfigs: Optional[List["_models.FleetCredentialResult"]] = rest_field(visibility=["read"])
    """Array of base64-encoded Kubernetes configuration files."""


class FleetHubProfile(_Model):
    """The FleetHubProfile configures the fleet hub.

    :ivar dns_prefix: DNS prefix used to create the FQDN for the Fleet hub.
    :vartype dns_prefix: str
    :ivar api_server_access_profile: The access profile for the Fleet hub API server.
    :vartype api_server_access_profile:
     ~azure.mgmt.containerservicefleet.models.APIServerAccessProfile
    :ivar agent_profile: The agent profile for the Fleet hub.
    :vartype agent_profile: ~azure.mgmt.containerservicefleet.models.AgentProfile
    :ivar fqdn: The FQDN of the Fleet hub.
    :vartype fqdn: str
    :ivar kubernetes_version: The Kubernetes version of the Fleet hub.
    :vartype kubernetes_version: str
    :ivar portal_fqdn: The Azure Portal FQDN of the Fleet hub.
    :vartype portal_fqdn: str
    """

    dns_prefix: Optional[str] = rest_field(name="dnsPrefix", visibility=["read", "create"])
    """DNS prefix used to create the FQDN for the Fleet hub."""
    api_server_access_profile: Optional["_models.APIServerAccessProfile"] = rest_field(
        name="apiServerAccessProfile", visibility=["read", "create"]
    )
    """The access profile for the Fleet hub API server."""
    agent_profile: Optional["_models.AgentProfile"] = rest_field(name="agentProfile", visibility=["read", "create"])
    """The agent profile for the Fleet hub."""
    fqdn: Optional[str] = rest_field(visibility=["read"])
    """The FQDN of the Fleet hub."""
    kubernetes_version: Optional[str] = rest_field(name="kubernetesVersion", visibility=["read"])
    """The Kubernetes version of the Fleet hub."""
    portal_fqdn: Optional[str] = rest_field(name="portalFqdn", visibility=["read"])
    """The Azure Portal FQDN of the Fleet hub."""

    @overload
    def __init__(
        self,
        *,
        dns_prefix: Optional[str] = None,
        api_server_access_profile: Optional["_models.APIServerAccessProfile"] = None,
        agent_profile: Optional["_models.AgentProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FleetMember(ProxyResource):
    """A member of the Fleet. It contains a reference to an existing Kubernetes cluster on Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.containerservicefleet.models.FleetMemberProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.FleetMemberProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    __flattened_items = ["cluster_resource_id", "group", "provisioning_state", "labels", "status"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.FleetMemberProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class FleetMemberProperties(_Model):
    """A member of the Fleet. It contains a reference to an existing Kubernetes cluster on Azure.

    :ivar cluster_resource_id: The ARM resource id of the cluster that joins the Fleet. Must be a
     valid Azure resource id. e.g.:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{clusterName}'.
     Required.
    :vartype cluster_resource_id: str
    :ivar group: The group this member belongs to for multi-cluster update management.
    :vartype group: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Joining", "Leaving", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservicefleet.models.FleetMemberProvisioningState
    :ivar labels: The labels for the fleet member.
    :vartype labels: dict[str, str]
    :ivar status: Status information of the last operation for fleet member.
    :vartype status: ~azure.mgmt.containerservicefleet.models.FleetMemberStatus
    """

    cluster_resource_id: str = rest_field(name="clusterResourceId", visibility=["read", "create"])
    """The ARM resource id of the cluster that joins the Fleet. Must be a valid Azure resource id.
     e.g.:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{clusterName}'.
     Required."""
    group: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The group this member belongs to for multi-cluster update management."""
    provisioning_state: Optional[Union[str, "_models.FleetMemberProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Joining\", \"Leaving\", and \"Updating\"."""
    labels: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The labels for the fleet member."""
    status: Optional["_models.FleetMemberStatus"] = rest_field(visibility=["read"])
    """Status information of the last operation for fleet member."""

    @overload
    def __init__(
        self,
        *,
        cluster_resource_id: str,
        group: Optional[str] = None,
        labels: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FleetMemberStatus(_Model):
    """Status information for the fleet member.

    :ivar last_operation_id: The last operation ID for the fleet member.
    :vartype last_operation_id: str
    :ivar last_operation_error: The last operation error of the fleet member.
    :vartype last_operation_error: ~azure.mgmt.containerservicefleet.models.ErrorDetail
    """

    last_operation_id: Optional[str] = rest_field(name="lastOperationId", visibility=["read"])
    """The last operation ID for the fleet member."""
    last_operation_error: Optional["_models.ErrorDetail"] = rest_field(name="lastOperationError", visibility=["read"])
    """The last operation error of the fleet member."""


class FleetMemberUpdate(_Model):
    """The type used for update operations of the FleetMember.

    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.containerservicefleet.models.FleetMemberUpdateProperties
    """

    properties: Optional["_models.FleetMemberUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["group", "labels"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.FleetMemberUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class FleetMemberUpdateProperties(_Model):
    """The updatable properties of the FleetMember.

    :ivar group: The group this member belongs to for multi-cluster update management.
    :vartype group: str
    :ivar labels: The labels for the fleet member.
    :vartype labels: dict[str, str]
    """

    group: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The group this member belongs to for multi-cluster update management."""
    labels: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The labels for the fleet member."""

    @overload
    def __init__(
        self,
        *,
        group: Optional[str] = None,
        labels: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FleetPatch(_Model):
    """Properties of a Fleet that can be patched.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed identity.
    :vartype identity: ~azure.mgmt.containerservicefleet.models.ManagedServiceIdentity
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed identity."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FleetProperties(_Model):
    """Fleet properties.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservicefleet.models.FleetProvisioningState
    :ivar hub_profile: The FleetHubProfile configures the Fleet's hub.
    :vartype hub_profile: ~azure.mgmt.containerservicefleet.models.FleetHubProfile
    :ivar status: Status information for the fleet.
    :vartype status: ~azure.mgmt.containerservicefleet.models.FleetStatus
    """

    provisioning_state: Optional[Union[str, "_models.FleetProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Creating\", \"Updating\", and \"Deleting\"."""
    hub_profile: Optional["_models.FleetHubProfile"] = rest_field(
        name="hubProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """The FleetHubProfile configures the Fleet's hub."""
    status: Optional["_models.FleetStatus"] = rest_field(visibility=["read"])
    """Status information for the fleet."""

    @overload
    def __init__(
        self,
        *,
        hub_profile: Optional["_models.FleetHubProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FleetStatus(_Model):
    """Status information for the fleet.

    :ivar last_operation_id: The last operation ID for the fleet.
    :vartype last_operation_id: str
    :ivar last_operation_error: The last operation error for the fleet.
    :vartype last_operation_error: ~azure.mgmt.containerservicefleet.models.ErrorDetail
    """

    last_operation_id: Optional[str] = rest_field(name="lastOperationId", visibility=["read"])
    """The last operation ID for the fleet."""
    last_operation_error: Optional["_models.ErrorDetail"] = rest_field(name="lastOperationError", visibility=["read"])
    """The last operation error for the fleet."""


class FleetUpdateStrategy(ProxyResource):
    """Defines a multi-stage process to perform update operations across members of a Fleet.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.containerservicefleet.models.FleetUpdateStrategyProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.FleetUpdateStrategyProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    __flattened_items = ["provisioning_state", "strategy"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.FleetUpdateStrategyProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class FleetUpdateStrategyProperties(_Model):
    """The properties of the UpdateStrategy.

    :ivar provisioning_state: The provisioning state of the UpdateStrategy resource. Known values
     are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservicefleet.models.FleetUpdateStrategyProvisioningState
    :ivar strategy: Defines the update sequence of the clusters. Required.
    :vartype strategy: ~azure.mgmt.containerservicefleet.models.UpdateRunStrategy
    """

    provisioning_state: Optional[Union[str, "_models.FleetUpdateStrategyProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the UpdateStrategy resource. Known values are: \"Succeeded\",
     \"Failed\", and \"Canceled\"."""
    strategy: "_models.UpdateRunStrategy" = rest_field(visibility=["read", "create", "update"])
    """Defines the update sequence of the clusters. Required."""

    @overload
    def __init__(
        self,
        *,
        strategy: "_models.UpdateRunStrategy",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Gate(ProxyResource):
    """A Gate controls the progression during a staged rollout, e.g. in an Update Run.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.containerservicefleet.models.GateProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.GateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    __flattened_items = ["provisioning_state", "display_name", "gate_type", "target", "state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.GateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class GateConfiguration(_Model):
    """GateConfiguration is used to define where Gates should be placed within the Update Run.

    :ivar display_name: The human-readable display name of the Gate.
    :vartype display_name: str
    :ivar type: The type of the Gate determines how it is completed. Required. "Approval"
    :vartype type: str or ~azure.mgmt.containerservicefleet.models.GateType
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The human-readable display name of the Gate."""
    type: Union[str, "_models.GateType"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of the Gate determines how it is completed. Required. \"Approval\""""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.GateType"],
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GatePatch(_Model):
    """Patch a Gate resource.

    :ivar properties: Properties of a Gate that can be patched. Required.
    :vartype properties: ~azure.mgmt.containerservicefleet.models.GatePatchProperties
    """

    properties: "_models.GatePatchProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties of a Gate that can be patched. Required."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.GatePatchProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GatePatchProperties(_Model):
    """Properties of a Gate that can be patched.

    :ivar state: The state of the Gate. Required. Known values are: "Pending", "Skipped", and
     "Completed".
    :vartype state: str or ~azure.mgmt.containerservicefleet.models.GateState
    """

    state: Union[str, "_models.GateState"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The state of the Gate. Required. Known values are: \"Pending\", \"Skipped\", and \"Completed\"."""

    @overload
    def __init__(
        self,
        *,
        state: Union[str, "_models.GateState"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GateProperties(_Model):
    """A Gate controls the progression during a staged rollout, e.g. in an Update Run.

    :ivar provisioning_state: The provisioning state of the Gate resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservicefleet.models.GateProvisioningState
    :ivar display_name: The human-readable display name of the Gate.
    :vartype display_name: str
    :ivar gate_type: The type of the Gate determines how it is completed. Required. "Approval"
    :vartype gate_type: str or ~azure.mgmt.containerservicefleet.models.GateType
    :ivar target: The target that the Gate is controlling, e.g. an Update Run. Required.
    :vartype target: ~azure.mgmt.containerservicefleet.models.GateTarget
    :ivar state: The state of the Gate. Required. Known values are: "Pending", "Skipped", and
     "Completed".
    :vartype state: str or ~azure.mgmt.containerservicefleet.models.GateState
    """

    provisioning_state: Optional[Union[str, "_models.GateProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the Gate resource. Known values are: \"Succeeded\", \"Failed\", and
     \"Canceled\"."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read", "create"])
    """The human-readable display name of the Gate."""
    gate_type: Union[str, "_models.GateType"] = rest_field(name="gateType", visibility=["read", "create"])
    """The type of the Gate determines how it is completed. Required. \"Approval\""""
    target: "_models.GateTarget" = rest_field(visibility=["read", "create"])
    """The target that the Gate is controlling, e.g. an Update Run. Required."""
    state: Union[str, "_models.GateState"] = rest_field(visibility=["read", "create", "update"])
    """The state of the Gate. Required. Known values are: \"Pending\", \"Skipped\", and \"Completed\"."""

    @overload
    def __init__(
        self,
        *,
        gate_type: Union[str, "_models.GateType"],
        target: "_models.GateTarget",
        state: Union[str, "_models.GateState"],
        display_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GateTarget(_Model):
    """The target that the Gate is controlling, e.g. an Update Run. Exactly one of the properties
    objects will be set.

    :ivar id: The resource id that the Gate is controlling the rollout of. Required.
    :vartype id: str
    :ivar update_run_properties: The properties of the Update Run that the Gate is targeting.
    :vartype update_run_properties:
     ~azure.mgmt.containerservicefleet.models.UpdateRunGateTargetProperties
    """

    id: str = rest_field(visibility=["read", "create"])
    """The resource id that the Gate is controlling the rollout of. Required."""
    update_run_properties: Optional["_models.UpdateRunGateTargetProperties"] = rest_field(
        name="updateRunProperties", visibility=["read", "create"]
    )
    """The properties of the Update Run that the Gate is targeting."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        update_run_properties: Optional["_models.UpdateRunGateTargetProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GenerateResponse(_Model):
    """GenerateResponse is the response of a generate request.

    :ivar id: The ARM resource id of the generated UpdateRun. e.g.:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/updateRuns/{updateRunName}'.
     Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read"])
    """The ARM resource id of the generated UpdateRun. e.g.:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/updateRuns/{updateRunName}'.
     Required."""


class ManagedClusterUpdate(_Model):
    """The update to be applied to the ManagedClusters.

    :ivar upgrade: The upgrade to apply to the ManagedClusters. Required.
    :vartype upgrade: ~azure.mgmt.containerservicefleet.models.ManagedClusterUpgradeSpec
    :ivar node_image_selection: The node image upgrade to be applied to the target nodes in update
     run.
    :vartype node_image_selection: ~azure.mgmt.containerservicefleet.models.NodeImageSelection
    """

    upgrade: "_models.ManagedClusterUpgradeSpec" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The upgrade to apply to the ManagedClusters. Required."""
    node_image_selection: Optional["_models.NodeImageSelection"] = rest_field(
        name="nodeImageSelection", visibility=["read", "create"]
    )
    """The node image upgrade to be applied to the target nodes in update run."""

    @overload
    def __init__(
        self,
        *,
        upgrade: "_models.ManagedClusterUpgradeSpec",
        node_image_selection: Optional["_models.NodeImageSelection"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedClusterUpgradeSpec(_Model):
    """The upgrade to apply to a ManagedCluster.

    :ivar type: ManagedClusterUpgradeType is the type of upgrade to be applied. Required. Known
     values are: "Full", "NodeImageOnly", and "ControlPlaneOnly".
    :vartype type: str or ~azure.mgmt.containerservicefleet.models.ManagedClusterUpgradeType
    :ivar kubernetes_version: The Kubernetes version to upgrade the member clusters to.
    :vartype kubernetes_version: str
    """

    type: Union[str, "_models.ManagedClusterUpgradeType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """ManagedClusterUpgradeType is the type of upgrade to be applied. Required. Known values are:
     \"Full\", \"NodeImageOnly\", and \"ControlPlaneOnly\"."""
    kubernetes_version: Optional[str] = rest_field(
        name="kubernetesVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Kubernetes version to upgrade the member clusters to."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedClusterUpgradeType"],
        kubernetes_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.containerservicefleet.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.containerservicefleet.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned, UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MemberUpdateStatus(_Model):
    """The status of a member update operation.

    :ivar status: The status of the MemberUpdate operation.
    :vartype status: ~azure.mgmt.containerservicefleet.models.UpdateStatus
    :ivar name: The name of the FleetMember.
    :vartype name: str
    :ivar cluster_resource_id: The Azure resource id of the target Kubernetes cluster.
    :vartype cluster_resource_id: str
    :ivar operation_id: The operation resource id of the latest attempt to perform the operation.
    :vartype operation_id: str
    :ivar message: The status message after processing the member update operation.
    :vartype message: str
    """

    status: Optional["_models.UpdateStatus"] = rest_field(visibility=["read"])
    """The status of the MemberUpdate operation."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the FleetMember."""
    cluster_resource_id: Optional[str] = rest_field(name="clusterResourceId", visibility=["read"])
    """The Azure resource id of the target Kubernetes cluster."""
    operation_id: Optional[str] = rest_field(name="operationId", visibility=["read"])
    """The operation resource id of the latest attempt to perform the operation."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The status message after processing the member update operation."""


class NodeImageSelection(_Model):
    """The node image upgrade to be applied to the target nodes in update run.

    :ivar type: The node image upgrade type. Required. Known values are: "Latest", "Consistent",
     and "Custom".
    :vartype type: str or ~azure.mgmt.containerservicefleet.models.NodeImageSelectionType
    :ivar custom_node_image_versions: Custom node image versions to upgrade the nodes to. This
     field is required if node image selection type is Custom. Otherwise, it must be empty. For each
     node image family (e.g., 'AKSUbuntu-1804gen2containerd'), this field can contain at most one
     version (e.g., only one of 'AKSUbuntu-1804gen2containerd-2023.01.12' or
     'AKSUbuntu-1804gen2containerd-2023.02.12', not both). If the nodes belong to a family without a
     matching image version in this field, they are not upgraded.
    :vartype custom_node_image_versions:
     list[~azure.mgmt.containerservicefleet.models.NodeImageVersion]
    """

    type: Union[str, "_models.NodeImageSelectionType"] = rest_field(visibility=["read", "create"])
    """The node image upgrade type. Required. Known values are: \"Latest\", \"Consistent\", and
     \"Custom\"."""
    custom_node_image_versions: Optional[List["_models.NodeImageVersion"]] = rest_field(
        name="customNodeImageVersions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Custom node image versions to upgrade the nodes to. This field is required if node image
     selection type is Custom. Otherwise, it must be empty. For each node image family (e.g.,
     'AKSUbuntu-1804gen2containerd'), this field can contain at most one version (e.g., only one of
     'AKSUbuntu-1804gen2containerd-2023.01.12' or 'AKSUbuntu-1804gen2containerd-2023.02.12', not
     both). If the nodes belong to a family without a matching image version in this field, they are
     not upgraded."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.NodeImageSelectionType"],
        custom_node_image_versions: Optional[List["_models.NodeImageVersion"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NodeImageSelectionStatus(_Model):
    """The node image upgrade specs for the update run.

    :ivar selected_node_image_versions: The image versions to upgrade the nodes to.
    :vartype selected_node_image_versions:
     list[~azure.mgmt.containerservicefleet.models.NodeImageVersion]
    """

    selected_node_image_versions: Optional[List["_models.NodeImageVersion"]] = rest_field(
        name="selectedNodeImageVersions", visibility=["read"]
    )
    """The image versions to upgrade the nodes to."""


class NodeImageVersion(_Model):
    """The node upgrade image version.

    :ivar version: The image version to upgrade the nodes to (e.g.,
     'AKSUbuntu-1804gen2containerd-2022.12.13').
    :vartype version: str
    """

    version: Optional[str] = rest_field(visibility=["read"])
    """The image version to upgrade the nodes to (e.g., 'AKSUbuntu-1804gen2containerd-2022.12.13')."""


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.containerservicefleet.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.containerservicefleet.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.containerservicefleet.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class SkipProperties(_Model):
    """The properties of a skip operation containing multiple skip requests.

    :ivar targets: The targets to skip. Required.
    :vartype targets: list[~azure.mgmt.containerservicefleet.models.SkipTarget]
    """

    targets: List["_models.SkipTarget"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The targets to skip. Required."""

    @overload
    def __init__(
        self,
        *,
        targets: List["_models.SkipTarget"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SkipTarget(_Model):
    """The definition of a single skip request.

    :ivar type: The skip target type. Required. Known values are: "Member", "Group", "Stage", and
     "AfterStageWait".
    :vartype type: str or ~azure.mgmt.containerservicefleet.models.TargetType
    :ivar name: The skip target's name.
     To skip a member/group/stage, use the member/group/stage's name;
     Tp skip an after stage wait, use the parent stage's name. Required.
    :vartype name: str
    """

    type: Union[str, "_models.TargetType"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The skip target type. Required. Known values are: \"Member\", \"Group\", \"Stage\", and
     \"AfterStageWait\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The skip target's name.
     To skip a member/group/stage, use the member/group/stage's name;
     Tp skip an after stage wait, use the parent stage's name. Required."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.TargetType"],
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.containerservicefleet.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.containerservicefleet.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateGroup(_Model):
    """A group to be updated.

    :ivar name: Name of the group.
     It must match a group name of an existing fleet member. Required.
    :vartype name: str
    :ivar before_gates: A list of Gates that will be created before this Group is executed.
    :vartype before_gates: list[~azure.mgmt.containerservicefleet.models.GateConfiguration]
    :ivar after_gates: A list of Gates that will be created after this Group is executed.
    :vartype after_gates: list[~azure.mgmt.containerservicefleet.models.GateConfiguration]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the group.
     It must match a group name of an existing fleet member. Required."""
    before_gates: Optional[List["_models.GateConfiguration"]] = rest_field(
        name="beforeGates", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of Gates that will be created before this Group is executed."""
    after_gates: Optional[List["_models.GateConfiguration"]] = rest_field(
        name="afterGates", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of Gates that will be created after this Group is executed."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        before_gates: Optional[List["_models.GateConfiguration"]] = None,
        after_gates: Optional[List["_models.GateConfiguration"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateGroupStatus(_Model):
    """The status of a UpdateGroup.

    :ivar status: The status of the UpdateGroup.
    :vartype status: ~azure.mgmt.containerservicefleet.models.UpdateStatus
    :ivar name: The name of the UpdateGroup.
    :vartype name: str
    :ivar members: The list of member this UpdateGroup updates.
    :vartype members: list[~azure.mgmt.containerservicefleet.models.MemberUpdateStatus]
    :ivar before_gates: The list of Gates that will run before this UpdateGroup.
    :vartype before_gates: list[~azure.mgmt.containerservicefleet.models.UpdateRunGateStatus]
    :ivar after_gates: The list of Gates that will run after this UpdateGroup.
    :vartype after_gates: list[~azure.mgmt.containerservicefleet.models.UpdateRunGateStatus]
    """

    status: Optional["_models.UpdateStatus"] = rest_field(visibility=["read"])
    """The status of the UpdateGroup."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the UpdateGroup."""
    members: Optional[List["_models.MemberUpdateStatus"]] = rest_field(visibility=["read"])
    """The list of member this UpdateGroup updates."""
    before_gates: Optional[List["_models.UpdateRunGateStatus"]] = rest_field(name="beforeGates", visibility=["read"])
    """The list of Gates that will run before this UpdateGroup."""
    after_gates: Optional[List["_models.UpdateRunGateStatus"]] = rest_field(name="afterGates", visibility=["read"])
    """The list of Gates that will run after this UpdateGroup."""


class UpdateRun(ProxyResource):
    """A multi-stage process to perform update operations across members of a Fleet.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.containerservicefleet.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.containerservicefleet.models.UpdateRunProperties
    :ivar e_tag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
    :vartype e_tag: str
    """

    properties: Optional["_models.UpdateRunProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields."""

    __flattened_items = [
        "provisioning_state",
        "update_strategy_id",
        "strategy",
        "managed_cluster_update",
        "status",
        "auto_upgrade_profile_id",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.UpdateRunProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class UpdateRunGateStatus(_Model):
    """The status of the Gate, as represented in the Update Run.

    :ivar display_name: The human-readable display name of the Gate.
    :vartype display_name: str
    :ivar gate_id: The resource id of the Gate.
    :vartype gate_id: str
    :ivar status: The status of the Gate.
    :vartype status: ~azure.mgmt.containerservicefleet.models.UpdateStatus
    """

    display_name: Optional[str] = rest_field(name="displayName", visibility=["read"])
    """The human-readable display name of the Gate."""
    gate_id: Optional[str] = rest_field(name="gateId", visibility=["read"])
    """The resource id of the Gate."""
    status: Optional["_models.UpdateStatus"] = rest_field(visibility=["read"])
    """The status of the Gate."""


class UpdateRunGateTargetProperties(_Model):
    """The properties of the Update Run that the Gate is targeting.

    :ivar name: The name of the Update Run. Required.
    :vartype name: str
    :ivar stage: The Update Stage of the Update Run.
    :vartype stage: str
    :ivar group: The Update Group of the Update Run.
    :vartype group: str
    :ivar timing: Whether the Gate is placed before or after the update itself. Required. Known
     values are: "Before" and "After".
    :vartype timing: str or ~azure.mgmt.containerservicefleet.models.Timing
    """

    name: str = rest_field(visibility=["read"])
    """The name of the Update Run. Required."""
    stage: Optional[str] = rest_field(visibility=["read"])
    """The Update Stage of the Update Run."""
    group: Optional[str] = rest_field(visibility=["read"])
    """The Update Group of the Update Run."""
    timing: Union[str, "_models.Timing"] = rest_field(visibility=["read", "create"])
    """Whether the Gate is placed before or after the update itself. Required. Known values are:
     \"Before\" and \"After\"."""

    @overload
    def __init__(
        self,
        *,
        timing: Union[str, "_models.Timing"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateRunProperties(_Model):
    """The properties of the UpdateRun.

    :ivar provisioning_state: The provisioning state of the UpdateRun resource. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservicefleet.models.UpdateRunProvisioningState
    :ivar update_strategy_id: The resource id of the FleetUpdateStrategy resource to reference.

     When creating a new run, there are three ways to define a strategy for the run:

     1. Define a new strategy in place: Set the "strategy" field.
     2. Use an existing strategy: Set the "updateStrategyId" field. (since 2023-08-15-preview)
     3. Use the default strategy to update all the members one by one: Leave both "updateStrategyId"
     and "strategy" unset. (since 2023-08-15-preview)

     Setting both "updateStrategyId" and "strategy" is invalid.

     UpdateRuns created by "updateStrategyId" snapshot the referenced UpdateStrategy at the time of
     creation and store it in the "strategy" field.
     Subsequent changes to the referenced FleetUpdateStrategy resource do not propagate.
     UpdateRunStrategy changes can be made directly on the "strategy" field before launching the
     UpdateRun.
    :vartype update_strategy_id: str
    :ivar strategy: The strategy defines the order in which the clusters will be updated.
     If not set, all members will be updated sequentially. The UpdateRun status will show a single
     UpdateStage and a single UpdateGroup targeting all members.
     The strategy of the UpdateRun can be modified until the run is started.
    :vartype strategy: ~azure.mgmt.containerservicefleet.models.UpdateRunStrategy
    :ivar managed_cluster_update: The update to be applied to all clusters in the UpdateRun. The
     managedClusterUpdate can be modified until the run is started. Required.
    :vartype managed_cluster_update: ~azure.mgmt.containerservicefleet.models.ManagedClusterUpdate
    :ivar status: The status of the UpdateRun.
    :vartype status: ~azure.mgmt.containerservicefleet.models.UpdateRunStatus
    :ivar auto_upgrade_profile_id: AutoUpgradeProfileId is the id of an auto upgrade profile
     resource.
    :vartype auto_upgrade_profile_id: str
    """

    provisioning_state: Optional[Union[str, "_models.UpdateRunProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the UpdateRun resource. Known values are: \"Succeeded\", \"Failed\",
     and \"Canceled\"."""
    update_strategy_id: Optional[str] = rest_field(
        name="updateStrategyId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource id of the FleetUpdateStrategy resource to reference.
     
     When creating a new run, there are three ways to define a strategy for the run:
     
     1. Define a new strategy in place: Set the \"strategy\" field.
     2. Use an existing strategy: Set the \"updateStrategyId\" field. (since 2023-08-15-preview)
     3. Use the default strategy to update all the members one by one: Leave both
     \"updateStrategyId\" and \"strategy\" unset. (since 2023-08-15-preview)
     
     Setting both \"updateStrategyId\" and \"strategy\" is invalid.
     
     UpdateRuns created by \"updateStrategyId\" snapshot the referenced UpdateStrategy at the time
     of creation and store it in the \"strategy\" field.
     Subsequent changes to the referenced FleetUpdateStrategy resource do not propagate.
     UpdateRunStrategy changes can be made directly on the \"strategy\" field before launching the
     UpdateRun."""
    strategy: Optional["_models.UpdateRunStrategy"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The strategy defines the order in which the clusters will be updated.
     If not set, all members will be updated sequentially. The UpdateRun status will show a single
     UpdateStage and a single UpdateGroup targeting all members.
     The strategy of the UpdateRun can be modified until the run is started."""
    managed_cluster_update: "_models.ManagedClusterUpdate" = rest_field(
        name="managedClusterUpdate", visibility=["read", "create", "update", "delete", "query"]
    )
    """The update to be applied to all clusters in the UpdateRun. The managedClusterUpdate can be
     modified until the run is started. Required."""
    status: Optional["_models.UpdateRunStatus"] = rest_field(visibility=["read"])
    """The status of the UpdateRun."""
    auto_upgrade_profile_id: Optional[str] = rest_field(name="autoUpgradeProfileId", visibility=["read"])
    """AutoUpgradeProfileId is the id of an auto upgrade profile resource."""

    @overload
    def __init__(
        self,
        *,
        managed_cluster_update: "_models.ManagedClusterUpdate",
        update_strategy_id: Optional[str] = None,
        strategy: Optional["_models.UpdateRunStrategy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateRunStatus(_Model):
    """The status of a UpdateRun.

    :ivar status: The status of the UpdateRun.
    :vartype status: ~azure.mgmt.containerservicefleet.models.UpdateStatus
    :ivar stages: The stages composing an update run. Stages are run sequentially withing an
     UpdateRun.
    :vartype stages: list[~azure.mgmt.containerservicefleet.models.UpdateStageStatus]
    :ivar node_image_selection: The node image upgrade specs for the update run. It is only set in
     update run when ``NodeImageSelection.type`` is ``Consistent``.
    :vartype node_image_selection:
     ~azure.mgmt.containerservicefleet.models.NodeImageSelectionStatus
    """

    status: Optional["_models.UpdateStatus"] = rest_field(visibility=["read"])
    """The status of the UpdateRun."""
    stages: Optional[List["_models.UpdateStageStatus"]] = rest_field(visibility=["read"])
    """The stages composing an update run. Stages are run sequentially withing an UpdateRun."""
    node_image_selection: Optional["_models.NodeImageSelectionStatus"] = rest_field(
        name="nodeImageSelection", visibility=["read"]
    )
    """The node image upgrade specs for the update run. It is only set in update run when
     ``NodeImageSelection.type`` is ``Consistent``."""


class UpdateRunStrategy(_Model):
    """Defines the update sequence of the clusters via stages and groups.

    Stages within a run are executed sequentially one after another.
    Groups within a stage are executed in parallel.
    Member clusters within a group are updated sequentially one after another.

    A valid strategy contains no duplicate groups within or across stages.

    :ivar stages: The list of stages that compose this update run. Min size: 1. Required.
    :vartype stages: list[~azure.mgmt.containerservicefleet.models.UpdateStage]
    """

    stages: List["_models.UpdateStage"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The list of stages that compose this update run. Min size: 1. Required."""

    @overload
    def __init__(
        self,
        *,
        stages: List["_models.UpdateStage"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateStage(_Model):
    """Defines a stage which contains the groups to update and the steps to take (e.g., wait for a
    time period) before starting the next stage.

    :ivar name: The name of the stage. Must be unique within the UpdateRun. Required.
    :vartype name: str
    :ivar groups: Defines the groups to be executed in parallel in this stage. Duplicate groups are
     not allowed. Min size: 1.
    :vartype groups: list[~azure.mgmt.containerservicefleet.models.UpdateGroup]
    :ivar after_stage_wait_in_seconds: The time in seconds to wait at the end of this stage before
     starting the next one. Defaults to 0 seconds if unspecified.
    :vartype after_stage_wait_in_seconds: int
    :ivar before_gates: A list of Gates that will be created before this Stage is executed.
    :vartype before_gates: list[~azure.mgmt.containerservicefleet.models.GateConfiguration]
    :ivar after_gates: A list of Gates that will be created after this Stage is executed.
    :vartype after_gates: list[~azure.mgmt.containerservicefleet.models.GateConfiguration]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the stage. Must be unique within the UpdateRun. Required."""
    groups: Optional[List["_models.UpdateGroup"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines the groups to be executed in parallel in this stage. Duplicate groups are not allowed.
     Min size: 1."""
    after_stage_wait_in_seconds: Optional[int] = rest_field(
        name="afterStageWaitInSeconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The time in seconds to wait at the end of this stage before starting the next one. Defaults to
     0 seconds if unspecified."""
    before_gates: Optional[List["_models.GateConfiguration"]] = rest_field(
        name="beforeGates", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of Gates that will be created before this Stage is executed."""
    after_gates: Optional[List["_models.GateConfiguration"]] = rest_field(
        name="afterGates", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of Gates that will be created after this Stage is executed."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        groups: Optional[List["_models.UpdateGroup"]] = None,
        after_stage_wait_in_seconds: Optional[int] = None,
        before_gates: Optional[List["_models.GateConfiguration"]] = None,
        after_gates: Optional[List["_models.GateConfiguration"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpdateStageStatus(_Model):
    """The status of a UpdateStage.

    :ivar status: The status of the UpdateStage.
    :vartype status: ~azure.mgmt.containerservicefleet.models.UpdateStatus
    :ivar name: The name of the UpdateStage.
    :vartype name: str
    :ivar groups: The list of groups to be updated as part of this UpdateStage.
    :vartype groups: list[~azure.mgmt.containerservicefleet.models.UpdateGroupStatus]
    :ivar before_gates: The list of Gates that will run before this UpdateStage.
    :vartype before_gates: list[~azure.mgmt.containerservicefleet.models.UpdateRunGateStatus]
    :ivar after_gates: The list of Gates that will run after this UpdateStage.
    :vartype after_gates: list[~azure.mgmt.containerservicefleet.models.UpdateRunGateStatus]
    :ivar after_stage_wait_status: The status of the wait period configured on the UpdateStage.
    :vartype after_stage_wait_status: ~azure.mgmt.containerservicefleet.models.WaitStatus
    """

    status: Optional["_models.UpdateStatus"] = rest_field(visibility=["read"])
    """The status of the UpdateStage."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the UpdateStage."""
    groups: Optional[List["_models.UpdateGroupStatus"]] = rest_field(visibility=["read"])
    """The list of groups to be updated as part of this UpdateStage."""
    before_gates: Optional[List["_models.UpdateRunGateStatus"]] = rest_field(name="beforeGates", visibility=["read"])
    """The list of Gates that will run before this UpdateStage."""
    after_gates: Optional[List["_models.UpdateRunGateStatus"]] = rest_field(name="afterGates", visibility=["read"])
    """The list of Gates that will run after this UpdateStage."""
    after_stage_wait_status: Optional["_models.WaitStatus"] = rest_field(
        name="afterStageWaitStatus", visibility=["read"]
    )
    """The status of the wait period configured on the UpdateStage."""


class UpdateStatus(_Model):
    """The status for an operation or group of operations.

    :ivar start_time: The time the operation or group was started.
    :vartype start_time: ~datetime.datetime
    :ivar completed_time: The time the operation or group was completed.
    :vartype completed_time: ~datetime.datetime
    :ivar state: The State of the operation or group. Known values are: "NotStarted", "Running",
     "Stopping", "Stopped", "Skipped", "Failed", "Pending", and "Completed".
    :vartype state: str or ~azure.mgmt.containerservicefleet.models.UpdateState
    :ivar error: The error details when a failure is encountered.
    :vartype error: ~azure.mgmt.containerservicefleet.models.ErrorDetail
    """

    start_time: Optional[datetime.datetime] = rest_field(name="startTime", visibility=["read"], format="rfc3339")
    """The time the operation or group was started."""
    completed_time: Optional[datetime.datetime] = rest_field(
        name="completedTime", visibility=["read"], format="rfc3339"
    )
    """The time the operation or group was completed."""
    state: Optional[Union[str, "_models.UpdateState"]] = rest_field(visibility=["read"])
    """The State of the operation or group. Known values are: \"NotStarted\", \"Running\",
     \"Stopping\", \"Stopped\", \"Skipped\", \"Failed\", \"Pending\", and \"Completed\"."""
    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read"])
    """The error details when a failure is encountered."""


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class WaitStatus(_Model):
    """The status of the wait duration.

    :ivar status: The status of the wait duration.
    :vartype status: ~azure.mgmt.containerservicefleet.models.UpdateStatus
    :ivar wait_duration_in_seconds: The wait duration configured in seconds.
    :vartype wait_duration_in_seconds: int
    """

    status: Optional["_models.UpdateStatus"] = rest_field(visibility=["read"])
    """The status of the wait duration."""
    wait_duration_in_seconds: Optional[int] = rest_field(name="waitDurationInSeconds", visibility=["read"])
    """The wait duration configured in seconds."""
