# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dnsresolver import DnsResolverManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDnsResolverManagementVirtualNetworkLinksOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DnsResolverManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_network_links_get(self, resource_group):
        response = self.client.virtual_network_links.get(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
            virtual_network_link_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_network_links_begin_create_or_update(self, resource_group):
        response = self.client.virtual_network_links.begin_create_or_update(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
            virtual_network_link_name="str",
            parameters={
                "properties": {"virtualNetwork": {"id": "str"}, "metadata": {"str": "str"}, "provisioningState": "str"},
                "etag": "str",
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_network_links_begin_update(self, resource_group):
        response = self.client.virtual_network_links.begin_update(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
            virtual_network_link_name="str",
            parameters={"properties": {"metadata": {"str": "str"}}},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_network_links_begin_delete(self, resource_group):
        response = self.client.virtual_network_links.begin_delete(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
            virtual_network_link_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_network_links_list(self, resource_group):
        response = self.client.virtual_network_links.list(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
