# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AddressDetails(_serialization.Model):
    """Address details for an order item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar forward_address: Customer address and contact details. It should be address resource.
     Required.
    :vartype forward_address: ~azure.mgmt.edgeorder.models.AddressProperties
    :ivar return_address: Return shipping address.
    :vartype return_address: ~azure.mgmt.edgeorder.models.AddressProperties
    """

    _validation = {
        "forward_address": {"required": True},
        "return_address": {"readonly": True},
    }

    _attribute_map = {
        "forward_address": {"key": "forwardAddress", "type": "AddressProperties"},
        "return_address": {"key": "returnAddress", "type": "AddressProperties"},
    }

    def __init__(self, *, forward_address: "_models.AddressProperties", **kwargs: Any) -> None:
        """
        :keyword forward_address: Customer address and contact details. It should be address resource.
         Required.
        :paramtype forward_address: ~azure.mgmt.edgeorder.models.AddressProperties
        """
        super().__init__(**kwargs)
        self.forward_address = forward_address
        self.return_address = None


class AddressProperties(_serialization.Model):
    """Address Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar shipping_address: Shipping details for the address.
    :vartype shipping_address: ~azure.mgmt.edgeorder.models.ShippingAddress
    :ivar contact_details: Contact details for the address. Required.
    :vartype contact_details: ~azure.mgmt.edgeorder.models.ContactDetails
    :ivar address_validation_status: Status of address validation. Known values are: "Valid",
     "Invalid", and "Ambiguous".
    :vartype address_validation_status: str or ~azure.mgmt.edgeorder.models.AddressValidationStatus
    """

    _validation = {
        "contact_details": {"required": True},
        "address_validation_status": {"readonly": True},
    }

    _attribute_map = {
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
        "contact_details": {"key": "contactDetails", "type": "ContactDetails"},
        "address_validation_status": {"key": "addressValidationStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        contact_details: "_models.ContactDetails",
        shipping_address: Optional["_models.ShippingAddress"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword shipping_address: Shipping details for the address.
        :paramtype shipping_address: ~azure.mgmt.edgeorder.models.ShippingAddress
        :keyword contact_details: Contact details for the address. Required.
        :paramtype contact_details: ~azure.mgmt.edgeorder.models.ContactDetails
        """
        super().__init__(**kwargs)
        self.shipping_address = shipping_address
        self.contact_details = contact_details
        self.address_validation_status = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AddressResource(TrackedResource):
    """Address Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar system_data: Represents resource creation and update time.
    :vartype system_data: ~azure.mgmt.edgeorder.models.SystemData
    :ivar shipping_address: Shipping details for the address.
    :vartype shipping_address: ~azure.mgmt.edgeorder.models.ShippingAddress
    :ivar contact_details: Contact details for the address. Required.
    :vartype contact_details: ~azure.mgmt.edgeorder.models.ContactDetails
    :ivar address_validation_status: Status of address validation. Known values are: "Valid",
     "Invalid", and "Ambiguous".
    :vartype address_validation_status: str or ~azure.mgmt.edgeorder.models.AddressValidationStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "contact_details": {"required": True},
        "address_validation_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "shipping_address": {"key": "properties.shippingAddress", "type": "ShippingAddress"},
        "contact_details": {"key": "properties.contactDetails", "type": "ContactDetails"},
        "address_validation_status": {"key": "properties.addressValidationStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        contact_details: "_models.ContactDetails",
        tags: Optional[Dict[str, str]] = None,
        shipping_address: Optional["_models.ShippingAddress"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword shipping_address: Shipping details for the address.
        :paramtype shipping_address: ~azure.mgmt.edgeorder.models.ShippingAddress
        :keyword contact_details: Contact details for the address. Required.
        :paramtype contact_details: ~azure.mgmt.edgeorder.models.ContactDetails
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.shipping_address = shipping_address
        self.contact_details = contact_details
        self.address_validation_status = None


class AddressResourceList(_serialization.Model):
    """Address Resource Collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of address resources.
    :vartype value: list[~azure.mgmt.edgeorder.models.AddressResource]
    :ivar next_link: Link for the next set of job resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AddressResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Link for the next set of job resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AddressUpdateParameter(_serialization.Model):
    """The Address update parameters.

    :ivar tags: The list of key value pairs that describe the resource. These tags can be used in
     viewing and grouping this resource (across resource groups).
    :vartype tags: dict[str, str]
    :ivar shipping_address: Shipping details for the address.
    :vartype shipping_address: ~azure.mgmt.edgeorder.models.ShippingAddress
    :ivar contact_details: Contact details for the address.
    :vartype contact_details: ~azure.mgmt.edgeorder.models.ContactDetails
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "shipping_address": {"key": "properties.shippingAddress", "type": "ShippingAddress"},
        "contact_details": {"key": "properties.contactDetails", "type": "ContactDetails"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        shipping_address: Optional["_models.ShippingAddress"] = None,
        contact_details: Optional["_models.ContactDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The list of key value pairs that describe the resource. These tags can be used
         in viewing and grouping this resource (across resource groups).
        :paramtype tags: dict[str, str]
        :keyword shipping_address: Shipping details for the address.
        :paramtype shipping_address: ~azure.mgmt.edgeorder.models.ShippingAddress
        :keyword contact_details: Contact details for the address.
        :paramtype contact_details: ~azure.mgmt.edgeorder.models.ContactDetails
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.shipping_address = shipping_address
        self.contact_details = contact_details


class AvailabilityInformation(_serialization.Model):
    """Availability information of a product system.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar availability_stage: Current availability stage of the product. Availability stage. Known
     values are: "Available", "ComingSoon", "Preview", "Deprecated", "Signup", and "Unavailable".
    :vartype availability_stage: str or ~azure.mgmt.edgeorder.models.AvailabilityStage
    :ivar disabled_reason: Reason why the product is disabled. Known values are: "None", "Country",
     "Region", "Feature", "OfferType", "NoSubscriptionInfo", "NotAvailable", and "OutOfStock".
    :vartype disabled_reason: str or ~azure.mgmt.edgeorder.models.DisabledReason
    :ivar disabled_reason_message: Message for why the product is disabled.
    :vartype disabled_reason_message: str
    """

    _validation = {
        "availability_stage": {"readonly": True},
        "disabled_reason": {"readonly": True},
        "disabled_reason_message": {"readonly": True},
    }

    _attribute_map = {
        "availability_stage": {"key": "availabilityStage", "type": "str"},
        "disabled_reason": {"key": "disabledReason", "type": "str"},
        "disabled_reason_message": {"key": "disabledReasonMessage", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.availability_stage = None
        self.disabled_reason = None
        self.disabled_reason_message = None


class BasicInformation(_serialization.Model):
    """Basic information for any product system.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information: ~azure.mgmt.edgeorder.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "image_information": {"readonly": True},
        "cost_information": {"readonly": True},
        "availability_information": {"readonly": True},
        "hierarchy_information": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "Description"},
        "image_information": {"key": "imageInformation", "type": "[ImageInformation]"},
        "cost_information": {"key": "costInformation", "type": "CostInformation"},
        "availability_information": {"key": "availabilityInformation", "type": "AvailabilityInformation"},
        "hierarchy_information": {"key": "hierarchyInformation", "type": "HierarchyInformation"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.image_information = None
        self.cost_information = None
        self.availability_information = None
        self.hierarchy_information = None


class BillingMeterDetails(_serialization.Model):
    """Holds billing meter details for each type of billing.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Represents Billing type name.
    :vartype name: str
    :ivar meter_details: Represents MeterDetails.
    :vartype meter_details: ~azure.mgmt.edgeorder.models.MeterDetails
    :ivar metering_type: Represents Metering type (eg one-time or recurrent). Known values are:
     "OneTime", "Recurring", and "Adhoc".
    :vartype metering_type: str or ~azure.mgmt.edgeorder.models.MeteringType
    :ivar frequency: Frequency of recurrence.
    :vartype frequency: str
    """

    _validation = {
        "name": {"readonly": True},
        "meter_details": {"readonly": True},
        "metering_type": {"readonly": True},
        "frequency": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "meter_details": {"key": "meterDetails", "type": "MeterDetails"},
        "metering_type": {"key": "meteringType", "type": "str"},
        "frequency": {"key": "frequency", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.meter_details = None
        self.metering_type = None
        self.frequency = None


class CancellationReason(_serialization.Model):
    """Reason for cancellation.

    All required parameters must be populated in order to send to server.

    :ivar reason: Reason for cancellation. Required.
    :vartype reason: str
    """

    _validation = {
        "reason": {"required": True},
    }

    _attribute_map = {
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: str, **kwargs: Any) -> None:
        """
        :keyword reason: Reason for cancellation. Required.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.reason = reason


class CommonProperties(BasicInformation):
    """Represents common properties across product hierarchy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information: ~azure.mgmt.edgeorder.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties: list[~azure.mgmt.edgeorder.models.FilterableProperty]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "image_information": {"readonly": True},
        "cost_information": {"readonly": True},
        "availability_information": {"readonly": True},
        "hierarchy_information": {"readonly": True},
        "filterable_properties": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "Description"},
        "image_information": {"key": "imageInformation", "type": "[ImageInformation]"},
        "cost_information": {"key": "costInformation", "type": "CostInformation"},
        "availability_information": {"key": "availabilityInformation", "type": "AvailabilityInformation"},
        "hierarchy_information": {"key": "hierarchyInformation", "type": "HierarchyInformation"},
        "filterable_properties": {"key": "filterableProperties", "type": "[FilterableProperty]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.filterable_properties = None


class Configuration(_serialization.Model):
    """Configuration object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information: ~azure.mgmt.edgeorder.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties: list[~azure.mgmt.edgeorder.models.FilterableProperty]
    :ivar specifications: Specifications of the configuration.
    :vartype specifications: list[~azure.mgmt.edgeorder.models.Specification]
    :ivar dimensions: Dimensions of the configuration.
    :vartype dimensions: ~azure.mgmt.edgeorder.models.Dimensions
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "image_information": {"readonly": True},
        "cost_information": {"readonly": True},
        "availability_information": {"readonly": True},
        "hierarchy_information": {"readonly": True},
        "filterable_properties": {"readonly": True},
        "specifications": {"readonly": True},
        "dimensions": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "Description"},
        "image_information": {"key": "properties.imageInformation", "type": "[ImageInformation]"},
        "cost_information": {"key": "properties.costInformation", "type": "CostInformation"},
        "availability_information": {"key": "properties.availabilityInformation", "type": "AvailabilityInformation"},
        "hierarchy_information": {"key": "properties.hierarchyInformation", "type": "HierarchyInformation"},
        "filterable_properties": {"key": "properties.filterableProperties", "type": "[FilterableProperty]"},
        "specifications": {"key": "properties.specifications", "type": "[Specification]"},
        "dimensions": {"key": "properties.dimensions", "type": "Dimensions"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.image_information = None
        self.cost_information = None
        self.availability_information = None
        self.hierarchy_information = None
        self.filterable_properties = None
        self.specifications = None
        self.dimensions = None


class ConfigurationFilters(_serialization.Model):
    """Configuration filters.

    All required parameters must be populated in order to send to server.

    :ivar hierarchy_information: Product hierarchy information. Required.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
    :ivar filterable_property: Filters specific to product.
    :vartype filterable_property: list[~azure.mgmt.edgeorder.models.FilterableProperty]
    """

    _validation = {
        "hierarchy_information": {"required": True},
    }

    _attribute_map = {
        "hierarchy_information": {"key": "hierarchyInformation", "type": "HierarchyInformation"},
        "filterable_property": {"key": "filterableProperty", "type": "[FilterableProperty]"},
    }

    def __init__(
        self,
        *,
        hierarchy_information: "_models.HierarchyInformation",
        filterable_property: Optional[List["_models.FilterableProperty"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword hierarchy_information: Product hierarchy information. Required.
        :paramtype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
        :keyword filterable_property: Filters specific to product.
        :paramtype filterable_property: list[~azure.mgmt.edgeorder.models.FilterableProperty]
        """
        super().__init__(**kwargs)
        self.hierarchy_information = hierarchy_information
        self.filterable_property = filterable_property


class ConfigurationProperties(CommonProperties):
    """Properties of configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information: ~azure.mgmt.edgeorder.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties: list[~azure.mgmt.edgeorder.models.FilterableProperty]
    :ivar specifications: Specifications of the configuration.
    :vartype specifications: list[~azure.mgmt.edgeorder.models.Specification]
    :ivar dimensions: Dimensions of the configuration.
    :vartype dimensions: ~azure.mgmt.edgeorder.models.Dimensions
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "image_information": {"readonly": True},
        "cost_information": {"readonly": True},
        "availability_information": {"readonly": True},
        "hierarchy_information": {"readonly": True},
        "filterable_properties": {"readonly": True},
        "specifications": {"readonly": True},
        "dimensions": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "Description"},
        "image_information": {"key": "imageInformation", "type": "[ImageInformation]"},
        "cost_information": {"key": "costInformation", "type": "CostInformation"},
        "availability_information": {"key": "availabilityInformation", "type": "AvailabilityInformation"},
        "hierarchy_information": {"key": "hierarchyInformation", "type": "HierarchyInformation"},
        "filterable_properties": {"key": "filterableProperties", "type": "[FilterableProperty]"},
        "specifications": {"key": "specifications", "type": "[Specification]"},
        "dimensions": {"key": "dimensions", "type": "Dimensions"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.specifications = None
        self.dimensions = None


class Configurations(_serialization.Model):
    """The list of configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of configurations.
    :vartype value: list[~azure.mgmt.edgeorder.models.Configuration]
    :ivar next_link: Link for the next set of configurations.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Configuration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Link for the next set of configurations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ConfigurationsRequest(_serialization.Model):
    """Configuration request object.

    All required parameters must be populated in order to send to server.

    :ivar configuration_filters: Holds details about product hierarchy information and filterable
     property. Required.
    :vartype configuration_filters: list[~azure.mgmt.edgeorder.models.ConfigurationFilters]
    :ivar customer_subscription_details: Customer subscription properties. Clients can display
     available products to unregistered customers by explicitly passing subscription details.
    :vartype customer_subscription_details:
     ~azure.mgmt.edgeorder.models.CustomerSubscriptionDetails
    """

    _validation = {
        "configuration_filters": {"required": True, "unique": True},
    }

    _attribute_map = {
        "configuration_filters": {"key": "configurationFilters", "type": "[ConfigurationFilters]"},
        "customer_subscription_details": {"key": "customerSubscriptionDetails", "type": "CustomerSubscriptionDetails"},
    }

    def __init__(
        self,
        *,
        configuration_filters: List["_models.ConfigurationFilters"],
        customer_subscription_details: Optional["_models.CustomerSubscriptionDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword configuration_filters: Holds details about product hierarchy information and
         filterable property. Required.
        :paramtype configuration_filters: list[~azure.mgmt.edgeorder.models.ConfigurationFilters]
        :keyword customer_subscription_details: Customer subscription properties. Clients can display
         available products to unregistered customers by explicitly passing subscription details.
        :paramtype customer_subscription_details:
         ~azure.mgmt.edgeorder.models.CustomerSubscriptionDetails
        """
        super().__init__(**kwargs)
        self.configuration_filters = configuration_filters
        self.customer_subscription_details = customer_subscription_details


class ContactDetails(_serialization.Model):
    """Contact Details.

    All required parameters must be populated in order to send to server.

    :ivar contact_name: Contact name of the person. Required.
    :vartype contact_name: str
    :ivar phone: Phone number of the contact person. Required.
    :vartype phone: str
    :ivar phone_extension: Phone extension number of the contact person.
    :vartype phone_extension: str
    :ivar mobile: Mobile number of the contact person.
    :vartype mobile: str
    :ivar email_list: List of Email-ids to be notified about job progress. Required.
    :vartype email_list: list[str]
    """

    _validation = {
        "contact_name": {"required": True},
        "phone": {"required": True},
        "email_list": {"required": True},
    }

    _attribute_map = {
        "contact_name": {"key": "contactName", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
        "phone_extension": {"key": "phoneExtension", "type": "str"},
        "mobile": {"key": "mobile", "type": "str"},
        "email_list": {"key": "emailList", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        contact_name: str,
        phone: str,
        email_list: List[str],
        phone_extension: Optional[str] = None,
        mobile: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword contact_name: Contact name of the person. Required.
        :paramtype contact_name: str
        :keyword phone: Phone number of the contact person. Required.
        :paramtype phone: str
        :keyword phone_extension: Phone extension number of the contact person.
        :paramtype phone_extension: str
        :keyword mobile: Mobile number of the contact person.
        :paramtype mobile: str
        :keyword email_list: List of Email-ids to be notified about job progress. Required.
        :paramtype email_list: list[str]
        """
        super().__init__(**kwargs)
        self.contact_name = contact_name
        self.phone = phone
        self.phone_extension = phone_extension
        self.mobile = mobile
        self.email_list = email_list


class CostInformation(_serialization.Model):
    """Cost information for the product system.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar billing_meter_details: Details on the various billing aspects for the product system.
    :vartype billing_meter_details: list[~azure.mgmt.edgeorder.models.BillingMeterDetails]
    :ivar billing_info_url: Default url to display billing information.
    :vartype billing_info_url: str
    """

    _validation = {
        "billing_meter_details": {"readonly": True},
        "billing_info_url": {"readonly": True},
    }

    _attribute_map = {
        "billing_meter_details": {"key": "billingMeterDetails", "type": "[BillingMeterDetails]"},
        "billing_info_url": {"key": "billingInfoUrl", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.billing_meter_details = None
        self.billing_info_url = None


class CustomerSubscriptionDetails(_serialization.Model):
    """Holds Customer subscription details. Clients can display available products to unregistered
    customers by explicitly passing subscription details.

    All required parameters must be populated in order to send to server.

    :ivar registered_features: List of registered feature flags for subscription.
    :vartype registered_features:
     list[~azure.mgmt.edgeorder.models.CustomerSubscriptionRegisteredFeatures]
    :ivar location_placement_id: Location placement Id of a subscription.
    :vartype location_placement_id: str
    :ivar quota_id: Quota ID of a subscription. Required.
    :vartype quota_id: str
    """

    _validation = {
        "quota_id": {"required": True},
    }

    _attribute_map = {
        "registered_features": {"key": "registeredFeatures", "type": "[CustomerSubscriptionRegisteredFeatures]"},
        "location_placement_id": {"key": "locationPlacementId", "type": "str"},
        "quota_id": {"key": "quotaId", "type": "str"},
    }

    def __init__(
        self,
        *,
        quota_id: str,
        registered_features: Optional[List["_models.CustomerSubscriptionRegisteredFeatures"]] = None,
        location_placement_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword registered_features: List of registered feature flags for subscription.
        :paramtype registered_features:
         list[~azure.mgmt.edgeorder.models.CustomerSubscriptionRegisteredFeatures]
        :keyword location_placement_id: Location placement Id of a subscription.
        :paramtype location_placement_id: str
        :keyword quota_id: Quota ID of a subscription. Required.
        :paramtype quota_id: str
        """
        super().__init__(**kwargs)
        self.registered_features = registered_features
        self.location_placement_id = location_placement_id
        self.quota_id = quota_id


class CustomerSubscriptionRegisteredFeatures(_serialization.Model):
    """Represents subscription registered features.

    :ivar name: Name of subscription registered feature.
    :vartype name: str
    :ivar state: State of subscription registered feature.
    :vartype state: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, state: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of subscription registered feature.
        :paramtype name: str
        :keyword state: State of subscription registered feature.
        :paramtype state: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.state = state


class Description(_serialization.Model):
    """Description related properties of a product system.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description_type: Type of description. "Base"
    :vartype description_type: str or ~azure.mgmt.edgeorder.models.DescriptionType
    :ivar short_description: Short description of the product system.
    :vartype short_description: str
    :ivar long_description: Long description of the product system.
    :vartype long_description: str
    :ivar keywords: Keywords for the product system.
    :vartype keywords: list[str]
    :ivar attributes: Attributes for the product system.
    :vartype attributes: list[str]
    :ivar links: Links for the product system.
    :vartype links: list[~azure.mgmt.edgeorder.models.Link]
    """

    _validation = {
        "description_type": {"readonly": True},
        "short_description": {"readonly": True},
        "long_description": {"readonly": True},
        "keywords": {"readonly": True},
        "attributes": {"readonly": True},
        "links": {"readonly": True},
    }

    _attribute_map = {
        "description_type": {"key": "descriptionType", "type": "str"},
        "short_description": {"key": "shortDescription", "type": "str"},
        "long_description": {"key": "longDescription", "type": "str"},
        "keywords": {"key": "keywords", "type": "[str]"},
        "attributes": {"key": "attributes", "type": "[str]"},
        "links": {"key": "links", "type": "[Link]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.description_type = None
        self.short_description = None
        self.long_description = None
        self.keywords = None
        self.attributes = None
        self.links = None


class DeviceDetails(_serialization.Model):
    """Device details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar serial_number: device serial number.
    :vartype serial_number: str
    :ivar management_resource_id: Management Resource Id.
    :vartype management_resource_id: str
    :ivar management_resource_tenant_id: Management Resource Tenant ID.
    :vartype management_resource_tenant_id: str
    """

    _validation = {
        "serial_number": {"readonly": True},
        "management_resource_id": {"readonly": True},
        "management_resource_tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "serial_number": {"key": "serialNumber", "type": "str"},
        "management_resource_id": {"key": "managementResourceId", "type": "str"},
        "management_resource_tenant_id": {"key": "managementResourceTenantId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.serial_number = None
        self.management_resource_id = None
        self.management_resource_tenant_id = None


class Dimensions(_serialization.Model):
    """Dimensions of a configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar length: Length of the device.
    :vartype length: float
    :ivar height: Height of the device.
    :vartype height: float
    :ivar width: Width of the device.
    :vartype width: float
    :ivar length_height_unit: Unit for the dimensions of length, height and width. Known values
     are: "IN", "CM", and "IN".
    :vartype length_height_unit: str or ~azure.mgmt.edgeorder.models.LengthHeightUnit
    :ivar weight: Weight of the device.
    :vartype weight: float
    :ivar depth: Depth of the device.
    :vartype depth: float
    :ivar weight_unit: Unit for the dimensions of weight. Known values are: "LBS" and "KGS".
    :vartype weight_unit: str or ~azure.mgmt.edgeorder.models.WeightMeasurementUnit
    """

    _validation = {
        "length": {"readonly": True},
        "height": {"readonly": True},
        "width": {"readonly": True},
        "length_height_unit": {"readonly": True},
        "weight": {"readonly": True},
        "depth": {"readonly": True},
        "weight_unit": {"readonly": True},
    }

    _attribute_map = {
        "length": {"key": "length", "type": "float"},
        "height": {"key": "height", "type": "float"},
        "width": {"key": "width", "type": "float"},
        "length_height_unit": {"key": "lengthHeightUnit", "type": "str"},
        "weight": {"key": "weight", "type": "float"},
        "depth": {"key": "depth", "type": "float"},
        "weight_unit": {"key": "weightUnit", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.length = None
        self.height = None
        self.width = None
        self.length_height_unit = None
        self.weight = None
        self.depth = None
        self.weight_unit = None


class DisplayInfo(_serialization.Model):
    """Describes product display information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar product_family_display_name: Product family display name.
    :vartype product_family_display_name: str
    :ivar configuration_display_name: Configuration display name.
    :vartype configuration_display_name: str
    """

    _validation = {
        "product_family_display_name": {"readonly": True},
        "configuration_display_name": {"readonly": True},
    }

    _attribute_map = {
        "product_family_display_name": {"key": "productFamilyDisplayName", "type": "str"},
        "configuration_display_name": {"key": "configurationDisplayName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.product_family_display_name = None
        self.configuration_display_name = None


class EncryptionPreferences(_serialization.Model):
    """Preferences related to the double encryption.

    :ivar double_encryption_status: Double encryption status as entered by the customer. It is
     compulsory to give this parameter if the 'Deny' or 'Disabled' policy is configured. Known
     values are: "Disabled" and "Enabled".
    :vartype double_encryption_status: str or ~azure.mgmt.edgeorder.models.DoubleEncryptionStatus
    """

    _attribute_map = {
        "double_encryption_status": {"key": "doubleEncryptionStatus", "type": "str"},
    }

    def __init__(
        self, *, double_encryption_status: Optional[Union[str, "_models.DoubleEncryptionStatus"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword double_encryption_status: Double encryption status as entered by the customer. It is
         compulsory to give this parameter if the 'Deny' or 'Disabled' policy is configured. Known
         values are: "Disabled" and "Enabled".
        :paramtype double_encryption_status: str or ~azure.mgmt.edgeorder.models.DoubleEncryptionStatus
        """
        super().__init__(**kwargs)
        self.double_encryption_status = double_encryption_status


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.edgeorder.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.edgeorder.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.edgeorder.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.edgeorder.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class FilterableProperty(_serialization.Model):
    """Different types of filters supported and its values.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of product filter. Required. Known values are: "ShipToCountries" and
     "DoubleEncryptionStatus".
    :vartype type: str or ~azure.mgmt.edgeorder.models.SupportedFilterTypes
    :ivar supported_values: Values to be filtered. Required.
    :vartype supported_values: list[str]
    """

    _validation = {
        "type": {"required": True},
        "supported_values": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "supported_values": {"key": "supportedValues", "type": "[str]"},
    }

    def __init__(
        self, *, type: Union[str, "_models.SupportedFilterTypes"], supported_values: List[str], **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of product filter. Required. Known values are: "ShipToCountries" and
         "DoubleEncryptionStatus".
        :paramtype type: str or ~azure.mgmt.edgeorder.models.SupportedFilterTypes
        :keyword supported_values: Values to be filtered. Required.
        :paramtype supported_values: list[str]
        """
        super().__init__(**kwargs)
        self.type = type
        self.supported_values = supported_values


class ForwardShippingDetails(_serialization.Model):
    """Forward shipment details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar carrier_name: Name of the carrier.
    :vartype carrier_name: str
    :ivar carrier_display_name: Carrier Name for display purpose. Not to be used for any
     processing.
    :vartype carrier_display_name: str
    :ivar tracking_id: TrackingId of the package.
    :vartype tracking_id: str
    :ivar tracking_url: TrackingUrl of the package.
    :vartype tracking_url: str
    """

    _validation = {
        "carrier_name": {"readonly": True},
        "carrier_display_name": {"readonly": True},
        "tracking_id": {"readonly": True},
        "tracking_url": {"readonly": True},
    }

    _attribute_map = {
        "carrier_name": {"key": "carrierName", "type": "str"},
        "carrier_display_name": {"key": "carrierDisplayName", "type": "str"},
        "tracking_id": {"key": "trackingId", "type": "str"},
        "tracking_url": {"key": "trackingUrl", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.carrier_name = None
        self.carrier_display_name = None
        self.tracking_id = None
        self.tracking_url = None


class HierarchyInformation(_serialization.Model):
    """Holds details about product hierarchy information.

    :ivar product_family_name: Represents product family name that uniquely identifies product
     family.
    :vartype product_family_name: str
    :ivar product_line_name: Represents product line name that uniquely identifies product line.
    :vartype product_line_name: str
    :ivar product_name: Represents product name that uniquely identifies product.
    :vartype product_name: str
    :ivar configuration_name: Represents configuration name that uniquely identifies configuration.
    :vartype configuration_name: str
    """

    _attribute_map = {
        "product_family_name": {"key": "productFamilyName", "type": "str"},
        "product_line_name": {"key": "productLineName", "type": "str"},
        "product_name": {"key": "productName", "type": "str"},
        "configuration_name": {"key": "configurationName", "type": "str"},
    }

    def __init__(
        self,
        *,
        product_family_name: Optional[str] = None,
        product_line_name: Optional[str] = None,
        product_name: Optional[str] = None,
        configuration_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword product_family_name: Represents product family name that uniquely identifies product
         family.
        :paramtype product_family_name: str
        :keyword product_line_name: Represents product line name that uniquely identifies product line.
        :paramtype product_line_name: str
        :keyword product_name: Represents product name that uniquely identifies product.
        :paramtype product_name: str
        :keyword configuration_name: Represents configuration name that uniquely identifies
         configuration.
        :paramtype configuration_name: str
        """
        super().__init__(**kwargs)
        self.product_family_name = product_family_name
        self.product_line_name = product_line_name
        self.product_name = product_name
        self.configuration_name = configuration_name


class ImageInformation(_serialization.Model):
    """Image for the product.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar image_type: Type of the image. Known values are: "MainImage", "BulletImage", and
     "GenericImage".
    :vartype image_type: str or ~azure.mgmt.edgeorder.models.ImageType
    :ivar image_url: Url of the image.
    :vartype image_url: str
    """

    _validation = {
        "image_type": {"readonly": True},
        "image_url": {"readonly": True},
    }

    _attribute_map = {
        "image_type": {"key": "imageType", "type": "str"},
        "image_url": {"key": "imageUrl", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.image_type = None
        self.image_url = None


class Link(_serialization.Model):
    """Returns link related to the product.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar link_type: Type of link. Known values are: "Generic", "TermsAndConditions",
     "Specification", "Documentation", "KnowMore", and "SignUp".
    :vartype link_type: str or ~azure.mgmt.edgeorder.models.LinkType
    :ivar link_url: Url of the link.
    :vartype link_url: str
    """

    _validation = {
        "link_type": {"readonly": True},
        "link_url": {"readonly": True},
    }

    _attribute_map = {
        "link_type": {"key": "linkType", "type": "str"},
        "link_url": {"key": "linkUrl", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.link_type = None
        self.link_url = None


class ManagementResourcePreferences(_serialization.Model):
    """Management resource preference to link device.

    :ivar preferred_management_resource_id: Customer preferred Management resource ARM ID.
    :vartype preferred_management_resource_id: str
    """

    _attribute_map = {
        "preferred_management_resource_id": {"key": "preferredManagementResourceId", "type": "str"},
    }

    def __init__(self, *, preferred_management_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword preferred_management_resource_id: Customer preferred Management resource ARM ID.
        :paramtype preferred_management_resource_id: str
        """
        super().__init__(**kwargs)
        self.preferred_management_resource_id = preferred_management_resource_id


class MeterDetails(_serialization.Model):
    """Holds details about billing type and its meter guids.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Pav2MeterDetails, PurchaseMeterDetails

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar billing_type: Represents billing type. Required. Known values are: "Pav2" and "Purchase".
    :vartype billing_type: str or ~azure.mgmt.edgeorder.models.BillingType
    :ivar multiplier: Billing unit applicable for Pav2 billing.
    :vartype multiplier: float
    :ivar charging_type: Charging type. Known values are: "PerOrder" and "PerDevice".
    :vartype charging_type: str or ~azure.mgmt.edgeorder.models.ChargingType
    """

    _validation = {
        "billing_type": {"required": True},
        "multiplier": {"readonly": True},
        "charging_type": {"readonly": True},
    }

    _attribute_map = {
        "billing_type": {"key": "billingType", "type": "str"},
        "multiplier": {"key": "multiplier", "type": "float"},
        "charging_type": {"key": "chargingType", "type": "str"},
    }

    _subtype_map = {"billing_type": {"Pav2": "Pav2MeterDetails", "Purchase": "PurchaseMeterDetails"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.billing_type: Optional[str] = None
        self.multiplier = None
        self.charging_type = None


class NotificationPreference(_serialization.Model):
    """Notification preference for a job stage.

    All required parameters must be populated in order to send to server.

    :ivar stage_name: Name of the stage. Required. Known values are: "Shipped" and "Delivered".
    :vartype stage_name: str or ~azure.mgmt.edgeorder.models.NotificationStageName
    :ivar send_notification: Notification is required or not. Required.
    :vartype send_notification: bool
    """

    _validation = {
        "stage_name": {"required": True},
        "send_notification": {"required": True},
    }

    _attribute_map = {
        "stage_name": {"key": "stageName", "type": "str"},
        "send_notification": {"key": "sendNotification", "type": "bool"},
    }

    def __init__(
        self, *, stage_name: Union[str, "_models.NotificationStageName"], send_notification: bool, **kwargs: Any
    ) -> None:
        """
        :keyword stage_name: Name of the stage. Required. Known values are: "Shipped" and "Delivered".
        :paramtype stage_name: str or ~azure.mgmt.edgeorder.models.NotificationStageName
        :keyword send_notification: Notification is required or not. Required.
        :paramtype send_notification: bool
        """
        super().__init__(**kwargs)
        self.stage_name = stage_name
        self.send_notification = send_notification


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.edgeorder.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.edgeorder.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.edgeorder.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.edgeorder.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.edgeorder.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OrderItemDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Order item details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar product_details: Unique identifier for configuration. Required.
    :vartype product_details: ~azure.mgmt.edgeorder.models.ProductDetails
    :ivar order_item_type: Order item type. Required. Known values are: "Purchase" and "Rental".
    :vartype order_item_type: str or ~azure.mgmt.edgeorder.models.OrderItemType
    :ivar current_stage: Current Order item Status.
    :vartype current_stage: ~azure.mgmt.edgeorder.models.StageDetails
    :ivar order_item_stage_history: Order item status history.
    :vartype order_item_stage_history: list[~azure.mgmt.edgeorder.models.StageDetails]
    :ivar preferences: Customer notification Preferences.
    :vartype preferences: ~azure.mgmt.edgeorder.models.Preferences
    :ivar forward_shipping_details: Forward Package Shipping details.
    :vartype forward_shipping_details: ~azure.mgmt.edgeorder.models.ForwardShippingDetails
    :ivar reverse_shipping_details: Reverse Package Shipping details.
    :vartype reverse_shipping_details: ~azure.mgmt.edgeorder.models.ReverseShippingDetails
    :ivar notification_email_list: Additional notification email list.
    :vartype notification_email_list: list[str]
    :ivar cancellation_reason: Cancellation reason.
    :vartype cancellation_reason: str
    :ivar cancellation_status: Describes whether the order item is cancellable or not. Known values
     are: "Cancellable", "CancellableWithFee", and "NotCancellable".
    :vartype cancellation_status: str or ~azure.mgmt.edgeorder.models.OrderItemCancellationEnum
    :ivar deletion_status: Describes whether the order item is deletable or not. Known values are:
     "Allowed" and "NotAllowed".
    :vartype deletion_status: str or ~azure.mgmt.edgeorder.models.ActionStatusEnum
    :ivar return_reason: Return reason.
    :vartype return_reason: str
    :ivar return_status: Describes whether the order item is returnable or not. Known values are:
     "Returnable", "ReturnableWithFee", and "NotReturnable".
    :vartype return_status: str or ~azure.mgmt.edgeorder.models.OrderItemReturnEnum
    :ivar management_rp_details: Parent RP details - this returns only the first or default parent
     RP from the entire list.
    :vartype management_rp_details: ~azure.mgmt.edgeorder.models.ResourceProviderDetails
    :ivar management_rp_details_list: List of parent RP details supported for configuration.
    :vartype management_rp_details_list: list[~azure.mgmt.edgeorder.models.ResourceProviderDetails]
    :ivar error: Top level error for the job.
    :vartype error: ~azure.mgmt.edgeorder.models.ErrorDetail
    """

    _validation = {
        "product_details": {"required": True},
        "order_item_type": {"required": True},
        "current_stage": {"readonly": True},
        "order_item_stage_history": {"readonly": True},
        "forward_shipping_details": {"readonly": True},
        "reverse_shipping_details": {"readonly": True},
        "cancellation_reason": {"readonly": True},
        "cancellation_status": {"readonly": True},
        "deletion_status": {"readonly": True},
        "return_reason": {"readonly": True},
        "return_status": {"readonly": True},
        "management_rp_details": {"readonly": True},
        "management_rp_details_list": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "product_details": {"key": "productDetails", "type": "ProductDetails"},
        "order_item_type": {"key": "orderItemType", "type": "str"},
        "current_stage": {"key": "currentStage", "type": "StageDetails"},
        "order_item_stage_history": {"key": "orderItemStageHistory", "type": "[StageDetails]"},
        "preferences": {"key": "preferences", "type": "Preferences"},
        "forward_shipping_details": {"key": "forwardShippingDetails", "type": "ForwardShippingDetails"},
        "reverse_shipping_details": {"key": "reverseShippingDetails", "type": "ReverseShippingDetails"},
        "notification_email_list": {"key": "notificationEmailList", "type": "[str]"},
        "cancellation_reason": {"key": "cancellationReason", "type": "str"},
        "cancellation_status": {"key": "cancellationStatus", "type": "str"},
        "deletion_status": {"key": "deletionStatus", "type": "str"},
        "return_reason": {"key": "returnReason", "type": "str"},
        "return_status": {"key": "returnStatus", "type": "str"},
        "management_rp_details": {"key": "managementRpDetails", "type": "ResourceProviderDetails"},
        "management_rp_details_list": {"key": "managementRpDetailsList", "type": "[ResourceProviderDetails]"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        product_details: "_models.ProductDetails",
        order_item_type: Union[str, "_models.OrderItemType"],
        preferences: Optional["_models.Preferences"] = None,
        notification_email_list: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword product_details: Unique identifier for configuration. Required.
        :paramtype product_details: ~azure.mgmt.edgeorder.models.ProductDetails
        :keyword order_item_type: Order item type. Required. Known values are: "Purchase" and "Rental".
        :paramtype order_item_type: str or ~azure.mgmt.edgeorder.models.OrderItemType
        :keyword preferences: Customer notification Preferences.
        :paramtype preferences: ~azure.mgmt.edgeorder.models.Preferences
        :keyword notification_email_list: Additional notification email list.
        :paramtype notification_email_list: list[str]
        """
        super().__init__(**kwargs)
        self.product_details = product_details
        self.order_item_type = order_item_type
        self.current_stage = None
        self.order_item_stage_history = None
        self.preferences = preferences
        self.forward_shipping_details = None
        self.reverse_shipping_details = None
        self.notification_email_list = notification_email_list
        self.cancellation_reason = None
        self.cancellation_status = None
        self.deletion_status = None
        self.return_reason = None
        self.return_status = None
        self.management_rp_details = None
        self.management_rp_details_list = None
        self.error = None


class OrderItemResource(TrackedResource):
    """Represents order item contract.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar system_data: Represents resource creation and update time.
    :vartype system_data: ~azure.mgmt.edgeorder.models.SystemData
    :ivar order_item_details: Represents order item details. Required.
    :vartype order_item_details: ~azure.mgmt.edgeorder.models.OrderItemDetails
    :ivar address_details: Represents shipping and return address for order item. Required.
    :vartype address_details: ~azure.mgmt.edgeorder.models.AddressDetails
    :ivar start_time: Start time of order item.
    :vartype start_time: ~datetime.datetime
    :ivar order_id: Id of the order to which order item belongs to. Required.
    :vartype order_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "order_item_details": {"required": True},
        "address_details": {"required": True},
        "start_time": {"readonly": True},
        "order_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "order_item_details": {"key": "properties.orderItemDetails", "type": "OrderItemDetails"},
        "address_details": {"key": "properties.addressDetails", "type": "AddressDetails"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "order_id": {"key": "properties.orderId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        order_item_details: "_models.OrderItemDetails",
        address_details: "_models.AddressDetails",
        order_id: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword order_item_details: Represents order item details. Required.
        :paramtype order_item_details: ~azure.mgmt.edgeorder.models.OrderItemDetails
        :keyword address_details: Represents shipping and return address for order item. Required.
        :paramtype address_details: ~azure.mgmt.edgeorder.models.AddressDetails
        :keyword order_id: Id of the order to which order item belongs to. Required.
        :paramtype order_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.order_item_details = order_item_details
        self.address_details = address_details
        self.start_time = None
        self.order_id = order_id


class OrderItemResourceList(_serialization.Model):
    """List of orderItems.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of order item resources.
    :vartype value: list[~azure.mgmt.edgeorder.models.OrderItemResource]
    :ivar next_link: Link for the next set of order item resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OrderItemResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Link for the next set of order item resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class OrderItemUpdateParameter(_serialization.Model):
    """Updates order item parameters.

    :ivar tags: The list of key value pairs that describe the resource. These tags can be used in
     viewing and grouping this resource (across resource groups).
    :vartype tags: dict[str, str]
    :ivar forward_address: Updates forward shipping address and contact details.
    :vartype forward_address: ~azure.mgmt.edgeorder.models.AddressProperties
    :ivar preferences: Customer preference.
    :vartype preferences: ~azure.mgmt.edgeorder.models.Preferences
    :ivar notification_email_list: Additional notification email list.
    :vartype notification_email_list: list[str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "forward_address": {"key": "properties.forwardAddress", "type": "AddressProperties"},
        "preferences": {"key": "properties.preferences", "type": "Preferences"},
        "notification_email_list": {"key": "properties.notificationEmailList", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        forward_address: Optional["_models.AddressProperties"] = None,
        preferences: Optional["_models.Preferences"] = None,
        notification_email_list: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The list of key value pairs that describe the resource. These tags can be used
         in viewing and grouping this resource (across resource groups).
        :paramtype tags: dict[str, str]
        :keyword forward_address: Updates forward shipping address and contact details.
        :paramtype forward_address: ~azure.mgmt.edgeorder.models.AddressProperties
        :keyword preferences: Customer preference.
        :paramtype preferences: ~azure.mgmt.edgeorder.models.Preferences
        :keyword notification_email_list: Additional notification email list.
        :paramtype notification_email_list: list[str]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.forward_address = forward_address
        self.preferences = preferences
        self.notification_email_list = notification_email_list


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """


class OrderResource(ProxyResource):
    """Specifies the properties or parameters for an order. Order is a grouping of one or more order
    items.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Represents resource creation and update time.
    :vartype system_data: ~azure.mgmt.edgeorder.models.SystemData
    :ivar order_item_ids: List of order item ARM Ids which are part of an order.
    :vartype order_item_ids: list[str]
    :ivar current_stage: Order current status.
    :vartype current_stage: ~azure.mgmt.edgeorder.models.StageDetails
    :ivar order_stage_history: Order status history.
    :vartype order_stage_history: list[~azure.mgmt.edgeorder.models.StageDetails]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "order_item_ids": {"readonly": True},
        "current_stage": {"readonly": True},
        "order_stage_history": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "order_item_ids": {"key": "properties.orderItemIds", "type": "[str]"},
        "current_stage": {"key": "properties.currentStage", "type": "StageDetails"},
        "order_stage_history": {"key": "properties.orderStageHistory", "type": "[StageDetails]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.system_data = None
        self.order_item_ids = None
        self.current_stage = None
        self.order_stage_history = None


class OrderResourceList(_serialization.Model):
    """List of orders.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of order resources.
    :vartype value: list[~azure.mgmt.edgeorder.models.OrderResource]
    :ivar next_link: Link for the next set of order resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OrderResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Link for the next set of order resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class Pav2MeterDetails(MeterDetails):
    """Billing type PAV2 meter details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar billing_type: Represents billing type. Required. Known values are: "Pav2" and "Purchase".
    :vartype billing_type: str or ~azure.mgmt.edgeorder.models.BillingType
    :ivar multiplier: Billing unit applicable for Pav2 billing.
    :vartype multiplier: float
    :ivar charging_type: Charging type. Known values are: "PerOrder" and "PerDevice".
    :vartype charging_type: str or ~azure.mgmt.edgeorder.models.ChargingType
    :ivar meter_guid: Validation status of requested data center and transport.
    :vartype meter_guid: str
    """

    _validation = {
        "billing_type": {"required": True},
        "multiplier": {"readonly": True},
        "charging_type": {"readonly": True},
        "meter_guid": {"readonly": True},
    }

    _attribute_map = {
        "billing_type": {"key": "billingType", "type": "str"},
        "multiplier": {"key": "multiplier", "type": "float"},
        "charging_type": {"key": "chargingType", "type": "str"},
        "meter_guid": {"key": "meterGuid", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.billing_type: str = "Pav2"
        self.meter_guid = None


class Preferences(_serialization.Model):
    """Preferences related to the order.

    :ivar notification_preferences: Notification preferences.
    :vartype notification_preferences: list[~azure.mgmt.edgeorder.models.NotificationPreference]
    :ivar transport_preferences: Preferences related to the shipment logistics of the order.
    :vartype transport_preferences: ~azure.mgmt.edgeorder.models.TransportPreferences
    :ivar encryption_preferences: Preferences related to the Encryption.
    :vartype encryption_preferences: ~azure.mgmt.edgeorder.models.EncryptionPreferences
    :ivar management_resource_preferences: Preferences related to the Management resource.
    :vartype management_resource_preferences:
     ~azure.mgmt.edgeorder.models.ManagementResourcePreferences
    """

    _attribute_map = {
        "notification_preferences": {"key": "notificationPreferences", "type": "[NotificationPreference]"},
        "transport_preferences": {"key": "transportPreferences", "type": "TransportPreferences"},
        "encryption_preferences": {"key": "encryptionPreferences", "type": "EncryptionPreferences"},
        "management_resource_preferences": {
            "key": "managementResourcePreferences",
            "type": "ManagementResourcePreferences",
        },
    }

    def __init__(
        self,
        *,
        notification_preferences: Optional[List["_models.NotificationPreference"]] = None,
        transport_preferences: Optional["_models.TransportPreferences"] = None,
        encryption_preferences: Optional["_models.EncryptionPreferences"] = None,
        management_resource_preferences: Optional["_models.ManagementResourcePreferences"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword notification_preferences: Notification preferences.
        :paramtype notification_preferences: list[~azure.mgmt.edgeorder.models.NotificationPreference]
        :keyword transport_preferences: Preferences related to the shipment logistics of the order.
        :paramtype transport_preferences: ~azure.mgmt.edgeorder.models.TransportPreferences
        :keyword encryption_preferences: Preferences related to the Encryption.
        :paramtype encryption_preferences: ~azure.mgmt.edgeorder.models.EncryptionPreferences
        :keyword management_resource_preferences: Preferences related to the Management resource.
        :paramtype management_resource_preferences:
         ~azure.mgmt.edgeorder.models.ManagementResourcePreferences
        """
        super().__init__(**kwargs)
        self.notification_preferences = notification_preferences
        self.transport_preferences = transport_preferences
        self.encryption_preferences = encryption_preferences
        self.management_resource_preferences = management_resource_preferences


class Product(_serialization.Model):
    """List of Products.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information: ~azure.mgmt.edgeorder.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties: list[~azure.mgmt.edgeorder.models.FilterableProperty]
    :ivar configurations: List of configurations for the product.
    :vartype configurations: list[~azure.mgmt.edgeorder.models.Configuration]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "image_information": {"readonly": True},
        "cost_information": {"readonly": True},
        "availability_information": {"readonly": True},
        "hierarchy_information": {"readonly": True},
        "filterable_properties": {"readonly": True},
        "configurations": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "Description"},
        "image_information": {"key": "properties.imageInformation", "type": "[ImageInformation]"},
        "cost_information": {"key": "properties.costInformation", "type": "CostInformation"},
        "availability_information": {"key": "properties.availabilityInformation", "type": "AvailabilityInformation"},
        "hierarchy_information": {"key": "properties.hierarchyInformation", "type": "HierarchyInformation"},
        "filterable_properties": {"key": "properties.filterableProperties", "type": "[FilterableProperty]"},
        "configurations": {"key": "properties.configurations", "type": "[Configuration]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.image_information = None
        self.cost_information = None
        self.availability_information = None
        self.hierarchy_information = None
        self.filterable_properties = None
        self.configurations = None


class ProductDetails(_serialization.Model):
    """Represents product details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_info: Display details of the product.
    :vartype display_info: ~azure.mgmt.edgeorder.models.DisplayInfo
    :ivar hierarchy_information: Hierarchy of the product which uniquely identifies the product.
     Required.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
    :ivar count: Quantity of the product.
    :vartype count: int
    :ivar product_double_encryption_status: Double encryption status of the configuration.
     Read-only field. Known values are: "Disabled" and "Enabled".
    :vartype product_double_encryption_status: str or
     ~azure.mgmt.edgeorder.models.DoubleEncryptionStatus
    :ivar device_details: list of device details.
    :vartype device_details: list[~azure.mgmt.edgeorder.models.DeviceDetails]
    """

    _validation = {
        "hierarchy_information": {"required": True},
        "count": {"readonly": True},
        "product_double_encryption_status": {"readonly": True},
        "device_details": {"readonly": True},
    }

    _attribute_map = {
        "display_info": {"key": "displayInfo", "type": "DisplayInfo"},
        "hierarchy_information": {"key": "hierarchyInformation", "type": "HierarchyInformation"},
        "count": {"key": "count", "type": "int"},
        "product_double_encryption_status": {"key": "productDoubleEncryptionStatus", "type": "str"},
        "device_details": {"key": "deviceDetails", "type": "[DeviceDetails]"},
    }

    def __init__(
        self,
        *,
        hierarchy_information: "_models.HierarchyInformation",
        display_info: Optional["_models.DisplayInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_info: Display details of the product.
        :paramtype display_info: ~azure.mgmt.edgeorder.models.DisplayInfo
        :keyword hierarchy_information: Hierarchy of the product which uniquely identifies the product.
         Required.
        :paramtype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
        """
        super().__init__(**kwargs)
        self.display_info = display_info
        self.hierarchy_information = hierarchy_information
        self.count = None
        self.product_double_encryption_status = None
        self.device_details = None


class ProductFamilies(_serialization.Model):
    """The list of product families.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of product families.
    :vartype value: list[~azure.mgmt.edgeorder.models.ProductFamily]
    :ivar next_link: Link for the next set of product families.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ProductFamily]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Link for the next set of product families.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class ProductFamiliesMetadata(_serialization.Model):
    """Holds details about product family metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of product family metadata details.
    :vartype value: list[~azure.mgmt.edgeorder.models.ProductFamiliesMetadataDetails]
    :ivar next_link: Link for the next set of product families.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ProductFamiliesMetadataDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ProductFamiliesMetadataDetails(_serialization.Model):
    """Product families metadata details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information: ~azure.mgmt.edgeorder.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties: list[~azure.mgmt.edgeorder.models.FilterableProperty]
    :ivar product_lines: List of product lines supported in the product family.
    :vartype product_lines: list[~azure.mgmt.edgeorder.models.ProductLine]
    :ivar resource_provider_details: Contains details related to resource provider.
    :vartype resource_provider_details: list[~azure.mgmt.edgeorder.models.ResourceProviderDetails]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "image_information": {"readonly": True},
        "cost_information": {"readonly": True},
        "availability_information": {"readonly": True},
        "hierarchy_information": {"readonly": True},
        "filterable_properties": {"readonly": True},
        "product_lines": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "Description"},
        "image_information": {"key": "properties.imageInformation", "type": "[ImageInformation]"},
        "cost_information": {"key": "properties.costInformation", "type": "CostInformation"},
        "availability_information": {"key": "properties.availabilityInformation", "type": "AvailabilityInformation"},
        "hierarchy_information": {"key": "properties.hierarchyInformation", "type": "HierarchyInformation"},
        "filterable_properties": {"key": "properties.filterableProperties", "type": "[FilterableProperty]"},
        "product_lines": {"key": "properties.productLines", "type": "[ProductLine]"},
        "resource_provider_details": {"key": "properties.resourceProviderDetails", "type": "[ResourceProviderDetails]"},
    }

    def __init__(
        self, *, resource_provider_details: Optional[List["_models.ResourceProviderDetails"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_provider_details: Contains details related to resource provider.
        :paramtype resource_provider_details:
         list[~azure.mgmt.edgeorder.models.ResourceProviderDetails]
        """
        super().__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.image_information = None
        self.cost_information = None
        self.availability_information = None
        self.hierarchy_information = None
        self.filterable_properties = None
        self.product_lines = None
        self.resource_provider_details = resource_provider_details


class ProductFamiliesRequest(_serialization.Model):
    """The filters for showing the product families.

    All required parameters must be populated in order to send to server.

    :ivar filterable_properties: Dictionary of filterable properties on product family. Required.
    :vartype filterable_properties: dict[str,
     list[~azure.mgmt.edgeorder.models.FilterableProperty]]
    :ivar customer_subscription_details: Customer subscription properties. Clients can display
     available products to unregistered customers by explicitly passing subscription details.
    :vartype customer_subscription_details:
     ~azure.mgmt.edgeorder.models.CustomerSubscriptionDetails
    """

    _validation = {
        "filterable_properties": {"required": True},
    }

    _attribute_map = {
        "filterable_properties": {"key": "filterableProperties", "type": "{[FilterableProperty]}"},
        "customer_subscription_details": {"key": "customerSubscriptionDetails", "type": "CustomerSubscriptionDetails"},
    }

    def __init__(
        self,
        *,
        filterable_properties: Dict[str, List["_models.FilterableProperty"]],
        customer_subscription_details: Optional["_models.CustomerSubscriptionDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword filterable_properties: Dictionary of filterable properties on product family.
         Required.
        :paramtype filterable_properties: dict[str,
         list[~azure.mgmt.edgeorder.models.FilterableProperty]]
        :keyword customer_subscription_details: Customer subscription properties. Clients can display
         available products to unregistered customers by explicitly passing subscription details.
        :paramtype customer_subscription_details:
         ~azure.mgmt.edgeorder.models.CustomerSubscriptionDetails
        """
        super().__init__(**kwargs)
        self.filterable_properties = filterable_properties
        self.customer_subscription_details = customer_subscription_details


class ProductFamily(_serialization.Model):
    """Product Family.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information: ~azure.mgmt.edgeorder.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties: list[~azure.mgmt.edgeorder.models.FilterableProperty]
    :ivar product_lines: List of product lines supported in the product family.
    :vartype product_lines: list[~azure.mgmt.edgeorder.models.ProductLine]
    :ivar resource_provider_details: Contains details related to resource provider.
    :vartype resource_provider_details: list[~azure.mgmt.edgeorder.models.ResourceProviderDetails]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "image_information": {"readonly": True},
        "cost_information": {"readonly": True},
        "availability_information": {"readonly": True},
        "hierarchy_information": {"readonly": True},
        "filterable_properties": {"readonly": True},
        "product_lines": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "Description"},
        "image_information": {"key": "properties.imageInformation", "type": "[ImageInformation]"},
        "cost_information": {"key": "properties.costInformation", "type": "CostInformation"},
        "availability_information": {"key": "properties.availabilityInformation", "type": "AvailabilityInformation"},
        "hierarchy_information": {"key": "properties.hierarchyInformation", "type": "HierarchyInformation"},
        "filterable_properties": {"key": "properties.filterableProperties", "type": "[FilterableProperty]"},
        "product_lines": {"key": "properties.productLines", "type": "[ProductLine]"},
        "resource_provider_details": {"key": "properties.resourceProviderDetails", "type": "[ResourceProviderDetails]"},
    }

    def __init__(
        self, *, resource_provider_details: Optional[List["_models.ResourceProviderDetails"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_provider_details: Contains details related to resource provider.
        :paramtype resource_provider_details:
         list[~azure.mgmt.edgeorder.models.ResourceProviderDetails]
        """
        super().__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.image_information = None
        self.cost_information = None
        self.availability_information = None
        self.hierarchy_information = None
        self.filterable_properties = None
        self.product_lines = None
        self.resource_provider_details = resource_provider_details


class ProductFamilyProperties(CommonProperties):
    """Properties of product family.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information: ~azure.mgmt.edgeorder.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties: list[~azure.mgmt.edgeorder.models.FilterableProperty]
    :ivar product_lines: List of product lines supported in the product family.
    :vartype product_lines: list[~azure.mgmt.edgeorder.models.ProductLine]
    :ivar resource_provider_details: Contains details related to resource provider.
    :vartype resource_provider_details: list[~azure.mgmt.edgeorder.models.ResourceProviderDetails]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "image_information": {"readonly": True},
        "cost_information": {"readonly": True},
        "availability_information": {"readonly": True},
        "hierarchy_information": {"readonly": True},
        "filterable_properties": {"readonly": True},
        "product_lines": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "Description"},
        "image_information": {"key": "imageInformation", "type": "[ImageInformation]"},
        "cost_information": {"key": "costInformation", "type": "CostInformation"},
        "availability_information": {"key": "availabilityInformation", "type": "AvailabilityInformation"},
        "hierarchy_information": {"key": "hierarchyInformation", "type": "HierarchyInformation"},
        "filterable_properties": {"key": "filterableProperties", "type": "[FilterableProperty]"},
        "product_lines": {"key": "productLines", "type": "[ProductLine]"},
        "resource_provider_details": {"key": "resourceProviderDetails", "type": "[ResourceProviderDetails]"},
    }

    def __init__(
        self, *, resource_provider_details: Optional[List["_models.ResourceProviderDetails"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_provider_details: Contains details related to resource provider.
        :paramtype resource_provider_details:
         list[~azure.mgmt.edgeorder.models.ResourceProviderDetails]
        """
        super().__init__(**kwargs)
        self.product_lines = None
        self.resource_provider_details = resource_provider_details


class ProductLine(_serialization.Model):
    """Product line.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information: ~azure.mgmt.edgeorder.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties: list[~azure.mgmt.edgeorder.models.FilterableProperty]
    :ivar products: List of products in the product line.
    :vartype products: list[~azure.mgmt.edgeorder.models.Product]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "image_information": {"readonly": True},
        "cost_information": {"readonly": True},
        "availability_information": {"readonly": True},
        "hierarchy_information": {"readonly": True},
        "filterable_properties": {"readonly": True},
        "products": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "Description"},
        "image_information": {"key": "properties.imageInformation", "type": "[ImageInformation]"},
        "cost_information": {"key": "properties.costInformation", "type": "CostInformation"},
        "availability_information": {"key": "properties.availabilityInformation", "type": "AvailabilityInformation"},
        "hierarchy_information": {"key": "properties.hierarchyInformation", "type": "HierarchyInformation"},
        "filterable_properties": {"key": "properties.filterableProperties", "type": "[FilterableProperty]"},
        "products": {"key": "properties.products", "type": "[Product]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.image_information = None
        self.cost_information = None
        self.availability_information = None
        self.hierarchy_information = None
        self.filterable_properties = None
        self.products = None


class ProductLineProperties(CommonProperties):
    """Properties of product line.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information: ~azure.mgmt.edgeorder.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties: list[~azure.mgmt.edgeorder.models.FilterableProperty]
    :ivar products: List of products in the product line.
    :vartype products: list[~azure.mgmt.edgeorder.models.Product]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "image_information": {"readonly": True},
        "cost_information": {"readonly": True},
        "availability_information": {"readonly": True},
        "hierarchy_information": {"readonly": True},
        "filterable_properties": {"readonly": True},
        "products": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "Description"},
        "image_information": {"key": "imageInformation", "type": "[ImageInformation]"},
        "cost_information": {"key": "costInformation", "type": "CostInformation"},
        "availability_information": {"key": "availabilityInformation", "type": "AvailabilityInformation"},
        "hierarchy_information": {"key": "hierarchyInformation", "type": "HierarchyInformation"},
        "filterable_properties": {"key": "filterableProperties", "type": "[FilterableProperty]"},
        "products": {"key": "products", "type": "[Product]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.products = None


class ProductProperties(CommonProperties):
    """Properties of products.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_name: Display Name for the product system.
    :vartype display_name: str
    :ivar description: Description related to the product system.
    :vartype description: ~azure.mgmt.edgeorder.models.Description
    :ivar image_information: Image information for the product system.
    :vartype image_information: list[~azure.mgmt.edgeorder.models.ImageInformation]
    :ivar cost_information: Cost information for the product system.
    :vartype cost_information: ~azure.mgmt.edgeorder.models.CostInformation
    :ivar availability_information: Availability information of the product system.
    :vartype availability_information: ~azure.mgmt.edgeorder.models.AvailabilityInformation
    :ivar hierarchy_information: Hierarchy information of a product.
    :vartype hierarchy_information: ~azure.mgmt.edgeorder.models.HierarchyInformation
    :ivar filterable_properties: list of filters supported for a product.
    :vartype filterable_properties: list[~azure.mgmt.edgeorder.models.FilterableProperty]
    :ivar configurations: List of configurations for the product.
    :vartype configurations: list[~azure.mgmt.edgeorder.models.Configuration]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "image_information": {"readonly": True},
        "cost_information": {"readonly": True},
        "availability_information": {"readonly": True},
        "hierarchy_information": {"readonly": True},
        "filterable_properties": {"readonly": True},
        "configurations": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "Description"},
        "image_information": {"key": "imageInformation", "type": "[ImageInformation]"},
        "cost_information": {"key": "costInformation", "type": "CostInformation"},
        "availability_information": {"key": "availabilityInformation", "type": "AvailabilityInformation"},
        "hierarchy_information": {"key": "hierarchyInformation", "type": "HierarchyInformation"},
        "filterable_properties": {"key": "filterableProperties", "type": "[FilterableProperty]"},
        "configurations": {"key": "configurations", "type": "[Configuration]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.configurations = None


class PurchaseMeterDetails(MeterDetails):
    """Billing type Purchase meter details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar billing_type: Represents billing type. Required. Known values are: "Pav2" and "Purchase".
    :vartype billing_type: str or ~azure.mgmt.edgeorder.models.BillingType
    :ivar multiplier: Billing unit applicable for Pav2 billing.
    :vartype multiplier: float
    :ivar charging_type: Charging type. Known values are: "PerOrder" and "PerDevice".
    :vartype charging_type: str or ~azure.mgmt.edgeorder.models.ChargingType
    :ivar product_id: Product Id.
    :vartype product_id: str
    :ivar sku_id: Sku Id.
    :vartype sku_id: str
    :ivar term_id: Term Id.
    :vartype term_id: str
    """

    _validation = {
        "billing_type": {"required": True},
        "multiplier": {"readonly": True},
        "charging_type": {"readonly": True},
        "product_id": {"readonly": True},
        "sku_id": {"readonly": True},
        "term_id": {"readonly": True},
    }

    _attribute_map = {
        "billing_type": {"key": "billingType", "type": "str"},
        "multiplier": {"key": "multiplier", "type": "float"},
        "charging_type": {"key": "chargingType", "type": "str"},
        "product_id": {"key": "productId", "type": "str"},
        "sku_id": {"key": "skuId", "type": "str"},
        "term_id": {"key": "termId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.billing_type: str = "Purchase"
        self.product_id = None
        self.sku_id = None
        self.term_id = None


class ResourceIdentity(_serialization.Model):
    """Msi identity details of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Identity type.
    :vartype type: str
    :ivar principal_id: Service Principal Id backing the Msi.
    :vartype principal_id: str
    :ivar tenant_id: Home Tenant Id.
    :vartype tenant_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword type: Identity type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None


class ResourceProviderDetails(_serialization.Model):
    """Management RP details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_provider_namespace: Resource provider namespace.
    :vartype resource_provider_namespace: str
    """

    _validation = {
        "resource_provider_namespace": {"readonly": True},
    }

    _attribute_map = {
        "resource_provider_namespace": {"key": "resourceProviderNamespace", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_provider_namespace = None


class ReturnOrderItemDetails(_serialization.Model):
    """Return order item request body.

    All required parameters must be populated in order to send to server.

    :ivar return_address: customer return address.
    :vartype return_address: ~azure.mgmt.edgeorder.models.AddressProperties
    :ivar return_reason: Return Reason. Required.
    :vartype return_reason: str
    :ivar service_tag: Service tag (located on the bottom-right corner of the device).
    :vartype service_tag: str
    :ivar shipping_box_required: Shipping Box required.
    :vartype shipping_box_required: bool
    """

    _validation = {
        "return_reason": {"required": True},
    }

    _attribute_map = {
        "return_address": {"key": "returnAddress", "type": "AddressProperties"},
        "return_reason": {"key": "returnReason", "type": "str"},
        "service_tag": {"key": "serviceTag", "type": "str"},
        "shipping_box_required": {"key": "shippingBoxRequired", "type": "bool"},
    }

    def __init__(
        self,
        *,
        return_reason: str,
        return_address: Optional["_models.AddressProperties"] = None,
        service_tag: Optional[str] = None,
        shipping_box_required: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword return_address: customer return address.
        :paramtype return_address: ~azure.mgmt.edgeorder.models.AddressProperties
        :keyword return_reason: Return Reason. Required.
        :paramtype return_reason: str
        :keyword service_tag: Service tag (located on the bottom-right corner of the device).
        :paramtype service_tag: str
        :keyword shipping_box_required: Shipping Box required.
        :paramtype shipping_box_required: bool
        """
        super().__init__(**kwargs)
        self.return_address = return_address
        self.return_reason = return_reason
        self.service_tag = service_tag
        self.shipping_box_required = shipping_box_required


class ReverseShippingDetails(_serialization.Model):
    """Reverse shipment details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sas_key_for_label: SAS key to download the reverse shipment label of the package.
    :vartype sas_key_for_label: str
    :ivar carrier_name: Name of the carrier.
    :vartype carrier_name: str
    :ivar carrier_display_name: Carrier Name for display purpose. Not to be used for any
     processing.
    :vartype carrier_display_name: str
    :ivar tracking_id: TrackingId of the package.
    :vartype tracking_id: str
    :ivar tracking_url: TrackingUrl of the package.
    :vartype tracking_url: str
    """

    _validation = {
        "sas_key_for_label": {"readonly": True},
        "carrier_name": {"readonly": True},
        "carrier_display_name": {"readonly": True},
        "tracking_id": {"readonly": True},
        "tracking_url": {"readonly": True},
    }

    _attribute_map = {
        "sas_key_for_label": {"key": "sasKeyForLabel", "type": "str"},
        "carrier_name": {"key": "carrierName", "type": "str"},
        "carrier_display_name": {"key": "carrierDisplayName", "type": "str"},
        "tracking_id": {"key": "trackingId", "type": "str"},
        "tracking_url": {"key": "trackingUrl", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.sas_key_for_label = None
        self.carrier_name = None
        self.carrier_display_name = None
        self.tracking_id = None
        self.tracking_url = None


class ShippingAddress(_serialization.Model):
    """Shipping address where customer wishes to receive the device.

    All required parameters must be populated in order to send to server.

    :ivar street_address1: Street Address line 1. Required.
    :vartype street_address1: str
    :ivar street_address2: Street Address line 2.
    :vartype street_address2: str
    :ivar street_address3: Street Address line 3.
    :vartype street_address3: str
    :ivar city: Name of the City.
    :vartype city: str
    :ivar state_or_province: Name of the State or Province.
    :vartype state_or_province: str
    :ivar country: Name of the Country. Required.
    :vartype country: str
    :ivar postal_code: Postal code.
    :vartype postal_code: str
    :ivar zip_extended_code: Extended Zip Code.
    :vartype zip_extended_code: str
    :ivar company_name: Name of the company.
    :vartype company_name: str
    :ivar address_type: Type of address. Known values are: "None", "Residential", and "Commercial".
    :vartype address_type: str or ~azure.mgmt.edgeorder.models.AddressType
    """

    _validation = {
        "street_address1": {"required": True},
        "country": {"required": True},
    }

    _attribute_map = {
        "street_address1": {"key": "streetAddress1", "type": "str"},
        "street_address2": {"key": "streetAddress2", "type": "str"},
        "street_address3": {"key": "streetAddress3", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "state_or_province": {"key": "stateOrProvince", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "zip_extended_code": {"key": "zipExtendedCode", "type": "str"},
        "company_name": {"key": "companyName", "type": "str"},
        "address_type": {"key": "addressType", "type": "str"},
    }

    def __init__(
        self,
        *,
        street_address1: str,
        country: str,
        street_address2: Optional[str] = None,
        street_address3: Optional[str] = None,
        city: Optional[str] = None,
        state_or_province: Optional[str] = None,
        postal_code: Optional[str] = None,
        zip_extended_code: Optional[str] = None,
        company_name: Optional[str] = None,
        address_type: Optional[Union[str, "_models.AddressType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword street_address1: Street Address line 1. Required.
        :paramtype street_address1: str
        :keyword street_address2: Street Address line 2.
        :paramtype street_address2: str
        :keyword street_address3: Street Address line 3.
        :paramtype street_address3: str
        :keyword city: Name of the City.
        :paramtype city: str
        :keyword state_or_province: Name of the State or Province.
        :paramtype state_or_province: str
        :keyword country: Name of the Country. Required.
        :paramtype country: str
        :keyword postal_code: Postal code.
        :paramtype postal_code: str
        :keyword zip_extended_code: Extended Zip Code.
        :paramtype zip_extended_code: str
        :keyword company_name: Name of the company.
        :paramtype company_name: str
        :keyword address_type: Type of address. Known values are: "None", "Residential", and
         "Commercial".
        :paramtype address_type: str or ~azure.mgmt.edgeorder.models.AddressType
        """
        super().__init__(**kwargs)
        self.street_address1 = street_address1
        self.street_address2 = street_address2
        self.street_address3 = street_address3
        self.city = city
        self.state_or_province = state_or_province
        self.country = country
        self.postal_code = postal_code
        self.zip_extended_code = zip_extended_code
        self.company_name = company_name
        self.address_type = address_type


class ShippingDetails(_serialization.Model):
    """Package shipping details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar carrier_name: Name of the carrier.
    :vartype carrier_name: str
    :ivar carrier_display_name: Carrier Name for display purpose. Not to be used for any
     processing.
    :vartype carrier_display_name: str
    :ivar tracking_id: TrackingId of the package.
    :vartype tracking_id: str
    :ivar tracking_url: TrackingUrl of the package.
    :vartype tracking_url: str
    """

    _validation = {
        "carrier_name": {"readonly": True},
        "carrier_display_name": {"readonly": True},
        "tracking_id": {"readonly": True},
        "tracking_url": {"readonly": True},
    }

    _attribute_map = {
        "carrier_name": {"key": "carrierName", "type": "str"},
        "carrier_display_name": {"key": "carrierDisplayName", "type": "str"},
        "tracking_id": {"key": "trackingId", "type": "str"},
        "tracking_url": {"key": "trackingUrl", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.carrier_name = None
        self.carrier_display_name = None
        self.tracking_id = None
        self.tracking_url = None


class Specification(_serialization.Model):
    """Specifications of the configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the specification.
    :vartype name: str
    :ivar value: Value of the specification.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class StageDetails(_serialization.Model):
    """Resource stage details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar stage_status: Stage status. Known values are: "None", "InProgress", "Succeeded",
     "Failed", "Cancelled", and "Cancelling".
    :vartype stage_status: str or ~azure.mgmt.edgeorder.models.StageStatus
    :ivar stage_name: Stage name. Known values are: "Placed", "InReview", "Confirmed",
     "ReadyToShip", "Shipped", "Delivered", "InUse", "ReturnInitiated", "ReturnPickedUp",
     "ReturnedToMicrosoft", "ReturnCompleted", and "Cancelled".
    :vartype stage_name: str or ~azure.mgmt.edgeorder.models.StageName
    :ivar display_name: Display name of the resource stage.
    :vartype display_name: str
    :ivar start_time: Stage start time.
    :vartype start_time: ~datetime.datetime
    """

    _validation = {
        "stage_status": {"readonly": True},
        "stage_name": {"readonly": True},
        "display_name": {"readonly": True},
        "start_time": {"readonly": True},
    }

    _attribute_map = {
        "stage_status": {"key": "stageStatus", "type": "str"},
        "stage_name": {"key": "stageName", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.stage_status = None
        self.stage_name = None
        self.display_name = None
        self.start_time = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.edgeorder.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.edgeorder.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.edgeorder.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.edgeorder.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TransportPreferences(_serialization.Model):
    """Preferences related to the shipment logistics of the sku.

    All required parameters must be populated in order to send to server.

    :ivar preferred_shipment_type: Indicates Shipment Logistics type that the customer preferred.
     Required. Known values are: "CustomerManaged" and "MicrosoftManaged".
    :vartype preferred_shipment_type: str or ~azure.mgmt.edgeorder.models.TransportShipmentTypes
    """

    _validation = {
        "preferred_shipment_type": {"required": True},
    }

    _attribute_map = {
        "preferred_shipment_type": {"key": "preferredShipmentType", "type": "str"},
    }

    def __init__(self, *, preferred_shipment_type: Union[str, "_models.TransportShipmentTypes"], **kwargs: Any) -> None:
        """
        :keyword preferred_shipment_type: Indicates Shipment Logistics type that the customer
         preferred. Required. Known values are: "CustomerManaged" and "MicrosoftManaged".
        :paramtype preferred_shipment_type: str or ~azure.mgmt.edgeorder.models.TransportShipmentTypes
        """
        super().__init__(**kwargs)
        self.preferred_shipment_type = preferred_shipment_type
