# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementPartnerDestinationsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_partner_destinations_get(self, resource_group):
        response = self.client.partner_destinations.get(
            resource_group_name=resource_group.name,
            partner_destination_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_partner_destinations_begin_create_or_update(self, resource_group):
        response = self.client.partner_destinations.begin_create_or_update(
            resource_group_name=resource_group.name,
            partner_destination_name="str",
            partner_destination={
                "location": "str",
                "activationState": "str",
                "endpointBaseUrl": "str",
                "endpointServiceContext": "str",
                "expirationTimeIfNotActivatedUtc": "2020-02-20 00:00:00",
                "id": "str",
                "messageForActivation": "str",
                "name": "str",
                "partnerRegistrationImmutableId": "str",
                "provisioningState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-04-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_partner_destinations_begin_delete(self, resource_group):
        response = self.client.partner_destinations.begin_delete(
            resource_group_name=resource_group.name,
            partner_destination_name="str",
            api_version="2025-04-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_partner_destinations_begin_update(self, resource_group):
        response = self.client.partner_destinations.begin_update(
            resource_group_name=resource_group.name,
            partner_destination_name="str",
            partner_destination_update_parameters={"tags": {"str": "str"}},
            api_version="2025-04-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_partner_destinations_list_by_subscription(self, resource_group):
        response = self.client.partner_destinations.list_by_subscription(
            api_version="2025-04-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_partner_destinations_list_by_resource_group(self, resource_group):
        response = self.client.partner_destinations.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-04-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_partner_destinations_activate(self, resource_group):
        response = self.client.partner_destinations.activate(
            resource_group_name=resource_group.name,
            partner_destination_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...
