# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class AddressValue(msrest.serialization.Model):
    """Address field value.

    :ivar house_number: House or building number.
    :vartype house_number: str
    :ivar po_box: Post office box number.
    :vartype po_box: str
    :ivar road: Street name.
    :vartype road: str
    :ivar city: Name of city, town, village, etc.
    :vartype city: str
    :ivar state: First-level administrative division.
    :vartype state: str
    :ivar postal_code: Postal code used for mail sorting.
    :vartype postal_code: str
    :ivar country_region: Country/region.
    :vartype country_region: str
    :ivar street_address: Street-level address, excluding city, state, countryRegion, and
     postalCode.
    :vartype street_address: str
    :ivar unit: Apartment or office number.
    :vartype unit: str
    :ivar city_district: Districts or boroughs within a city, such as Brooklyn in New York City or
     City of Westminster in London.
    :vartype city_district: str
    :ivar state_district: Second-level administrative division used in certain locales.
    :vartype state_district: str
    :ivar suburb: Unofficial neighborhood name, like Chinatown.
    :vartype suburb: str
    :ivar house: Build name, such as World Trade Center.
    :vartype house: str
    :ivar level: Floor number, such as 3F.
    :vartype level: str
    """

    _attribute_map = {
        'house_number': {'key': 'houseNumber', 'type': 'str'},
        'po_box': {'key': 'poBox', 'type': 'str'},
        'road': {'key': 'road', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'country_region': {'key': 'countryRegion', 'type': 'str'},
        'street_address': {'key': 'streetAddress', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'city_district': {'key': 'cityDistrict', 'type': 'str'},
        'state_district': {'key': 'stateDistrict', 'type': 'str'},
        'suburb': {'key': 'suburb', 'type': 'str'},
        'house': {'key': 'house', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        house_number: Optional[str] = None,
        po_box: Optional[str] = None,
        road: Optional[str] = None,
        city: Optional[str] = None,
        state: Optional[str] = None,
        postal_code: Optional[str] = None,
        country_region: Optional[str] = None,
        street_address: Optional[str] = None,
        unit: Optional[str] = None,
        city_district: Optional[str] = None,
        state_district: Optional[str] = None,
        suburb: Optional[str] = None,
        house: Optional[str] = None,
        level: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword house_number: House or building number.
        :paramtype house_number: str
        :keyword po_box: Post office box number.
        :paramtype po_box: str
        :keyword road: Street name.
        :paramtype road: str
        :keyword city: Name of city, town, village, etc.
        :paramtype city: str
        :keyword state: First-level administrative division.
        :paramtype state: str
        :keyword postal_code: Postal code used for mail sorting.
        :paramtype postal_code: str
        :keyword country_region: Country/region.
        :paramtype country_region: str
        :keyword street_address: Street-level address, excluding city, state, countryRegion, and
         postalCode.
        :paramtype street_address: str
        :keyword unit: Apartment or office number.
        :paramtype unit: str
        :keyword city_district: Districts or boroughs within a city, such as Brooklyn in New York City
         or City of Westminster in London.
        :paramtype city_district: str
        :keyword state_district: Second-level administrative division used in certain locales.
        :paramtype state_district: str
        :keyword suburb: Unofficial neighborhood name, like Chinatown.
        :paramtype suburb: str
        :keyword house: Build name, such as World Trade Center.
        :paramtype house: str
        :keyword level: Floor number, such as 3F.
        :paramtype level: str
        """
        super(AddressValue, self).__init__(**kwargs)
        self.house_number = house_number
        self.po_box = po_box
        self.road = road
        self.city = city
        self.state = state
        self.postal_code = postal_code
        self.country_region = country_region
        self.street_address = street_address
        self.unit = unit
        self.city_district = city_district
        self.state_district = state_district
        self.suburb = suburb
        self.house = house
        self.level = level


class AnalyzeDocumentRequest(msrest.serialization.Model):
    """Document analysis parameters.

    :ivar url_source: Document URL to analyze.  Either urlSource or base64Source must be specified.
    :vartype url_source: str
    :ivar base64_source: Base64 encoding of the document to analyze.  Either urlSource or
     base64Source must be specified.
    :vartype base64_source: bytearray
    """

    _attribute_map = {
        'url_source': {'key': 'urlSource', 'type': 'str'},
        'base64_source': {'key': 'base64Source', 'type': 'bytearray'},
    }

    def __init__(
        self,
        *,
        url_source: Optional[str] = None,
        base64_source: Optional[bytearray] = None,
        **kwargs
    ):
        """
        :keyword url_source: Document URL to analyze.  Either urlSource or base64Source must be
         specified.
        :paramtype url_source: str
        :keyword base64_source: Base64 encoding of the document to analyze.  Either urlSource or
         base64Source must be specified.
        :paramtype base64_source: bytearray
        """
        super(AnalyzeDocumentRequest, self).__init__(**kwargs)
        self.url_source = url_source
        self.base64_source = base64_source


class AnalyzeResult(msrest.serialization.Model):
    """Document analysis result.

    All required parameters must be populated in order to send to Azure.

    :ivar api_version: Required. API version used to produce this result.
    :vartype api_version: str
    :ivar model_id: Required. Document model ID used to produce this result.
    :vartype model_id: str
    :ivar string_index_type: Required. Method used to compute string offset and length. Known
     values are: "textElements", "unicodeCodePoint", "utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.formrecognizer.v2023_07_31.models.StringIndexType
    :ivar content: Required. Concatenate string representation of all textual and visual elements
     in reading order.
    :vartype content: str
    :ivar pages: Required. Analyzed pages.
    :vartype pages: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentPage]
    :ivar paragraphs: Extracted paragraphs.
    :vartype paragraphs: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentParagraph]
    :ivar tables: Extracted tables.
    :vartype tables: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentTable]
    :ivar key_value_pairs: Extracted key-value pairs.
    :vartype key_value_pairs:
     list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentKeyValuePair]
    :ivar styles: Extracted font styles.
    :vartype styles: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentStyle]
    :ivar languages: Detected languages.
    :vartype languages: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentLanguage]
    :ivar documents: Extracted documents.
    :vartype documents: list[~azure.ai.formrecognizer.v2023_07_31.models.Document]
    """

    _validation = {
        'api_version': {'required': True},
        'model_id': {'required': True, 'pattern': r'^[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}$'},
        'string_index_type': {'required': True},
        'content': {'required': True},
        'pages': {'required': True},
    }

    _attribute_map = {
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'model_id': {'key': 'modelId', 'type': 'str'},
        'string_index_type': {'key': 'stringIndexType', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
        'pages': {'key': 'pages', 'type': '[DocumentPage]'},
        'paragraphs': {'key': 'paragraphs', 'type': '[DocumentParagraph]'},
        'tables': {'key': 'tables', 'type': '[DocumentTable]'},
        'key_value_pairs': {'key': 'keyValuePairs', 'type': '[DocumentKeyValuePair]'},
        'styles': {'key': 'styles', 'type': '[DocumentStyle]'},
        'languages': {'key': 'languages', 'type': '[DocumentLanguage]'},
        'documents': {'key': 'documents', 'type': '[Document]'},
    }

    def __init__(
        self,
        *,
        api_version: str,
        model_id: str,
        string_index_type: Union[str, "_models.StringIndexType"],
        content: str,
        pages: List["_models.DocumentPage"],
        paragraphs: Optional[List["_models.DocumentParagraph"]] = None,
        tables: Optional[List["_models.DocumentTable"]] = None,
        key_value_pairs: Optional[List["_models.DocumentKeyValuePair"]] = None,
        styles: Optional[List["_models.DocumentStyle"]] = None,
        languages: Optional[List["_models.DocumentLanguage"]] = None,
        documents: Optional[List["_models.Document"]] = None,
        **kwargs
    ):
        """
        :keyword api_version: Required. API version used to produce this result.
        :paramtype api_version: str
        :keyword model_id: Required. Document model ID used to produce this result.
        :paramtype model_id: str
        :keyword string_index_type: Required. Method used to compute string offset and length. Known
         values are: "textElements", "unicodeCodePoint", "utf16CodeUnit".
        :paramtype string_index_type: str or
         ~azure.ai.formrecognizer.v2023_07_31.models.StringIndexType
        :keyword content: Required. Concatenate string representation of all textual and visual
         elements in reading order.
        :paramtype content: str
        :keyword pages: Required. Analyzed pages.
        :paramtype pages: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentPage]
        :keyword paragraphs: Extracted paragraphs.
        :paramtype paragraphs: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentParagraph]
        :keyword tables: Extracted tables.
        :paramtype tables: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentTable]
        :keyword key_value_pairs: Extracted key-value pairs.
        :paramtype key_value_pairs:
         list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentKeyValuePair]
        :keyword styles: Extracted font styles.
        :paramtype styles: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentStyle]
        :keyword languages: Detected languages.
        :paramtype languages: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentLanguage]
        :keyword documents: Extracted documents.
        :paramtype documents: list[~azure.ai.formrecognizer.v2023_07_31.models.Document]
        """
        super(AnalyzeResult, self).__init__(**kwargs)
        self.api_version = api_version
        self.model_id = model_id
        self.string_index_type = string_index_type
        self.content = content
        self.pages = pages
        self.paragraphs = paragraphs
        self.tables = tables
        self.key_value_pairs = key_value_pairs
        self.styles = styles
        self.languages = languages
        self.documents = documents


class AnalyzeResultOperation(msrest.serialization.Model):
    """Status and result of the analyze operation.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. Operation status. Known values are: "notStarted", "running", "failed",
     "succeeded".
    :vartype status: str or
     ~azure.ai.formrecognizer.v2023_07_31.models.AnalyzeResultOperationStatus
    :ivar created_date_time: Required. Date and time (UTC) when the analyze operation was
     submitted.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar error: Encountered error during document analysis.
    :vartype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
    :ivar analyze_result: Document analysis result.
    :vartype analyze_result: ~azure.ai.formrecognizer.v2023_07_31.models.AnalyzeResult
    """

    _validation = {
        'status': {'required': True},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'Error'},
        'analyze_result': {'key': 'analyzeResult', 'type': 'AnalyzeResult'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "_models.AnalyzeResultOperationStatus"],
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        error: Optional["_models.Error"] = None,
        analyze_result: Optional["_models.AnalyzeResult"] = None,
        **kwargs
    ):
        """
        :keyword status: Required. Operation status. Known values are: "notStarted", "running",
         "failed", "succeeded".
        :paramtype status: str or
         ~azure.ai.formrecognizer.v2023_07_31.models.AnalyzeResultOperationStatus
        :keyword created_date_time: Required. Date and time (UTC) when the analyze operation was
         submitted.
        :paramtype created_date_time: ~datetime.datetime
        :keyword last_updated_date_time: Required. Date and time (UTC) when the status was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        :keyword error: Encountered error during document analysis.
        :paramtype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
        :keyword analyze_result: Document analysis result.
        :paramtype analyze_result: ~azure.ai.formrecognizer.v2023_07_31.models.AnalyzeResult
        """
        super(AnalyzeResultOperation, self).__init__(**kwargs)
        self.status = status
        self.created_date_time = created_date_time
        self.last_updated_date_time = last_updated_date_time
        self.error = error
        self.analyze_result = analyze_result


class AuthorizeCopyRequest(msrest.serialization.Model):
    """Request body to authorize document model copy.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Unique document model name.
    :vartype model_id: str
    :ivar description: Document model description.
    :vartype description: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the document model.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'^[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}$'},
        'description': {'max_length': 4096, 'min_length': 0},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        description: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword model_id: Required. Unique document model name.
        :paramtype model_id: str
        :keyword description: Document model description.
        :paramtype description: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the document
         model.
        :paramtype tags: dict[str, str]
        """
        super(AuthorizeCopyRequest, self).__init__(**kwargs)
        self.model_id = model_id
        self.description = description
        self.tags = tags


class AzureBlobContentSource(msrest.serialization.Model):
    """Azure Blob Storage content.

    All required parameters must be populated in order to send to Azure.

    :ivar container_url: Required. Azure Blob Storage container URL.
    :vartype container_url: str
    :ivar prefix: Blob name prefix.
    :vartype prefix: str
    """

    _validation = {
        'container_url': {'required': True},
    }

    _attribute_map = {
        'container_url': {'key': 'containerUrl', 'type': 'str'},
        'prefix': {'key': 'prefix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_url: str,
        prefix: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword container_url: Required. Azure Blob Storage container URL.
        :paramtype container_url: str
        :keyword prefix: Blob name prefix.
        :paramtype prefix: str
        """
        super(AzureBlobContentSource, self).__init__(**kwargs)
        self.container_url = container_url
        self.prefix = prefix


class AzureBlobFileListContentSource(msrest.serialization.Model):
    """File list in Azure Blob Storage.

    All required parameters must be populated in order to send to Azure.

    :ivar container_url: Required. Azure Blob Storage container URL.
    :vartype container_url: str
    :ivar file_list: Required. Path to a JSONL file within the container specifying a subset of
     documents for training.
    :vartype file_list: str
    """

    _validation = {
        'container_url': {'required': True},
        'file_list': {'required': True},
    }

    _attribute_map = {
        'container_url': {'key': 'containerUrl', 'type': 'str'},
        'file_list': {'key': 'fileList', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        container_url: str,
        file_list: str,
        **kwargs
    ):
        """
        :keyword container_url: Required. Azure Blob Storage container URL.
        :paramtype container_url: str
        :keyword file_list: Required. Path to a JSONL file within the container specifying a subset of
         documents for training.
        :paramtype file_list: str
        """
        super(AzureBlobFileListContentSource, self).__init__(**kwargs)
        self.container_url = container_url
        self.file_list = file_list


class BoundingRegion(msrest.serialization.Model):
    """Bounding polygon on a specific page of the input.

    All required parameters must be populated in order to send to Azure.

    :ivar page_number: Required. 1-based page number of page containing the bounding region.
    :vartype page_number: int
    :ivar polygon: Required. Bounding polygon on the page, or the entire page if not specified.
    :vartype polygon: list[float]
    """

    _validation = {
        'page_number': {'required': True, 'minimum': 1},
        'polygon': {'required': True},
    }

    _attribute_map = {
        'page_number': {'key': 'pageNumber', 'type': 'int'},
        'polygon': {'key': 'polygon', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        page_number: int,
        polygon: List[float],
        **kwargs
    ):
        """
        :keyword page_number: Required. 1-based page number of page containing the bounding region.
        :paramtype page_number: int
        :keyword polygon: Required. Bounding polygon on the page, or the entire page if not specified.
        :paramtype polygon: list[float]
        """
        super(BoundingRegion, self).__init__(**kwargs)
        self.page_number = page_number
        self.polygon = polygon


class BuildDocumentClassifierRequest(msrest.serialization.Model):
    """Request body to build a new custom document classifier.

    All required parameters must be populated in order to send to Azure.

    :ivar classifier_id: Required. Unique document classifier name.
    :vartype classifier_id: str
    :ivar description: Document classifier description.
    :vartype description: str
    :ivar doc_types: Required. List of document types to classify against.
    :vartype doc_types: dict[str,
     ~azure.ai.formrecognizer.v2023_07_31.models.ClassifierDocumentTypeDetails]
    """

    _validation = {
        'classifier_id': {'required': True, 'pattern': r'^[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}$'},
        'description': {'max_length': 4096, 'min_length': 0},
        'doc_types': {'required': True},
    }

    _attribute_map = {
        'classifier_id': {'key': 'classifierId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'doc_types': {'key': 'docTypes', 'type': '{ClassifierDocumentTypeDetails}'},
    }

    def __init__(
        self,
        *,
        classifier_id: str,
        doc_types: Dict[str, "_models.ClassifierDocumentTypeDetails"],
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword classifier_id: Required. Unique document classifier name.
        :paramtype classifier_id: str
        :keyword description: Document classifier description.
        :paramtype description: str
        :keyword doc_types: Required. List of document types to classify against.
        :paramtype doc_types: dict[str,
         ~azure.ai.formrecognizer.v2023_07_31.models.ClassifierDocumentTypeDetails]
        """
        super(BuildDocumentClassifierRequest, self).__init__(**kwargs)
        self.classifier_id = classifier_id
        self.description = description
        self.doc_types = doc_types


class BuildDocumentModelRequest(msrest.serialization.Model):
    """Request body to build a new custom document model.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Unique document model name.
    :vartype model_id: str
    :ivar description: Document model description.
    :vartype description: str
    :ivar build_mode: Required. Custom document model build mode. Known values are: "template",
     "neural".
    :vartype build_mode: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentBuildMode
    :ivar azure_blob_source: Azure Blob Storage location containing the training data.  Either
     azureBlobSource or azureBlobFileListSource must be specified.
    :vartype azure_blob_source: ~azure.ai.formrecognizer.v2023_07_31.models.AzureBlobContentSource
    :ivar azure_blob_file_list_source: Azure Blob Storage file list specifying the training data.
     Either azureBlobSource or azureBlobFileListSource must be specified.
    :vartype azure_blob_file_list_source:
     ~azure.ai.formrecognizer.v2023_07_31.models.AzureBlobFileListContentSource
    :ivar tags: A set of tags. List of key-value tag attributes associated with the document model.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'^[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}$'},
        'description': {'max_length': 4096, 'min_length': 0},
        'build_mode': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'build_mode': {'key': 'buildMode', 'type': 'str'},
        'azure_blob_source': {'key': 'azureBlobSource', 'type': 'AzureBlobContentSource'},
        'azure_blob_file_list_source': {'key': 'azureBlobFileListSource', 'type': 'AzureBlobFileListContentSource'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        build_mode: Union[str, "_models.DocumentBuildMode"],
        description: Optional[str] = None,
        azure_blob_source: Optional["_models.AzureBlobContentSource"] = None,
        azure_blob_file_list_source: Optional["_models.AzureBlobFileListContentSource"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword model_id: Required. Unique document model name.
        :paramtype model_id: str
        :keyword description: Document model description.
        :paramtype description: str
        :keyword build_mode: Required. Custom document model build mode. Known values are: "template",
         "neural".
        :paramtype build_mode: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentBuildMode
        :keyword azure_blob_source: Azure Blob Storage location containing the training data.  Either
         azureBlobSource or azureBlobFileListSource must be specified.
        :paramtype azure_blob_source:
         ~azure.ai.formrecognizer.v2023_07_31.models.AzureBlobContentSource
        :keyword azure_blob_file_list_source: Azure Blob Storage file list specifying the training
         data.  Either azureBlobSource or azureBlobFileListSource must be specified.
        :paramtype azure_blob_file_list_source:
         ~azure.ai.formrecognizer.v2023_07_31.models.AzureBlobFileListContentSource
        :keyword tags: A set of tags. List of key-value tag attributes associated with the document
         model.
        :paramtype tags: dict[str, str]
        """
        super(BuildDocumentModelRequest, self).__init__(**kwargs)
        self.model_id = model_id
        self.description = description
        self.build_mode = build_mode
        self.azure_blob_source = azure_blob_source
        self.azure_blob_file_list_source = azure_blob_file_list_source
        self.tags = tags


class ClassifierDocumentTypeDetails(msrest.serialization.Model):
    """Classifier document type info.

    :ivar azure_blob_source: Azure Blob Storage location containing the training data for a
     classifier document type.  Either azureBlobSource or azureBlobFileListSource must be specified.
    :vartype azure_blob_source: ~azure.ai.formrecognizer.v2023_07_31.models.AzureBlobContentSource
    :ivar azure_blob_file_list_source: Azure Blob Storage file list specifying the training data
     for a classifier document type.  Either azureBlobSource or azureBlobFileListSource must be
     specified.
    :vartype azure_blob_file_list_source:
     ~azure.ai.formrecognizer.v2023_07_31.models.AzureBlobFileListContentSource
    """

    _attribute_map = {
        'azure_blob_source': {'key': 'azureBlobSource', 'type': 'AzureBlobContentSource'},
        'azure_blob_file_list_source': {'key': 'azureBlobFileListSource', 'type': 'AzureBlobFileListContentSource'},
    }

    def __init__(
        self,
        *,
        azure_blob_source: Optional["_models.AzureBlobContentSource"] = None,
        azure_blob_file_list_source: Optional["_models.AzureBlobFileListContentSource"] = None,
        **kwargs
    ):
        """
        :keyword azure_blob_source: Azure Blob Storage location containing the training data for a
         classifier document type.  Either azureBlobSource or azureBlobFileListSource must be specified.
        :paramtype azure_blob_source:
         ~azure.ai.formrecognizer.v2023_07_31.models.AzureBlobContentSource
        :keyword azure_blob_file_list_source: Azure Blob Storage file list specifying the training data
         for a classifier document type.  Either azureBlobSource or azureBlobFileListSource must be
         specified.
        :paramtype azure_blob_file_list_source:
         ~azure.ai.formrecognizer.v2023_07_31.models.AzureBlobFileListContentSource
        """
        super(ClassifierDocumentTypeDetails, self).__init__(**kwargs)
        self.azure_blob_source = azure_blob_source
        self.azure_blob_file_list_source = azure_blob_file_list_source


class ClassifyDocumentRequest(msrest.serialization.Model):
    """Document classification parameters.

    :ivar url_source: Document URL to classify.  Either urlSource or base64Source must be
     specified.
    :vartype url_source: str
    :ivar base64_source: Base64 encoding of the document to classify.  Either urlSource or
     base64Source must be specified.
    :vartype base64_source: bytearray
    """

    _attribute_map = {
        'url_source': {'key': 'urlSource', 'type': 'str'},
        'base64_source': {'key': 'base64Source', 'type': 'bytearray'},
    }

    def __init__(
        self,
        *,
        url_source: Optional[str] = None,
        base64_source: Optional[bytearray] = None,
        **kwargs
    ):
        """
        :keyword url_source: Document URL to classify.  Either urlSource or base64Source must be
         specified.
        :paramtype url_source: str
        :keyword base64_source: Base64 encoding of the document to classify.  Either urlSource or
         base64Source must be specified.
        :paramtype base64_source: bytearray
        """
        super(ClassifyDocumentRequest, self).__init__(**kwargs)
        self.url_source = url_source
        self.base64_source = base64_source


class ComponentDocumentModelDetails(msrest.serialization.Model):
    """A component of a composed document model.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Unique document model name.
    :vartype model_id: str
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'^[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}$'},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        **kwargs
    ):
        """
        :keyword model_id: Required. Unique document model name.
        :paramtype model_id: str
        """
        super(ComponentDocumentModelDetails, self).__init__(**kwargs)
        self.model_id = model_id


class ComposeDocumentModelRequest(msrest.serialization.Model):
    """Request body to create a composed document model from component document models.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Unique document model name.
    :vartype model_id: str
    :ivar description: Document model description.
    :vartype description: str
    :ivar component_models: Required. List of component document models to compose.
    :vartype component_models:
     list[~azure.ai.formrecognizer.v2023_07_31.models.ComponentDocumentModelDetails]
    :ivar tags: A set of tags. List of key-value tag attributes associated with the document model.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'^[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}$'},
        'description': {'max_length': 4096, 'min_length': 0},
        'component_models': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'component_models': {'key': 'componentModels', 'type': '[ComponentDocumentModelDetails]'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        component_models: List["_models.ComponentDocumentModelDetails"],
        description: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword model_id: Required. Unique document model name.
        :paramtype model_id: str
        :keyword description: Document model description.
        :paramtype description: str
        :keyword component_models: Required. List of component document models to compose.
        :paramtype component_models:
         list[~azure.ai.formrecognizer.v2023_07_31.models.ComponentDocumentModelDetails]
        :keyword tags: A set of tags. List of key-value tag attributes associated with the document
         model.
        :paramtype tags: dict[str, str]
        """
        super(ComposeDocumentModelRequest, self).__init__(**kwargs)
        self.model_id = model_id
        self.description = description
        self.component_models = component_models
        self.tags = tags


class CopyAuthorization(msrest.serialization.Model):
    """Authorization to copy a document model to the specified target resource and modelId.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: Required. ID of the target Azure resource where the document model
     should be copied to.
    :vartype target_resource_id: str
    :ivar target_resource_region: Required. Location of the target Azure resource where the
     document model should be copied to.
    :vartype target_resource_region: str
    :ivar target_model_id: Required. Identifier of the target document model.
    :vartype target_model_id: str
    :ivar target_model_location: Required. URL of the copied document model in the target account.
    :vartype target_model_location: str
    :ivar access_token: Required. Token used to authorize the request.
    :vartype access_token: str
    :ivar expiration_date_time: Required. Date/time when the access token expires.
    :vartype expiration_date_time: ~datetime.datetime
    """

    _validation = {
        'target_resource_id': {'required': True},
        'target_resource_region': {'required': True},
        'target_model_id': {'required': True, 'pattern': r'^[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}$'},
        'target_model_location': {'required': True},
        'access_token': {'required': True},
        'expiration_date_time': {'required': True},
    }

    _attribute_map = {
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'target_resource_region': {'key': 'targetResourceRegion', 'type': 'str'},
        'target_model_id': {'key': 'targetModelId', 'type': 'str'},
        'target_model_location': {'key': 'targetModelLocation', 'type': 'str'},
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        target_resource_region: str,
        target_model_id: str,
        target_model_location: str,
        access_token: str,
        expiration_date_time: datetime.datetime,
        **kwargs
    ):
        """
        :keyword target_resource_id: Required. ID of the target Azure resource where the document model
         should be copied to.
        :paramtype target_resource_id: str
        :keyword target_resource_region: Required. Location of the target Azure resource where the
         document model should be copied to.
        :paramtype target_resource_region: str
        :keyword target_model_id: Required. Identifier of the target document model.
        :paramtype target_model_id: str
        :keyword target_model_location: Required. URL of the copied document model in the target
         account.
        :paramtype target_model_location: str
        :keyword access_token: Required. Token used to authorize the request.
        :paramtype access_token: str
        :keyword expiration_date_time: Required. Date/time when the access token expires.
        :paramtype expiration_date_time: ~datetime.datetime
        """
        super(CopyAuthorization, self).__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.target_resource_region = target_resource_region
        self.target_model_id = target_model_id
        self.target_model_location = target_model_location
        self.access_token = access_token
        self.expiration_date_time = expiration_date_time


class CurrencyValue(msrest.serialization.Model):
    """Currency field value.

    All required parameters must be populated in order to send to Azure.

    :ivar amount: Required. Currency amount.
    :vartype amount: float
    :ivar currency_symbol: Currency symbol label, if any.
    :vartype currency_symbol: str
    :ivar currency_code: Resolved currency code (ISO 4217), if any.
    :vartype currency_code: str
    """

    _validation = {
        'amount': {'required': True},
    }

    _attribute_map = {
        'amount': {'key': 'amount', 'type': 'float'},
        'currency_symbol': {'key': 'currencySymbol', 'type': 'str'},
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        amount: float,
        currency_symbol: Optional[str] = None,
        currency_code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword amount: Required. Currency amount.
        :paramtype amount: float
        :keyword currency_symbol: Currency symbol label, if any.
        :paramtype currency_symbol: str
        :keyword currency_code: Resolved currency code (ISO 4217), if any.
        :paramtype currency_code: str
        """
        super(CurrencyValue, self).__init__(**kwargs)
        self.amount = amount
        self.currency_symbol = currency_symbol
        self.currency_code = currency_code


class CustomDocumentModelsDetails(msrest.serialization.Model):
    """Details regarding custom document models.

    All required parameters must be populated in order to send to Azure.

    :ivar count: Required. Number of custom document models in the current resource.
    :vartype count: int
    :ivar limit: Required. Maximum number of custom document models supported in the current
     resource.
    :vartype limit: int
    """

    _validation = {
        'count': {'required': True},
        'limit': {'required': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        count: int,
        limit: int,
        **kwargs
    ):
        """
        :keyword count: Required. Number of custom document models in the current resource.
        :paramtype count: int
        :keyword limit: Required. Maximum number of custom document models supported in the current
         resource.
        :paramtype limit: int
        """
        super(CustomDocumentModelsDetails, self).__init__(**kwargs)
        self.count = count
        self.limit = limit


class Document(msrest.serialization.Model):
    """An object describing the location and semantic content of a document.

    All required parameters must be populated in order to send to Azure.

    :ivar doc_type: Required. Document type.
    :vartype doc_type: str
    :ivar bounding_regions: Bounding regions covering the document.
    :vartype bounding_regions: list[~azure.ai.formrecognizer.v2023_07_31.models.BoundingRegion]
    :ivar spans: Required. Location of the document in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
    :ivar fields: Dictionary of named field values.
    :vartype fields: dict[str, ~azure.ai.formrecognizer.v2023_07_31.models.DocumentField]
    :ivar confidence: Required. Confidence of correctly extracting the document.
    :vartype confidence: float
    """

    _validation = {
        'doc_type': {'required': True, 'max_length': 64, 'min_length': 2},
        'spans': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'doc_type': {'key': 'docType', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'fields': {'key': 'fields', 'type': '{DocumentField}'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        doc_type: str,
        spans: List["_models.DocumentSpan"],
        confidence: float,
        bounding_regions: Optional[List["_models.BoundingRegion"]] = None,
        fields: Optional[Dict[str, "_models.DocumentField"]] = None,
        **kwargs
    ):
        """
        :keyword doc_type: Required. Document type.
        :paramtype doc_type: str
        :keyword bounding_regions: Bounding regions covering the document.
        :paramtype bounding_regions: list[~azure.ai.formrecognizer.v2023_07_31.models.BoundingRegion]
        :keyword spans: Required. Location of the document in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
        :keyword fields: Dictionary of named field values.
        :paramtype fields: dict[str, ~azure.ai.formrecognizer.v2023_07_31.models.DocumentField]
        :keyword confidence: Required. Confidence of correctly extracting the document.
        :paramtype confidence: float
        """
        super(Document, self).__init__(**kwargs)
        self.doc_type = doc_type
        self.bounding_regions = bounding_regions
        self.spans = spans
        self.fields = fields
        self.confidence = confidence


class DocumentBarcode(msrest.serialization.Model):
    """A barcode object.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Barcode kind. Known values are: "QRCode", "PDF417", "UPCA", "UPCE",
     "Code39", "Code128", "EAN8", "EAN13", "DataBar", "Code93", "Codabar", "DataBarExpanded", "ITF",
     "MicroQRCode", "Aztec", "DataMatrix", "MaxiCode".
    :vartype kind: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentBarcodeKind
    :ivar value: Required. Barcode value.
    :vartype value: str
    :ivar polygon: Bounding polygon of the barcode.
    :vartype polygon: list[float]
    :ivar span: Required. Location of the barcode in the reading order concatenated content.
    :vartype span: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan
    :ivar confidence: Required. Confidence of correctly extracting the barcode.
    :vartype confidence: float
    """

    _validation = {
        'kind': {'required': True},
        'value': {'required': True},
        'span': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'polygon': {'key': 'polygon', 'type': '[float]'},
        'span': {'key': 'span', 'type': 'DocumentSpan'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        kind: Union[str, "_models.DocumentBarcodeKind"],
        value: str,
        span: "_models.DocumentSpan",
        confidence: float,
        polygon: Optional[List[float]] = None,
        **kwargs
    ):
        """
        :keyword kind: Required. Barcode kind. Known values are: "QRCode", "PDF417", "UPCA", "UPCE",
         "Code39", "Code128", "EAN8", "EAN13", "DataBar", "Code93", "Codabar", "DataBarExpanded", "ITF",
         "MicroQRCode", "Aztec", "DataMatrix", "MaxiCode".
        :paramtype kind: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentBarcodeKind
        :keyword value: Required. Barcode value.
        :paramtype value: str
        :keyword polygon: Bounding polygon of the barcode.
        :paramtype polygon: list[float]
        :keyword span: Required. Location of the barcode in the reading order concatenated content.
        :paramtype span: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan
        :keyword confidence: Required. Confidence of correctly extracting the barcode.
        :paramtype confidence: float
        """
        super(DocumentBarcode, self).__init__(**kwargs)
        self.kind = kind
        self.value = value
        self.polygon = polygon
        self.span = span
        self.confidence = confidence


class OperationDetails(msrest.serialization.Model):
    """Get Operation response object.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DocumentClassifierBuildOperationDetails, DocumentModelBuildOperationDetails, DocumentModelComposeOperationDetails, DocumentModelCopyToOperationDetails.

    All required parameters must be populated in order to send to Azure.

    :ivar operation_id: Required. Operation ID.
    :vartype operation_id: str
    :ivar status: Required. Operation status. Known values are: "notStarted", "running", "failed",
     "succeeded", "canceled".
    :vartype status: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationStatus
    :ivar percent_completed: Operation progress (0-100).
    :vartype percent_completed: int
    :ivar created_date_time: Required. Date and time (UTC) when the operation was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar kind: Required. Type of operation.Constant filled by server.
    :vartype kind: str
    :ivar resource_location: Required. URL of the resource targeted by this operation.
    :vartype resource_location: str
    :ivar api_version: API version used to create this operation.
    :vartype api_version: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the document model.
    :vartype tags: dict[str, str]
    :ivar error: Encountered error.
    :vartype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
    """

    _validation = {
        'operation_id': {'required': True},
        'status': {'required': True},
        'percent_completed': {'maximum': 100, 'minimum': 0},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
        'kind': {'required': True},
        'resource_location': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'percent_completed': {'key': 'percentCompleted', 'type': 'int'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'kind': {'key': 'kind', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'error': {'key': 'error', 'type': 'Error'},
    }

    _subtype_map = {
        'kind': {'documentClassifierBuild': 'DocumentClassifierBuildOperationDetails', 'documentModelBuild': 'DocumentModelBuildOperationDetails', 'documentModelCompose': 'DocumentModelComposeOperationDetails', 'documentModelCopyTo': 'DocumentModelCopyToOperationDetails'}
    }

    def __init__(
        self,
        *,
        operation_id: str,
        status: Union[str, "_models.OperationStatus"],
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        resource_location: str,
        percent_completed: Optional[int] = None,
        api_version: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        error: Optional["_models.Error"] = None,
        **kwargs
    ):
        """
        :keyword operation_id: Required. Operation ID.
        :paramtype operation_id: str
        :keyword status: Required. Operation status. Known values are: "notStarted", "running",
         "failed", "succeeded", "canceled".
        :paramtype status: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationStatus
        :keyword percent_completed: Operation progress (0-100).
        :paramtype percent_completed: int
        :keyword created_date_time: Required. Date and time (UTC) when the operation was created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword last_updated_date_time: Required. Date and time (UTC) when the status was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        :keyword resource_location: Required. URL of the resource targeted by this operation.
        :paramtype resource_location: str
        :keyword api_version: API version used to create this operation.
        :paramtype api_version: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the document
         model.
        :paramtype tags: dict[str, str]
        :keyword error: Encountered error.
        :paramtype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
        """
        super(OperationDetails, self).__init__(**kwargs)
        self.operation_id = operation_id
        self.status = status
        self.percent_completed = percent_completed
        self.created_date_time = created_date_time
        self.last_updated_date_time = last_updated_date_time
        self.kind = None  # type: Optional[str]
        self.resource_location = resource_location
        self.api_version = api_version
        self.tags = tags
        self.error = error


class DocumentClassifierBuildOperationDetails(OperationDetails):
    """Get Operation response object.

    All required parameters must be populated in order to send to Azure.

    :ivar operation_id: Required. Operation ID.
    :vartype operation_id: str
    :ivar status: Required. Operation status. Known values are: "notStarted", "running", "failed",
     "succeeded", "canceled".
    :vartype status: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationStatus
    :ivar percent_completed: Operation progress (0-100).
    :vartype percent_completed: int
    :ivar created_date_time: Required. Date and time (UTC) when the operation was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar kind: Required. Type of operation.Constant filled by server.
    :vartype kind: str
    :ivar resource_location: Required. URL of the resource targeted by this operation.
    :vartype resource_location: str
    :ivar api_version: API version used to create this operation.
    :vartype api_version: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the document model.
    :vartype tags: dict[str, str]
    :ivar error: Encountered error.
    :vartype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
    :ivar result: Operation result upon success.
    :vartype result: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentClassifierDetails
    """

    _validation = {
        'operation_id': {'required': True},
        'status': {'required': True},
        'percent_completed': {'maximum': 100, 'minimum': 0},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
        'kind': {'required': True},
        'resource_location': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'percent_completed': {'key': 'percentCompleted', 'type': 'int'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'kind': {'key': 'kind', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'error': {'key': 'error', 'type': 'Error'},
        'result': {'key': 'result', 'type': 'DocumentClassifierDetails'},
    }

    def __init__(
        self,
        *,
        operation_id: str,
        status: Union[str, "_models.OperationStatus"],
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        resource_location: str,
        percent_completed: Optional[int] = None,
        api_version: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        error: Optional["_models.Error"] = None,
        result: Optional["_models.DocumentClassifierDetails"] = None,
        **kwargs
    ):
        """
        :keyword operation_id: Required. Operation ID.
        :paramtype operation_id: str
        :keyword status: Required. Operation status. Known values are: "notStarted", "running",
         "failed", "succeeded", "canceled".
        :paramtype status: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationStatus
        :keyword percent_completed: Operation progress (0-100).
        :paramtype percent_completed: int
        :keyword created_date_time: Required. Date and time (UTC) when the operation was created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword last_updated_date_time: Required. Date and time (UTC) when the status was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        :keyword resource_location: Required. URL of the resource targeted by this operation.
        :paramtype resource_location: str
        :keyword api_version: API version used to create this operation.
        :paramtype api_version: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the document
         model.
        :paramtype tags: dict[str, str]
        :keyword error: Encountered error.
        :paramtype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
        :keyword result: Operation result upon success.
        :paramtype result: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentClassifierDetails
        """
        super(DocumentClassifierBuildOperationDetails, self).__init__(operation_id=operation_id, status=status, percent_completed=percent_completed, created_date_time=created_date_time, last_updated_date_time=last_updated_date_time, resource_location=resource_location, api_version=api_version, tags=tags, error=error, **kwargs)
        self.kind = 'documentClassifierBuild'  # type: str
        self.result = result


class DocumentClassifierDetails(msrest.serialization.Model):
    """Document classifier info.

    All required parameters must be populated in order to send to Azure.

    :ivar classifier_id: Required. Unique document classifier name.
    :vartype classifier_id: str
    :ivar description: Document classifier description.
    :vartype description: str
    :ivar created_date_time: Required. Date and time (UTC) when the document classifier was
     created.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time: Date and time (UTC) when the document classifier will expire.
    :vartype expiration_date_time: ~datetime.datetime
    :ivar api_version: Required. API version used to create this document classifier.
    :vartype api_version: str
    :ivar doc_types: Required. List of document types to classify against.
    :vartype doc_types: dict[str,
     ~azure.ai.formrecognizer.v2023_07_31.models.ClassifierDocumentTypeDetails]
    """

    _validation = {
        'classifier_id': {'required': True, 'pattern': r'^[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}$'},
        'description': {'max_length': 4096, 'min_length': 0},
        'created_date_time': {'required': True},
        'api_version': {'required': True},
        'doc_types': {'required': True},
    }

    _attribute_map = {
        'classifier_id': {'key': 'classifierId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'doc_types': {'key': 'docTypes', 'type': '{ClassifierDocumentTypeDetails}'},
    }

    def __init__(
        self,
        *,
        classifier_id: str,
        created_date_time: datetime.datetime,
        api_version: str,
        doc_types: Dict[str, "_models.ClassifierDocumentTypeDetails"],
        description: Optional[str] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword classifier_id: Required. Unique document classifier name.
        :paramtype classifier_id: str
        :keyword description: Document classifier description.
        :paramtype description: str
        :keyword created_date_time: Required. Date and time (UTC) when the document classifier was
         created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time: Date and time (UTC) when the document classifier will expire.
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword api_version: Required. API version used to create this document classifier.
        :paramtype api_version: str
        :keyword doc_types: Required. List of document types to classify against.
        :paramtype doc_types: dict[str,
         ~azure.ai.formrecognizer.v2023_07_31.models.ClassifierDocumentTypeDetails]
        """
        super(DocumentClassifierDetails, self).__init__(**kwargs)
        self.classifier_id = classifier_id
        self.description = description
        self.created_date_time = created_date_time
        self.expiration_date_time = expiration_date_time
        self.api_version = api_version
        self.doc_types = doc_types


class DocumentField(msrest.serialization.Model):
    """An object representing the content and location of a field value.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Data type of the field value. Known values are: "string", "date", "time",
     "phoneNumber", "number", "integer", "selectionMark", "countryRegion", "signature", "array",
     "object", "currency", "address", "boolean".
    :vartype type: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentFieldType
    :ivar value_string: String value.
    :vartype value_string: str
    :ivar value_date: Date value in YYYY-MM-DD format (ISO 8601).
    :vartype value_date: ~datetime.date
    :ivar value_time: Time value in hh:mm:ss format (ISO 8601).
    :vartype value_time: ~datetime.time
    :ivar value_phone_number: Phone number value in E.164 format (ex. +19876543210).
    :vartype value_phone_number: str
    :ivar value_number: Floating point value.
    :vartype value_number: float
    :ivar value_integer: Integer value.
    :vartype value_integer: long
    :ivar value_selection_mark: Selection mark value. Known values are: "selected", "unselected".
    :vartype value_selection_mark: str or
     ~azure.ai.formrecognizer.v2023_07_31.models.SelectionMarkState
    :ivar value_signature: Presence of signature. Known values are: "signed", "unsigned".
    :vartype value_signature: str or
     ~azure.ai.formrecognizer.v2023_07_31.models.DocumentSignatureType
    :ivar value_country_region: 3-letter country code value (ISO 3166-1 alpha-3).
    :vartype value_country_region: str
    :ivar value_array: Array of field values.
    :vartype value_array: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentField]
    :ivar value_object: Dictionary of named field values.
    :vartype value_object: dict[str, ~azure.ai.formrecognizer.v2023_07_31.models.DocumentField]
    :ivar value_currency: Currency value.
    :vartype value_currency: ~azure.ai.formrecognizer.v2023_07_31.models.CurrencyValue
    :ivar value_address: Address value.
    :vartype value_address: ~azure.ai.formrecognizer.v2023_07_31.models.AddressValue
    :ivar value_boolean: Boolean value.
    :vartype value_boolean: bool
    :ivar content: Field content.
    :vartype content: str
    :ivar bounding_regions: Bounding regions covering the field.
    :vartype bounding_regions: list[~azure.ai.formrecognizer.v2023_07_31.models.BoundingRegion]
    :ivar spans: Location of the field in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
    :ivar confidence: Confidence of correctly extracting the field.
    :vartype confidence: float
    """

    _validation = {
        'type': {'required': True},
        'confidence': {'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value_string': {'key': 'valueString', 'type': 'str'},
        'value_date': {'key': 'valueDate', 'type': 'date'},
        'value_time': {'key': 'valueTime', 'type': 'time'},
        'value_phone_number': {'key': 'valuePhoneNumber', 'type': 'str'},
        'value_number': {'key': 'valueNumber', 'type': 'float'},
        'value_integer': {'key': 'valueInteger', 'type': 'long'},
        'value_selection_mark': {'key': 'valueSelectionMark', 'type': 'str'},
        'value_signature': {'key': 'valueSignature', 'type': 'str'},
        'value_country_region': {'key': 'valueCountryRegion', 'type': 'str'},
        'value_array': {'key': 'valueArray', 'type': '[DocumentField]'},
        'value_object': {'key': 'valueObject', 'type': '{DocumentField}'},
        'value_currency': {'key': 'valueCurrency', 'type': 'CurrencyValue'},
        'value_address': {'key': 'valueAddress', 'type': 'AddressValue'},
        'value_boolean': {'key': 'valueBoolean', 'type': 'bool'},
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.DocumentFieldType"],
        value_string: Optional[str] = None,
        value_date: Optional[datetime.date] = None,
        value_time: Optional[datetime.time] = None,
        value_phone_number: Optional[str] = None,
        value_number: Optional[float] = None,
        value_integer: Optional[int] = None,
        value_selection_mark: Optional[Union[str, "_models.SelectionMarkState"]] = None,
        value_signature: Optional[Union[str, "_models.DocumentSignatureType"]] = None,
        value_country_region: Optional[str] = None,
        value_array: Optional[List["_models.DocumentField"]] = None,
        value_object: Optional[Dict[str, "_models.DocumentField"]] = None,
        value_currency: Optional["_models.CurrencyValue"] = None,
        value_address: Optional["_models.AddressValue"] = None,
        value_boolean: Optional[bool] = None,
        content: Optional[str] = None,
        bounding_regions: Optional[List["_models.BoundingRegion"]] = None,
        spans: Optional[List["_models.DocumentSpan"]] = None,
        confidence: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword type: Required. Data type of the field value. Known values are: "string", "date",
         "time", "phoneNumber", "number", "integer", "selectionMark", "countryRegion", "signature",
         "array", "object", "currency", "address", "boolean".
        :paramtype type: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentFieldType
        :keyword value_string: String value.
        :paramtype value_string: str
        :keyword value_date: Date value in YYYY-MM-DD format (ISO 8601).
        :paramtype value_date: ~datetime.date
        :keyword value_time: Time value in hh:mm:ss format (ISO 8601).
        :paramtype value_time: ~datetime.time
        :keyword value_phone_number: Phone number value in E.164 format (ex. +19876543210).
        :paramtype value_phone_number: str
        :keyword value_number: Floating point value.
        :paramtype value_number: float
        :keyword value_integer: Integer value.
        :paramtype value_integer: long
        :keyword value_selection_mark: Selection mark value. Known values are: "selected",
         "unselected".
        :paramtype value_selection_mark: str or
         ~azure.ai.formrecognizer.v2023_07_31.models.SelectionMarkState
        :keyword value_signature: Presence of signature. Known values are: "signed", "unsigned".
        :paramtype value_signature: str or
         ~azure.ai.formrecognizer.v2023_07_31.models.DocumentSignatureType
        :keyword value_country_region: 3-letter country code value (ISO 3166-1 alpha-3).
        :paramtype value_country_region: str
        :keyword value_array: Array of field values.
        :paramtype value_array: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentField]
        :keyword value_object: Dictionary of named field values.
        :paramtype value_object: dict[str, ~azure.ai.formrecognizer.v2023_07_31.models.DocumentField]
        :keyword value_currency: Currency value.
        :paramtype value_currency: ~azure.ai.formrecognizer.v2023_07_31.models.CurrencyValue
        :keyword value_address: Address value.
        :paramtype value_address: ~azure.ai.formrecognizer.v2023_07_31.models.AddressValue
        :keyword value_boolean: Boolean value.
        :paramtype value_boolean: bool
        :keyword content: Field content.
        :paramtype content: str
        :keyword bounding_regions: Bounding regions covering the field.
        :paramtype bounding_regions: list[~azure.ai.formrecognizer.v2023_07_31.models.BoundingRegion]
        :keyword spans: Location of the field in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
        :keyword confidence: Confidence of correctly extracting the field.
        :paramtype confidence: float
        """
        super(DocumentField, self).__init__(**kwargs)
        self.type = type
        self.value_string = value_string
        self.value_date = value_date
        self.value_time = value_time
        self.value_phone_number = value_phone_number
        self.value_number = value_number
        self.value_integer = value_integer
        self.value_selection_mark = value_selection_mark
        self.value_signature = value_signature
        self.value_country_region = value_country_region
        self.value_array = value_array
        self.value_object = value_object
        self.value_currency = value_currency
        self.value_address = value_address
        self.value_boolean = value_boolean
        self.content = content
        self.bounding_regions = bounding_regions
        self.spans = spans
        self.confidence = confidence


class DocumentFieldSchema(msrest.serialization.Model):
    """Description of the field semantic schema using a JSON Schema style syntax.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Semantic data type of the field value. Known values are: "string",
     "date", "time", "phoneNumber", "number", "integer", "selectionMark", "countryRegion",
     "signature", "array", "object", "currency", "address", "boolean".
    :vartype type: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentFieldType
    :ivar description: Field description.
    :vartype description: str
    :ivar example: Example field content.
    :vartype example: str
    :ivar items: Field type schema of each array element.
    :vartype items: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentFieldSchema
    :ivar properties: Named sub-fields of the object field.
    :vartype properties: dict[str, ~azure.ai.formrecognizer.v2023_07_31.models.DocumentFieldSchema]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'example': {'key': 'example', 'type': 'str'},
        'items': {'key': 'items', 'type': 'DocumentFieldSchema'},
        'properties': {'key': 'properties', 'type': '{DocumentFieldSchema}'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.DocumentFieldType"],
        description: Optional[str] = None,
        example: Optional[str] = None,
        items: Optional["_models.DocumentFieldSchema"] = None,
        properties: Optional[Dict[str, "_models.DocumentFieldSchema"]] = None,
        **kwargs
    ):
        """
        :keyword type: Required. Semantic data type of the field value. Known values are: "string",
         "date", "time", "phoneNumber", "number", "integer", "selectionMark", "countryRegion",
         "signature", "array", "object", "currency", "address", "boolean".
        :paramtype type: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentFieldType
        :keyword description: Field description.
        :paramtype description: str
        :keyword example: Example field content.
        :paramtype example: str
        :keyword items: Field type schema of each array element.
        :paramtype items: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentFieldSchema
        :keyword properties: Named sub-fields of the object field.
        :paramtype properties: dict[str,
         ~azure.ai.formrecognizer.v2023_07_31.models.DocumentFieldSchema]
        """
        super(DocumentFieldSchema, self).__init__(**kwargs)
        self.type = type
        self.description = description
        self.example = example
        self.items = items
        self.properties = properties


class DocumentFormula(msrest.serialization.Model):
    """A formula object.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Required. Formula kind. Known values are: "inline", "display".
    :vartype kind: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentFormulaKind
    :ivar value: Required. LaTex expression describing the formula.
    :vartype value: str
    :ivar polygon: Bounding polygon of the formula.
    :vartype polygon: list[float]
    :ivar span: Required. Location of the formula in the reading order concatenated content.
    :vartype span: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan
    :ivar confidence: Required. Confidence of correctly extracting the formula.
    :vartype confidence: float
    """

    _validation = {
        'kind': {'required': True},
        'value': {'required': True},
        'span': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'polygon': {'key': 'polygon', 'type': '[float]'},
        'span': {'key': 'span', 'type': 'DocumentSpan'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        kind: Union[str, "_models.DocumentFormulaKind"],
        value: str,
        span: "_models.DocumentSpan",
        confidence: float,
        polygon: Optional[List[float]] = None,
        **kwargs
    ):
        """
        :keyword kind: Required. Formula kind. Known values are: "inline", "display".
        :paramtype kind: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentFormulaKind
        :keyword value: Required. LaTex expression describing the formula.
        :paramtype value: str
        :keyword polygon: Bounding polygon of the formula.
        :paramtype polygon: list[float]
        :keyword span: Required. Location of the formula in the reading order concatenated content.
        :paramtype span: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan
        :keyword confidence: Required. Confidence of correctly extracting the formula.
        :paramtype confidence: float
        """
        super(DocumentFormula, self).__init__(**kwargs)
        self.kind = kind
        self.value = value
        self.polygon = polygon
        self.span = span
        self.confidence = confidence


class DocumentKeyValueElement(msrest.serialization.Model):
    """An object representing the field key or value in a key-value pair.

    All required parameters must be populated in order to send to Azure.

    :ivar content: Required. Concatenated content of the key-value element in reading order.
    :vartype content: str
    :ivar bounding_regions: Bounding regions covering the key-value element.
    :vartype bounding_regions: list[~azure.ai.formrecognizer.v2023_07_31.models.BoundingRegion]
    :ivar spans: Required. Location of the key-value element in the reading order concatenated
     content.
    :vartype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
    """

    _validation = {
        'content': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        *,
        content: str,
        spans: List["_models.DocumentSpan"],
        bounding_regions: Optional[List["_models.BoundingRegion"]] = None,
        **kwargs
    ):
        """
        :keyword content: Required. Concatenated content of the key-value element in reading order.
        :paramtype content: str
        :keyword bounding_regions: Bounding regions covering the key-value element.
        :paramtype bounding_regions: list[~azure.ai.formrecognizer.v2023_07_31.models.BoundingRegion]
        :keyword spans: Required. Location of the key-value element in the reading order concatenated
         content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
        """
        super(DocumentKeyValueElement, self).__init__(**kwargs)
        self.content = content
        self.bounding_regions = bounding_regions
        self.spans = spans


class DocumentKeyValuePair(msrest.serialization.Model):
    """An object representing a form field with distinct field label (key) and field value (may be empty).

    All required parameters must be populated in order to send to Azure.

    :ivar key: Required. Field label of the key-value pair.
    :vartype key: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentKeyValueElement
    :ivar value: Field value of the key-value pair.
    :vartype value: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentKeyValueElement
    :ivar confidence: Required. Confidence of correctly extracting the key-value pair.
    :vartype confidence: float
    """

    _validation = {
        'key': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'DocumentKeyValueElement'},
        'value': {'key': 'value', 'type': 'DocumentKeyValueElement'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        key: "_models.DocumentKeyValueElement",
        confidence: float,
        value: Optional["_models.DocumentKeyValueElement"] = None,
        **kwargs
    ):
        """
        :keyword key: Required. Field label of the key-value pair.
        :paramtype key: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentKeyValueElement
        :keyword value: Field value of the key-value pair.
        :paramtype value: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentKeyValueElement
        :keyword confidence: Required. Confidence of correctly extracting the key-value pair.
        :paramtype confidence: float
        """
        super(DocumentKeyValuePair, self).__init__(**kwargs)
        self.key = key
        self.value = value
        self.confidence = confidence


class DocumentLanguage(msrest.serialization.Model):
    """An object representing the detected language for a given text span.

    All required parameters must be populated in order to send to Azure.

    :ivar locale: Required. Detected language.  Value may an ISO 639-1 language code (ex. "en",
     "fr") or BCP 47 language tag (ex. "zh-Hans").
    :vartype locale: str
    :ivar spans: Required. Location of the text elements in the concatenated content the language
     applies to.
    :vartype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
    :ivar confidence: Required. Confidence of correctly identifying the language.
    :vartype confidence: float
    """

    _validation = {
        'locale': {'required': True},
        'spans': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'locale': {'key': 'locale', 'type': 'str'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        locale: str,
        spans: List["_models.DocumentSpan"],
        confidence: float,
        **kwargs
    ):
        """
        :keyword locale: Required. Detected language.  Value may an ISO 639-1 language code (ex. "en",
         "fr") or BCP 47 language tag (ex. "zh-Hans").
        :paramtype locale: str
        :keyword spans: Required. Location of the text elements in the concatenated content the
         language applies to.
        :paramtype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
        :keyword confidence: Required. Confidence of correctly identifying the language.
        :paramtype confidence: float
        """
        super(DocumentLanguage, self).__init__(**kwargs)
        self.locale = locale
        self.spans = spans
        self.confidence = confidence


class DocumentLine(msrest.serialization.Model):
    """A content line object consisting of an adjacent sequence of content elements, such as words and selection marks.

    All required parameters must be populated in order to send to Azure.

    :ivar content: Required. Concatenated content of the contained elements in reading order.
    :vartype content: str
    :ivar polygon: Bounding polygon of the line.
    :vartype polygon: list[float]
    :ivar spans: Required. Location of the line in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
    """

    _validation = {
        'content': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'polygon': {'key': 'polygon', 'type': '[float]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        *,
        content: str,
        spans: List["_models.DocumentSpan"],
        polygon: Optional[List[float]] = None,
        **kwargs
    ):
        """
        :keyword content: Required. Concatenated content of the contained elements in reading order.
        :paramtype content: str
        :keyword polygon: Bounding polygon of the line.
        :paramtype polygon: list[float]
        :keyword spans: Required. Location of the line in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
        """
        super(DocumentLine, self).__init__(**kwargs)
        self.content = content
        self.polygon = polygon
        self.spans = spans


class DocumentModelBuildOperationDetails(OperationDetails):
    """Get Operation response object.

    All required parameters must be populated in order to send to Azure.

    :ivar operation_id: Required. Operation ID.
    :vartype operation_id: str
    :ivar status: Required. Operation status. Known values are: "notStarted", "running", "failed",
     "succeeded", "canceled".
    :vartype status: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationStatus
    :ivar percent_completed: Operation progress (0-100).
    :vartype percent_completed: int
    :ivar created_date_time: Required. Date and time (UTC) when the operation was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar kind: Required. Type of operation.Constant filled by server.
    :vartype kind: str
    :ivar resource_location: Required. URL of the resource targeted by this operation.
    :vartype resource_location: str
    :ivar api_version: API version used to create this operation.
    :vartype api_version: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the document model.
    :vartype tags: dict[str, str]
    :ivar error: Encountered error.
    :vartype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
    :ivar result: Operation result upon success.
    :vartype result: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentModelDetails
    """

    _validation = {
        'operation_id': {'required': True},
        'status': {'required': True},
        'percent_completed': {'maximum': 100, 'minimum': 0},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
        'kind': {'required': True},
        'resource_location': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'percent_completed': {'key': 'percentCompleted', 'type': 'int'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'kind': {'key': 'kind', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'error': {'key': 'error', 'type': 'Error'},
        'result': {'key': 'result', 'type': 'DocumentModelDetails'},
    }

    def __init__(
        self,
        *,
        operation_id: str,
        status: Union[str, "_models.OperationStatus"],
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        resource_location: str,
        percent_completed: Optional[int] = None,
        api_version: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        error: Optional["_models.Error"] = None,
        result: Optional["_models.DocumentModelDetails"] = None,
        **kwargs
    ):
        """
        :keyword operation_id: Required. Operation ID.
        :paramtype operation_id: str
        :keyword status: Required. Operation status. Known values are: "notStarted", "running",
         "failed", "succeeded", "canceled".
        :paramtype status: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationStatus
        :keyword percent_completed: Operation progress (0-100).
        :paramtype percent_completed: int
        :keyword created_date_time: Required. Date and time (UTC) when the operation was created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword last_updated_date_time: Required. Date and time (UTC) when the status was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        :keyword resource_location: Required. URL of the resource targeted by this operation.
        :paramtype resource_location: str
        :keyword api_version: API version used to create this operation.
        :paramtype api_version: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the document
         model.
        :paramtype tags: dict[str, str]
        :keyword error: Encountered error.
        :paramtype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
        :keyword result: Operation result upon success.
        :paramtype result: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentModelDetails
        """
        super(DocumentModelBuildOperationDetails, self).__init__(operation_id=operation_id, status=status, percent_completed=percent_completed, created_date_time=created_date_time, last_updated_date_time=last_updated_date_time, resource_location=resource_location, api_version=api_version, tags=tags, error=error, **kwargs)
        self.kind = 'documentModelBuild'  # type: str
        self.result = result


class DocumentModelComposeOperationDetails(OperationDetails):
    """Get Operation response object.

    All required parameters must be populated in order to send to Azure.

    :ivar operation_id: Required. Operation ID.
    :vartype operation_id: str
    :ivar status: Required. Operation status. Known values are: "notStarted", "running", "failed",
     "succeeded", "canceled".
    :vartype status: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationStatus
    :ivar percent_completed: Operation progress (0-100).
    :vartype percent_completed: int
    :ivar created_date_time: Required. Date and time (UTC) when the operation was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar kind: Required. Type of operation.Constant filled by server.
    :vartype kind: str
    :ivar resource_location: Required. URL of the resource targeted by this operation.
    :vartype resource_location: str
    :ivar api_version: API version used to create this operation.
    :vartype api_version: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the document model.
    :vartype tags: dict[str, str]
    :ivar error: Encountered error.
    :vartype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
    :ivar result: Operation result upon success.
    :vartype result: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentModelDetails
    """

    _validation = {
        'operation_id': {'required': True},
        'status': {'required': True},
        'percent_completed': {'maximum': 100, 'minimum': 0},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
        'kind': {'required': True},
        'resource_location': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'percent_completed': {'key': 'percentCompleted', 'type': 'int'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'kind': {'key': 'kind', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'error': {'key': 'error', 'type': 'Error'},
        'result': {'key': 'result', 'type': 'DocumentModelDetails'},
    }

    def __init__(
        self,
        *,
        operation_id: str,
        status: Union[str, "_models.OperationStatus"],
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        resource_location: str,
        percent_completed: Optional[int] = None,
        api_version: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        error: Optional["_models.Error"] = None,
        result: Optional["_models.DocumentModelDetails"] = None,
        **kwargs
    ):
        """
        :keyword operation_id: Required. Operation ID.
        :paramtype operation_id: str
        :keyword status: Required. Operation status. Known values are: "notStarted", "running",
         "failed", "succeeded", "canceled".
        :paramtype status: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationStatus
        :keyword percent_completed: Operation progress (0-100).
        :paramtype percent_completed: int
        :keyword created_date_time: Required. Date and time (UTC) when the operation was created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword last_updated_date_time: Required. Date and time (UTC) when the status was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        :keyword resource_location: Required. URL of the resource targeted by this operation.
        :paramtype resource_location: str
        :keyword api_version: API version used to create this operation.
        :paramtype api_version: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the document
         model.
        :paramtype tags: dict[str, str]
        :keyword error: Encountered error.
        :paramtype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
        :keyword result: Operation result upon success.
        :paramtype result: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentModelDetails
        """
        super(DocumentModelComposeOperationDetails, self).__init__(operation_id=operation_id, status=status, percent_completed=percent_completed, created_date_time=created_date_time, last_updated_date_time=last_updated_date_time, resource_location=resource_location, api_version=api_version, tags=tags, error=error, **kwargs)
        self.kind = 'documentModelCompose'  # type: str
        self.result = result


class DocumentModelCopyToOperationDetails(OperationDetails):
    """Get Operation response object.

    All required parameters must be populated in order to send to Azure.

    :ivar operation_id: Required. Operation ID.
    :vartype operation_id: str
    :ivar status: Required. Operation status. Known values are: "notStarted", "running", "failed",
     "succeeded", "canceled".
    :vartype status: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationStatus
    :ivar percent_completed: Operation progress (0-100).
    :vartype percent_completed: int
    :ivar created_date_time: Required. Date and time (UTC) when the operation was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar kind: Required. Type of operation.Constant filled by server.
    :vartype kind: str
    :ivar resource_location: Required. URL of the resource targeted by this operation.
    :vartype resource_location: str
    :ivar api_version: API version used to create this operation.
    :vartype api_version: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the document model.
    :vartype tags: dict[str, str]
    :ivar error: Encountered error.
    :vartype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
    :ivar result: Operation result upon success.
    :vartype result: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentModelDetails
    """

    _validation = {
        'operation_id': {'required': True},
        'status': {'required': True},
        'percent_completed': {'maximum': 100, 'minimum': 0},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
        'kind': {'required': True},
        'resource_location': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'percent_completed': {'key': 'percentCompleted', 'type': 'int'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'kind': {'key': 'kind', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'error': {'key': 'error', 'type': 'Error'},
        'result': {'key': 'result', 'type': 'DocumentModelDetails'},
    }

    def __init__(
        self,
        *,
        operation_id: str,
        status: Union[str, "_models.OperationStatus"],
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        resource_location: str,
        percent_completed: Optional[int] = None,
        api_version: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        error: Optional["_models.Error"] = None,
        result: Optional["_models.DocumentModelDetails"] = None,
        **kwargs
    ):
        """
        :keyword operation_id: Required. Operation ID.
        :paramtype operation_id: str
        :keyword status: Required. Operation status. Known values are: "notStarted", "running",
         "failed", "succeeded", "canceled".
        :paramtype status: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationStatus
        :keyword percent_completed: Operation progress (0-100).
        :paramtype percent_completed: int
        :keyword created_date_time: Required. Date and time (UTC) when the operation was created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword last_updated_date_time: Required. Date and time (UTC) when the status was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        :keyword resource_location: Required. URL of the resource targeted by this operation.
        :paramtype resource_location: str
        :keyword api_version: API version used to create this operation.
        :paramtype api_version: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the document
         model.
        :paramtype tags: dict[str, str]
        :keyword error: Encountered error.
        :paramtype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
        :keyword result: Operation result upon success.
        :paramtype result: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentModelDetails
        """
        super(DocumentModelCopyToOperationDetails, self).__init__(operation_id=operation_id, status=status, percent_completed=percent_completed, created_date_time=created_date_time, last_updated_date_time=last_updated_date_time, resource_location=resource_location, api_version=api_version, tags=tags, error=error, **kwargs)
        self.kind = 'documentModelCopyTo'  # type: str
        self.result = result


class DocumentModelDetails(msrest.serialization.Model):
    """Document model info.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Unique document model name.
    :vartype model_id: str
    :ivar description: Document model description.
    :vartype description: str
    :ivar created_date_time: Required. Date and time (UTC) when the document model was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time: Date and time (UTC) when the document model will expire.
    :vartype expiration_date_time: ~datetime.datetime
    :ivar api_version: API version used to create this document model.
    :vartype api_version: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the document model.
    :vartype tags: dict[str, str]
    :ivar doc_types: Supported document types.
    :vartype doc_types: dict[str, ~azure.ai.formrecognizer.v2023_07_31.models.DocumentTypeDetails]
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'^[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}$'},
        'description': {'max_length': 4096, 'min_length': 0},
        'created_date_time': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'doc_types': {'key': 'docTypes', 'type': '{DocumentTypeDetails}'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        created_date_time: datetime.datetime,
        description: Optional[str] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        api_version: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        doc_types: Optional[Dict[str, "_models.DocumentTypeDetails"]] = None,
        **kwargs
    ):
        """
        :keyword model_id: Required. Unique document model name.
        :paramtype model_id: str
        :keyword description: Document model description.
        :paramtype description: str
        :keyword created_date_time: Required. Date and time (UTC) when the document model was created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time: Date and time (UTC) when the document model will expire.
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword api_version: API version used to create this document model.
        :paramtype api_version: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the document
         model.
        :paramtype tags: dict[str, str]
        :keyword doc_types: Supported document types.
        :paramtype doc_types: dict[str,
         ~azure.ai.formrecognizer.v2023_07_31.models.DocumentTypeDetails]
        """
        super(DocumentModelDetails, self).__init__(**kwargs)
        self.model_id = model_id
        self.description = description
        self.created_date_time = created_date_time
        self.expiration_date_time = expiration_date_time
        self.api_version = api_version
        self.tags = tags
        self.doc_types = doc_types


class DocumentModelSummary(msrest.serialization.Model):
    """Document model summary.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Unique document model name.
    :vartype model_id: str
    :ivar description: Document model description.
    :vartype description: str
    :ivar created_date_time: Required. Date and time (UTC) when the document model was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time: Date and time (UTC) when the document model will expire.
    :vartype expiration_date_time: ~datetime.datetime
    :ivar api_version: API version used to create this document model.
    :vartype api_version: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the document model.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'model_id': {'required': True, 'pattern': r'^[a-zA-Z0-9][a-zA-Z0-9._~-]{1,63}$'},
        'description': {'max_length': 4096, 'min_length': 0},
        'created_date_time': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'expiration_date_time': {'key': 'expirationDateTime', 'type': 'iso-8601'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        created_date_time: datetime.datetime,
        description: Optional[str] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        api_version: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword model_id: Required. Unique document model name.
        :paramtype model_id: str
        :keyword description: Document model description.
        :paramtype description: str
        :keyword created_date_time: Required. Date and time (UTC) when the document model was created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time: Date and time (UTC) when the document model will expire.
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword api_version: API version used to create this document model.
        :paramtype api_version: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the document
         model.
        :paramtype tags: dict[str, str]
        """
        super(DocumentModelSummary, self).__init__(**kwargs)
        self.model_id = model_id
        self.description = description
        self.created_date_time = created_date_time
        self.expiration_date_time = expiration_date_time
        self.api_version = api_version
        self.tags = tags


class DocumentPage(msrest.serialization.Model):
    """Content and layout elements extracted from a page from the input.

    All required parameters must be populated in order to send to Azure.

    :ivar page_number: Required. 1-based page number in the input document.
    :vartype page_number: int
    :ivar angle: The general orientation of the content in clockwise direction, measured in degrees
     between (-180, 180].
    :vartype angle: float
    :ivar width: The width of the image/PDF in pixels/inches, respectively.
    :vartype width: float
    :ivar height: The height of the image/PDF in pixels/inches, respectively.
    :vartype height: float
    :ivar unit: The unit used by the width, height, and polygon properties. For images, the unit is
     "pixel". For PDF, the unit is "inch". Known values are: "pixel", "inch".
    :vartype unit: str or ~azure.ai.formrecognizer.v2023_07_31.models.LengthUnit
    :ivar spans: Required. Location of the page in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
    :ivar words: Extracted words from the page.
    :vartype words: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentWord]
    :ivar selection_marks: Extracted selection marks from the page.
    :vartype selection_marks:
     list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSelectionMark]
    :ivar lines: Extracted lines from the page, potentially containing both textual and visual
     elements.
    :vartype lines: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentLine]
    :ivar barcodes: Extracted barcodes from the page.
    :vartype barcodes: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentBarcode]
    :ivar formulas: Extracted formulas from the page.
    :vartype formulas: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentFormula]
    """

    _validation = {
        'page_number': {'required': True, 'minimum': 1},
        'angle': {'maximum': 180, 'minimum_ex': -180},
        'width': {'minimum': 0},
        'height': {'minimum': 0},
        'spans': {'required': True},
    }

    _attribute_map = {
        'page_number': {'key': 'pageNumber', 'type': 'int'},
        'angle': {'key': 'angle', 'type': 'float'},
        'width': {'key': 'width', 'type': 'float'},
        'height': {'key': 'height', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'words': {'key': 'words', 'type': '[DocumentWord]'},
        'selection_marks': {'key': 'selectionMarks', 'type': '[DocumentSelectionMark]'},
        'lines': {'key': 'lines', 'type': '[DocumentLine]'},
        'barcodes': {'key': 'barcodes', 'type': '[DocumentBarcode]'},
        'formulas': {'key': 'formulas', 'type': '[DocumentFormula]'},
    }

    def __init__(
        self,
        *,
        page_number: int,
        spans: List["_models.DocumentSpan"],
        angle: Optional[float] = None,
        width: Optional[float] = None,
        height: Optional[float] = None,
        unit: Optional[Union[str, "_models.LengthUnit"]] = None,
        words: Optional[List["_models.DocumentWord"]] = None,
        selection_marks: Optional[List["_models.DocumentSelectionMark"]] = None,
        lines: Optional[List["_models.DocumentLine"]] = None,
        barcodes: Optional[List["_models.DocumentBarcode"]] = None,
        formulas: Optional[List["_models.DocumentFormula"]] = None,
        **kwargs
    ):
        """
        :keyword page_number: Required. 1-based page number in the input document.
        :paramtype page_number: int
        :keyword angle: The general orientation of the content in clockwise direction, measured in
         degrees between (-180, 180].
        :paramtype angle: float
        :keyword width: The width of the image/PDF in pixels/inches, respectively.
        :paramtype width: float
        :keyword height: The height of the image/PDF in pixels/inches, respectively.
        :paramtype height: float
        :keyword unit: The unit used by the width, height, and polygon properties. For images, the unit
         is "pixel". For PDF, the unit is "inch". Known values are: "pixel", "inch".
        :paramtype unit: str or ~azure.ai.formrecognizer.v2023_07_31.models.LengthUnit
        :keyword spans: Required. Location of the page in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
        :keyword words: Extracted words from the page.
        :paramtype words: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentWord]
        :keyword selection_marks: Extracted selection marks from the page.
        :paramtype selection_marks:
         list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSelectionMark]
        :keyword lines: Extracted lines from the page, potentially containing both textual and visual
         elements.
        :paramtype lines: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentLine]
        :keyword barcodes: Extracted barcodes from the page.
        :paramtype barcodes: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentBarcode]
        :keyword formulas: Extracted formulas from the page.
        :paramtype formulas: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentFormula]
        """
        super(DocumentPage, self).__init__(**kwargs)
        self.page_number = page_number
        self.angle = angle
        self.width = width
        self.height = height
        self.unit = unit
        self.spans = spans
        self.words = words
        self.selection_marks = selection_marks
        self.lines = lines
        self.barcodes = barcodes
        self.formulas = formulas


class DocumentParagraph(msrest.serialization.Model):
    """A paragraph object consisting with contiguous lines generally with common alignment and spacing.

    All required parameters must be populated in order to send to Azure.

    :ivar role: Semantic role of the paragraph. Known values are: "pageHeader", "pageFooter",
     "pageNumber", "title", "sectionHeading", "footnote", "formulaBlock".
    :vartype role: str or ~azure.ai.formrecognizer.v2023_07_31.models.ParagraphRole
    :ivar content: Required. Concatenated content of the paragraph in reading order.
    :vartype content: str
    :ivar bounding_regions: Bounding regions covering the paragraph.
    :vartype bounding_regions: list[~azure.ai.formrecognizer.v2023_07_31.models.BoundingRegion]
    :ivar spans: Required. Location of the paragraph in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
    """

    _validation = {
        'content': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'role': {'key': 'role', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        *,
        content: str,
        spans: List["_models.DocumentSpan"],
        role: Optional[Union[str, "_models.ParagraphRole"]] = None,
        bounding_regions: Optional[List["_models.BoundingRegion"]] = None,
        **kwargs
    ):
        """
        :keyword role: Semantic role of the paragraph. Known values are: "pageHeader", "pageFooter",
         "pageNumber", "title", "sectionHeading", "footnote", "formulaBlock".
        :paramtype role: str or ~azure.ai.formrecognizer.v2023_07_31.models.ParagraphRole
        :keyword content: Required. Concatenated content of the paragraph in reading order.
        :paramtype content: str
        :keyword bounding_regions: Bounding regions covering the paragraph.
        :paramtype bounding_regions: list[~azure.ai.formrecognizer.v2023_07_31.models.BoundingRegion]
        :keyword spans: Required. Location of the paragraph in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
        """
        super(DocumentParagraph, self).__init__(**kwargs)
        self.role = role
        self.content = content
        self.bounding_regions = bounding_regions
        self.spans = spans


class DocumentSelectionMark(msrest.serialization.Model):
    """A selection mark object representing check boxes, radio buttons, and other elements indicating a selection.

    All required parameters must be populated in order to send to Azure.

    :ivar state: Required. State of the selection mark. Known values are: "selected", "unselected".
    :vartype state: str or ~azure.ai.formrecognizer.v2023_07_31.models.SelectionMarkState
    :ivar polygon: Bounding polygon of the selection mark.
    :vartype polygon: list[float]
    :ivar span: Required. Location of the selection mark in the reading order concatenated content.
    :vartype span: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan
    :ivar confidence: Required. Confidence of correctly extracting the selection mark.
    :vartype confidence: float
    """

    _validation = {
        'state': {'required': True},
        'span': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'polygon': {'key': 'polygon', 'type': '[float]'},
        'span': {'key': 'span', 'type': 'DocumentSpan'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "_models.SelectionMarkState"],
        span: "_models.DocumentSpan",
        confidence: float,
        polygon: Optional[List[float]] = None,
        **kwargs
    ):
        """
        :keyword state: Required. State of the selection mark. Known values are: "selected",
         "unselected".
        :paramtype state: str or ~azure.ai.formrecognizer.v2023_07_31.models.SelectionMarkState
        :keyword polygon: Bounding polygon of the selection mark.
        :paramtype polygon: list[float]
        :keyword span: Required. Location of the selection mark in the reading order concatenated
         content.
        :paramtype span: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan
        :keyword confidence: Required. Confidence of correctly extracting the selection mark.
        :paramtype confidence: float
        """
        super(DocumentSelectionMark, self).__init__(**kwargs)
        self.state = state
        self.polygon = polygon
        self.span = span
        self.confidence = confidence


class DocumentSpan(msrest.serialization.Model):
    """Contiguous region of the concatenated content property, specified as an offset and length.

    All required parameters must be populated in order to send to Azure.

    :ivar offset: Required. Zero-based index of the content represented by the span.
    :vartype offset: int
    :ivar length: Required. Number of characters in the content represented by the span.
    :vartype length: int
    """

    _validation = {
        'offset': {'required': True, 'minimum': 0},
        'length': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'offset': {'key': 'offset', 'type': 'int'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        offset: int,
        length: int,
        **kwargs
    ):
        """
        :keyword offset: Required. Zero-based index of the content represented by the span.
        :paramtype offset: int
        :keyword length: Required. Number of characters in the content represented by the span.
        :paramtype length: int
        """
        super(DocumentSpan, self).__init__(**kwargs)
        self.offset = offset
        self.length = length


class DocumentStyle(msrest.serialization.Model):
    """An object representing observed text styles.

    All required parameters must be populated in order to send to Azure.

    :ivar is_handwritten: Is content handwritten?.
    :vartype is_handwritten: bool
    :ivar similar_font_family: Visually most similar font from among the set of supported font
     families, with fallback fonts following CSS convention (ex. 'Arial, sans-serif').
    :vartype similar_font_family: str
    :ivar font_style: Font style. Known values are: "normal", "italic".
    :vartype font_style: str or ~azure.ai.formrecognizer.v2023_07_31.models.FontStyle
    :ivar font_weight: Font weight. Known values are: "normal", "bold".
    :vartype font_weight: str or ~azure.ai.formrecognizer.v2023_07_31.models.FontWeight
    :ivar color: Foreground color in #rrggbb hexadecimal format.
    :vartype color: str
    :ivar background_color: Background color in #rrggbb hexadecimal format..
    :vartype background_color: str
    :ivar spans: Required. Location of the text elements in the concatenated content the style
     applies to.
    :vartype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
    :ivar confidence: Required. Confidence of correctly identifying the style.
    :vartype confidence: float
    """

    _validation = {
        'color': {'pattern': r'^#[0-9a-f]{6}$'},
        'background_color': {'pattern': r'^#[0-9a-f]{6}$'},
        'spans': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'is_handwritten': {'key': 'isHandwritten', 'type': 'bool'},
        'similar_font_family': {'key': 'similarFontFamily', 'type': 'str'},
        'font_style': {'key': 'fontStyle', 'type': 'str'},
        'font_weight': {'key': 'fontWeight', 'type': 'str'},
        'color': {'key': 'color', 'type': 'str'},
        'background_color': {'key': 'backgroundColor', 'type': 'str'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        spans: List["_models.DocumentSpan"],
        confidence: float,
        is_handwritten: Optional[bool] = None,
        similar_font_family: Optional[str] = None,
        font_style: Optional[Union[str, "_models.FontStyle"]] = None,
        font_weight: Optional[Union[str, "_models.FontWeight"]] = None,
        color: Optional[str] = None,
        background_color: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword is_handwritten: Is content handwritten?.
        :paramtype is_handwritten: bool
        :keyword similar_font_family: Visually most similar font from among the set of supported font
         families, with fallback fonts following CSS convention (ex. 'Arial, sans-serif').
        :paramtype similar_font_family: str
        :keyword font_style: Font style. Known values are: "normal", "italic".
        :paramtype font_style: str or ~azure.ai.formrecognizer.v2023_07_31.models.FontStyle
        :keyword font_weight: Font weight. Known values are: "normal", "bold".
        :paramtype font_weight: str or ~azure.ai.formrecognizer.v2023_07_31.models.FontWeight
        :keyword color: Foreground color in #rrggbb hexadecimal format.
        :paramtype color: str
        :keyword background_color: Background color in #rrggbb hexadecimal format..
        :paramtype background_color: str
        :keyword spans: Required. Location of the text elements in the concatenated content the style
         applies to.
        :paramtype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
        :keyword confidence: Required. Confidence of correctly identifying the style.
        :paramtype confidence: float
        """
        super(DocumentStyle, self).__init__(**kwargs)
        self.is_handwritten = is_handwritten
        self.similar_font_family = similar_font_family
        self.font_style = font_style
        self.font_weight = font_weight
        self.color = color
        self.background_color = background_color
        self.spans = spans
        self.confidence = confidence


class DocumentTable(msrest.serialization.Model):
    """A table object consisting table cells arranged in a rectangular layout.

    All required parameters must be populated in order to send to Azure.

    :ivar row_count: Required. Number of rows in the table.
    :vartype row_count: int
    :ivar column_count: Required. Number of columns in the table.
    :vartype column_count: int
    :ivar cells: Required. Cells contained within the table.
    :vartype cells: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentTableCell]
    :ivar bounding_regions: Bounding regions covering the table.
    :vartype bounding_regions: list[~azure.ai.formrecognizer.v2023_07_31.models.BoundingRegion]
    :ivar spans: Required. Location of the table in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
    """

    _validation = {
        'row_count': {'required': True, 'minimum': 1},
        'column_count': {'required': True, 'minimum': 1},
        'cells': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'row_count': {'key': 'rowCount', 'type': 'int'},
        'column_count': {'key': 'columnCount', 'type': 'int'},
        'cells': {'key': 'cells', 'type': '[DocumentTableCell]'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        *,
        row_count: int,
        column_count: int,
        cells: List["_models.DocumentTableCell"],
        spans: List["_models.DocumentSpan"],
        bounding_regions: Optional[List["_models.BoundingRegion"]] = None,
        **kwargs
    ):
        """
        :keyword row_count: Required. Number of rows in the table.
        :paramtype row_count: int
        :keyword column_count: Required. Number of columns in the table.
        :paramtype column_count: int
        :keyword cells: Required. Cells contained within the table.
        :paramtype cells: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentTableCell]
        :keyword bounding_regions: Bounding regions covering the table.
        :paramtype bounding_regions: list[~azure.ai.formrecognizer.v2023_07_31.models.BoundingRegion]
        :keyword spans: Required. Location of the table in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
        """
        super(DocumentTable, self).__init__(**kwargs)
        self.row_count = row_count
        self.column_count = column_count
        self.cells = cells
        self.bounding_regions = bounding_regions
        self.spans = spans


class DocumentTableCell(msrest.serialization.Model):
    """An object representing the location and content of a table cell.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Table cell kind. Known values are: "content", "rowHeader", "columnHeader",
     "stubHead", "description". Default value: "content".
    :vartype kind: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentTableCellKind
    :ivar row_index: Required. Row index of the cell.
    :vartype row_index: int
    :ivar column_index: Required. Column index of the cell.
    :vartype column_index: int
    :ivar row_span: Number of rows spanned by this cell.
    :vartype row_span: int
    :ivar column_span: Number of columns spanned by this cell.
    :vartype column_span: int
    :ivar content: Required. Concatenated content of the table cell in reading order.
    :vartype content: str
    :ivar bounding_regions: Bounding regions covering the table cell.
    :vartype bounding_regions: list[~azure.ai.formrecognizer.v2023_07_31.models.BoundingRegion]
    :ivar spans: Required. Location of the table cell in the reading order concatenated content.
    :vartype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
    """

    _validation = {
        'row_index': {'required': True},
        'column_index': {'required': True},
        'row_span': {'minimum': 1},
        'column_span': {'minimum': 1},
        'content': {'required': True},
        'spans': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'row_index': {'key': 'rowIndex', 'type': 'int'},
        'column_index': {'key': 'columnIndex', 'type': 'int'},
        'row_span': {'key': 'rowSpan', 'type': 'int'},
        'column_span': {'key': 'columnSpan', 'type': 'int'},
        'content': {'key': 'content', 'type': 'str'},
        'bounding_regions': {'key': 'boundingRegions', 'type': '[BoundingRegion]'},
        'spans': {'key': 'spans', 'type': '[DocumentSpan]'},
    }

    def __init__(
        self,
        *,
        row_index: int,
        column_index: int,
        content: str,
        spans: List["_models.DocumentSpan"],
        kind: Optional[Union[str, "_models.DocumentTableCellKind"]] = "content",
        row_span: Optional[int] = 1,
        column_span: Optional[int] = 1,
        bounding_regions: Optional[List["_models.BoundingRegion"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Table cell kind. Known values are: "content", "rowHeader", "columnHeader",
         "stubHead", "description". Default value: "content".
        :paramtype kind: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentTableCellKind
        :keyword row_index: Required. Row index of the cell.
        :paramtype row_index: int
        :keyword column_index: Required. Column index of the cell.
        :paramtype column_index: int
        :keyword row_span: Number of rows spanned by this cell.
        :paramtype row_span: int
        :keyword column_span: Number of columns spanned by this cell.
        :paramtype column_span: int
        :keyword content: Required. Concatenated content of the table cell in reading order.
        :paramtype content: str
        :keyword bounding_regions: Bounding regions covering the table cell.
        :paramtype bounding_regions: list[~azure.ai.formrecognizer.v2023_07_31.models.BoundingRegion]
        :keyword spans: Required. Location of the table cell in the reading order concatenated content.
        :paramtype spans: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan]
        """
        super(DocumentTableCell, self).__init__(**kwargs)
        self.kind = kind
        self.row_index = row_index
        self.column_index = column_index
        self.row_span = row_span
        self.column_span = column_span
        self.content = content
        self.bounding_regions = bounding_regions
        self.spans = spans


class DocumentTypeDetails(msrest.serialization.Model):
    """Document type info.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Document model description.
    :vartype description: str
    :ivar build_mode: Custom document model build mode. Known values are: "template", "neural".
    :vartype build_mode: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentBuildMode
    :ivar field_schema: Required. Description of the document semantic schema using a JSON Schema
     style syntax.
    :vartype field_schema: dict[str,
     ~azure.ai.formrecognizer.v2023_07_31.models.DocumentFieldSchema]
    :ivar field_confidence: Estimated confidence for each field.
    :vartype field_confidence: dict[str, float]
    """

    _validation = {
        'description': {'max_length': 4096, 'min_length': 0},
        'field_schema': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'build_mode': {'key': 'buildMode', 'type': 'str'},
        'field_schema': {'key': 'fieldSchema', 'type': '{DocumentFieldSchema}'},
        'field_confidence': {'key': 'fieldConfidence', 'type': '{float}'},
    }

    def __init__(
        self,
        *,
        field_schema: Dict[str, "_models.DocumentFieldSchema"],
        description: Optional[str] = None,
        build_mode: Optional[Union[str, "_models.DocumentBuildMode"]] = None,
        field_confidence: Optional[Dict[str, float]] = None,
        **kwargs
    ):
        """
        :keyword description: Document model description.
        :paramtype description: str
        :keyword build_mode: Custom document model build mode. Known values are: "template", "neural".
        :paramtype build_mode: str or ~azure.ai.formrecognizer.v2023_07_31.models.DocumentBuildMode
        :keyword field_schema: Required. Description of the document semantic schema using a JSON
         Schema style syntax.
        :paramtype field_schema: dict[str,
         ~azure.ai.formrecognizer.v2023_07_31.models.DocumentFieldSchema]
        :keyword field_confidence: Estimated confidence for each field.
        :paramtype field_confidence: dict[str, float]
        """
        super(DocumentTypeDetails, self).__init__(**kwargs)
        self.description = description
        self.build_mode = build_mode
        self.field_schema = field_schema
        self.field_confidence = field_confidence


class DocumentWord(msrest.serialization.Model):
    """A word object consisting of a contiguous sequence of characters.  For non-space delimited languages, such as Chinese, Japanese, and Korean, each character is represented as its own word.

    All required parameters must be populated in order to send to Azure.

    :ivar content: Required. Text content of the word.
    :vartype content: str
    :ivar polygon: Bounding polygon of the word.
    :vartype polygon: list[float]
    :ivar span: Required. Location of the word in the reading order concatenated content.
    :vartype span: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan
    :ivar confidence: Required. Confidence of correctly extracting the word.
    :vartype confidence: float
    """

    _validation = {
        'content': {'required': True},
        'span': {'required': True},
        'confidence': {'required': True, 'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'polygon': {'key': 'polygon', 'type': '[float]'},
        'span': {'key': 'span', 'type': 'DocumentSpan'},
        'confidence': {'key': 'confidence', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        content: str,
        span: "_models.DocumentSpan",
        confidence: float,
        polygon: Optional[List[float]] = None,
        **kwargs
    ):
        """
        :keyword content: Required. Text content of the word.
        :paramtype content: str
        :keyword polygon: Bounding polygon of the word.
        :paramtype polygon: list[float]
        :keyword span: Required. Location of the word in the reading order concatenated content.
        :paramtype span: ~azure.ai.formrecognizer.v2023_07_31.models.DocumentSpan
        :keyword confidence: Required. Confidence of correctly extracting the word.
        :paramtype confidence: float
        """
        super(DocumentWord, self).__init__(**kwargs)
        self.content = content
        self.polygon = polygon
        self.span = span
        self.confidence = confidence


class Error(msrest.serialization.Model):
    """Error info.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Error code.
    :vartype code: str
    :ivar message: Required. Error message.
    :vartype message: str
    :ivar target: Target of the error.
    :vartype target: str
    :ivar details: List of detailed errors.
    :vartype details: list[~azure.ai.formrecognizer.v2023_07_31.models.Error]
    :ivar innererror: Detailed error.
    :vartype innererror: ~azure.ai.formrecognizer.v2023_07_31.models.InnerError
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[Error]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["_models.Error"]] = None,
        innererror: Optional["_models.InnerError"] = None,
        **kwargs
    ):
        """
        :keyword code: Required. Error code.
        :paramtype code: str
        :keyword message: Required. Error message.
        :paramtype message: str
        :keyword target: Target of the error.
        :paramtype target: str
        :keyword details: List of detailed errors.
        :paramtype details: list[~azure.ai.formrecognizer.v2023_07_31.models.Error]
        :keyword innererror: Detailed error.
        :paramtype innererror: ~azure.ai.formrecognizer.v2023_07_31.models.InnerError
        """
        super(Error, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.innererror = innererror


class ErrorResponse(msrest.serialization.Model):
    """Error response object.

    All required parameters must be populated in order to send to Azure.

    :ivar error: Required. Error info.
    :vartype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(
        self,
        *,
        error: "_models.Error",
        **kwargs
    ):
        """
        :keyword error: Required. Error info.
        :paramtype error: ~azure.ai.formrecognizer.v2023_07_31.models.Error
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class GetDocumentClassifiersResponse(msrest.serialization.Model):
    """List document classifiers response object.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. List of document classifiers.
    :vartype value: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentClassifierDetails]
    :ivar next_link: Link to the next page of document classifiers.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DocumentClassifierDetails]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.DocumentClassifierDetails"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. List of document classifiers.
        :paramtype value: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentClassifierDetails]
        :keyword next_link: Link to the next page of document classifiers.
        :paramtype next_link: str
        """
        super(GetDocumentClassifiersResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GetDocumentModelsResponse(msrest.serialization.Model):
    """List document models response object.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. List of document models.
    :vartype value: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentModelSummary]
    :ivar next_link: Link to the next page of document models.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DocumentModelSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.DocumentModelSummary"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. List of document models.
        :paramtype value: list[~azure.ai.formrecognizer.v2023_07_31.models.DocumentModelSummary]
        :keyword next_link: Link to the next page of document models.
        :paramtype next_link: str
        """
        super(GetDocumentModelsResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GetOperationsResponse(msrest.serialization.Model):
    """List Operations response object.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. List of operations.
    :vartype value: list[~azure.ai.formrecognizer.v2023_07_31.models.OperationSummary]
    :ivar next_link: Link to the next page of operations.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.OperationSummary"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. List of operations.
        :paramtype value: list[~azure.ai.formrecognizer.v2023_07_31.models.OperationSummary]
        :keyword next_link: Link to the next page of operations.
        :paramtype next_link: str
        """
        super(GetOperationsResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class InnerError(msrest.serialization.Model):
    """Detailed error.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar innererror: Detailed error.
    :vartype innererror: ~azure.ai.formrecognizer.v2023_07_31.models.InnerError
    """

    _validation = {
        'code': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: Optional[str] = None,
        innererror: Optional["_models.InnerError"] = None,
        **kwargs
    ):
        """
        :keyword code: Required. Error code.
        :paramtype code: str
        :keyword message: Error message.
        :paramtype message: str
        :keyword innererror: Detailed error.
        :paramtype innererror: ~azure.ai.formrecognizer.v2023_07_31.models.InnerError
        """
        super(InnerError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.innererror = innererror


class OperationSummary(msrest.serialization.Model):
    """Operation info.

    All required parameters must be populated in order to send to Azure.

    :ivar operation_id: Required. Operation ID.
    :vartype operation_id: str
    :ivar status: Required. Operation status. Known values are: "notStarted", "running", "failed",
     "succeeded", "canceled".
    :vartype status: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationStatus
    :ivar percent_completed: Operation progress (0-100).
    :vartype percent_completed: int
    :ivar created_date_time: Required. Date and time (UTC) when the operation was created.
    :vartype created_date_time: ~datetime.datetime
    :ivar last_updated_date_time: Required. Date and time (UTC) when the status was last updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar kind: Required. Type of operation. Known values are: "documentModelBuild",
     "documentModelCompose", "documentModelCopyTo", "documentClassifierBuild".
    :vartype kind: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationKind
    :ivar resource_location: Required. URL of the resource targeted by this operation.
    :vartype resource_location: str
    :ivar api_version: API version used to create this operation.
    :vartype api_version: str
    :ivar tags: A set of tags. List of key-value tag attributes associated with the document model.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'operation_id': {'required': True},
        'status': {'required': True},
        'percent_completed': {'maximum': 100, 'minimum': 0},
        'created_date_time': {'required': True},
        'last_updated_date_time': {'required': True},
        'kind': {'required': True},
        'resource_location': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'percent_completed': {'key': 'percentCompleted', 'type': 'int'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'kind': {'key': 'kind', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        operation_id: str,
        status: Union[str, "_models.OperationStatus"],
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        kind: Union[str, "_models.OperationKind"],
        resource_location: str,
        percent_completed: Optional[int] = None,
        api_version: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword operation_id: Required. Operation ID.
        :paramtype operation_id: str
        :keyword status: Required. Operation status. Known values are: "notStarted", "running",
         "failed", "succeeded", "canceled".
        :paramtype status: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationStatus
        :keyword percent_completed: Operation progress (0-100).
        :paramtype percent_completed: int
        :keyword created_date_time: Required. Date and time (UTC) when the operation was created.
        :paramtype created_date_time: ~datetime.datetime
        :keyword last_updated_date_time: Required. Date and time (UTC) when the status was last
         updated.
        :paramtype last_updated_date_time: ~datetime.datetime
        :keyword kind: Required. Type of operation. Known values are: "documentModelBuild",
         "documentModelCompose", "documentModelCopyTo", "documentClassifierBuild".
        :paramtype kind: str or ~azure.ai.formrecognizer.v2023_07_31.models.OperationKind
        :keyword resource_location: Required. URL of the resource targeted by this operation.
        :paramtype resource_location: str
        :keyword api_version: API version used to create this operation.
        :paramtype api_version: str
        :keyword tags: A set of tags. List of key-value tag attributes associated with the document
         model.
        :paramtype tags: dict[str, str]
        """
        super(OperationSummary, self).__init__(**kwargs)
        self.operation_id = operation_id
        self.status = status
        self.percent_completed = percent_completed
        self.created_date_time = created_date_time
        self.last_updated_date_time = last_updated_date_time
        self.kind = kind
        self.resource_location = resource_location
        self.api_version = api_version
        self.tags = tags


class QuotaDetails(msrest.serialization.Model):
    """Quota used, limit, and next reset date/time.

    All required parameters must be populated in order to send to Azure.

    :ivar used: Required. Amount of the resource quota used.
    :vartype used: int
    :ivar quota: Required. Resource quota limit.
    :vartype quota: int
    :ivar quota_reset_date_time: Required. Date/time when the resource quota usage will be reset.
    :vartype quota_reset_date_time: ~datetime.datetime
    """

    _validation = {
        'used': {'required': True},
        'quota': {'required': True},
        'quota_reset_date_time': {'required': True},
    }

    _attribute_map = {
        'used': {'key': 'used', 'type': 'int'},
        'quota': {'key': 'quota', 'type': 'int'},
        'quota_reset_date_time': {'key': 'quotaResetDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        used: int,
        quota: int,
        quota_reset_date_time: datetime.datetime,
        **kwargs
    ):
        """
        :keyword used: Required. Amount of the resource quota used.
        :paramtype used: int
        :keyword quota: Required. Resource quota limit.
        :paramtype quota: int
        :keyword quota_reset_date_time: Required. Date/time when the resource quota usage will be
         reset.
        :paramtype quota_reset_date_time: ~datetime.datetime
        """
        super(QuotaDetails, self).__init__(**kwargs)
        self.used = used
        self.quota = quota
        self.quota_reset_date_time = quota_reset_date_time


class ResourceDetails(msrest.serialization.Model):
    """General information regarding the current resource.

    All required parameters must be populated in order to send to Azure.

    :ivar custom_document_models: Required. Details regarding custom document models.
    :vartype custom_document_models:
     ~azure.ai.formrecognizer.v2023_07_31.models.CustomDocumentModelsDetails
    :ivar custom_neural_document_model_builds: Required. Quota used, limit, and next reset
     date/time.
    :vartype custom_neural_document_model_builds:
     ~azure.ai.formrecognizer.v2023_07_31.models.QuotaDetails
    """

    _validation = {
        'custom_document_models': {'required': True},
        'custom_neural_document_model_builds': {'required': True},
    }

    _attribute_map = {
        'custom_document_models': {'key': 'customDocumentModels', 'type': 'CustomDocumentModelsDetails'},
        'custom_neural_document_model_builds': {'key': 'customNeuralDocumentModelBuilds', 'type': 'QuotaDetails'},
    }

    def __init__(
        self,
        *,
        custom_document_models: "_models.CustomDocumentModelsDetails",
        custom_neural_document_model_builds: "_models.QuotaDetails",
        **kwargs
    ):
        """
        :keyword custom_document_models: Required. Details regarding custom document models.
        :paramtype custom_document_models:
         ~azure.ai.formrecognizer.v2023_07_31.models.CustomDocumentModelsDetails
        :keyword custom_neural_document_model_builds: Required. Quota used, limit, and next reset
         date/time.
        :paramtype custom_neural_document_model_builds:
         ~azure.ai.formrecognizer.v2023_07_31.models.QuotaDetails
        """
        super(ResourceDetails, self).__init__(**kwargs)
        self.custom_document_models = custom_document_models
        self.custom_neural_document_model_builds = custom_neural_document_model_builds
