# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from typing import Any, Callable, Dict, Literal, Optional, TypeVar, Union

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._policy_tracked_resources_operations import (
    build_list_query_results_for_management_group_request,
    build_list_query_results_for_resource_group_request,
    build_list_query_results_for_resource_request,
    build_list_query_results_for_subscription_request,
)
from .._configuration import PolicyInsightsClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class PolicyTrackedResourcesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.policyinsights.aio.PolicyInsightsClient`'s
        :attr:`policy_tracked_resources` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: PolicyInsightsClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_query_results_for_management_group(
        self,
        management_group_name: str,
        policy_tracked_resources_resource: Union[str, _models.PolicyTrackedResourcesResourceType],
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyTrackedResource"]:
        """Queries policy tracked resources under the management group.

        :param management_group_name: Management group name. Required.
        :type management_group_name: str
        :param policy_tracked_resources_resource: The name of the virtual resource under
         PolicyTrackedResources resource type; only "default" is allowed. "default" Required.
        :type policy_tracked_resources_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyTrackedResourcesResourceType
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyTrackedResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyTrackedResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        management_groups_namespace: Literal["Microsoft.Management"] = kwargs.pop(
            "management_groups_namespace", "Microsoft.Management"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2018-07-01-preview"))
        cls: ClsType[_models.PolicyTrackedResourcesQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _filter = None
                if query_options is not None:
                    _filter = query_options.filter
                    _top = query_options.top

                _request = build_list_query_results_for_management_group_request(
                    management_group_name=management_group_name,
                    policy_tracked_resources_resource=policy_tracked_resources_resource,
                    top=_top,
                    filter=_filter,
                    management_groups_namespace=management_groups_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyTrackedResourcesQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_subscription(
        self,
        policy_tracked_resources_resource: Union[str, _models.PolicyTrackedResourcesResourceType],
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyTrackedResource"]:
        """Queries policy tracked resources under the subscription.

        :param policy_tracked_resources_resource: The name of the virtual resource under
         PolicyTrackedResources resource type; only "default" is allowed. "default" Required.
        :type policy_tracked_resources_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyTrackedResourcesResourceType
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyTrackedResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyTrackedResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2018-07-01-preview"))
        cls: ClsType[_models.PolicyTrackedResourcesQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _filter = None
                if query_options is not None:
                    _filter = query_options.filter
                    _top = query_options.top

                _request = build_list_query_results_for_subscription_request(
                    policy_tracked_resources_resource=policy_tracked_resources_resource,
                    subscription_id=self._config.subscription_id,
                    top=_top,
                    filter=_filter,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyTrackedResourcesQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_resource_group(
        self,
        resource_group_name: str,
        policy_tracked_resources_resource: Union[str, _models.PolicyTrackedResourcesResourceType],
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyTrackedResource"]:
        """Queries policy tracked resources under the resource group.

        :param resource_group_name: Resource group name. Required.
        :type resource_group_name: str
        :param policy_tracked_resources_resource: The name of the virtual resource under
         PolicyTrackedResources resource type; only "default" is allowed. "default" Required.
        :type policy_tracked_resources_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyTrackedResourcesResourceType
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyTrackedResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyTrackedResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2018-07-01-preview"))
        cls: ClsType[_models.PolicyTrackedResourcesQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _filter = None
                if query_options is not None:
                    _filter = query_options.filter
                    _top = query_options.top

                _request = build_list_query_results_for_resource_group_request(
                    resource_group_name=resource_group_name,
                    policy_tracked_resources_resource=policy_tracked_resources_resource,
                    subscription_id=self._config.subscription_id,
                    top=_top,
                    filter=_filter,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyTrackedResourcesQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_resource(
        self,
        resource_id: str,
        policy_tracked_resources_resource: Union[str, _models.PolicyTrackedResourcesResourceType],
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyTrackedResource"]:
        """Queries policy tracked resources under the resource.

        :param resource_id: Resource ID. Required.
        :type resource_id: str
        :param policy_tracked_resources_resource: The name of the virtual resource under
         PolicyTrackedResources resource type; only "default" is allowed. "default" Required.
        :type policy_tracked_resources_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyTrackedResourcesResourceType
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyTrackedResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyTrackedResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2018-07-01-preview"))
        cls: ClsType[_models.PolicyTrackedResourcesQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _filter = None
                if query_options is not None:
                    _filter = query_options.filter
                    _top = query_options.top

                _request = build_list_query_results_for_resource_request(
                    resource_id=resource_id,
                    policy_tracked_resources_resource=policy_tracked_resources_resource,
                    top=_top,
                    filter=_filter,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyTrackedResourcesQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
