# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, Literal, Optional, TypeVar, Union, overload

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._configuration import PolicyInsightsClientConfiguration
from .._utils.serialization import Deserializer, Serializer

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_check_at_subscription_scope_request(  # pylint: disable=name-too-long
    subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url", "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions"
    )
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_check_at_resource_group_scope_request(  # pylint: disable=name-too-long
    resource_group_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions",
    )
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_check_at_management_group_scope_request(  # pylint: disable=name-too-long
    management_group_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    management_groups_namespace: Literal["Microsoft.Management"] = kwargs.pop(
        "management_groups_namespace", "Microsoft.Management"
    )
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions",
    )
    path_format_arguments = {
        "managementGroupsNamespace": _SERIALIZER.url("management_groups_namespace", management_groups_namespace, "str"),
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class PolicyRestrictionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.policyinsights.PolicyInsightsClient`'s
        :attr:`policy_restrictions` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: PolicyInsightsClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def check_at_subscription_scope(
        self, parameters: _models.CheckRestrictionsRequest, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on a resource within a subscription.

        :param parameters: The check policy restrictions parameters. Required.
        :type parameters: ~azure.mgmt.policyinsights.models.CheckRestrictionsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def check_at_subscription_scope(
        self, parameters: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on a resource within a subscription.

        :param parameters: The check policy restrictions parameters. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def check_at_subscription_scope(
        self, parameters: Union[_models.CheckRestrictionsRequest, IO[bytes]], **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on a resource within a subscription.

        :param parameters: The check policy restrictions parameters. Is either a
         CheckRestrictionsRequest type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.policyinsights.models.CheckRestrictionsRequest or IO[bytes]
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CheckRestrictionsResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CheckRestrictionsRequest")

        _request = build_check_at_subscription_scope_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponseAutoGenerated, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CheckRestrictionsResult", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def check_at_resource_group_scope(
        self,
        resource_group_name: str,
        parameters: _models.CheckRestrictionsRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on a resource within a resource group. Use
        this when the resource group the resource will be created in is already known.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param parameters: The check policy restrictions parameters. Required.
        :type parameters: ~azure.mgmt.policyinsights.models.CheckRestrictionsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def check_at_resource_group_scope(
        self, resource_group_name: str, parameters: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on a resource within a resource group. Use
        this when the resource group the resource will be created in is already known.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param parameters: The check policy restrictions parameters. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def check_at_resource_group_scope(
        self, resource_group_name: str, parameters: Union[_models.CheckRestrictionsRequest, IO[bytes]], **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on a resource within a resource group. Use
        this when the resource group the resource will be created in is already known.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param parameters: The check policy restrictions parameters. Is either a
         CheckRestrictionsRequest type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.policyinsights.models.CheckRestrictionsRequest or IO[bytes]
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CheckRestrictionsResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CheckRestrictionsRequest")

        _request = build_check_at_resource_group_scope_request(
            resource_group_name=resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponseAutoGenerated, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CheckRestrictionsResult", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def check_at_management_group_scope(
        self,
        management_group_id: str,
        parameters: _models.CheckManagementGroupRestrictionsRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on resources within a management group.

        :param management_group_id: Management group ID. Required.
        :type management_group_id: str
        :param parameters: The check policy restrictions parameters. Required.
        :type parameters: ~azure.mgmt.policyinsights.models.CheckManagementGroupRestrictionsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def check_at_management_group_scope(
        self, management_group_id: str, parameters: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on resources within a management group.

        :param management_group_id: Management group ID. Required.
        :type management_group_id: str
        :param parameters: The check policy restrictions parameters. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def check_at_management_group_scope(
        self,
        management_group_id: str,
        parameters: Union[_models.CheckManagementGroupRestrictionsRequest, IO[bytes]],
        **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on resources within a management group.

        :param management_group_id: Management group ID. Required.
        :type management_group_id: str
        :param parameters: The check policy restrictions parameters. Is either a
         CheckManagementGroupRestrictionsRequest type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.policyinsights.models.CheckManagementGroupRestrictionsRequest or
         IO[bytes]
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        management_groups_namespace: Literal["Microsoft.Management"] = kwargs.pop(
            "management_groups_namespace", "Microsoft.Management"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CheckRestrictionsResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CheckManagementGroupRestrictionsRequest")

        _request = build_check_at_management_group_scope_request(
            management_group_id=management_group_id,
            management_groups_namespace=management_groups_namespace,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponseAutoGenerated, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CheckRestrictionsResult", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
