# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterAlertsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_list(self, resource_group):
        response = self.client.alerts.list(
            api_version="2022-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_list_by_resource_group(self, resource_group):
        response = self.client.alerts.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2022-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_list_subscription_level_by_region(self, resource_group):
        response = self.client.alerts.list_subscription_level_by_region(
            asc_location="str",
            api_version="2022-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_list_resource_group_level_by_region(self, resource_group):
        response = self.client.alerts.list_resource_group_level_by_region(
            asc_location="str",
            resource_group_name=resource_group.name,
            api_version="2022-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_get_subscription_level(self, resource_group):
        response = await self.client.alerts.get_subscription_level(
            asc_location="str",
            alert_name="str",
            api_version="2022-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_get_resource_group_level(self, resource_group):
        response = await self.client.alerts.get_resource_group_level(
            resource_group_name=resource_group.name,
            asc_location="str",
            alert_name="str",
            api_version="2022-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_update_subscription_level_state_to_dismiss(self, resource_group):
        response = await self.client.alerts.update_subscription_level_state_to_dismiss(
            asc_location="str",
            alert_name="str",
            api_version="2022-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_update_subscription_level_state_to_resolve(self, resource_group):
        response = await self.client.alerts.update_subscription_level_state_to_resolve(
            asc_location="str",
            alert_name="str",
            api_version="2022-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_update_subscription_level_state_to_activate(self, resource_group):
        response = await self.client.alerts.update_subscription_level_state_to_activate(
            asc_location="str",
            alert_name="str",
            api_version="2022-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_update_subscription_level_state_to_in_progress(self, resource_group):
        response = await self.client.alerts.update_subscription_level_state_to_in_progress(
            asc_location="str",
            alert_name="str",
            api_version="2022-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_update_resource_group_level_state_to_resolve(self, resource_group):
        response = await self.client.alerts.update_resource_group_level_state_to_resolve(
            resource_group_name=resource_group.name,
            asc_location="str",
            alert_name="str",
            api_version="2022-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_update_resource_group_level_state_to_dismiss(self, resource_group):
        response = await self.client.alerts.update_resource_group_level_state_to_dismiss(
            resource_group_name=resource_group.name,
            asc_location="str",
            alert_name="str",
            api_version="2022-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_update_resource_group_level_state_to_activate(self, resource_group):
        response = await self.client.alerts.update_resource_group_level_state_to_activate(
            resource_group_name=resource_group.name,
            asc_location="str",
            alert_name="str",
            api_version="2022-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_update_resource_group_level_state_to_in_progress(self, resource_group):
        response = await self.client.alerts.update_resource_group_level_state_to_in_progress(
            resource_group_name=resource_group.name,
            asc_location="str",
            alert_name="str",
            api_version="2022-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_begin_simulate(self, resource_group):
        response = await (
            await self.client.alerts.begin_simulate(
                asc_location="str",
                alert_simulator_request_body={"properties": "alert_simulator_request_properties"},
                api_version="2022-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
