# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterRegulatoryComplianceAssessmentsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_regulatory_compliance_assessments_list(self, resource_group):
        response = self.client.regulatory_compliance_assessments.list(
            regulatory_compliance_standard_name="str",
            regulatory_compliance_control_name="str",
            api_version="2019-01-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_regulatory_compliance_assessments_get(self, resource_group):
        response = await self.client.regulatory_compliance_assessments.get(
            regulatory_compliance_standard_name="str",
            regulatory_compliance_control_name="str",
            regulatory_compliance_assessment_name="str",
            api_version="2019-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...
