# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.servicefabricmanagedclusters import ServiceFabricManagedClustersManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-servicefabricmanagedclusters
# USAGE
    python application_action_update_upgrade_example.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ServiceFabricManagedClustersManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    client.applications.begin_update_upgrade(
        resource_group_name="resRg",
        cluster_name="myCluster",
        application_name="myApp",
        parameters={
            "applicationHealthPolicy": {
                "considerWarningAsError": True,
                "defaultServiceTypeHealthPolicy": {
                    "maxPercentUnhealthyPartitionsPerService": 10,
                    "maxPercentUnhealthyReplicasPerPartition": 11,
                    "maxPercentUnhealthyServices": 12,
                },
                "maxPercentUnhealthyDeployedApplications": 10,
                "serviceTypeHealthPolicyMap": {
                    "VotingWeb": {
                        "maxPercentUnhealthyPartitionsPerService": 13,
                        "maxPercentUnhealthyReplicasPerPartition": 14,
                        "maxPercentUnhealthyServices": 15,
                    }
                },
            },
            "name": "fabric:/Voting",
            "updateDescription": {
                "failureAction": "Manual",
                "forceRestart": True,
                "healthCheckRetryTimeoutInMilliseconds": "PT0H15M0S",
                "healthCheckStableDurationInMilliseconds": "PT1H0M0S",
                "healthCheckWaitDurationInMilliseconds": "PT0H0M10S",
                "rollingUpgradeMode": "Monitored",
                "upgradeDomainTimeoutInMilliseconds": "PT2H0M0S",
                "upgradeTimeoutInMilliseconds": "PT2H0M0S",
            },
            "upgradeKind": "Rolling",
        },
    ).result()


# x-ms-original-file: 2025-10-01-preview/ApplicationActionUpdateUpgrade_example.json
if __name__ == "__main__":
    main()
