# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storagediscovery import StorageDiscoveryMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageDiscoveryMgmtStorageDiscoveryWorkspacesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageDiscoveryMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_discovery_workspaces_get(self, resource_group):
        response = self.client.storage_discovery_workspaces.get(
            resource_group_name=resource_group.name,
            storage_discovery_workspace_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_discovery_workspaces_create_or_update(self, resource_group):
        response = self.client.storage_discovery_workspaces.create_or_update(
            resource_group_name=resource_group.name,
            storage_discovery_workspace_name="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "scopes": [
                        {"displayName": "str", "resourceTypes": ["str"], "tagKeysOnly": ["str"], "tags": {"str": "str"}}
                    ],
                    "workspaceRoots": ["str"],
                    "description": "str",
                    "provisioningState": "str",
                    "sku": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_discovery_workspaces_update(self, resource_group):
        response = self.client.storage_discovery_workspaces.update(
            resource_group_name=resource_group.name,
            storage_discovery_workspace_name="str",
            properties={
                "properties": {
                    "description": "str",
                    "scopes": [
                        {"displayName": "str", "resourceTypes": ["str"], "tagKeysOnly": ["str"], "tags": {"str": "str"}}
                    ],
                    "sku": "str",
                    "workspaceRoots": ["str"],
                },
                "tags": {"str": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_discovery_workspaces_delete(self, resource_group):
        response = self.client.storage_discovery_workspaces.delete(
            resource_group_name=resource_group.name,
            storage_discovery_workspace_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_discovery_workspaces_list_by_resource_group(self, resource_group):
        response = self.client.storage_discovery_workspaces.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_discovery_workspaces_list_by_subscription(self, resource_group):
        response = self.client.storage_discovery_workspaces.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
