from silx.gui import qt
from typing import Optional
from processview.gui.processmanager import ProcessManagerWindow
from processview.core.superviseprocess import SuperviseProcess
from processview.core.dataset import Dataset
from processview.core.dataset import DatasetIdentifier
from processview.core.manager import DatasetState
from processview.gui.processmanager import ProcessManager
import datetime


class _DummyScan(Dataset):
    def __init__(self, name):
        super().__init__()
        self.__name = name

    def __str__(self) -> str:
        return self.__name

    def get_identifier(self) -> DatasetIdentifier:
        return _DummyIdentifier(
            self,
            metadata={
                "name": self.__name,
                "creation_time": datetime.datetime.now(),
                "modification_time": datetime.datetime.now(),
            },
        )


class _DummyIdentifier(DatasetIdentifier):
    def to_str(self):
        return str(self)

    def __str__(self):
        return self.name()

    def __eq__(self, other):
        return self.name() == other.name()

    def __hash__(self):
        return hash(self.name())


app = qt.QApplication([])

window = ProcessManagerWindow(parent=None)
window.show()

p1 = SuperviseProcess(name="process1")
p2 = SuperviseProcess(name="process2")
scan_1 = _DummyScan("scan1")
scan_2 = _DummyScan("scan2 with a very long name ... really long")

manager = ProcessManager()
manager.notify_dataset_state(dataset=scan_1, state=DatasetState.PENDING, process=p1)
manager.notify_dataset_state(dataset=scan_2, state=DatasetState.SUCCEED, process=p1)
manager.notify_dataset_state(dataset=scan_2, state=DatasetState.FAILED, process=p2)

app.exec_()
