# Copyright and Usage

## Overview

`recipe-scrapers` is a Python library that provides tools for extracting structured recipe data
from websites. This document outlines our approach to copyright considerations and clarifies
responsibilities for library maintainers and end users.

## Copyright Responsibility

### Library's Role

`recipe-scrapers` is a tool that facilitates data extraction. The library itself:

- Provides methods to access made available web content
- Transforms unstructured recipe data into structured formats
- Does not store, host, or redistribute any content
- Does not circumvent any technical access controls
- Makes no claims about the copyright status of accessed content

### End User Responsibility

Users of `recipe-scrapers` are responsible for:

- Ensuring their use of scraped content complies with applicable laws
- Respecting website terms of service and *robots.txt* directives
- Obtaining necessary permissions for their intended use of scraped content
- Managing any copyright or licensing requirements for scraped content

## Fair Use Considerations

Many uses of `recipe-scrapers` may fall under fair use doctrine, particularly:

- Personal recipe collection and organization
- Academic research and analysis
- Transformative uses that add value to the original content
- Non-commercial educational purposes

However, users should conduct their own legal analysis based on their specific use case and
jurisdiction.

## Best Practices for Users

We recommend users:

- Cache scraped content appropriately to minimize server load
- Include attribution when displaying scraped content
- Respect rate limits and *robots.txt* directives
- Consider websites' terms of service
- Implement appropriate error handling and fallbacks

## Library Development Guidelines

For contributors and maintainers:

- Focus on structural improvements and bug fixes
- Maintain the library's role as a neutral tool
- Keep copyright considerations proportional and practical
- Balance legal compliance with usability
- Avoid features that could only serve infringing purposes

## Disclaimer

`recipe-scrapers` is provided "as is" without warranty of any kind. The maintainers make no
representations about the suitability, reliability, availability, timeliness, or accuracy of the
software or its content extraction capabilities.

## Additional Resources

For more information about web scraping and copyright:

- [Stanford Libraries: Copyright and Fair Use](https://fairuse.stanford.edu/)
- [EFF: Legal Guide for Developers](https://www.eff.org/issues/coders)
- [Digital Media Law Project: Legal Risks in Scraping](https://www.dmlp.org/legal-guide)
