/****************************************************************************
**
** Copyright (C) 2020 Uwe Kindler
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or (at your option) any later version.
** The licenses are as published by the Free Software Foundation
** and appearing in the file LICENSE.LGPLv21 included in the packaging
** of this file. Please review the following information to ensure
** the GNU Lesser General Public License version 2.1 requirements
** will be met: https://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#pragma once

#include "ads_globals.h"
#include "dockmanager.h"

#include <QObject>

namespace ADS {

class DockFocusControllerPrivate;
class DockManager;
class FloatingDockContainer;

/**
 * Manages focus styling of dock widgets and handling of focus changes
 */
class ADS_EXPORT DockFocusController : public QObject
{
    Q_OBJECT

private:
    DockFocusControllerPrivate* d; ///< private data (pimpl)
    friend class DockFocusControllerPrivate;

private:
    void onApplicationFocusChanged(QWidget *old, QWidget *now);
    void onFocusedDockAreaViewToggled(bool open);
    void onStateRestored();

public:
    /**
     * Default Constructor
     */
    DockFocusController(DockManager *dockManager);

    /**
     * Virtual Destructor
     */
    ~DockFocusController() override;

    /**
     * Helper function to set focus depending on the configuration of the
     * FocusStyling flag
     */
    template <class QWidgetPtr>
    static void setWidgetFocus(QWidgetPtr widget)
    {
        if (!DockManager::testConfigFlag(DockManager::FocusHighlighting))
            return;

        widget->setFocus(Qt::OtherFocusReason);
    }

    /**
     * A container needs to call this function if a widget has been dropped
     * into it
     */
    void notifyWidgetOrAreaRelocation(QWidget *relocatedWidget);

    /**
     * This function is called, if a floating widget has been dropped into
     * an new position.
     * When this function is called, all dock widgets of the FloatingWidget
     * are already inserted into its new position
     */
    void notifyFloatingWidgetDrop(FloatingDockContainer *floatingWidget);

    /**
     * Request a focus change to the given dock widget
     */
    void setDockWidgetFocused(DockWidget *focusedNow);
}; // class DockFocusController

} // namespace ADS
