% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callMutationBurden.R
\name{callMutationBurden}
\alias{callMutationBurden}
\title{Call mutation burden}
\usage{
callMutationBurden(
  res,
  id = 1,
  remove.flagged = TRUE,
  min.prior.somatic = 0.1,
  max.prior.somatic = 1,
  min.cellfraction = 0,
  fun.countMutation = function(vcf) width(vcf) == 1,
  callable = NULL,
  exclude = NULL
)
}
\arguments{
\item{res}{Return object of the \code{\link{runAbsoluteCN}} function.}

\item{id}{Candidate solution to extract mutation burden from.
\code{id=1} will use the maximum likelihood solution.}

\item{remove.flagged}{Remove variants flagged by
\code{\link{predictSomatic}}.}

\item{min.prior.somatic}{Exclude variants with somatic prior
probability lower than this cutoff.}

\item{max.prior.somatic}{Exclude variants with somatic prior
probability higher than this cutoff. This is useful for removing
hotspot mutations in small panels that might inflate the mutation
burden.}

\item{min.cellfraction}{Exclude variants with cellular fraction
lower than this cutoff. These are sub-clonal mutations or artifacts
with very low allelic fraction.}

\item{fun.countMutation}{Function that can be used to filter the
input VCF further for filtering, for example to only keep missense
mutations. Expects a \code{logical} vector indicating whether variant
should be counted (\code{TRUE}) or not (\code{FALSE}). Default
is to keep only single nucleotide variants.}

\item{callable}{\code{GRanges} object with callable genomic regions,
for example obtained by \sQuote{GATK CallableLoci} BED file, imported
with \code{rtracklayer}.}

\item{exclude}{\code{GRanges} object with genomic regions that
should be excluded from the \code{callable} regions, for example
intronic regions. Requires \code{callable}.}
}
\value{
Returns \code{data.frame} with mutation counts and sizes
of callable regions.
}
\description{
This function provides detailed mutation burden information.
}
\examples{

data(purecn.example.output)
callMutationBurden(purecn.example.output)

# To calculate exact mutations per megabase, we can provide a BED
# file containing all callable regions
callableBed <- import(system.file("extdata", "example_callable.bed.gz",
    package = "PureCN"))

# We can exclude some regions for mutation burden calculation,
# for example intronic regions. 
exclude <- GRanges(seqnames = "chr1", IRanges(start = 1, 
    end = max(end(callableBed))))

# We can also exclude specific mutations by filtering the input VCF
myVcfFilter <- function(vcf) seqnames(vcf)!="chr2"

callsCallable <- callMutationBurden(purecn.example.output,
    callable = callableBed, exclude = exclude,
    fun.countMutation = myVcfFilter)

}
\seealso{
\code{\link{runAbsoluteCN}} \code{\link{predictSomatic}}
}
\author{
Markus Riester
}
