% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whichNonZero.R
\name{whichNonZero}
\alias{whichNonZero}
\alias{whichNonZero,dgTMatrix-method}
\alias{whichNonZero,dgCMatrix-method}
\alias{whichNonZero,ANY-method}
\title{Find non-zero entries of a matrix}
\usage{
whichNonZero(x, ...)

\S4method{whichNonZero}{dgTMatrix}(x, ...)

\S4method{whichNonZero}{dgCMatrix}(x, ...)

\S4method{whichNonZero}{ANY}(x, BPPARAM = SerialParam(), ...)
}
\arguments{
\item{x}{A numeric matrix-like object, usually sparse in content if not in representation.}

\item{...}{For the generic, additional arguments to pass to the specific methods.

For the methods, additional arguments that are currently ignored.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object controlling how parallelization should be performed.
only used when \code{x} is a \linkS4class{DelayedMatrix} object.}
}
\value{
A list containing \code{i}, an integer vector of the row indices of all non-zero entries;
\code{j}, an integer vector of the column indices of all non-zero entries;
and \code{x}, a numeric vector of the values of the non-zero entries.
}
\description{
Finds the non-zero entries of a matrix in the most efficient manner.
Not sure there's much more to say here.
}
\examples{
x <- Matrix::rsparsematrix(1e6, 1e6, 0.000001)
out <- whichNonZero(x)
str(out)

}
\seealso{
\code{\link{which}}, obviously.
}
\author{
Aaron Lun
}
