% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon_state.R
\name{taxon_state}
\alias{taxon_state}
\title{Keep track of queries in \verb{get_*} functions}
\description{
Keep track of queries in \verb{get_*} functions

Keep track of queries in \verb{get_*} functions
}
\details{
This object lives inside each \verb{get_*} function call, maintaining
results as they are accumulated.
}
\examples{
\dontrun{
if (interactive()) {
ts <- taxon_state$new()
taxon_last()
ts
res <- list(
  id = 123456,
  att = "found",
  multiple = FALSE,
  direct = FALSE,
  class = "tsn"
)
ts$add(query = "Quercus robur", result = res)
ts
ts$get(query = "Quercus robur")
ts$count
ts$remove(query = "Quercus robur")
ts
ts$count

res2 <- list(
  id = 3430834535,
  att = "found",
  multiple = FALSE,
  direct = FALSE,
  class = "gbifid"
)
ts$add(query = "Poa annua", result = res2)
res3 <- list(
  id = 1223424,
  att = "found",
  multiple = FALSE,
  direct = FALSE,
  class = "uid"
)
ts$add(query = "Puma concolor", result = res3)
ts
ts$count
ts$get("Puma concolor")
ts$get()

# cleanup
ts$purge()
ts$count
}
}
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{initialized}}{(time) time job started}

\item{\code{finalized}}{(time) time job finished}

\item{\code{class}}{(character) a class name (e.g., "gbif")}

\item{\code{names}}{(character) one or more taxon names}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{count}}{(integer) count number of records}

\item{\code{exit}}{record date/time function exited}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{taxon_state$new()}}
\item \href{#method-print}{\code{taxon_state$print()}}
\item \href{#method-add}{\code{taxon_state$add()}}
\item \href{#method-get}{\code{taxon_state$get()}}
\item \href{#method-remove}{\code{taxon_state$remove()}}
\item \href{#method-purge}{\code{taxon_state$purge()}}
\item \href{#method-taxa_remaining}{\code{taxon_state$taxa_remaining()}}
\item \href{#method-taxa_completed}{\code{taxon_state$taxa_completed()}}
\item \href{#method-clone}{\code{taxon_state$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{taxon_state} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taxon_state$new(class, names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{class}}{(character) a class name (e.g., "gbif")}

\item{\code{names}}{(character) one or more taxon names}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{taxon_state} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print method for the \code{taxon_state} class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taxon_state$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add"></a>}}
\if{latex}{\out{\hypertarget{method-add}{}}}
\subsection{Method \code{add()}}{
add a record with it's result; duplicates allowed
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taxon_state$add(query, result)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{(character), a taxon name}

\item{\code{result}}{(list) a named list}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned; sets only
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
get all records matching 'query'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taxon_state$get(query = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{(character), a taxon name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a named list, with slots for the taxon id, and other attributes,
named by the taxon name
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove"></a>}}
\if{latex}{\out{\hypertarget{method-remove}{}}}
\subsection{Method \code{remove()}}{
remove's all records matching 'query'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taxon_state$remove(query)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{(character), a taxon name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing, removes records matching query
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-purge"></a>}}
\if{latex}{\out{\hypertarget{method-purge}{}}}
\subsection{Method \code{purge()}}{
removes all records
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taxon_state$purge()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
nothing returned; sets only
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taxa_remaining"></a>}}
\if{latex}{\out{\hypertarget{method-taxa_remaining}{}}}
\subsection{Method \code{taxa_remaining()}}{
get remaining taxa
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taxon_state$taxa_remaining()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
sorted taxon names
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taxa_completed"></a>}}
\if{latex}{\out{\hypertarget{method-taxa_completed}{}}}
\subsection{Method \code{taxa_completed()}}{
get completed taxa
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taxon_state$taxa_completed()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
sorted taxon names
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taxon_state$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
