% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-vector.R
\name{all_of}
\alias{all_of}
\alias{any_of}
\title{Select variables from character vectors}
\usage{
all_of(x)

any_of(x, ..., vars = NULL)
}
\arguments{
\item{x}{A vector of character names or numeric locations.}

\item{...}{These dots are for future extensions and must be empty.}

\item{vars}{A character vector of variable names. If not supplied,
the variables are taken from the current selection context (as
established by functions like \code{select()} or \code{pivot_longer()}).}
}
\description{
These \link[=language]{selection helpers} select variables
contained in a character vector. They are especially useful for
programming with selecting functions.
\itemize{
\item \code{\link[=all_of]{all_of()}} is for strict selection. If any of the variables in
the character vector is missing, an error is thrown.
\item \code{\link[=any_of]{any_of()}} doesn't check for missing variables. It is especially
useful with negative selections, when you would like to make sure
a variable is removed.
}

The order of selected columns is determined by the order in the
vector.
}
\section{Examples}{


Selection helpers can be used in functions like \code{dplyr::select()}
or \code{tidyr::pivot_longer()}. Let's first attach the tidyverse:\if{html}{\out{<div class="r">}}\preformatted{library(tidyverse)

# For better printing
iris <- as_tibble(iris)
}\if{html}{\out{</div>}}

It is a common to have a names of variables in a vector.\if{html}{\out{<div class="r">}}\preformatted{vars <- c("Sepal.Length", "Sepal.Width")

iris[, vars]
#> # A tibble: 150 x 2
#>   Sepal.Length Sepal.Width
#>          <dbl>       <dbl>
#> 1          5.1         3.5
#> 2          4.9         3  
#> 3          4.7         3.2
#> 4          4.6         3.1
#> # ... with 146 more rows
}\if{html}{\out{</div>}}

To refer to these variables in selecting function, use \code{all_of()}:\if{html}{\out{<div class="r">}}\preformatted{iris \%>\% select(all_of(vars))
#> # A tibble: 150 x 2
#>   Sepal.Length Sepal.Width
#>          <dbl>       <dbl>
#> 1          5.1         3.5
#> 2          4.9         3  
#> 3          4.7         3.2
#> 4          4.6         3.1
#> # ... with 146 more rows

iris \%>\% pivot_longer(all_of(vars))
#> # A tibble: 300 x 5
#>   Petal.Length Petal.Width Species name         value
#>          <dbl>       <dbl> <fct>   <chr>        <dbl>
#> 1          1.4         0.2 setosa  Sepal.Length   5.1
#> 2          1.4         0.2 setosa  Sepal.Width    3.5
#> 3          1.4         0.2 setosa  Sepal.Length   4.9
#> 4          1.4         0.2 setosa  Sepal.Width    3  
#> # ... with 296 more rows
}\if{html}{\out{</div>}}

If any of the variable is missing from the data frame, that's an error:\if{html}{\out{<div class="r">}}\preformatted{starwars \%>\% select(all_of(vars))
}\if{html}{\out{</div>}}\preformatted{## Error: Can't subset columns that don't exist.
## x Columns `Sepal.Length` and `Sepal.Width` don't exist.
}

Use \code{any_of()} to allow missing variables:\if{html}{\out{<div class="r">}}\preformatted{starwars \%>\% select(any_of(vars))
#> # A tibble: 87 x 0
}\if{html}{\out{</div>}}

\code{any_of()} is especially useful to remove variables from a data
frame because calling it again does not cause an error:\if{html}{\out{<div class="r">}}\preformatted{iris \%>\% select(-any_of(vars))
#> # A tibble: 150 x 3
#>   Petal.Length Petal.Width Species
#>          <dbl>       <dbl> <fct>  
#> 1          1.4         0.2 setosa 
#> 2          1.4         0.2 setosa 
#> 3          1.3         0.2 setosa 
#> 4          1.5         0.2 setosa 
#> # ... with 146 more rows

iris \%>\% select(-any_of(vars)) \%>\% select(-any_of(vars))
#> # A tibble: 150 x 3
#>   Petal.Length Petal.Width Species
#>          <dbl>       <dbl> <fct>  
#> 1          1.4         0.2 setosa 
#> 2          1.4         0.2 setosa 
#> 3          1.3         0.2 setosa 
#> 4          1.5         0.2 setosa 
#> # ... with 146 more rows
}\if{html}{\out{</div>}}
}

\seealso{
The \link[=language]{selection language} page, which includes links to other selection helpers.
}
