# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2020 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from ExternalSensorManager.idl.

use strict;

package Raritan::RPC::sensors::ExternalSensorManager_2_0_0;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "sensors.ExternalSensorManager:2.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::sensors::ExternalSensorManager_2_0_0::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant ERR_INVALID_PARAMS => 1;

use constant ERR_NOT_SUPPORTED => 2;


sub getExternalSensorSlots($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getExternalSensorSlots', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}->[$i0], 'sensors.ExternalSensorSlot');
    }
    return $_ret_;
}

use Raritan::RPC::sensors::ExternalSensorData_2_0_0;

sub getDiscoveredExternalSensors($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getDiscoveredExternalSensors', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::sensors::ExternalSensorData_2_0_0::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

use Raritan::RPC::sensors::ExternalSensorManager_2_0_0::Settings;

sub getSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::sensors::ExternalSensorManager_2_0_0::Settings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::sensors::ExternalSensorManager_2_0_0::Settings;

sub setSettings($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::sensors::ExternalSensorManager_2_0_0::Settings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::sensors::ExternalSensorManager_2_0_0::MetaData;

sub getMetaData($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getMetaData', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::sensors::ExternalSensorManager_2_0_0::MetaData::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

sub setPortPower($$$) {
    my ($self, $port, $hasPower) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'port'} = 1 * $port;
    $args->{'hasPower'} = ($hasPower) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setPortPower', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub setAllPortPower($$) {
    my ($self, $hasPower) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'hasPower'} = ($hasPower) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setAllPortPower', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('sensors.ExternalSensorManager', 2, 0, 0, 'Raritan::RPC::sensors::ExternalSensorManager_2_0_0');
1;
