# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2020 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "DisplayControl.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.display

import raritan.rpc.event


# interface
class DisplayControl(Interface):
    idlType = "display.DisplayControl:1.0.1"

    SUCCESS = 0

    ERR_INVALID_VALUE = 1

    # structure
    class Info(Structure):
        idlType = "display.DisplayControl_1_0_1.Info:1.0.0"
        elements = ["fwAppVersion", "fwBootVersion", "orientation", "width", "height", "versionAvailable"]

        def __init__(self, fwAppVersion, fwBootVersion, orientation, width, height, versionAvailable):
            typecheck.is_int(fwAppVersion, AssertionError)
            typecheck.is_int(fwBootVersion, AssertionError)
            typecheck.is_int(orientation, AssertionError)
            typecheck.is_int(width, AssertionError)
            typecheck.is_int(height, AssertionError)
            typecheck.is_bool(versionAvailable, AssertionError)

            self.fwAppVersion = fwAppVersion
            self.fwBootVersion = fwBootVersion
            self.orientation = orientation
            self.width = width
            self.height = height
            self.versionAvailable = versionAvailable

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                fwAppVersion = json['fwAppVersion'],
                fwBootVersion = json['fwBootVersion'],
                orientation = json['orientation'],
                width = json['width'],
                height = json['height'],
                versionAvailable = json['versionAvailable'],
            )
            return obj

        def encode(self):
            json = {}
            json['fwAppVersion'] = self.fwAppVersion
            json['fwBootVersion'] = self.fwBootVersion
            json['orientation'] = self.orientation
            json['width'] = self.width
            json['height'] = self.height
            json['versionAvailable'] = self.versionAvailable
            return json

    # structure
    class DefaultViewItem(Structure):
        idlType = "display.DisplayControl_1_0_1.DefaultViewItem:1.0.0"
        elements = ["id", "description"]

        def __init__(self, id, description):
            typecheck.is_string(id, AssertionError)
            typecheck.is_string(description, AssertionError)

            self.id = id
            self.description = description

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                id = json['id'],
                description = json['description'],
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = self.id
            json['description'] = self.description
            return json

    # value object
    class DefaultViewChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "display.DisplayControl_1_0_1.DefaultViewChangedEvent:1.0.0"

        def __init__(self, newView, actUserName, actIpAddr, source):
            super(raritan.rpc.display.DisplayControl.DefaultViewChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_struct(newView, raritan.rpc.display.DisplayControl.DefaultViewItem, AssertionError)

            self.newView = newView

        def encode(self):
            json = super(raritan.rpc.display.DisplayControl.DefaultViewChangedEvent, self).encode()
            json['newView'] = raritan.rpc.display.DisplayControl.DefaultViewItem.encode(self.newView)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                newView = raritan.rpc.display.DisplayControl.DefaultViewItem.decode(json['newView'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["newView"]
            elements = elements + super(raritan.rpc.display.DisplayControl.DefaultViewChangedEvent, self).listElements()
            return elements

    class _getAvailableDefaultViews(Interface.Method):
        name = 'getAvailableDefaultViews'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.display.DisplayControl.DefaultViewItem.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.display.DisplayControl.DefaultViewItem, DecodeException)
            return _ret_

    class _getDefaultView(Interface.Method):
        name = 'getDefaultView'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_string(_ret_, DecodeException)
            return _ret_

    class _setDefaultView(Interface.Method):
        name = 'setDefaultView'

        @staticmethod
        def encode(id):
            typecheck.is_string(id, AssertionError)
            args = {}
            args['id'] = id
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getInfo(Interface.Method):
        name = 'getInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.display.DisplayControl.Info.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.display.DisplayControl.Info, DecodeException)
            return _ret_

    class _showSmiley(Interface.Method):
        name = 'showSmiley'

        @staticmethod
        def encode(on, happy, msg):
            typecheck.is_bool(on, AssertionError)
            typecheck.is_bool(happy, AssertionError)
            typecheck.is_string(msg, AssertionError)
            args = {}
            args['on'] = on
            args['happy'] = happy
            args['msg'] = msg
            return args

        @staticmethod
        def decode(rsp, agent):
            return None
    def __init__(self, target, agent):
        super(DisplayControl, self).__init__(target, agent)
        self.getAvailableDefaultViews = DisplayControl._getAvailableDefaultViews(self)
        self.getDefaultView = DisplayControl._getDefaultView(self)
        self.setDefaultView = DisplayControl._setDefaultView(self)
        self.getInfo = DisplayControl._getInfo(self)
        self.showSmiley = DisplayControl._showSmiley(self)
