// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Ade.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.pdumodel {
  public class Ade : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Ade:1.0.0", null);

    public Ade(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Ade(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Ade StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Ade(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class MetaData : ICloneable {
      public object Clone() {
        MetaData copy = new MetaData();
        copy.adeType = this.adeType;
        copy.channels = this.channels;
        copy.currentDivider = this.currentDivider;
        copy.voltageDivider = this.voltageDivider;
        copy.energyDivider = this.energyDivider;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["adeType"] = this.adeType;
        json["channels"] = this.channels;
        json["currentDivider"] = this.currentDivider;
        json["voltageDivider"] = this.voltageDivider;
        json["energyDivider"] = this.energyDivider;
        return json;
      }

      public static MetaData Decode(LightJson.JsonObject json, Agent agent) {
        MetaData inst = new MetaData();
        inst.adeType = (string)json["adeType"];
        inst.channels = (int)json["channels"];
        inst.currentDivider = (double)json["currentDivider"];
        inst.voltageDivider = (double)json["voltageDivider"];
        inst.energyDivider = (double)json["energyDivider"];
        return inst;
      }

      public string adeType = "";
      public int channels = 0;
      public double currentDivider = 0.0;
      public double voltageDivider = 0.0;
      public double energyDivider = 0.0;
    }

    public class Sample : ICloneable {
      public object Clone() {
        Sample copy = new Sample();
        copy.vrms = this.vrms;
        copy.irms = this.irms;
        copy.watt = this.watt;
        copy.va = this.va;
        copy.wh = this.wh;
        copy.vah = this.vah;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["vrms"] = this.vrms;
        json["irms"] = this.irms;
        json["watt"] = this.watt;
        json["va"] = this.va;
        json["wh"] = this.wh;
        json["vah"] = this.vah;
        return json;
      }

      public static Sample Decode(LightJson.JsonObject json, Agent agent) {
        Sample inst = new Sample();
        inst.vrms = (long)json["vrms"];
        inst.irms = (long)json["irms"];
        inst.watt = (long)json["watt"];
        inst.va = (long)json["va"];
        inst.wh = (long)json["wh"];
        inst.vah = (long)json["vah"];
        return inst;
      }

      public long vrms = 0;
      public long irms = 0;
      public long watt = 0;
      public long va = 0;
      public long wh = 0;
      public long vah = 0;
    }

    public class GetMetaDataResult {
      public Com.Raritan.Idl.pdumodel.Ade.MetaData _ret_;
    }

    public GetMetaDataResult getMetaData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Ade.MetaData.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Ade.MetaData.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetLatestSampleResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Ade.Sample> _ret_;
    }

    public GetLatestSampleResult getLatestSample() {
      JsonObject _parameters = null;
      var _result = RpcCall("getLatestSample", _parameters);
      var _ret = new GetLatestSampleResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Ade.Sample>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.pdumodel.Ade.Sample.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getLatestSample(AsyncRpcResponse<GetLatestSampleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getLatestSample(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getLatestSample(AsyncRpcResponse<GetLatestSampleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getLatestSample", _parameters,
        _result => {
          try {
            var _ret = new GetLatestSampleResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Ade.Sample>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.pdumodel.Ade.Sample.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetCalibrationDataResult {
      public System.Collections.Generic.IDictionary<string, long> _ret_;
    }

    public GetCalibrationDataResult getCalibrationData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getCalibrationData", _parameters);
      var _ret = new GetCalibrationDataResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<string, long>(_value["key"], (long)_value["value"])));
      return _ret;
    }

    public AsyncRequest getCalibrationData(AsyncRpcResponse<GetCalibrationDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getCalibrationData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getCalibrationData(AsyncRpcResponse<GetCalibrationDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getCalibrationData", _parameters,
        _result => {
          try {
            var _ret = new GetCalibrationDataResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<string, long>(_value["key"], (long)_value["value"])));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetCalibrationDataResult {
      public int _ret_;
    }

    public SetCalibrationDataResult setCalibrationData(System.Collections.Generic.IDictionary<string, long> regs) {
      var _parameters = new LightJson.JsonObject();
      _parameters["regs"] = new JsonArray(regs.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value)
      })));

      var _result = RpcCall("setCalibrationData", _parameters);
      var _ret = new SetCalibrationDataResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setCalibrationData(System.Collections.Generic.IDictionary<string, long> regs, AsyncRpcResponse<SetCalibrationDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setCalibrationData(regs, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setCalibrationData(System.Collections.Generic.IDictionary<string, long> regs, AsyncRpcResponse<SetCalibrationDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["regs"] = new JsonArray(regs.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value)
        })));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setCalibrationData", _parameters,
        _result => {
          try {
            var _ret = new SetCalibrationDataResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
