/**
 * Copyright (c) Tiny Technologies, Inc. All rights reserved.
 * Licensed under the LGPL or a commercial license.
 * For LGPL see License.txt in the project root for license information.
 * For commercial licenses see https://www.tiny.cloud/
 */

import Env from 'tinymce/core/api/Env';

const meta = Env.mac ? '\u2318' : 'Ctrl';
const access = Env.mac ? 'Ctrl + Alt' : 'Shift + Alt';

const shortcuts = [
  { shortcut: meta + ' + B', action: 'Bold' },
  { shortcut: meta + ' + I', action: 'Italic' },
  { shortcut: meta + ' + U', action: 'Underline' },
  { shortcut: meta + ' + A', action: 'Select all' },
  { shortcut: meta + ' + Y or ' + meta + ' + Shift + Z', action: 'Redo' },
  { shortcut: meta + ' + Z', action: 'Undo' },
  { shortcut: access + ' + 1', action: 'Header 1' },
  { shortcut: access + ' + 2', action: 'Header 2' },
  { shortcut: access + ' + 3', action: 'Header 3' },
  { shortcut: access + ' + 4', action: 'Header 4' },
  { shortcut: access + ' + 5', action: 'Header 5' },
  { shortcut: access + ' + 6', action: 'Header 6' },
  { shortcut: access + ' + 7', action: 'Paragraph' },
  { shortcut: access + ' + 8', action: 'Div' },
  { shortcut: access + ' + 9', action: 'Address' },
  { shortcut: 'Alt + F9', action: 'Focus to menubar' },
  { shortcut: 'Alt + F10', action: 'Focus to toolbar' },
  { shortcut: 'Alt + F11', action: 'Focus to element path' },
  {
    shortcut: 'Ctrl + F9',
    action: 'Focus to contextual toolbar'
  },
  { shortcut: meta + ' + K', action: 'Insert link (if link plugin activated)' },
  { shortcut: meta + ' + S', action: 'Save (if save plugin activated)' },
  { shortcut: meta + ' + F', action: 'Find (if searchreplace plugin activated)' }
];

export default {
  shortcuts
};