# 2022-07-12 Triage Log

A fairly noisy week (many entries below dropped and untagged as regressions),
largely driven by tt-muncher and html5ever. Our sensitivity assessment currently
takes roughly a week since new noise starts to learn the noise level, so it can
take some time for oscillations to stop reporting somewhat spurious results.

Otherwise, this week had a number of solid improvements, and was overall
positive, with improvements across many benchmarks.

Triage done by **@simulacrum**.
Revision range: [880646ca9c6dc21e04efe2f1940369a45b71ff2d..b3f4c3119957aa0a250cab08ab586b7a9a680ef1](https://perf.rust-lang.org/?start=880646ca9c6dc21e04efe2f1940369a45b71ff2d&end=b3f4c3119957aa0a250cab08ab586b7a9a680ef1&absolute=false&stat=instructions%3Au)

**Summary**:

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.7% | 1.4% | 19    |
| Regressions 😿 <br /> (secondary) | 2.1% | 5.3% | 13    |
| Improvements 🎉 <br /> (primary) | -1.1% | -2.5% | 153   |
| Improvements 🎉 <br /> (secondary) | -2.1% | -9.9% | 121   |
| All 😿🎉 (primary) | -0.9% | -2.5% | 172   |


3 Regressions, 6 Improvements, 3 Mixed; 3 of them in rollups
53 artifact comparisons made in total

#### Regressions

Make lowering a query [#95573](https://github.com/rust-lang/rust/pull/95573)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3e51277fe638dc0c8ceb6d1d3acc5aa247277c29&end=0f573a0c5474ad65bc9f0b0fd3a94d1b06dcfdfa&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.5% | 1.1% | 76    |
| Regressions 😿 <br /> (secondary) | 0.8% | 2.4% | 57    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -0.2% | -0.2% | 1     |
| All 😿🎉 (primary) | 0.5% | 1.1% | 76    |

These results may partially be noise, and are overall limited enough in impact
that further investigation is not warranted at this time. Marked as triaged.

Rollup of 6 pull requests [#99047](https://github.com/rust-lang/rust/pull/99047)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=eba361ae36be41e42fb8fdf138455307e0ad407c&end=0f97e02bdc7a53176aa96a53ff8b533947d7649c&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 1.9% | 4.0% | 13    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | N/A  | N/A | 0     |

Looks to be a genuine regression, far exceeding the noise bound for the
[deeply-nested-multi benchmark][noise-graph-99047]. (This is the 4% spike on
that graph). Maybe caused by #98795, needs a little further investigation.

[noise-graph-99047]: https://perf.rust-lang.org/index.html?start=2022-06-08&end=2022-07-12&benchmark=deeply-nested-multi&profile=check&scenario=full&stat=instructions:u&kind=percentrelative

Enforce that layout size fits in isize in Layout [#95295](https://github.com/rust-lang/rust/pull/95295)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=95e77648e466c780a9adce2fa3d3eb5e423dc04e&end=4ec97d991b1bd86dc89fee761d79ac8e85239a08&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.5% | 1.5% | 106   |
| Regressions 😿 <br /> (secondary) | 0.6% | 1.7% | 39    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -1.3% | -1.5% | 6     |
| All 😿🎉 (primary) | 0.5% | 1.5% | 106   |

As noted on the PR (thanks for triaging perf regressions!), this is a limited
in magnitude and a justified regression for a soundness fix. See
this [comment](https://github.com/rust-lang/rust/pull/95295#issuecomment-1179744091) for details.

#### Improvements

continue nll transition by removing stuff [#98584](https://github.com/rust-lang/rust/pull/98584)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=54f79babae06d3772c067f696e5b12db822ae25f&end=efb171e2350de2bec6dd1f035b99bc00535c1c15&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -1.0% | -2.3% | 66    |
| Improvements 🎉 <br /> (secondary) | -1.2% | -3.6% | 63    |
| All 😿🎉 (primary) | -1.0% | -2.3% | 66    |


interpret: remove support for unsized_locals [#98831](https://github.com/rust-lang/rust/pull/98831)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7665c3543079ebc3710b676d0fd6951bedfd4b29&end=8824d131619e58a38bde8bcf56401629b91a204a&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -0.6% | -0.8% | 11    |
| All 😿🎉 (primary) | N/A  | N/A | 0     |

Use a bitset instead of a hash map in HIR ID validator [#98841](https://github.com/rust-lang/rust/pull/98841)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e78e747f53c36e53ff99c94438d2efa26830fc4b&end=c461f7a16e8372216dbf7a54ab86ee958bec83b5&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.8% | -1.7% | 123   |
| Improvements 🎉 <br /> (secondary) | -0.8% | -2.0% | 82    |
| All 😿🎉 (primary) | -0.8% | -1.7% | 123   |

don't use `commit_if_ok` during `higher_ranked_sub` [#99056](https://github.com/rust-lang/rust/pull/99056)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f893495e3da91dc319d37861b803eed9d6c8c7c7&end=6dba4ed215e7a60f0a2a19c04f3f73691f89c509&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.7% | -0.7% | 7     |
| Improvements 🎉 <br /> (secondary) | -0.8% | -0.9% | 6     |
| All 😿🎉 (primary) | -0.7% | -0.7% | 7     |

More derive output improvements [#98758](https://github.com/rust-lang/rust/pull/98758)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1dcff2d5077244f49687ea25070958f23bd9edc6&end=fbdb07f4e7f4666085aec4b1ed2fd05817dc42cf&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.6% | 0.8% | 2     |
| Regressions 😿 <br /> (secondary) | 1.6% | 2.3% | 10    |
| Improvements 🎉 <br /> (primary) | -0.4% | -0.6% | 55    |
| Improvements 🎉 <br /> (secondary) | -2.1% | -8.0% | 34    |
| All 😿🎉 (primary) | -0.4% | 0.8% | 57    |

Regressions appear primarily in tt-muncher and are spurious noise; cargo and
image also show slight regressions but much smaller in comparative magnitude.
Overall a small, but solid improvement.

Miscellaneous inlining improvements [#99028](https://github.com/rust-lang/rust/pull/99028)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=db78ab70a88a0a5e89031d7ee4eccec835dcdbde&end=86b8dd5389cd9d545418a60902222a4ba859365f&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 0.7% | 1.4% | 13    |
| Improvements 🎉 <br /> (primary) | -0.4% | -0.9% | 124   |
| Improvements 🎉 <br /> (secondary) | -0.5% | -1.0% | 62    |
| All 😿🎉 (primary) | -0.4% | -0.9% | 124   |

#### Mixed

Rollup of 7 pull requests [#98987](https://github.com/rust-lang/rust/pull/98987)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3dcb616888aac50d55160b025266d555dad937d9&end=7665c3543079ebc3710b676d0fd6951bedfd4b29&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.6% | 0.6% | 1     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.2% | -0.2% | 1     |
| Improvements 🎉 <br /> (secondary) | -0.3% | -0.6% | 9     |
| All 😿🎉 (primary) | 0.2% | 0.6% | 2     |


Rollup of 8 pull requests [#99014](https://github.com/rust-lang/rust/pull/99014)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=20dd6930134d07a5ef90393a040a1594ac8d714c&end=3e51277fe638dc0c8ceb6d1d3acc5aa247277c29&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.5% | 0.5% | 1     |
| Regressions 😿 <br /> (secondary) | 0.3% | 0.3% | 1     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -1.3% | -1.5% | 6     |
| All 😿🎉 (primary) | 0.5% | 0.5% | 1     |

Don't allow ZST in ScalarInt  [#98957](https://github.com/rust-lang/rust/pull/98957)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6c20ab744b0f82646d90ce9d25894823abc9c669&end=f893495e3da91dc319d37861b803eed9d6c8c7c7&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 4.4% | 4.4% | 2     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -0.4% | -0.4% | 2     |
| All 😿🎉 (primary) | N/A  | N/A | 0     |
