# 2021-04-06 Triage Log

A pretty major week for [memory usage improvements], while wall time performance
largely stayed neutral, with an average of ~20% gains on memory usage for
release builds, and 5% on check builds, due to an update in the default allocator
used (to a more recent jemalloc).

Triage done by **@simulacrum**.
Revision range: [4896450e7e0a522486b4d3a8d360ac4e1d2072a0..d32238532138485c80db4f2cd596372bce214e00](https://perf.rust-lang.org/?start=4896450e7e0a522486b4d3a8d360ac4e1d2072a0&end=d32238532138485c80db4f2cd596372bce214e00&absolute=false&stat=instructions%3Au)

[memory usage improvements]: https://perf.rust-lang.org/?start=4896450e7e0a522486b4d3a8d360ac4e1d2072a0&end=d32238532138485c80db4f2cd596372bce214e00&absolute=false&stat=max-rss

1 Regressions, 4 Improvements, 0 Mixed

#### Regressions

add OR_PATTERNS_BACK_COMPAT lint [#83468](https://github.com/rust-lang/rust/issues/83468)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a207871d5c22f89093085da89becbb636a45ef89&end=36bcf4069717b9dff90270d13b53a3b130329960&stat=instructions:u) (up to 1.2% on `incr-patched: println` builds of `coercions-debug`)
- Relatively small hit on a number of benchmarks. Likely largely unavoidable.

#### Improvements

Stream the dep-graph to a file instead of storing it in-memory [#82780](https://github.com/rust-lang/rust/pull/82780)
- Large improvement in [memory usage](https://perf.rust-lang.org/compare.html?start=803ddb83598838fb9de308d283b759ba463e5e80&end=d474075a8f28ae9a410e95d849d009006db4b176&stat=max-rss)

panic early when `TrustedLen` indicates a `length > usize::MAX` [#83726](https://github.com/rust-lang/rust/issues/83726)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=49e1ec09952c5ab7798addd29532d44dc020283f&end=803ddb83598838fb9de308d283b759ba463e5e80&stat=instructions:u) (up to -7.9% on `incr-patched: compile one` builds of `regex-debug`)

Use tikv-jemallocator in rustc/rustdoc in addition to jemalloc-sys when enabled. [#83152](https://github.com/rust-lang/rust/issues/83152)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=d203fceeb12f8c0e3123fc45036575018d2f990a&end=d32238532138485c80db4f2cd596372bce214e00&stat=instructions:u) (up to -5.4% on `incr-unchanged` builds of `deep-vector-check`)
- Pretty nice improvements to instruction counts, though not a major contributor
  to wall times it seems.

Stream the dep-graph to a file instead of storing it in-memory. [#82780](https://github.com/rust-lang/rust/issues/82780)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=803ddb83598838fb9de308d283b759ba463e5e80&end=d474075a8f28ae9a410e95d849d009006db4b176&stat=instructions:u) (up to -1.8% on `incr-full` builds of `unused-warnings-check`)

#### Mixed

- None

#### Nags requiring follow up

- The [issue](https://github.com/rust-lang/rust/pull/82964#issuecomment-800663588) from three weeks ago has stalled.
  Likely this needs someone to mentor the author, or to take over the
  investigation.
