# 2024-01-30 Triage Log

This was a very quiet week with only one PR having any real impact on overall compiler performance. The removal of the internal `StructuralEq` trait saw a roughly 0.4% improvement on average across nearly 50 real-world benchmarks. 

Triage done by **@rylev**.
Revision range: [d6b151fc7..5c9c3c7](https://perf.rust-lang.org/?start=d6b151fc77e213bf637db0f12c1965ace3ffe255&end=5c9c3c7871d603ba13d38372830eca0c9013e575&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.3%, 0.7%]   | 5     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 1.4%]   | 10    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.5%, -0.2%] | 48    |
| Improvements ✅ <br /> (secondary) | -2.3% | [-7.7%, -0.4%] | 36    |
| All ❌✅ (primary)                 | -0.4% | [-1.5%, 0.7%]  | 53    |


0 Regressions, 4 Improvements, 4 Mixed; 3 of them in rollups
37 artifact comparisons made in total

#### Regressions



#### Improvements

Only use dense bitsets in dataflow analyses [#116152](https://github.com/rust-lang/rust/pull/116152) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8b94152af68a0ed6d6af0b5ba57491e40481008e&end=0e4243538b9119654c22dce688f8a63c81864de9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.5%, -0.2%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.1%, -0.4%] | 2     |
| All ❌✅ (primary)                 | -0.4% | [-0.5%, -0.2%] | 5     |


const-eval interning: get rid of type-driven traversal [#119044](https://github.com/rust-lang/rust/pull/119044) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0e4243538b9119654c22dce688f8a63c81864de9&end=6265a95b3735a51cca1d48b8bbc3c8a6a035e15b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.1%, -0.8%] | 3     |
| Improvements ✅ <br /> (secondary) | -3.8% | [-8.0%, -0.6%] | 14    |
| All ❌✅ (primary)                 | -0.9% | [-1.1%, -0.8%] | 3     |


Remove all ConstPropNonsense [#119627](https://github.com/rust-lang/rust/pull/119627) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7ffc697ce10f19447c0ce338428ae4b9bc0c041c&end=68411c955458ffbc98649d6dd057c4be3b187f38&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.2%] | 11    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.5%, -0.5%] | 3     |
| All ❌✅ (primary)                 | -0.4% | [-0.6%, -0.2%] | 11    |


remove StructuralEq trait [#116167](https://github.com/rust-lang/rust/pull/116167) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0c1fb2a1e65a57073dc62dd502319a00cf753371&end=dd2559e08e1530806740931037d6bb83ef956161&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.2%] | 48    |
| Improvements ✅ <br /> (secondary) | -1.3% | [-3.0%, -0.3%] | 23    |
| All ❌✅ (primary)                 | -0.4% | [-0.6%, 0.3%]  | 49    |


#### Mixed

Rollup of 10 pull requests [#120335](https://github.com/rust-lang/rust/pull/120335) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d93feccb35183fa66fee77e7a2c9d4bf4d01695c&end=5bd5d214effd494f4bafb29b3a7a2f6c2070ca5c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.8%]   | 9     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.6%, 0.9%]   | 2     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-0.7%, -0.7%] | 1     |
| All ❌✅ (primary)                 | 0.4%  | [0.3%, 0.8%]   | 9     |
- Small regressions in doc benchmarks
- Most likely caused by [addings `AsyncFn` family of traits](https://github.com/rust-lang/rust/pull/119305).
- Author has been pinged, but it's probably acceptable cost given that we're documenting more.


Rollup of 9 pull requests [#120375](https://github.com/rust-lang/rust/pull/120375) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cdd4ff8d8179197ba25708e0d85a4fc30f0a4971&end=e7bbe8ce933123a8e327c79e38bcb790595e6a65&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.4%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 6     |
- Small number of improvements outweigh the small number of regressions and so it's not really worth investigating further.


Rollup of 12 pull requests [#120401](https://github.com/rust-lang/rust/pull/120401) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c073f56a416b541fc66e46fb5265dad870da9229&end=b362939be16f9324dd9e6e36e22b606020068d75&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.5%, 1.1%]   | 7     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -3.1% | [-3.1%, -3.1%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |
- Very small regressions in match stress test is not worth investigating


Merge into larger interval set [#120024](https://github.com/rust-lang/rust/pull/120024) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6b4f1c5e782c72a047a23e922decd33e7d462345&end=635124704849eeead4e3a7bb6e663c5351571d93&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 14    |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.2%] | 2     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.4%]   | 14    |
- The reviewer decided that the performance hit here was worth it given that we are now protecting against truly extreme cases that the perf benchmark suite doesn't test against. 
