<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\Console\Tests\Fixtures;

use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand('app:loop:example')]
class LoopExampleCommand extends AbstractLoopCommand
{
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $output->writeln(' Hello world');

        return Command::SUCCESS;
    }
}
