/*----- PROTECTED REGION ID(TangoTest.cpp) ENABLED START -----*/
static const char *RcsId = "$Id$";
//=============================================================================
//
// file :        TangoTest.cpp
//
// description : C++ source for the TangoTest class and its commands.
//               The class is derived from Device. It represents the
//               CORBA servant object which will be accessed from the
//               network. All commands which can be executed on the
//               TangoTest are implemented in this file.
//
// project :     TANGO Device Server for testing generic clients
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Author$
//
// $Revision$
// $Date$
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#include <math.h>
#include <tango.h>
#include <TangoTest.h>
#include <TangoTestClass.h>

#if defined(ENABLE_CRASH_REPORT)
# include <crashreporting/crash_report.h>
#endif

static const long kSpecLen = 256;
static const long kImagLen = 251;


/*----- PROTECTED REGION END -----*/	//	TangoTest.cpp

/**
 *  TangoTest class description:
 *    A device to test generic clients. It offers a \"echo\" like command for
 *    each TANGO data type (i.e. each command returns an exact copy of <argin>).
 */

//================================================================
//  The following table gives the correspondence
//  between command and method names.
//
//  Command name               |  Method name
//================================================================
//  State                      |  Inherited (no method)
//  Status                     |  Inherited (no method)
//  CrashFromDevelopperThread  |  crash_from_developper_thread
//  CrashFromOmniThread        |  crash_from_omni_thread
//  DevBoolean                 |  dev_boolean
//  DevDouble                  |  dev_double
//  DevFloat                   |  dev_float
//  DevLong                    |  dev_long
//  DevLong64                  |  dev_long64
//  DevShort                   |  dev_short
//  DevString                  |  dev_string
//  DevULong                   |  dev_ulong
//  DevULong64                 |  dev_ulong64
//  DevUShort                  |  dev_ushort
//  DevVarCharArray            |  dev_var_char_array
//  DevVarDoubleArray          |  dev_var_double_array
//  DevVarDoubleStringArray    |  dev_var_double_string_array
//  DevVarFloatArray           |  dev_var_float_array
//  DevVarLong64Array          |  dev_var_long64_array
//  DevVarLongArray            |  dev_var_long_array
//  DevVarLongStringArray      |  dev_var_long_string_array
//  DevVarShortArray           |  dev_var_short_array
//  DevVarStringArray          |  dev_var_string_array
//  DevVarULong64Array         |  dev_var_ulong64_array
//  DevVarULongArray           |  dev_var_ulong_array
//  DevVarUShortArray          |  dev_var_ushort_array
//  DevVoid                    |  dev_void
//  DumpExecutionState         |  dump_execution_state
//  SwitchStates               |  switch_states
//================================================================

//================================================================
//  Attributes managed are:
//================================================================
//  ampli                |  Tango::DevDouble	Scalar
//  boolean_scalar       |  Tango::DevBoolean	Scalar
//  double_scalar        |  Tango::DevDouble	Scalar
//  double_scalar_rww    |  Tango::DevDouble	Scalar
//  double_scalar_w      |  Tango::DevDouble	Scalar
//  float_scalar         |  Tango::DevFloat	Scalar
//  long64_scalar        |  Tango::DevLong64	Scalar
//  long_scalar          |  Tango::DevLong	Scalar
//  long_scalar_rww      |  Tango::DevLong	Scalar
//  long_scalar_w        |  Tango::DevLong	Scalar
//  no_value             |  Tango::DevLong	Scalar
//  short_scalar         |  Tango::DevShort	Scalar
//  short_scalar_ro      |  Tango::DevShort	Scalar
//  short_scalar_rww     |  Tango::DevShort	Scalar
//  short_scalar_w       |  Tango::DevShort	Scalar
//  string_scalar        |  Tango::DevString	Scalar
//  throw_exception      |  Tango::DevLong	Scalar
//  uchar_scalar         |  Tango::DevUChar	Scalar
//  ulong64_scalar       |  Tango::DevULong64	Scalar
//  ushort_scalar        |  Tango::DevUShort	Scalar
//  ulong_scalar         |  Tango::DevULong	Scalar
//  boolean_spectrum     |  Tango::DevBoolean	Spectrum  ( max = 4096)
//  boolean_spectrum_ro  |  Tango::DevBoolean	Spectrum  ( max = 4096)
//  double_spectrum      |  Tango::DevDouble	Spectrum  ( max = 4096)
//  double_spectrum_ro   |  Tango::DevDouble	Spectrum  ( max = 4096)
//  float_spectrum       |  Tango::DevFloat	Spectrum  ( max = 4096)
//  float_spectrum_ro    |  Tango::DevFloat	Spectrum  ( max = 4096)
//  long64_spectrum_ro   |  Tango::DevLong64	Spectrum  ( max = 4096)
//  long_spectrum        |  Tango::DevLong	Spectrum  ( max = 4096)
//  long_spectrum_ro     |  Tango::DevLong	Spectrum  ( max = 4096)
//  short_spectrum       |  Tango::DevShort	Spectrum  ( max = 4096)
//  short_spectrum_ro    |  Tango::DevShort	Spectrum  ( max = 4096)
//  string_spectrum      |  Tango::DevString	Spectrum  ( max = 256)
//  string_spectrum_ro   |  Tango::DevString	Spectrum  ( max = 256)
//  uchar_spectrum       |  Tango::DevUChar	Spectrum  ( max = 4096)
//  uchar_spectrum_ro    |  Tango::DevUChar	Spectrum  ( max = 4096)
//  ulong64_spectrum_ro  |  Tango::DevULong64	Spectrum  ( max = 4096)
//  ulong_spectrum_ro    |  Tango::DevULong	Spectrum  ( max = 4096)
//  ushort_spectrum      |  Tango::DevUShort	Spectrum  ( max = 4096)
//  ushort_spectrum_ro   |  Tango::DevUShort	Spectrum  ( max = 4096)
//  wave                 |  Tango::DevDouble	Spectrum  ( max = 4096)
//  boolean_image        |  Tango::DevBoolean	Image  ( max = 251 x 251)
//  boolean_image_ro     |  Tango::DevBoolean	Image  ( max = 251 x 251)
//  double_image         |  Tango::DevDouble	Image  ( max = 251 x 251)
//  double_image_ro      |  Tango::DevDouble	Image  ( max = 251 x 251)
//  float_image          |  Tango::DevFloat	Image  ( max = 251 x 251)
//  float_image_ro       |  Tango::DevFloat	Image  ( max = 251 x 251)
//  long64_image_ro      |  Tango::DevLong64	Image  ( max = 251 x 251)
//  long_image           |  Tango::DevLong	Image  ( max = 251 x 251)
//  long_image_ro        |  Tango::DevLong	Image  ( max = 251 x 251)
//  short_image          |  Tango::DevShort	Image  ( max = 251 x 251)
//  short_image_ro       |  Tango::DevShort	Image  ( max = 251 x 251)
//  string_image         |  Tango::DevString	Image  ( max = 256 x 256)
//  string_image_ro      |  Tango::DevString	Image  ( max = 256 x 256)
//  uchar_image          |  Tango::DevUChar	Image  ( max = 251 x 251)
//  uchar_image_ro       |  Tango::DevUChar	Image  ( max = 251 x 251)
//  ulong64_image_ro     |  Tango::DevULong64	Image  ( max = 251 x 251)
//  ulong_image_ro       |  Tango::DevULong	Image  ( max = 251 x 251)
//  ushort_image         |  Tango::DevUShort	Image  ( max = 251 x 251)
//  ushort_image_ro      |  Tango::DevUShort	Image  ( max = 8192 x 8192)
//================================================================

namespace TangoTest_ns
{
/*----- PROTECTED REGION ID(TangoTest::namespace_starting) ENABLED START -----*/

//	static initializations

//=============================================================================
// Class: DataGenerator (thread)
//=============================================================================
class DataGenerator : public omni_thread, public Tango::LogAdapter
{
public:
  DataGenerator (TangoTest& dev, long sleep_time)
    : omni_thread(),
      Tango::LogAdapter(&dev),
      go_on_(1),
      dev_(dev),
      sleep_time_(sleep_time),
      generate_crash_ (false)
  {
    // noop ctor
  }

  void go (void)
  {
    DEBUG_STREAM << "DataGenerator::go" << endl;
    start_undetached();
  }

  void crash (void)
  {
    WARN_STREAM << "DataGenerator::crash" << endl;
    generate_crash_ = true;
  }

  virtual void* run_undetached (void *)
  {
    static int * __invalid_ptr__ = 0;

    DEBUG_STREAM << "DataGenerator::run_undetached" << endl;
    do
    {
      if (generate_crash_)
        *__invalid_ptr__ = 0;

      { //- enter critical section
        omni_mutex_lock guard(dev_.lock);
        if (! go_on_) break;
        DEBUG_STREAM << "DataGenerator::generating data" << endl;
        dev_.gen_data();
      } //- leave critical section
      sleep(0, sleep_time_ * 1000000);
    }
    while (go_on_);
    return 0;
  }

  void abort (void)
  {
    DEBUG_STREAM << "DataGenerator::abort" << endl;
    go_on_ = 0;
  }

protected:
  virtual ~DataGenerator (void)
  {
    // noop dtor
  }

private:
  int go_on_;
  TangoTest& dev_;
  long sleep_time_;
  bool generate_crash_;
}
;

/*----- PROTECTED REGION END -----*/	//	TangoTest::namespace_starting

//--------------------------------------------------------
/**
 *	Method      : TangoTest::TangoTest()
 *	Description : Constructors for a Tango device
 *                implementing the classTangoTest
 */
//--------------------------------------------------------
TangoTest::TangoTest(Tango::DeviceClass *cl, string &s)
 : TANGO_BASE_CLASS(cl, s.c_str())
{
	/*----- PROTECTED REGION ID(TangoTest::constructor_1) ENABLED START -----*/
	init_device();

	/*----- PROTECTED REGION END -----*/	//	TangoTest::constructor_1
}
//--------------------------------------------------------
TangoTest::TangoTest(Tango::DeviceClass *cl, const char *s)
 : TANGO_BASE_CLASS(cl, s)
{
	/*----- PROTECTED REGION ID(TangoTest::constructor_2) ENABLED START -----*/
	init_device();

	/*----- PROTECTED REGION END -----*/	//	TangoTest::constructor_2
}
//--------------------------------------------------------
TangoTest::TangoTest(Tango::DeviceClass *cl, const char *s, const char *d)
 : TANGO_BASE_CLASS(cl, s, d)
{
	/*----- PROTECTED REGION ID(TangoTest::constructor_3) ENABLED START -----*/
	init_device();

	/*----- PROTECTED REGION END -----*/	//	TangoTest::constructor_3
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::delete_device()
 *	Description : will be called at device destruction or at init command
 */
//--------------------------------------------------------
void TangoTest::delete_device()
{
	DEBUG_STREAM << "TangoTest::delete_device() " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::delete_device) ENABLED START -----*/

	//	Delete device allocated objects
	omni_mutex_lock guard(lock);

  if (mthreaded_impl && data_gen) {
    data_gen->abort();
    data_gen->join(0);
    data_gen = 0;
  }

  if (attr_short_scalar_ro_read) {
    delete attr_short_scalar_ro_read;
    attr_short_scalar_ro_read = 0;
  }

  if (attr_short_scalar_read) {
    delete attr_short_scalar_read;
    attr_short_scalar_read = 0;
  }


  if (attr_short_scalar_rww_read) {
	  delete attr_short_scalar_rww_read;
    attr_short_scalar_rww_read = 0;
  }

  if (attr_long_scalar_read) {
    delete attr_long_scalar_read;
    attr_long_scalar_read = 0;
  }

  if (attr_ulong_scalar_read) {
    delete attr_ulong_scalar_read;
    attr_ulong_scalar_read = 0;
  }

  if (attr_long64_scalar_read) {
    delete attr_long64_scalar_read;
    attr_long64_scalar_read = 0;
  }

  if (attr_ulong64_scalar_read) {
    delete attr_ulong64_scalar_read;
    attr_ulong64_scalar_read = 0;
  }

  if (attr_long_scalar_rww_read) {
	  delete attr_long_scalar_rww_read;
    attr_long_scalar_rww_read = 0;
  }

  if (attr_double_scalar_read) {
	  delete attr_double_scalar_read;
    attr_double_scalar_read = 0;
  }

  if (attr_double_scalar_rww_read) {
	  delete attr_double_scalar_rww_read;
    attr_double_scalar_rww_read = 0;
  }

  if (*attr_string_scalar_read) {
    delete *attr_string_scalar_read;
  }

  if (attr_string_scalar_read) {
	  delete[] attr_string_scalar_read;
    attr_string_scalar_read = 0;
  }

  if (attr_boolean_scalar_read) {
    delete attr_boolean_scalar_read;
    attr_boolean_scalar_read = 0;
  }

  if (attr_float_scalar_read) {
    delete attr_float_scalar_read;
    attr_float_scalar_read = 0;
  }

  if (attr_uchar_scalar_read) {
    delete attr_uchar_scalar_read;
    attr_uchar_scalar_read = 0;
  }

  if (attr_ushort_scalar_read) {
    delete attr_ushort_scalar_read;
    attr_ushort_scalar_read = 0;
  }

  //- spectrum
  if (attr_short_spectrum_read) {
    delete[] attr_short_spectrum_read;
    attr_short_spectrum_read = 0;
  }

  if (attr_short_spectrum_ro_read) {
    delete[] attr_short_spectrum_ro_read;
    attr_short_spectrum_ro_read = 0;
  }

  if (attr_long_spectrum_read) {
    delete[] attr_long_spectrum_read;
    attr_long_spectrum_read = 0;
  }

  if (attr_long_spectrum_ro_read) {
    delete[] attr_long_spectrum_ro_read;
    attr_long_spectrum_ro_read = 0;
  }

  if (attr_ulong_spectrum_ro_read) {
    delete[] attr_ulong_spectrum_ro_read;
    attr_ulong_spectrum_ro_read = 0;
  }

  if (attr_ulong_spectrum_ro_read) {
    delete[] attr_ulong_spectrum_ro_read;
    attr_ulong_spectrum_ro_read = 0;
  }

  if (attr_ulong64_spectrum_ro_read) {
    delete[] attr_ulong64_spectrum_ro_read;
    attr_ulong64_spectrum_ro_read = 0;
  }

  if (attr_double_spectrum_read) {
    delete[] attr_double_spectrum_read;
    attr_double_spectrum_read = 0;
  }

  if (attr_long64_spectrum_ro_read) {
    delete[] attr_long64_spectrum_ro_read;
    attr_long64_spectrum_ro_read = 0;
  }

  if (attr_double_spectrum_ro_read) {
    delete[] attr_double_spectrum_ro_read;
    attr_double_spectrum_ro_read = 0;
  }

  if (attr_boolean_spectrum_read) {
    delete[] attr_boolean_spectrum_read;
    attr_boolean_spectrum_read = 0;
  }

  if (attr_boolean_spectrum_ro_read) {
    delete[] attr_boolean_spectrum_ro_read;
    attr_boolean_spectrum_ro_read = 0;
  }

  if (attr_uchar_spectrum_read) {
    delete[] attr_uchar_spectrum_read;
    attr_uchar_spectrum_read = 0;
  }

  if (attr_uchar_spectrum_ro_read) {
    delete[] attr_uchar_spectrum_ro_read;
    attr_uchar_spectrum_ro_read = 0;
  }

  if (attr_ushort_spectrum_read) {
    delete[] attr_ushort_spectrum_read;
    attr_ushort_spectrum_read = 0;
  }

  if (attr_ushort_spectrum_ro_read) {
    delete[] attr_ushort_spectrum_ro_read;
    attr_ushort_spectrum_ro_read = 0;
  }

   if (attr_float_spectrum_read) {
    delete[] attr_float_spectrum_read;
    attr_float_spectrum_read = 0;
  }

  if (attr_float_spectrum_ro_read) {
    delete[] attr_float_spectrum_ro_read;
    attr_float_spectrum_ro_read = 0;
  }

  int s = 0;
  if (attr_string_spectrum_ro_read) {
    for (s = 0; s < kSpecLen; s++)
      CORBA::string_free(attr_string_spectrum_ro_read[s]);
    delete[] attr_string_spectrum_ro_read;
    attr_string_spectrum_ro_read = 0;
  }

  if (attr_string_spectrum_read) {
    for (s = 0; s < dimStringSpectrum; s++)
      CORBA::string_free(attr_string_spectrum_read[s]);
    delete[] attr_string_spectrum_read;
    attr_string_spectrum_read = 0;
  }


  //- image
  if (attr_short_image_read) {
    delete[] attr_short_image_read;
    attr_short_image_read = 0;
  }

  if (attr_long_image_read) {
    delete[] attr_long_image_read;
    attr_long_image_read = 0;
  }

  if (attr_double_image_read) {
    delete[] attr_double_image_read;
    attr_double_image_read = 0;
  }

  if (attr_boolean_image_read) {
    delete[] attr_boolean_image_read;
    attr_boolean_image_read = 0;
  }

  if (attr_uchar_image_read) {
    delete[] attr_uchar_image_read;
    attr_uchar_image_read = 0;
  }

  if (attr_ushort_image_read) {
    delete[] attr_ushort_image_read;
    attr_ushort_image_read = 0;
  }

  if (attr_float_image_read) {
    delete[] attr_float_image_read;
    attr_float_image_read = 0;
  }

  //

  if (attr_short_image_ro_read) {
    delete[] attr_short_image_ro_read;
    attr_short_image_ro_read = 0;
  }

  if (attr_long_image_ro_read) {
    delete[] attr_long_image_ro_read;
    attr_long_image_ro_read = 0;
  }

  if (attr_ulong_image_ro_read) {
    delete[] attr_ulong_image_ro_read;
    attr_ulong_image_ro_read = 0;
  }

  if (attr_long64_image_ro_read) {
    delete[] attr_long64_image_ro_read;
    attr_long64_image_ro_read = 0;
  }

  if (attr_ulong64_image_ro_read) {
    delete[] attr_ulong64_image_ro_read;
    attr_ulong64_image_ro_read = 0;
  }

  if (attr_double_image_ro_read) {
    delete[] attr_double_image_ro_read;
    attr_double_image_ro_read = 0;
  }

  if (attr_boolean_image_ro_read) {
    delete[] attr_boolean_image_ro_read;
    attr_boolean_image_ro_read = 0;
  }

  if (attr_uchar_image_ro_read) {
    delete[] attr_uchar_image_ro_read;
    attr_uchar_image_ro_read = 0;
  }

  if (attr_ushort_image_ro_read) {
    delete[] attr_ushort_image_ro_read;
    attr_ushort_image_ro_read = 0;
  }

  if (attr_float_image_ro_read) {
    delete[] attr_float_image_ro_read;
    attr_float_image_ro_read = 0;
  }

  if (attr_string_image_ro_read) {
    for (s = 0; s < kImagLen * kImagLen; s++)
      CORBA::string_free(attr_string_image_ro_read[s]);
    delete[] attr_string_image_ro_read;
    attr_string_image_ro_read = 0;
  }

  if (attr_string_image_read) {
    for (s = 0; s < kImagLen * kImagLen; s++)
      CORBA::string_free(attr_string_image_read[s]);
    delete[] attr_string_image_read;
    attr_string_image_read = 0;
  }

  if (attr_wave_read) {
    delete[] attr_wave_read;
    attr_wave_read = 0;
  }

	/*----- PROTECTED REGION END -----*/	//	TangoTest::delete_device
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::init_device()
 *	Description : will be called at device initialization.
 */
//--------------------------------------------------------
void TangoTest::init_device()
{
	DEBUG_STREAM << "TangoTest::init_device() create device " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::init_device_before) ENABLED START -----*/

	//	Initialization before get_device_property() call
	LOG_INFO(("TangoTest::init_device::init device %s", device_name.c_str()));

  // Two lines of code ONLY to make the Debian hardening_check command
  // happy. Required for Debian packaging

  char host[256];
  gethostname(host,sizeof(host));

  omni_mutex_lock guard(lock);
	//-------------------------------------------------------

    // Get device property from database


	/*----- PROTECTED REGION END -----*/	//	TangoTest::init_device_before


	//	Get the device properties from database
	get_device_property();

	/*----- PROTECTED REGION ID(TangoTest::init_device) ENABLED START -----*/

	//	Initialize device
  // Allocate/initialize read part for each readable attribute
  // Initialize write part for each writable attribute

  //- Scalar
  	attr_short_scalar_ro_read = new Tango::DevShort;
	*attr_short_scalar_ro_read = 0;

	attr_short_scalar_read = new Tango::DevShort;
	*attr_short_scalar_read = 0;
  	attr_short_scalar_write = 256;

  	attr_short_scalar_w_write = 256;
  	attr_short_scalar_rww_read = new Tango::DevShort;
  	*attr_short_scalar_rww_read = 0;

	attr_long_scalar_read = new Tango::DevLong;
	*attr_long_scalar_read = 0;
  	attr_long_scalar_write = 256;

	attr_ulong_scalar_read = new Tango::DevULong;
	*attr_ulong_scalar_read = 0;
	attr_ulong_scalar_write = 256;

	attr_long64_scalar_read = new Tango::DevLong64;
	*attr_long64_scalar_read = 0;
	attr_long64_scalar_write = 256;

	attr_ulong64_scalar_read = new Tango::DevULong64;
	*attr_ulong64_scalar_read = 0;
	attr_ulong64_scalar_write = 256;

	attr_long_scalar_w_write = 256;
	attr_long_scalar_rww_read = new Tango::DevLong;
	*attr_long_scalar_rww_read = 0;

	attr_double_scalar_read = new Tango::DevDouble;
	*attr_double_scalar_read = 0;
 	attr_double_scalar_write = 256;

  	attr_double_scalar_w_write = 256;
  	attr_double_scalar_rww_read = new Tango::DevDouble;
  	*attr_double_scalar_rww_read = 0;

	attr_string_scalar_read = new char*;
	*attr_string_scalar_read = new char[256];
  	::strcpy(*attr_string_scalar_read, "Default string");
  	attr_string_scalar_write = 0;

  	attr_boolean_scalar_read = new Tango::DevBoolean;
	*attr_boolean_scalar_read = true;
	attr_boolean_scalar_write = false;

  	attr_float_scalar_read = new Tango::DevFloat;
	*attr_float_scalar_read = 0;
	attr_float_scalar_write = 0;

	attr_uchar_scalar_read = new Tango::DevUChar;
	*attr_uchar_scalar_read = 0;
	attr_uchar_scalar_write = 0;

	attr_ushort_scalar_read = new Tango::DevUShort;
	*attr_ushort_scalar_read = 0;
	attr_ushort_scalar_write = 0;

  //- Spectrum
	attr_short_spectrum_ro_read = new Tango::DevShort[kSpecLen];
	::memset(attr_short_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevShort));

  attr_short_spectrum_read = new Tango::DevShort[kSpecLen];
	::memset(attr_short_spectrum_read, 0, kSpecLen * sizeof(Tango::DevShort));

  dimShortSpectrum = kSpecLen;

  attr_long_spectrum_ro_read = new Tango::DevLong[kSpecLen];
	::memset(attr_long_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevLong));

  attr_ulong_spectrum_ro_read = new Tango::DevULong[kSpecLen];
  ::memset(attr_ulong_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevULong));

  attr_long64_spectrum_ro_read = new Tango::DevLong64[kSpecLen];
  ::memset(attr_long64_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevLong64));

  attr_ulong64_spectrum_ro_read = new Tango::DevULong64[kSpecLen];
  ::memset(attr_ulong64_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevULong64));

	attr_long_spectrum_read = new Tango::DevLong[kSpecLen];
	::memset(attr_long_spectrum_read, 0, kSpecLen * sizeof(Tango::DevLong));

  dimLongSpectrum = kSpecLen;

  attr_double_spectrum_ro_read = new Tango::DevDouble[kSpecLen];
	::memset(attr_double_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevDouble));

	attr_double_spectrum_read = new Tango::DevDouble[kSpecLen];
	::memset(attr_double_spectrum_read, 0, kSpecLen * sizeof(Tango::DevDouble));

  dimDoubleSpectrum = kSpecLen;

  attr_string_spectrum_ro_read = new Tango::DevString[kSpecLen];

  int s;
  for (s = 0; s < kSpecLen; s++)
  {
    attr_string_spectrum_ro_read[s] = CORBA::string_alloc(kSpecLen);
    ::memset(attr_string_spectrum_ro_read[s], 0, kSpecLen * sizeof(char));
  }

  attr_string_spectrum_read = new Tango::DevString[kSpecLen];
  for (s = 0; s < kSpecLen; s++)
  {
    attr_string_spectrum_read[s] = CORBA::string_alloc(kSpecLen);
    ::memset(attr_string_spectrum_read[s], 0, kSpecLen * sizeof(char));
  }
  attr_string_spectrum_write = 0;

  dimStringSpectrum = kSpecLen;

	attr_wave_read = new Tango::DevDouble[kSpecLen];
	::memset(attr_wave_read, 0, kSpecLen * sizeof(Tango::DevDouble));
	attr_ampli_write= 1;

  attr_boolean_spectrum_ro_read = new Tango::DevBoolean[kSpecLen];
	::memset(attr_boolean_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevBoolean));

	attr_boolean_spectrum_read = new Tango::DevBoolean[kSpecLen];
	::memset(attr_boolean_spectrum_read, 0, kSpecLen * sizeof(Tango::DevBoolean));

  dimBooleanSpectrum = kSpecLen;

  attr_ushort_spectrum_ro_read = new Tango::DevUShort[kSpecLen];
	::memset(attr_ushort_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevUShort));

  attr_ushort_spectrum_read = new Tango::DevUShort[kSpecLen];
	::memset(attr_ushort_spectrum_read, 0, kSpecLen * sizeof(Tango::DevUShort));

  dimUshortSpectrum = kSpecLen;

  attr_uchar_spectrum_ro_read = new Tango::DevUChar[kSpecLen];
	::memset(attr_uchar_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevUChar));

	attr_uchar_spectrum_read = new Tango::DevUChar[kSpecLen];
	::memset(attr_uchar_spectrum_read, 0, kSpecLen * sizeof(Tango::DevUChar));

  dimUcharSpectrum = kSpecLen;

  attr_float_spectrum_ro_read = new Tango::DevFloat[kSpecLen];
	::memset(attr_float_spectrum_ro_read, 0, kSpecLen * sizeof(Tango::DevFloat));

	attr_float_spectrum_read = new Tango::DevFloat[kSpecLen];
	::memset(attr_float_spectrum_read, 0, kSpecLen * sizeof(Tango::DevFloat));

  dimFloatSpectrum = kSpecLen;

  //- Images
	attr_short_image_read = new Tango::DevShort[kImagLen * kImagLen];
	::memset(attr_short_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevShort));

  dimXShortImage = kImagLen;
  dimYShortImage = kImagLen;

	attr_long_image_read = new Tango::DevLong[kImagLen * kImagLen];
	::memset(attr_long_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevLong));

  dimXLongImage = kImagLen;
  dimYLongImage = kImagLen;

	attr_double_image_read = new Tango::DevDouble[kImagLen * kImagLen];
	::memset(attr_double_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevDouble));

  dimXDoubleImage = kImagLen;
  dimYDoubleImage = kImagLen;

	attr_uchar_image_read = new Tango::DevUChar[kImagLen * kImagLen];
	::memset(attr_uchar_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevUChar));

  dimXUcharImage = kImagLen;
  dimYUcharImage = kImagLen;

	attr_ushort_image_read = new Tango::DevUShort[kImagLen * kImagLen];
	::memset(attr_ushort_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevUShort));

  dimXUshortImage = kImagLen;
  dimYUshortImage = kImagLen;

	attr_float_image_read = new Tango::DevFloat[kImagLen * kImagLen];
	::memset(attr_float_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevFloat));

  dimXFloatImage = kImagLen;
  dimYFloatImage = kImagLen;

  	attr_boolean_image_read = new Tango::DevBoolean[kImagLen * kImagLen];
	::memset(attr_boolean_image_read, 0, kImagLen * kImagLen * sizeof(Tango::DevBoolean));

  dimXBooleanImage = kImagLen;
  dimYBooleanImage = kImagLen;

  attr_short_image_ro_read = new Tango::DevShort[kImagLen * kImagLen];
	::memset(attr_short_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevShort));

	attr_long_image_ro_read = new Tango::DevLong[kImagLen * kImagLen];
	::memset(attr_long_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevLong));

  attr_ulong_image_ro_read = new Tango::DevULong[kImagLen * kImagLen];
  ::memset(attr_ulong_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevULong));

  attr_long64_image_ro_read = new Tango::DevLong64[kImagLen * kImagLen];
  ::memset(attr_long64_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevLong64));

  attr_ulong64_image_ro_read = new Tango::DevULong64[kImagLen * kImagLen];
  ::memset(attr_ulong64_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevULong64));

	attr_double_image_ro_read = new Tango::DevDouble[kImagLen * kImagLen];
	::memset(attr_double_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevDouble));

	attr_uchar_image_ro_read = new Tango::DevUChar[kImagLen * kImagLen];
	::memset(attr_uchar_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevUChar));

	attr_ushort_image_ro_read = new Tango::DevUShort[uShort_image_ro_size * uShort_image_ro_size];
	::memset(attr_ushort_image_ro_read, 0, uShort_image_ro_size * uShort_image_ro_size * sizeof(Tango::DevUShort));

	attr_float_image_ro_read = new Tango::DevFloat[kImagLen * kImagLen];
	::memset(attr_float_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevFloat));

  attr_boolean_image_ro_read = new Tango::DevBoolean[kImagLen * kImagLen];
	::memset(attr_boolean_image_ro_read, 0, kImagLen * kImagLen * sizeof(Tango::DevBoolean));

  attr_string_image_ro_read = new char*[kImagLen * kImagLen];
  for (s = 0; s < kImagLen * kImagLen; s++)
  {
    attr_string_image_ro_read[s] = CORBA::string_alloc(kSpecLen);
    ::memset(attr_string_image_ro_read[s], 0, kSpecLen * sizeof(char));
  }

  attr_string_image_read = new char*[kImagLen * kImagLen];
  for (s = 0; s < kImagLen * kImagLen; s++)
  {
    attr_string_image_read[s] = CORBA::string_alloc(kSpecLen);
    ::memset(attr_string_image_read[s], 0, kSpecLen * sizeof(char));
  }
  attr_string_image_write = 0;

  dimXStringImage = kImagLen;
  dimYStringImage = kImagLen;


  // Multithreaded implementation stuffs
  if (mthreaded_impl == 0) {
   data_gen = 0;
   return;
  }

  Tango::Attribute &att1 = dev_attr->get_attr_by_name("short_image_ro");
  att1.set_attr_serial_model(Tango::ATTR_BY_USER);

  Tango::Attribute &att2 = dev_attr->get_attr_by_name("long_image_ro");
  att2.set_attr_serial_model(Tango::ATTR_BY_USER);

  Tango::Attribute &att3 = dev_attr->get_attr_by_name("ulong_image_ro");
  att3.set_attr_serial_model(Tango::ATTR_BY_USER);

  Tango::Attribute &att4 = dev_attr->get_attr_by_name("long64_image_ro");
  att4.set_attr_serial_model(Tango::ATTR_BY_USER);

  Tango::Attribute &att5 = dev_attr->get_attr_by_name("ulong64_image_ro");
  att5.set_attr_serial_model(Tango::ATTR_BY_USER);

  Tango::Attribute &att6 = dev_attr->get_attr_by_name("float_image_ro");
  att6.set_attr_serial_model(Tango::ATTR_BY_USER);

  Tango::Attribute &att7 = dev_attr->get_attr_by_name("double_image_ro");
  att7.set_attr_serial_model(Tango::ATTR_BY_USER);

  Tango::Attribute &att8 = dev_attr->get_attr_by_name("boolean_image_ro");
  att8.set_attr_serial_model(Tango::ATTR_BY_USER);

  Tango::Attribute &att9 = dev_attr->get_attr_by_name("uchar_image_ro");
  att9.set_attr_serial_model(Tango::ATTR_BY_USER);

  Tango::Attribute &att10 = dev_attr->get_attr_by_name("ushort_image_ro");
  att10.set_attr_serial_model(Tango::ATTR_BY_USER);

  data_gen = new DataGenerator(*this, sleep_period);
  data_gen->go();

// pipe
  pi_str = "The string";
  pi_long = 666;
  pi_short = (Tango::DevShort)12;

  set_state(Tango::RUNNING);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::init_device
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::get_device_property()
 *	Description : Read database to initialize property data members.
 */
//--------------------------------------------------------
void TangoTest::get_device_property()
{
	/*----- PROTECTED REGION ID(TangoTest::get_device_property_before) ENABLED START -----*/

	//	Initialize property data members
	mthreaded_impl = 1;
	sleep_period = 2000;
	uShort_image_ro_size = kImagLen;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::get_device_property_before


	//	Read device properties from database.
	Tango::DbData	dev_prop;
	dev_prop.push_back(Tango::DbDatum("Mthreaded_impl"));
	dev_prop.push_back(Tango::DbDatum("Sleep_period"));
	dev_prop.push_back(Tango::DbDatum("UShort_image_ro_size"));

	//	is there at least one property to be read ?
	if (dev_prop.size()>0)
	{
		//	Call database and extract values
		if (Tango::Util::instance()->_UseDb==true)
			get_db_device()->get_property(dev_prop);

		//	get instance on TangoTestClass to get class property
		Tango::DbDatum	def_prop, cl_prop;
		TangoTestClass	*ds_class =
			(static_cast<TangoTestClass *>(get_device_class()));
		int	i = -1;

		//	Try to initialize Mthreaded_impl from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  mthreaded_impl;
		else {
			//	Try to initialize Mthreaded_impl from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  mthreaded_impl;
		}
		//	And try to extract Mthreaded_impl value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  mthreaded_impl;

		//	Try to initialize Sleep_period from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  sleep_period;
		else {
			//	Try to initialize Sleep_period from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  sleep_period;
		}
		//	And try to extract Sleep_period value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  sleep_period;

		//	Try to initialize UShort_image_ro_size from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  uShort_image_ro_size;
		else {
			//	Try to initialize UShort_image_ro_size from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  uShort_image_ro_size;
		}
		//	And try to extract UShort_image_ro_size value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  uShort_image_ro_size;

	}

	/*----- PROTECTED REGION ID(TangoTest::get_device_property_after) ENABLED START -----*/

	//	Check device property data members init
	DEBUG_STREAM << "sleep_period=" << sleep_period << endl;
	DEBUG_STREAM << "mthreaded_impl=" << mthreaded_impl << endl;
	DEBUG_STREAM << "uShort_image_ro_size=" << uShort_image_ro_size << endl;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::get_device_property_after
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::always_executed_hook()
 *	Description : method always executed before any command is executed
 */
//--------------------------------------------------------
void TangoTest::always_executed_hook()
{
	DEBUG_STREAM << "TangoTest::always_executed_hook()  " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::always_executed_hook) ENABLED START -----*/

	//	code always executed before all requests

	/*----- PROTECTED REGION END -----*/	//	TangoTest::always_executed_hook
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::read_attr_hardware()
 *	Description : Hardware acquisition for attributes
 */
//--------------------------------------------------------
void TangoTest::read_attr_hardware(TANGO_UNUSED(vector<long> &attr_list))
{
	DEBUG_STREAM << "TangoTest::read_attr_hardware(vector<long> &attr_list) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_attr_hardware) ENABLED START -----*/

	//	Add your own code
	LOG_DEBUG(("In read_attr_hardware for %d attributes",attr_list.size()));

  // Generate data for all attributes
  if (mthreaded_impl == 0) {
 	  gen_data();
  }

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_attr_hardware
}
//--------------------------------------------------------
/**
 *	Method      : TangoTest::write_attr_hardware()
 *	Description : Hardware writing for attributes
 */
//--------------------------------------------------------
void TangoTest::write_attr_hardware(TANGO_UNUSED(vector<long> &attr_list))
{
	DEBUG_STREAM << "TangoTest::write_attr_hardware(vector<long> &attr_list) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::write_attr_hardware) ENABLED START -----*/

	//	Add your own code

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_attr_hardware
}

//--------------------------------------------------------
/**
 *	Write attribute ampli related method
 *	Description:
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_ampli(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_ampli(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevDouble	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_ampli) ENABLED START -----*/
  	DEBUG_STREAM << "ampli = " << w_val << endl;
	attr_ampli_write = w_val;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_ampli
}
//--------------------------------------------------------
/**
 *	Read attribute boolean_scalar related method
 *	Description: A boolean scalar attribute
 *
 *	Data type:	Tango::DevBoolean
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_boolean_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_boolean_scalar(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_boolean_scalar) ENABLED START -----*/
	attr.set_value(attr_boolean_scalar_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_boolean_scalar
}
//--------------------------------------------------------
/**
 *	Write attribute boolean_scalar related method
 *	Description: A boolean scalar attribute
 *
 *	Data type:	Tango::DevBoolean
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_boolean_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_boolean_scalar(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevBoolean	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_boolean_scalar) ENABLED START -----*/
	*attr_boolean_scalar_read = w_val;
	attr_boolean_scalar_write = w_val;
	DEBUG_STREAM << "Read and write attributes were set to the same value" << endl;
  	DEBUG_STREAM << "w_val = " << w_val << endl;
	DEBUG_STREAM << "attr_boolean_scalar_read = " << *attr_boolean_scalar_read << endl;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_boolean_scalar
}
//--------------------------------------------------------
/**
 *	Read attribute double_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_double_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_double_scalar(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_double_scalar) ENABLED START -----*/
	attr.set_value(attr_double_scalar_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_double_scalar
}
//--------------------------------------------------------
/**
 *	Write attribute double_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_double_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_double_scalar(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevDouble	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_double_scalar) ENABLED START -----*/
    DEBUG_STREAM << "w_val = " << w_val << endl;
	attr_double_scalar_write = w_val;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_double_scalar
}
//--------------------------------------------------------
/**
 *	Read attribute double_scalar_rww related method
 *	Description:
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_double_scalar_rww(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_double_scalar_rww(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_double_scalar_rww) ENABLED START -----*/
	attr.set_value(attr_double_scalar_rww_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_double_scalar_rww
}
//--------------------------------------------------------
/**
 *	Write attribute double_scalar_rww related method
 *	Description:
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_double_scalar_rww(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_double_scalar_rww(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevDouble	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_double_scalar_rww) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_double_scalar_rww
}
//--------------------------------------------------------
/**
 *	Write attribute double_scalar_w related method
 *	Description:
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_double_scalar_w(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_double_scalar_w(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevDouble	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_double_scalar_w) ENABLED START -----*/
  	DEBUG_STREAM << "double_scalar_w = " << w_val << endl;
	attr_double_scalar_w_write = w_val;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_double_scalar_w
}
//--------------------------------------------------------
/**
 *	Read attribute float_scalar related method
 *	Description: A float attribute
 *
 *	Data type:	Tango::DevFloat
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_float_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_float_scalar(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_float_scalar) ENABLED START -----*/
	attr.set_value(attr_float_scalar_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_float_scalar
}
//--------------------------------------------------------
/**
 *	Write attribute float_scalar related method
 *	Description: A float attribute
 *
 *	Data type:	Tango::DevFloat
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_float_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_float_scalar(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevFloat	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_float_scalar) ENABLED START -----*/
  	DEBUG_STREAM << "w_val = " << w_val << endl;
	attr_float_scalar_write = w_val;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_float_scalar
}
//--------------------------------------------------------
/**
 *	Read attribute long64_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevLong64
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_long64_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long64_scalar(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_long64_scalar) ENABLED START -----*/
	attr.set_value(attr_long64_scalar_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_long64_scalar
}
//--------------------------------------------------------
/**
 *	Write attribute long64_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevLong64
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_long64_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_long64_scalar(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevLong64	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_long64_scalar) ENABLED START -----*/
  	DEBUG_STREAM << "w_val = " << w_val << endl;
	attr_long64_scalar_write = w_val;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_long64_scalar
}
//--------------------------------------------------------
/**
 *	Read attribute long_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevLong
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_long_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long_scalar(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_long_scalar) ENABLED START -----*/
	attr.set_value(attr_long_scalar_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_long_scalar
}
//--------------------------------------------------------
/**
 *	Write attribute long_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevLong
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_long_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_long_scalar(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevLong	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_long_scalar) ENABLED START -----*/
    DEBUG_STREAM << "w_val = " << w_val << endl;
	attr_long_scalar_write = w_val;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_long_scalar
}
//--------------------------------------------------------
/**
 *	Read attribute long_scalar_rww related method
 *	Description:
 *
 *	Data type:	Tango::DevLong
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_long_scalar_rww(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long_scalar_rww(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_long_scalar_rww) ENABLED START -----*/
	attr.set_value(attr_long_scalar_rww_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_long_scalar_rww
}
//--------------------------------------------------------
/**
 *	Write attribute long_scalar_rww related method
 *	Description:
 *
 *	Data type:	Tango::DevLong
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_long_scalar_rww(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_long_scalar_rww(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevLong	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_long_scalar_rww) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_long_scalar_rww
}
//--------------------------------------------------------
/**
 *	Write attribute long_scalar_w related method
 *	Description:
 *
 *	Data type:	Tango::DevLong
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_long_scalar_w(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_long_scalar_w(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevLong	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_long_scalar_w) ENABLED START -----*/
  	DEBUG_STREAM << "long_scalar_w = " << w_val << endl;
	attr_long_scalar_w_write = w_val;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_long_scalar_w
}
//--------------------------------------------------------
/**
 *	Read attribute no_value related method
 *	Description:
 *
 *	Data type:	Tango::DevLong
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_no_value(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_no_value(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_no_value) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_no_value
}
//--------------------------------------------------------
/**
 *	Read attribute short_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevShort
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_short_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_scalar(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_short_scalar) ENABLED START -----*/
	attr.set_value(attr_short_scalar_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_short_scalar
}
//--------------------------------------------------------
/**
 *	Write attribute short_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevShort
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_short_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_short_scalar(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevShort	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_short_scalar) ENABLED START -----*/
  	DEBUG_STREAM << "w_val = " << w_val << endl;
	attr_short_scalar_write = w_val;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_short_scalar
}
//--------------------------------------------------------
/**
 *	Read attribute short_scalar_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevShort
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_short_scalar_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_scalar_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_short_scalar_ro) ENABLED START -----*/
	attr.set_value(attr_short_scalar_ro_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_short_scalar_ro
}
//--------------------------------------------------------
/**
 *	Read attribute short_scalar_rww related method
 *	Description:
 *
 *	Data type:	Tango::DevShort
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_short_scalar_rww(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_scalar_rww(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_short_scalar_rww) ENABLED START -----*/
	attr.set_value(attr_short_scalar_rww_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_short_scalar_rww
}
//--------------------------------------------------------
/**
 *	Write attribute short_scalar_rww related method
 *	Description:
 *
 *	Data type:	Tango::DevShort
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_short_scalar_rww(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_short_scalar_rww(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevShort	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_short_scalar_rww) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_short_scalar_rww
}
//--------------------------------------------------------
/**
 *	Write attribute short_scalar_w related method
 *	Description:
 *
 *	Data type:	Tango::DevShort
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_short_scalar_w(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_short_scalar_w(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevShort	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_short_scalar_w) ENABLED START -----*/
  	DEBUG_STREAM << "short_scalar_w = " << w_val << endl;
	attr_short_scalar_w_write = w_val;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_short_scalar_w
}
//--------------------------------------------------------
/**
 *	Read attribute string_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevString
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_string_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_string_scalar(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_string_scalar) ENABLED START -----*/
	attr.set_value(attr_string_scalar_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_string_scalar
}
//--------------------------------------------------------
/**
 *	Write attribute string_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevString
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_string_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_string_scalar(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevString	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_string_scalar) ENABLED START -----*/
  	DEBUG_STREAM << "w_val = " << w_val << endl;
	attr_string_scalar_write = w_val;
  	if (*attr_string_scalar_read)
  	{
   	 	delete[] *attr_string_scalar_read;
    	size_t len = ::strlen(w_val) + 1;
    	*attr_string_scalar_read = new char[len];
    	if (*attr_string_scalar_read)
    	{
      		::memset(*attr_string_scalar_read, 0, len * sizeof(char));
      		::strcpy(*attr_string_scalar_read, w_val);
    	}
  	}

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_string_scalar
}
//--------------------------------------------------------
/**
 *	Read attribute throw_exception related method
 *	Description:
 *
 *	Data type:	Tango::DevLong
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_throw_exception(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_throw_exception(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_throw_exception) ENABLED START -----*/
  Tango::Except::throw_exception((const char *)"exception test",
						                     (const char *)"here is the exception you requested",
						                     (const char *)"TangoTest::read_throw_exception");
	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_throw_exception
}
//--------------------------------------------------------
/**
 *	Read attribute uchar_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevUChar
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_uchar_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_uchar_scalar(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_uchar_scalar) ENABLED START -----*/
	attr.set_value(attr_uchar_scalar_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_uchar_scalar
}
//--------------------------------------------------------
/**
 *	Write attribute uchar_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevUChar
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_uchar_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_uchar_scalar(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevUChar	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_uchar_scalar) ENABLED START -----*/
  	DEBUG_STREAM << "w_val = " << w_val << endl;
	attr_uchar_scalar_write = w_val;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_uchar_scalar
}
//--------------------------------------------------------
/**
 *	Read attribute ulong64_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevULong64
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_ulong64_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ulong64_scalar(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_ulong64_scalar) ENABLED START -----*/
	attr.set_value(attr_ulong64_scalar_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_ulong64_scalar
}
//--------------------------------------------------------
/**
 *	Write attribute ulong64_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevULong64
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_ulong64_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_ulong64_scalar(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevULong64	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_ulong64_scalar) ENABLED START -----*/
  	DEBUG_STREAM << "w_val = " << w_val << endl;
	attr_ulong64_scalar_write = w_val;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_ulong64_scalar
}
//--------------------------------------------------------
/**
 *	Read attribute ushort_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevUShort
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_ushort_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ushort_scalar(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_ushort_scalar) ENABLED START -----*/
	attr.set_value(attr_ushort_scalar_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_ushort_scalar
}
//--------------------------------------------------------
/**
 *	Write attribute ushort_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevUShort
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_ushort_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_ushort_scalar(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevUShort	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_ushort_scalar) ENABLED START -----*/
  	DEBUG_STREAM << "w_val = " << w_val << endl;
	attr_ushort_scalar_write = w_val;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_ushort_scalar
}
//--------------------------------------------------------
/**
 *	Read attribute ulong_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevULong
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::read_ulong_scalar(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ulong_scalar(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_ulong_scalar) ENABLED START -----*/
	attr.set_value(attr_ulong_scalar_read);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_ulong_scalar
}
//--------------------------------------------------------
/**
 *	Write attribute ulong_scalar related method
 *	Description:
 *
 *	Data type:	Tango::DevULong
 *	Attr type:	Scalar
 */
//--------------------------------------------------------
void TangoTest::write_ulong_scalar(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_ulong_scalar(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve write value
	Tango::DevULong	w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_ulong_scalar) ENABLED START -----*/
  	DEBUG_STREAM << "w_val = " << w_val << endl;
	attr_ulong_scalar_write = w_val;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_ulong_scalar
}
//--------------------------------------------------------
/**
 *	Read attribute boolean_spectrum related method
 *	Description:
 *
 *	Data type:	Tango::DevBoolean
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_boolean_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_boolean_spectrum(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_boolean_spectrum) ENABLED START -----*/
	attr.set_value(attr_boolean_spectrum_read, dimBooleanSpectrum);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_boolean_spectrum
}
//--------------------------------------------------------
/**
 *	Write attribute boolean_spectrum related method
 *	Description:
 *
 *	Data type:	Tango::DevBoolean
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::write_boolean_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_boolean_spectrum(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevBoolean	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_boolean_spectrum) ENABLED START -----*/

  const bool * p;
  attr.get_write_value(p);

  long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  ::memcpy(attr_boolean_spectrum_read, p, len * sizeof(Tango::DevBoolean));

  dimBooleanSpectrum = len;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_boolean_spectrum
}
//--------------------------------------------------------
/**
 *	Read attribute boolean_spectrum_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevBoolean
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_boolean_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_boolean_spectrum_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_boolean_spectrum_ro) ENABLED START -----*/
	attr.set_value(attr_boolean_spectrum_ro_read, kSpecLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_boolean_spectrum_ro
}
//--------------------------------------------------------
/**
 *	Read attribute double_spectrum related method
 *	Description:
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_double_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_double_spectrum(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_double_spectrum) ENABLED START -----*/
	attr.set_value(attr_double_spectrum_read, dimDoubleSpectrum);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_double_spectrum
}
//--------------------------------------------------------
/**
 *	Write attribute double_spectrum related method
 *	Description:
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::write_double_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_double_spectrum(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevDouble	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_double_spectrum) ENABLED START -----*/

  const double * p;
  attr.get_write_value(p);

  long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  ::memcpy(attr_double_spectrum_read, p, len * sizeof(Tango::DevDouble));

  dimDoubleSpectrum = len;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_double_spectrum
}
//--------------------------------------------------------
/**
 *	Read attribute double_spectrum_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_double_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_double_spectrum_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_double_spectrum_ro) ENABLED START -----*/
	attr.set_value(attr_double_spectrum_ro_read, kSpecLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_double_spectrum_ro
}
//--------------------------------------------------------
/**
 *	Read attribute float_spectrum related method
 *	Description: A float spectrum attribute
 *
 *	Data type:	Tango::DevFloat
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_float_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_float_spectrum(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_float_spectrum) ENABLED START -----*/
	attr.set_value(attr_float_spectrum_read, dimFloatSpectrum);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_float_spectrum
}
//--------------------------------------------------------
/**
 *	Write attribute float_spectrum related method
 *	Description: A float spectrum attribute
 *
 *	Data type:	Tango::DevFloat
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::write_float_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_float_spectrum(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevFloat	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_float_spectrum) ENABLED START -----*/

  const float * p;
  attr.get_write_value(p);

  long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  ::memcpy(attr_float_spectrum_read, p, len * sizeof(Tango::DevFloat));

  dimFloatSpectrum = len;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_float_spectrum
}
//--------------------------------------------------------
/**
 *	Read attribute float_spectrum_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevFloat
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_float_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_float_spectrum_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_float_spectrum_ro) ENABLED START -----*/
	attr.set_value(attr_float_spectrum_ro_read, kSpecLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_float_spectrum_ro
}
//--------------------------------------------------------
/**
 *	Read attribute long64_spectrum_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevLong64
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_long64_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long64_spectrum_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_long64_spectrum_ro) ENABLED START -----*/
	attr.set_value(attr_long64_spectrum_ro_read, kSpecLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_long64_spectrum_ro
}
//--------------------------------------------------------
/**
 *	Read attribute long_spectrum related method
 *	Description:
 *
 *	Data type:	Tango::DevLong
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_long_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long_spectrum(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_long_spectrum) ENABLED START -----*/
	attr.set_value(attr_long_spectrum_read, dimLongSpectrum);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_long_spectrum
}
//--------------------------------------------------------
/**
 *	Write attribute long_spectrum related method
 *	Description:
 *
 *	Data type:	Tango::DevLong
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::write_long_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_long_spectrum(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevLong	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_long_spectrum) ENABLED START -----*/
	const Tango::DevLong * p;
  attr.get_write_value(p);

  long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  ::memcpy(attr_long_spectrum_read, p, len * sizeof(Tango::DevLong));

  dimLongSpectrum = len;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_long_spectrum
}
//--------------------------------------------------------
/**
 *	Read attribute long_spectrum_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevLong
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_long_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long_spectrum_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_long_spectrum_ro) ENABLED START -----*/
	attr.set_value(attr_long_spectrum_ro_read, kSpecLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_long_spectrum_ro
}
//--------------------------------------------------------
/**
 *	Read attribute short_spectrum related method
 *	Description:
 *
 *	Data type:	Tango::DevShort
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_short_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_spectrum(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_short_spectrum) ENABLED START -----*/
	attr.set_value(attr_short_spectrum_read, dimShortSpectrum);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_short_spectrum
}
//--------------------------------------------------------
/**
 *	Write attribute short_spectrum related method
 *	Description:
 *
 *	Data type:	Tango::DevShort
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::write_short_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_short_spectrum(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevShort	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_short_spectrum) ENABLED START -----*/
	long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;

  const short * p;
  attr.get_write_value(p);

  len = attr.get_write_value_length();
  DEBUG_STREAM << "Length from get_write_value_length:" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  DEBUG_STREAM << "Final length:" << len << endl;

  ::memcpy(attr_short_spectrum_read, p, len * sizeof(Tango::DevShort));
  dimShortSpectrum = len;

  //::memcpy(attr_short_spectrum_read, p, len * sizeof(Tango::DevShort));

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_short_spectrum
}
//--------------------------------------------------------
/**
 *	Read attribute short_spectrum_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevShort
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_short_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_spectrum_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_short_spectrum_ro) ENABLED START -----*/
	attr.set_value(attr_short_spectrum_ro_read, kSpecLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_short_spectrum_ro
}
//--------------------------------------------------------
/**
 *	Read attribute string_spectrum related method
 *	Description:
 *
 *	Data type:	Tango::DevString
 *	Attr type:	Spectrum max = 256
 */
//--------------------------------------------------------
void TangoTest::read_string_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_string_spectrum(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_string_spectrum) ENABLED START -----*/
	attr.set_value(attr_string_spectrum_read, dimStringSpectrum);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_string_spectrum
}
//--------------------------------------------------------
/**
 *	Write attribute string_spectrum related method
 *	Description:
 *
 *	Data type:	Tango::DevString
 *	Attr type:	Spectrum max = 256
 */
//--------------------------------------------------------
void TangoTest::write_string_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_string_spectrum(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::ConstDevString	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_string_spectrum) ENABLED START -----*/
	const Tango::ConstDevString *p=NULL;
  attr.get_write_value(p);

  int len = attr.get_w_dim_x();
  len = (len <= kSpecLen) ? len : kSpecLen;

  // Free the old spectrum first in case the new spectrum length is less
  // than the previous spectrum.
  for (int i = 0; i < dimStringSpectrum; i++) {
    CORBA::string_free(attr_string_spectrum_read[i]);
  }
  for (int i = 0; i < len; i++) {
    attr_string_spectrum_read[i] = CORBA::string_dup(p[i]);
  }
  dimStringSpectrum = len;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_string_spectrum
}
//--------------------------------------------------------
/**
 *	Read attribute string_spectrum_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevString
 *	Attr type:	Spectrum max = 256
 */
//--------------------------------------------------------
void TangoTest::read_string_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_string_spectrum_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_string_spectrum_ro) ENABLED START -----*/
	attr.set_value(attr_string_spectrum_ro_read, kSpecLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_string_spectrum_ro
}
//--------------------------------------------------------
/**
 *	Read attribute uchar_spectrum related method
 *	Description: An unsigned char spectrum attribute
 *
 *	Data type:	Tango::DevUChar
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_uchar_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_uchar_spectrum(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_uchar_spectrum) ENABLED START -----*/
	attr.set_value(attr_uchar_spectrum_read, dimUcharSpectrum);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_uchar_spectrum
}
//--------------------------------------------------------
/**
 *	Write attribute uchar_spectrum related method
 *	Description: An unsigned char spectrum attribute
 *
 *	Data type:	Tango::DevUChar
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::write_uchar_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_uchar_spectrum(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevUChar	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_uchar_spectrum) ENABLED START -----*/
  const unsigned char * p;
  attr.get_write_value(p);

  long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  ::memcpy(attr_uchar_spectrum_read, p, len * sizeof(Tango::DevUChar));

  dimUcharSpectrum = len;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_uchar_spectrum
}
//--------------------------------------------------------
/**
 *	Read attribute uchar_spectrum_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevUChar
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_uchar_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_uchar_spectrum_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_uchar_spectrum_ro) ENABLED START -----*/
	attr.set_value(attr_uchar_spectrum_ro_read, kSpecLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_uchar_spectrum_ro
}
//--------------------------------------------------------
/**
 *	Read attribute ulong64_spectrum_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevULong64
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_ulong64_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ulong64_spectrum_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_ulong64_spectrum_ro) ENABLED START -----*/
	attr.set_value(attr_ulong64_spectrum_ro_read, kSpecLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_ulong64_spectrum_ro
}
//--------------------------------------------------------
/**
 *	Read attribute ulong_spectrum_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevULong
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_ulong_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ulong_spectrum_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_ulong_spectrum_ro) ENABLED START -----*/
	attr.set_value(attr_ulong_spectrum_ro_read, kSpecLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_ulong_spectrum_ro
}
//--------------------------------------------------------
/**
 *	Read attribute ushort_spectrum related method
 *	Description: An unsigned short spectrum attribute
 *
 *	Data type:	Tango::DevUShort
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_ushort_spectrum(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ushort_spectrum(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_ushort_spectrum) ENABLED START -----*/
	attr.set_value(attr_ushort_spectrum_read, dimUshortSpectrum);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_ushort_spectrum
}
//--------------------------------------------------------
/**
 *	Write attribute ushort_spectrum related method
 *	Description: An unsigned short spectrum attribute
 *
 *	Data type:	Tango::DevUShort
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::write_ushort_spectrum(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_ushort_spectrum(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevUShort	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_ushort_spectrum) ENABLED START -----*/

  const unsigned short * p;
  attr.get_write_value(p);

  long len = attr.get_write_value_length();
  DEBUG_STREAM << "Length :" << len << endl;

  len = (len <= kSpecLen) ? len : kSpecLen;

  ::memcpy(attr_ushort_spectrum_read, p, len * sizeof(Tango::DevUShort));

  dimUshortSpectrum = len;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_ushort_spectrum
}
//--------------------------------------------------------
/**
 *	Read attribute ushort_spectrum_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevUShort
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_ushort_spectrum_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ushort_spectrum_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_ushort_spectrum_ro) ENABLED START -----*/
	attr.set_value(attr_ushort_spectrum_ro_read, kSpecLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_ushort_spectrum_ro
}
//--------------------------------------------------------
/**
 *	Read attribute wave related method
 *	Description:
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Spectrum max = 4096
 */
//--------------------------------------------------------
void TangoTest::read_wave(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_wave(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_wave) ENABLED START -----*/
	attr.set_value(attr_wave_read, kSpecLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_wave
}
//--------------------------------------------------------
/**
 *	Read attribute boolean_image related method
 *	Description:
 *
 *	Data type:	Tango::DevBoolean
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_boolean_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_boolean_image(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_boolean_image) ENABLED START -----*/
	attr.set_value(attr_boolean_image_read, dimXBooleanImage, dimYBooleanImage);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_boolean_image
}
//--------------------------------------------------------
/**
 *	Write attribute boolean_image related method
 *	Description:
 *
 *	Data type:	Tango::DevBoolean
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::write_boolean_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_boolean_image(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevBoolean	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_boolean_image) ENABLED START -----*/
	const bool * p;
  attr.get_write_value(p);

  dimXBooleanImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXBooleanImage << endl;

  dimYBooleanImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYBooleanImage << endl;

  long len = dimXBooleanImage * dimYBooleanImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_boolean_image_read, p, len * sizeof(Tango::DevBoolean));

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_boolean_image
}
//--------------------------------------------------------
/**
 *	Read attribute boolean_image_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevBoolean
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_boolean_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_boolean_image_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_boolean_image_ro) ENABLED START -----*/
	if (mthreaded_impl != 0)
		boolean_image_lock.lock();
	attr.set_value(attr_boolean_image_ro_read, kImagLen, kImagLen);
	if (mthreaded_impl != 0)
		attr.set_user_attr_mutex(&boolean_image_lock);
	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_boolean_image_ro
}
//--------------------------------------------------------
/**
 *	Read attribute double_image related method
 *	Description:
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_double_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_double_image(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_double_image) ENABLED START -----*/
	attr.set_value(attr_double_image_read, dimXDoubleImage, dimYDoubleImage);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_double_image
}
//--------------------------------------------------------
/**
 *	Write attribute double_image related method
 *	Description:
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::write_double_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_double_image(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevDouble	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_double_image) ENABLED START -----*/
	const double * p;
  attr.get_write_value(p);

  dimXDoubleImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXDoubleImage << endl;

  dimYDoubleImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYDoubleImage << endl;

  long len = dimXDoubleImage * dimYDoubleImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_double_image_read, p, len * sizeof(Tango::DevDouble));

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_double_image
}
//--------------------------------------------------------
/**
 *	Read attribute double_image_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_double_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_double_image_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_double_image_ro) ENABLED START -----*/
	if (mthreaded_impl != 0)
		double_image_lock.lock();
	attr.set_value(attr_double_image_ro_read, kImagLen, kImagLen);
	if (mthreaded_impl != 0)
		attr.set_user_attr_mutex(&double_image_lock);
	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_double_image_ro
}
//--------------------------------------------------------
/**
 *	Read attribute float_image related method
 *	Description:
 *
 *	Data type:	Tango::DevFloat
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_float_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_float_image(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_float_image) ENABLED START -----*/
	attr.set_value(attr_float_image_read, dimXFloatImage, dimYFloatImage);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_float_image
}
//--------------------------------------------------------
/**
 *	Write attribute float_image related method
 *	Description:
 *
 *	Data type:	Tango::DevFloat
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::write_float_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_float_image(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevFloat	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_float_image) ENABLED START -----*/
	const float * p;
  attr.get_write_value(p);

  dimXFloatImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXFloatImage << endl;

  dimYFloatImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYFloatImage << endl;

  long len = dimXFloatImage * dimYFloatImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_float_image_read, p, len * sizeof(Tango::DevFloat));

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_float_image
}
//--------------------------------------------------------
/**
 *	Read attribute float_image_ro related method
 *	Description: A float image attribute
 *
 *	Data type:	Tango::DevFloat
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_float_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_float_image_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_float_image_ro) ENABLED START -----*/
	if (mthreaded_impl != 0)
		float_image_lock.lock();
	attr.set_value(attr_float_image_ro_read, kImagLen, kImagLen);
	if (mthreaded_impl != 0)
		attr.set_user_attr_mutex(&float_image_lock);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_float_image_ro
}
//--------------------------------------------------------
/**
 *	Read attribute long64_image_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevLong64
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_long64_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long64_image_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_long64_image_ro) ENABLED START -----*/
	if (mthreaded_impl != 0)
		long64_image_lock.lock();
	attr.set_value(attr_long64_image_ro_read, kImagLen, kImagLen);
	if (mthreaded_impl != 0)
		attr.set_user_attr_mutex(&long64_image_lock);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_long64_image_ro
}
//--------------------------------------------------------
/**
 *	Read attribute long_image related method
 *	Description:
 *
 *	Data type:	Tango::DevLong
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_long_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long_image(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_long_image) ENABLED START -----*/
	attr.set_value(attr_long_image_read, kImagLen, kImagLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_long_image
}
//--------------------------------------------------------
/**
 *	Write attribute long_image related method
 *	Description:
 *
 *	Data type:	Tango::DevLong
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::write_long_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_long_image(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevLong	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_long_image) ENABLED START -----*/
	const long * p;
  attr.get_write_value(p);

  dimXLongImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXLongImage << endl;

  dimYLongImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYLongImage << endl;

  long len = dimXLongImage * dimYLongImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_long_image_read, p, len * sizeof(Tango::DevLong));

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_long_image
}
//--------------------------------------------------------
/**
 *	Read attribute long_image_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevLong
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_long_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_long_image_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_long_image_ro) ENABLED START -----*/
	if (mthreaded_impl != 0)
		long_image_lock.lock();
	attr.set_value(attr_long_image_ro_read, kImagLen, kImagLen);
	if (mthreaded_impl != 0)
		attr.set_user_attr_mutex(&long_image_lock);
	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_long_image_ro
}
//--------------------------------------------------------
/**
 *	Read attribute short_image related method
 *	Description:
 *
 *	Data type:	Tango::DevShort
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_short_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_image(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_short_image) ENABLED START -----*/
	attr.set_value(attr_short_image_read, dimXShortImage, dimYShortImage);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_short_image
}
//--------------------------------------------------------
/**
 *	Write attribute short_image related method
 *	Description:
 *
 *	Data type:	Tango::DevShort
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::write_short_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_short_image(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevShort	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_short_image) ENABLED START -----*/
	const short * p;
  attr.get_write_value(p);

  dimXShortImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXShortImage << endl;

  dimYShortImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYShortImage << endl;

  long len = dimXShortImage * dimYShortImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_short_image_read, p, len * sizeof(Tango::DevShort));

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_short_image
}
//--------------------------------------------------------
/**
 *	Read attribute short_image_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevShort
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_short_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_short_image_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_short_image_ro) ENABLED START -----*/
	if (mthreaded_impl != 0)
		short_image_lock.lock();
	attr.set_value(attr_short_image_ro_read, kImagLen, kImagLen);
	if (mthreaded_impl != 0)
		attr.set_user_attr_mutex(&short_image_lock);
	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_short_image_ro
}
//--------------------------------------------------------
/**
 *	Read attribute string_image related method
 *	Description:
 *
 *	Data type:	Tango::DevString
 *	Attr type:	Image max = 256 x 256
 */
//--------------------------------------------------------
void TangoTest::read_string_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_string_image(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_string_image) ENABLED START -----*/
	attr.set_value(attr_string_image_read, dimXStringImage, dimYStringImage);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_string_image
}
//--------------------------------------------------------
/**
 *	Write attribute string_image related method
 *	Description:
 *
 *	Data type:	Tango::DevString
 *	Attr type:	Image max = 256 x 256
 */
//--------------------------------------------------------
void TangoTest::write_string_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_string_image(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::ConstDevString	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_string_image) ENABLED START -----*/
	const Tango::ConstDevString *p=NULL;
  attr.get_write_value(p);

  dimXStringImage = attr.get_w_dim_x();
  if (dimXStringImage > kImagLen)
    dimXStringImage = kImagLen;
  DEBUG_STREAM << "X :" << dimXStringImage << endl;

  dimYStringImage = attr.get_w_dim_y();
  if (dimYStringImage > kImagLen)
    dimYStringImage = kImagLen;
  DEBUG_STREAM << "Y :" << dimYStringImage << endl;

  int i ,j, str_index;
  for (j = 0; j < dimYStringImage; j++)
  {
    for (i = 0; i < dimXStringImage; i++)
    {
      str_index = i + j * dimXStringImage;
      CORBA::string_free(attr_string_image_read[str_index]);
      attr_string_image_read[str_index] = CORBA::string_dup(p[str_index]);
    }
  }

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_string_image
}
//--------------------------------------------------------
/**
 *	Read attribute string_image_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevString
 *	Attr type:	Image max = 256 x 256
 */
//--------------------------------------------------------
void TangoTest::read_string_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_string_image_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_string_image_ro) ENABLED START -----*/
	attr.set_value(attr_string_image_ro_read, kImagLen, kImagLen);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_string_image_ro
}
//--------------------------------------------------------
/**
 *	Read attribute uchar_image related method
 *	Description:
 *
 *	Data type:	Tango::DevUChar
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_uchar_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_uchar_image(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_uchar_image) ENABLED START -----*/
	attr.set_value(attr_uchar_image_read, dimXUcharImage, dimYUcharImage);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_uchar_image
}
//--------------------------------------------------------
/**
 *	Write attribute uchar_image related method
 *	Description:
 *
 *	Data type:	Tango::DevUChar
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::write_uchar_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_uchar_image(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevUChar	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_uchar_image) ENABLED START -----*/
	const unsigned char * p;
  attr.get_write_value(p);

  dimXUcharImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXUcharImage << endl;

  dimYUcharImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYUcharImage << endl;

  long len = dimXUcharImage * dimYUcharImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_uchar_image_read, p, len * sizeof(Tango::DevUChar));

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_uchar_image
}
//--------------------------------------------------------
/**
 *	Read attribute uchar_image_ro related method
 *	Description: An unsigned char image attribute
 *
 *	Data type:	Tango::DevUChar
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_uchar_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_uchar_image_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_uchar_image_ro) ENABLED START -----*/
	if (mthreaded_impl != 0)
		uchar_image_lock.lock();
	attr.set_value(attr_uchar_image_ro_read, kImagLen, kImagLen);
	if (mthreaded_impl != 0)
		attr.set_user_attr_mutex(&uchar_image_lock);
	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_uchar_image_ro
}
//--------------------------------------------------------
/**
 *	Read attribute ulong64_image_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevULong64
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_ulong64_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ulong64_image_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_ulong64_image_ro) ENABLED START -----*/
	if (mthreaded_impl != 0)
		ulong64_image_lock.lock();
	attr.set_value(attr_ulong64_image_ro_read, kImagLen, kImagLen);
	if (mthreaded_impl != 0)
		attr.set_user_attr_mutex(&ulong64_image_lock);
	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_ulong64_image_ro
}
//--------------------------------------------------------
/**
 *	Read attribute ulong_image_ro related method
 *	Description:
 *
 *	Data type:	Tango::DevULong
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_ulong_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ulong_image_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_ulong_image_ro) ENABLED START -----*/
	if (mthreaded_impl != 0)
		ulong_image_lock.lock();
	attr.set_value(attr_ulong_image_ro_read, kImagLen, kImagLen);
	if (mthreaded_impl != 0)
		attr.set_user_attr_mutex(&ulong_image_lock);
	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_ulong_image_ro
}
//--------------------------------------------------------
/**
 *	Read attribute ushort_image related method
 *	Description:
 *
 *	Data type:	Tango::DevUShort
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::read_ushort_image(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ushort_image(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_ushort_image) ENABLED START -----*/
	attr.set_value(attr_ushort_image_read, dimXUshortImage, dimYUshortImage);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_ushort_image
}
//--------------------------------------------------------
/**
 *	Write attribute ushort_image related method
 *	Description:
 *
 *	Data type:	Tango::DevUShort
 *	Attr type:	Image max = 251 x 251
 */
//--------------------------------------------------------
void TangoTest::write_ushort_image(Tango::WAttribute &attr)
{
	DEBUG_STREAM << "TangoTest::write_ushort_image(Tango::WAttribute &attr) entering... " << endl;
	//	Retrieve number of write values
	int	w_length = attr.get_write_value_length();

	//	Retrieve pointer on write values (Do not delete !)
	const Tango::DevUShort	*w_val;
	attr.get_write_value(w_val);
	/*----- PROTECTED REGION ID(TangoTest::write_ushort_image) ENABLED START -----*/
	const unsigned short * p;
  attr.get_write_value(p);

  dimXUshortImage = attr.get_w_dim_x();
  DEBUG_STREAM << "X :" << dimXUshortImage << endl;

  dimYUshortImage = attr.get_w_dim_y();
  DEBUG_STREAM << "Y :" << dimYUshortImage << endl;

  long len = dimXUshortImage * dimYUshortImage;

  len = (len <= kImagLen * kImagLen) ? len : kImagLen * kImagLen;

  ::memcpy(attr_ushort_image_read, p, len * sizeof(Tango::DevUShort));

	/*----- PROTECTED REGION END -----*/	//	TangoTest::write_ushort_image
}
//--------------------------------------------------------
/**
 *	Read attribute ushort_image_ro related method
 *	Description: An unsigned short image attribute
 *
 *	Data type:	Tango::DevUShort
 *	Attr type:	Image max = 8192 x 8192
 */
//--------------------------------------------------------
void TangoTest::read_ushort_image_ro(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TangoTest::read_ushort_image_ro(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_ushort_image_ro) ENABLED START -----*/
	if (mthreaded_impl != 0)
		ushort_image_lock.lock();
	attr.set_value(attr_ushort_image_ro_read, uShort_image_ro_size, uShort_image_ro_size);
	if (mthreaded_impl != 0)
		attr.set_user_attr_mutex(&ushort_image_lock);
	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_ushort_image_ro
}

//--------------------------------------------------------
/**
 *	Method      : TangoTest::add_dynamic_attributes()
 *	Description : Create the dynamic attributes if any
 *                for specified device.
 */
//--------------------------------------------------------
void TangoTest::add_dynamic_attributes()
{
	/*----- PROTECTED REGION ID(TangoTest::add_dynamic_attributes) ENABLED START -----*/

	//	Add your own code to create and add dynamic attributes if any

	/*----- PROTECTED REGION END -----*/	//	TangoTest::add_dynamic_attributes
}

//--------------------------------------------------------
/**
 *	Read pipe string_long_short_ro related method
 *	Description: Pipe example
 */
//--------------------------------------------------------
void TangoTest::read_string_long_short_ro(Tango::Pipe &pipe)
{
	DEBUG_STREAM << "TangoTest::read_string_long_short_ro(Tango::Pipe &pipe) entering... " << endl;
	/*----- PROTECTED REGION ID(TangoTest::read_string_long_short_ro) ENABLED START -----*/

    vector<string> de_names;
    de_names.push_back("FirstDE");
    de_names.push_back("SecondDE");
    de_names.push_back("ThirdDE");
    pipe.set_data_elt_names(de_names);

    pipe << pi_str << pi_long << pi_short;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::read_string_long_short_ro
}
//--------------------------------------------------------
/**
 *	Command CrashFromDevelopperThread related method
 *	Description: Crashes the device!
 *
 */
//--------------------------------------------------------
void TangoTest::crash_from_developper_thread()
{
	DEBUG_STREAM << "TangoTest::CrashFromDevelopperThread()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::crash_from_developper_thread) ENABLED START -----*/

	//	Add your own code
	#if defined(ENABLE_CRASH_REPORT)
  if (data_gen)
    data_gen->crash();
#else
  ERROR_STREAM << "Crash report disabled "
               << "[rebuild this device with ENABLE_CRASH_REPORT defined "
               << "and link against the breakpad_client library"
               << std::endl;
#endif

	/*----- PROTECTED REGION END -----*/	//	TangoTest::crash_from_developper_thread
}
//--------------------------------------------------------
/**
 *	Command CrashFromOmniThread related method
 *	Description: Crashes the device!
 *
 */
//--------------------------------------------------------
void TangoTest::crash_from_omni_thread()
{
	DEBUG_STREAM << "TangoTest::CrashFromOmniThread()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::crash_from_omni_thread) ENABLED START -----*/

	//	Add your own code
	#if defined(ENABLE_CRASH_REPORT)
	//	Add your own code to control device here
  int * invalid_ptr = 0;
  *invalid_ptr = 0;
#else
  ERROR_STREAM << "Crash report disabled "
               << "[rebuild this device with ENABLE_CRASH_REPORT defined "
               << "and link against the breakpad_client library"
               << std::endl;
#endif

	/*----- PROTECTED REGION END -----*/	//	TangoTest::crash_from_omni_thread
}
//--------------------------------------------------------
/**
 *	Command DevBoolean related method
 *	Description: A DevBoolean comand example
 *
 *	@param argin Any boolean value
 *	@returns Echo of the argin value
 */
//--------------------------------------------------------
Tango::DevBoolean TangoTest::dev_boolean(Tango::DevBoolean argin)
{
	Tango::DevBoolean argout;
	DEBUG_STREAM << "TangoTest::DevBoolean()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_boolean) ENABLED START -----*/

	//	Add your own code
	// Tangotest : just send back input argument
	return argin;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_boolean
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevDouble related method
 *	Description: A DevDouble command example
 *
 *	@param argin Any DevDouble value
 *	@returns Echo of the argin value
 */
//--------------------------------------------------------
Tango::DevDouble TangoTest::dev_double(Tango::DevDouble argin)
{
	Tango::DevDouble argout;
	DEBUG_STREAM << "TangoTest::DevDouble()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_double) ENABLED START -----*/

	//	Add your own code
	// Tangotest : just send back input argument
	return argin;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_double
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevFloat related method
 *	Description: A DevFloat command example
 *
 *	@param argin Any DevFloat value
 *	@returns Echo of the argin value
 */
//--------------------------------------------------------
Tango::DevFloat TangoTest::dev_float(Tango::DevFloat argin)
{
	Tango::DevFloat argout;
	DEBUG_STREAM << "TangoTest::DevFloat()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_float) ENABLED START -----*/

	//	Add your own code
	// Tangotest : just send back input argument
	return argin;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_float
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevLong related method
 *	Description: A DevLong command example
 *
 *	@param argin Any DevLong value
 *	@returns Echo of the argin value
 */
//--------------------------------------------------------
Tango::DevLong TangoTest::dev_long(Tango::DevLong argin)
{
	Tango::DevLong argout;
	DEBUG_STREAM << "TangoTest::DevLong()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_long) ENABLED START -----*/

	//	Add your own code
	// Tangotest : just send back input argument
	return argin;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_long
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevLong64 related method
 *	Description: A DevLong command example
 *
 *	@param argin Any DevLong64 value
 *	@returns Echo of the argin value
 */
//--------------------------------------------------------
Tango::DevLong64 TangoTest::dev_long64(Tango::DevLong64 argin)
{
	Tango::DevLong64 argout;
	DEBUG_STREAM << "TangoTest::DevLong64()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_long64) ENABLED START -----*/

	//	Add your own code
	return argin;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_long64
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevShort related method
 *	Description: A DevShort command example
 *
 *	@param argin Any DevShort value
 *	@returns Echo of the argin value
 */
//--------------------------------------------------------
Tango::DevShort TangoTest::dev_short(Tango::DevShort argin)
{
	Tango::DevShort argout;
	DEBUG_STREAM << "TangoTest::DevShort()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_short) ENABLED START -----*/

	//	Add your own code
	// Tangotest : just send back input argument
	return argin;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_short
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevString related method
 *	Description: none
 *
 *	@param argin -
 *	@returns -
 */
//--------------------------------------------------------
Tango::DevString TangoTest::dev_string(Tango::DevString argin)
{
	Tango::DevString argout;
	DEBUG_STREAM << "TangoTest::DevString()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_string) ENABLED START -----*/

	//	Add your own code
	// Allocate argout
  argout = new char [::strlen(argin) + 1];
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevString" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_string");
  }

  // Tangotest : just send back input argument
	::strcpy(argout, argin);

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_string
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevULong related method
 *	Description: A DevULong command example
 *
 *	@param argin Any DevULong
 *	@returns Echo of the argin value
 */
//--------------------------------------------------------
Tango::DevULong TangoTest::dev_ulong(Tango::DevULong argin)
{
	Tango::DevULong argout;
	DEBUG_STREAM << "TangoTest::DevULong()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_ulong) ENABLED START -----*/

	//	Add your own code
	// Tangotest : just send back input argument
	return argin;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_ulong
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevULong64 related method
 *	Description: A DevULong64 command example
 *
 *	@param argin Any DevULong64 value
 *	@returns Echo of the argin value
 */
//--------------------------------------------------------
Tango::DevULong64 TangoTest::dev_ulong64(Tango::DevULong64 argin)
{
	Tango::DevULong64 argout;
	DEBUG_STREAM << "TangoTest::DevULong64()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_ulong64) ENABLED START -----*/

	//	Add your own code
	return argin;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_ulong64
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevUShort related method
 *	Description: A DevUShort command example
 *
 *	@param argin Any DevUShort value
 *	@returns Echo of the argin value
 */
//--------------------------------------------------------
Tango::DevUShort TangoTest::dev_ushort(Tango::DevUShort argin)
{
	Tango::DevUShort argout;
	DEBUG_STREAM << "TangoTest::DevUShort()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_ushort) ENABLED START -----*/

	//	Add your own code
	// Tangotest : just send back input argument
	return argin;

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_ushort
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevVarCharArray related method
 *	Description: none
 *
 *	@param argin -
 *	@returns -
 */
//--------------------------------------------------------
Tango::DevVarCharArray *TangoTest::dev_var_char_array(const Tango::DevVarCharArray *argin)
{
	Tango::DevVarCharArray *argout;
	DEBUG_STREAM << "TangoTest::DevVarCharArray()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_var_char_array) ENABLED START -----*/

	//	Add your own code
	// Allocate argout
	argout = new Tango::DevVarCharArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarCharArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_char_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_var_char_array
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevVarDoubleArray related method
 *	Description: none
 *
 *	@param argin -
 *	@returns -
 */
//--------------------------------------------------------
Tango::DevVarDoubleArray *TangoTest::dev_var_double_array(const Tango::DevVarDoubleArray *argin)
{
	Tango::DevVarDoubleArray *argout;
	DEBUG_STREAM << "TangoTest::DevVarDoubleArray()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_var_double_array) ENABLED START -----*/

	//	Add your own code
	// Allocate argout
	argout = new Tango::DevVarDoubleArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarDoubleArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_double_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_var_double_array
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevVarDoubleStringArray related method
 *	Description: none
 *
 *	@param argin -
 *	@returns -
 */
//--------------------------------------------------------
Tango::DevVarDoubleStringArray *TangoTest::dev_var_double_string_array(const Tango::DevVarDoubleStringArray *argin)
{
	Tango::DevVarDoubleStringArray *argout;
	DEBUG_STREAM << "TangoTest::DevVarDoubleStringArray()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_var_double_string_array) ENABLED START -----*/

	//	Add your own code
	// Allocate argout
  argout = new Tango::DevVarDoubleStringArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarDoubleStringArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_double_string_array");
  }

  // Tangotest : just send back input argument
  argout->dvalue = argin->dvalue;
  argout->svalue.length(argin->svalue.length());
  for (unsigned int i = 0; i < argin->svalue.length(); i++) {
    argout->svalue[i] = CORBA::string_dup(argin->svalue[i]);
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_var_double_string_array
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevVarFloatArray related method
 *	Description: none
 *
 *	@param argin -
 *	@returns -
 */
//--------------------------------------------------------
Tango::DevVarFloatArray *TangoTest::dev_var_float_array(const Tango::DevVarFloatArray *argin)
{
	Tango::DevVarFloatArray *argout;
	DEBUG_STREAM << "TangoTest::DevVarFloatArray()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_var_float_array) ENABLED START -----*/

	//	Add your own code
	// Allocate argout
	argout = new Tango::DevVarFloatArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarFloatArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_float_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_var_float_array
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevVarLong64Array related method
 *	Description:
 *
 *	@param argin
 *	@returns
 */
//--------------------------------------------------------
Tango::DevVarLong64Array *TangoTest::dev_var_long64_array(const Tango::DevVarLong64Array *argin)
{
	Tango::DevVarLong64Array *argout;
	DEBUG_STREAM << "TangoTest::DevVarLong64Array()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_var_long64_array) ENABLED START -----*/

	//	Add your own code
	// Allocate argout
  argout = new Tango::DevVarLong64Array();
  if (argout == 0)
  {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarLong64Array" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
                                   o.str(),
                                   (const char *)"TangoTest::dev_var_long64_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++)
    (*argout)[i] = (*argin)[i];

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_var_long64_array
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevVarLongArray related method
 *	Description: none
 *
 *	@param argin -
 *	@returns -
 */
//--------------------------------------------------------
Tango::DevVarLongArray *TangoTest::dev_var_long_array(const Tango::DevVarLongArray *argin)
{
	Tango::DevVarLongArray *argout;
	DEBUG_STREAM << "TangoTest::DevVarLongArray()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_var_long_array) ENABLED START -----*/

	//	Add your own code
	// Allocate argout
  argout = new Tango::DevVarLongArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarLongArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_long_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_var_long_array
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevVarLongStringArray related method
 *	Description: none
 *
 *	@param argin -
 *	@returns -
 */
//--------------------------------------------------------
Tango::DevVarLongStringArray *TangoTest::dev_var_long_string_array(const Tango::DevVarLongStringArray *argin)
{
	Tango::DevVarLongStringArray *argout;
	DEBUG_STREAM << "TangoTest::DevVarLongStringArray()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_var_long_string_array) ENABLED START -----*/

	//	Add your own code
	// Allocate argout
	argout = new Tango::DevVarLongStringArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarLongStringArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_long_string_array");
  }

  // Tangotest : just send back input argument
  argout->lvalue = argin->lvalue;
  argout->svalue.length(argin->svalue.length());
  for (unsigned int i = 0; i < argin->svalue.length(); i++) {
    argout->svalue[i] = CORBA::string_dup(argin->svalue[i]);
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_var_long_string_array
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevVarShortArray related method
 *	Description: none
 *
 *	@param argin -
 *	@returns -
 */
//--------------------------------------------------------
Tango::DevVarShortArray *TangoTest::dev_var_short_array(const Tango::DevVarShortArray *argin)
{
	Tango::DevVarShortArray *argout;
	DEBUG_STREAM << "TangoTest::DevVarShortArray()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_var_short_array) ENABLED START -----*/

	//	Add your own code
	// Allocate argout
  argout = new Tango::DevVarShortArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarShortArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_short_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_var_short_array
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevVarStringArray related method
 *	Description: none
 *
 *	@param argin -
 *	@returns -
 */
//--------------------------------------------------------
Tango::DevVarStringArray *TangoTest::dev_var_string_array(const Tango::DevVarStringArray *argin)
{
	Tango::DevVarStringArray *argout;
	DEBUG_STREAM << "TangoTest::DevVarStringArray()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_var_string_array) ENABLED START -----*/

	//	Add your own code
	// Allocate argout
	argout = new Tango::DevVarStringArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarStringArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_string_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = CORBA::string_dup((*argin)[i]);
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_var_string_array
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevVarULong64Array related method
 *	Description:
 *
 *	@param argin
 *	@returns
 */
//--------------------------------------------------------
Tango::DevVarULong64Array *TangoTest::dev_var_ulong64_array(const Tango::DevVarULong64Array *argin)
{
	Tango::DevVarULong64Array *argout;
	DEBUG_STREAM << "TangoTest::DevVarULong64Array()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_var_ulong64_array) ENABLED START -----*/

	//	Add your own code
	// Allocate argout
  argout = new Tango::DevVarULong64Array();
  if (argout == 0)
  {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarULong64Array" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
                                   o.str(),
                                   (const char *)"TangoTest::dev_var_ulong64_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++)
    (*argout)[i] = (*argin)[i];

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_var_ulong64_array
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevVarULongArray related method
 *	Description: none
 *
 *	@param argin -
 *	@returns -
 */
//--------------------------------------------------------
Tango::DevVarULongArray *TangoTest::dev_var_ulong_array(const Tango::DevVarULongArray *argin)
{
	Tango::DevVarULongArray *argout;
	DEBUG_STREAM << "TangoTest::DevVarULongArray()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_var_ulong_array) ENABLED START -----*/

	//	Add your own code
	// Allocate argout
	argout = new Tango::DevVarULongArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarULongArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_ulong_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_var_ulong_array
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevVarUShortArray related method
 *	Description: none
 *
 *	@param argin -
 *	@returns -
 */
//--------------------------------------------------------
Tango::DevVarUShortArray *TangoTest::dev_var_ushort_array(const Tango::DevVarUShortArray *argin)
{
	Tango::DevVarUShortArray *argout;
	DEBUG_STREAM << "TangoTest::DevVarUShortArray()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_var_ushort_array) ENABLED START -----*/

	//	Add your own code
	// Allocate argout
	argout = new Tango::DevVarUShortArray();
  if (argout == 0) {
    TangoSys_OMemStream o;
    o << "Failed to allocate Tango::DevVarUShortArray" << ends;
    LOG_ERROR((o.str()));
    Tango::Except::throw_exception((const char *)"Out of memory error",
						                       o.str(),
						                       (const char *)"TangoTest::dev_var_ushort_array");
  }

  // Tangotest : just send back input argument
  argout->length(argin->length());
  for (unsigned int i = 0; i < argin->length(); i++) {
    (*argout)[i] = (*argin)[i];
  }

  // DO NOT DELETE <argin>
  // See the TANGO programmer's manual section 7.2.3
  // for more info about C++ memory management.

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_var_ushort_array
	return argout;
}
//--------------------------------------------------------
/**
 *	Command DevVoid related method
 *	Description: A DevVoid comand example
 *
 */
//--------------------------------------------------------
void TangoTest::dev_void()
{
	DEBUG_STREAM << "TangoTest::DevVoid()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dev_void) ENABLED START -----*/

	//	Add your own code
	//	Add your own code to control device here

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dev_void
}
//--------------------------------------------------------
/**
 *	Command DumpExecutionState related method
 *	Description: Forces mini dump generation
 *
 */
//--------------------------------------------------------
void TangoTest::dump_execution_state()
{
	DEBUG_STREAM << "TangoTest::DumpExecutionState()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::dump_execution_state) ENABLED START -----*/

	//	Add your own code
	#if defined(ENABLE_CRASH_REPORT)
  TangoCrashHandler::dump_current_exec_state();
#else
  ERROR_STREAM << "Crash report disabled "
               << "[rebuild this device with ENABLE_CRASH_REPORT defined "
               << "and link against the breakpad_client library"
               << std::endl;
#endif

	/*----- PROTECTED REGION END -----*/	//	TangoTest::dump_execution_state
}
//--------------------------------------------------------
/**
 *	Command SwitchStates related method
 *	Description: This command changes the device state from RUNNING to FAULT or from FAULT to RUNNING
 *
 */
//--------------------------------------------------------
void TangoTest::switch_states()
{
	DEBUG_STREAM << "TangoTest::SwitchStates()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(TangoTest::switch_states) ENABLED START -----*/

	//	Add your own code
	if(get_state() == Tango::RUNNING)
	{
		set_state(Tango::FAULT);
	}
	else
	{
		set_state(Tango::RUNNING);
	}

	/*----- PROTECTED REGION END -----*/	//	TangoTest::switch_states
}
//--------------------------------------------------------
/**
 *	Method      : TangoTest::add_dynamic_commands()
 *	Description : Create the dynamic commands if any
 *                for specified device.
 */
//--------------------------------------------------------
void TangoTest::add_dynamic_commands()
{
	/*----- PROTECTED REGION ID(TangoTest::add_dynamic_commands) ENABLED START -----*/

	//	Add your own code to create and add dynamic commands if any

	/*----- PROTECTED REGION END -----*/	//	TangoTest::add_dynamic_commands
}

/*----- PROTECTED REGION ID(TangoTest::namespace_ending) ENABLED START -----*/

//	Additional Methods
//=============================================================================
// Standalone template function: generates a random <T> in the range [0, max]
//=============================================================================
template<typename T> inline T randomize (T max)
{
  if (max > 1)
  {
    int r = ::rand();
	  r = r < 0 ? -r : r;
	  return static_cast<T>(r % static_cast<int>(max));
  }
  return 0;
}
//=============================================================================
// Standalone template function: generates a random image
//=============================================================================
template<typename T>
void generate_full_image (T* buffer, long max_xy, long max_value, omni_mutex &lock)
{
    lock.lock();
	// For each pixel, we need to generate a random value between [0, max_value]
	for(long i=0; i<max_xy; i++)
	{
		for(long j=0; j<max_xy; j++)
		{
      int r = ::rand();
			r = r < 0 ? -r : r;
			buffer[i * max_xy + j] = (long)(r % (int)max_value);
		}
	}
	lock.unlock();
}
//=============================================================================
// Standalone template function: generates a dummy beam image
//=============================================================================
template <typename T>
void generate_image (T* buffer, long max_xy, omni_mutex &lock)
{
  lock.lock();
	long bimg_center_x = ::rand() % (int)(max_xy * 0.05);
  if (::rand() % 2) {
    bimg_center_x *= -1;
  }
	long bimg_center_y = ::rand() % (int)(max_xy * 0.05);
  if (::rand() % 2) {
    bimg_center_y *= -1;
  }
	long bimg_offset_to_zero = (max_xy - 1) / 2;
	long bimg_x_offset_to_zero = bimg_offset_to_zero + bimg_center_x;
	long bimg_y_offset_to_zero = bimg_offset_to_zero + bimg_center_y;
  long limit = max_xy / 8;
  long noise = ::rand() % (int)(limit * 0.2);
  if (::rand() % 2) {
    noise *= -1;
  }
  limit += noise;
  // Reset image content
  ::memset(buffer, 0, max_xy * max_xy * sizeof(T));
  // Fill image buffer
  long i, j, x, y, value;
  for (i = -limit; i < limit; i++) {
    y = i + bimg_y_offset_to_zero;
    if (y >= 0 && y < max_xy) {
      for (j = -limit; j < limit; j++) {
	      x = j + bimg_x_offset_to_zero;
        if (x >= 0 && x < max_xy) {
          value = (long)::sqrt((double)(i * i + j * j));
          buffer[x * max_xy + y] = (T) ((value < limit) ? limit - value : 0);
        }
      }
    }
  }
  lock.unlock();
}


//=============================================================================
// TangoTest::gen_data
//=============================================================================
void TangoTest::gen_data ()
{
  // Generate data for all attributes
  static long k = 0;
  static const double kpi_deg = 3.14159 / 180.0;
  static const int boolean_generation_max_value = 2;
  static const int int_generation_max_value = 256;

  *attr_short_scalar_rww_read =
			randomize(attr_short_scalar_w_write);

  *attr_long_scalar_rww_read =
     	randomize(attr_long_scalar_w_write);

  *attr_double_scalar_rww_read =
       attr_double_scalar_w_write * ::sin(kpi_deg * (k%360));

  *attr_short_scalar_ro_read =
     randomize(attr_short_scalar_write);

  *attr_short_scalar_read =
     randomize(attr_short_scalar_write);

 	*attr_long_scalar_read =
     randomize(attr_long_scalar_write);

  *attr_ulong_scalar_read =
     randomize(attr_ulong_scalar_write);

  *attr_long64_scalar_read =
     randomize(attr_long_scalar_write);

  *attr_ulong64_scalar_read =
     randomize(attr_ulong_scalar_write);

 	*attr_double_scalar_read =
     attr_double_scalar_write * ::sin(kpi_deg * (k%360));

 	*attr_ushort_scalar_read =
     randomize(attr_ushort_scalar_write);

  *attr_uchar_scalar_read =
     randomize(attr_uchar_scalar_write);

  *attr_float_scalar_read =
     randomize(attr_float_scalar_write);

 	int i, j;

	for (i = 0; i < kSpecLen; i++)
		attr_short_spectrum_ro_read[i] = randomize(int_generation_max_value);

	for (i = 0; i < kSpecLen; i++)
		attr_long_spectrum_ro_read[i] = randomize(int_generation_max_value);

  for (i = 0; i < kSpecLen; i++)
    attr_ulong_spectrum_ro_read[i] = randomize(int_generation_max_value);

  for (i = 0; i < kSpecLen; i++)
    attr_long64_spectrum_ro_read[i] = randomize(int_generation_max_value);

  for (i = 0; i < kSpecLen; i++)
    attr_ulong64_spectrum_ro_read[i] = randomize(int_generation_max_value);

	for (i = 0; i < kSpecLen; i++)
		attr_double_spectrum_ro_read[i] = randomize(int_generation_max_value);

	for (i = 0; i < kSpecLen; i++)
     attr_wave_read[i] = attr_ampli_write * ::sin(kpi_deg * (i + (k%360)));

	for (i = 0; i < kSpecLen; i++)
		attr_boolean_spectrum_ro_read[i] =
            randomize(boolean_generation_max_value) ? true : false;

	for (i = 0; i < kSpecLen; i++)
		attr_ushort_spectrum_ro_read[i] = randomize(int_generation_max_value);

	for (i = 0; i < kSpecLen; i++)
		attr_uchar_spectrum_ro_read[i] = randomize(int_generation_max_value);

	for (i = 0; i < kSpecLen; i++)
		attr_float_spectrum_ro_read[i] = (float) randomize(int_generation_max_value);

  generate_image(attr_short_image_ro_read,  kImagLen, short_image_lock);

  generate_image(attr_long_image_ro_read,  kImagLen, long_image_lock);

  generate_image(attr_ulong_image_ro_read,  kImagLen, ulong64_image_lock);

  generate_image(attr_long64_image_ro_read,  kImagLen, long64_image_lock);

  generate_image(attr_ulong64_image_ro_read,  kImagLen, ulong64_image_lock);

  generate_image(attr_float_image_ro_read, kImagLen, float_image_lock);

  generate_image(attr_double_image_ro_read,  kImagLen, double_image_lock);

  generate_full_image(attr_boolean_image_ro_read, kImagLen, boolean_generation_max_value, boolean_image_lock);

  generate_full_image(attr_uchar_image_ro_read, kImagLen, int_generation_max_value, uchar_image_lock);

  generate_full_image(attr_ushort_image_ro_read, uShort_image_ro_size, int_generation_max_value, ushort_image_lock);

  for (i = 0; i < kSpecLen; i++)
    ::sprintf(attr_string_spectrum_ro_read[i],"[%.2d]::hello-world-%.4d", i, randomize(int_generation_max_value));

  for (j = 0; j < kImagLen; j++)
    for (i = 0; i < kImagLen; i++)
      ::sprintf(attr_string_image_ro_read[ i + j * kImagLen],
                "[%.2d][%.2d]::hello world::%.4d",
                i,
                j,
                randomize(int_generation_max_value));

  k++;
}

/*----- PROTECTED REGION END -----*/	//	TangoTest::namespace_ending
} //	namespace
