/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * AM654: DDRSS Register definitions and structures.
 *
 * Copyright (C) 2018 Texas Instruments Incorporated - http://www.ti.com/
 *	Lokesh Vutla <lokeshvutla@ti.com>
 *
 */

#ifndef __K3_AM654_DDRSS_H
#define __K3_AM654_DDRSS_H

/* DDRSS subsystem wrapper logic registers */
#include <linux/bitops.h>
#define DDRSS_SS_ID_REV_REG		0x00000000
#define DDRSS_SS_CTL_REG		0x00000004
#define DDRSS_V2H_CTL_REG		0x00000020

#define SS_CTL_REG_CTL_ARST_SHIFT	0x0
#define SS_CTL_REG_CTL_ARST_MASK	BIT(SS_CTL_REG_CTL_ARST_SHIFT)

/* DDRSS controller configuration registers */
#define DDRSS_DDRCTL_MSTR		0x00000000
#define DDRSS_DDRCTL_STAT		0x00000004
#define DDRSS_DDRCTL_MRCTRL0		0x00000010
#define DDRSS_DDRCTL_MRCTRL1		0x00000014
#define DDRSS_DDRCTL_MRSTAT		0x00000018
#define DDRSS_DDRCTL_MRCTRL2		0x0000001C
#define DDRSS_DDRCTL_DERATEEN		0x00000020
#define DDRSS_DDRCTL_DERATEINT		0x00000024
#define DDRSS_DDRCTL_MSTR2		0x00000028
#define DDRSS_DDRCTL_PWRCTL		0x00000030
#define DDRSS_DDRCTL_PWRTMG		0x00000034
#define DDRSS_DDRCTL_HWLPCTL		0x00000038
#define DDRSS_DDRCTL_RFSHCTL0		0x00000050
#define DDRSS_DDRCTL_RFSHCTL1		0x00000054
#define DDRSS_DDRCTL_RFSHCTL2		0x00000058
#define DDRSS_DDRCTL_RFSHCTL3		0x00000060
#define DDRSS_DDRCTL_RFSHTMG		0x00000064
#define DDRSS_DDRCTL_ECCCFG0		0x00000070
#define DDRSS_DDRCTL_ECCCFG1		0x00000074
#define DDRSS_DDRCTL_ECCSTAT		0x00000078
#define DDRSS_DDRCTL_ECCCLR		0x0000007C
#define DDRSS_DDRCTL_ECCERRCNT		0x00000080
#define DDRSS_DDRCTL_ECCCADDR0		0x00000084
#define DDRSS_DDRCTL_ECCCADDR1		0x00000088
#define DDRSS_DDRCTL_ECCCSYN0		0x0000008C
#define DDRSS_DDRCTL_ECCCSYN2		0x00000094
#define DDRSS_DDRCTL_ECCBITMASK0	0x00000098
#define DDRSS_DDRCTL_ECCBITMASK2	0x000000A0
#define DDRSS_DDRCTL_ECCUADDR0		0x000000A4
#define DDRSS_DDRCTL_ECCUADDR1		0x000000A8
#define DDRSS_DDRCTL_ECCUSYN0		0x000000AC
#define DDRSS_DDRCTL_ECCUSYN2		0x000000B4
#define DDRSS_DDRCTL_ECCPOISONADDR0	0x000000B8
#define DDRSS_DDRCTL_ECCPOISONADDR1	0x000000BC
#define DDRSS_DDRCTL_CRCPARCTL0		0x000000C0
#define DDRSS_DDRCTL_CRCPARCTL1		0x000000C4
#define DDRSS_DDRCTL_CRCPARCTL2		0x000000C8
#define DDRSS_DDRCTL_CRCPARSTAT		0x000000CC
#define DDRSS_DDRCTL_INIT0		0x000000D0
#define DDRSS_DDRCTL_INIT1		0x000000D4
#define DDRSS_DDRCTL_INIT2		0x000000D8
#define DDRSS_DDRCTL_INIT3		0x000000DC
#define DDRSS_DDRCTL_INIT4		0x000000E0
#define DDRSS_DDRCTL_INIT5		0x000000E4
#define DDRSS_DDRCTL_INIT6		0x000000E8
#define DDRSS_DDRCTL_INIT7		0x000000EC
#define DDRSS_DDRCTL_DIMMCTL		0x000000F0
#define DDRSS_DDRCTL_RANKCTL		0x000000F4
#define DDRSS_DDRCTL_DRAMTMG0		0x00000100
#define DDRSS_DDRCTL_DRAMTMG1		0x00000104
#define DDRSS_DDRCTL_DRAMTMG2		0x00000108
#define DDRSS_DDRCTL_DRAMTMG3		0x0000010C
#define DDRSS_DDRCTL_DRAMTMG4		0x00000110
#define DDRSS_DDRCTL_DRAMTMG5		0x00000114
#define DDRSS_DDRCTL_DRAMTMG6		0x00000118
#define DDRSS_DDRCTL_DRAMTMG7		0x0000011C
#define DDRSS_DDRCTL_DRAMTMG8		0x00000120
#define DDRSS_DDRCTL_DRAMTMG9		0x00000124
#define DDRSS_DDRCTL_DRAMTMG10		0x00000128
#define DDRSS_DDRCTL_DRAMTMG11		0x0000012C
#define DDRSS_DDRCTL_DRAMTMG12		0x00000130
#define DDRSS_DDRCTL_DRAMTMG13		0x00000134
#define DDRSS_DDRCTL_DRAMTMG14		0x00000138
#define DDRSS_DDRCTL_DRAMTMG15		0x0000013C
#define DDRSS_DDRCTL_DRAMTMG17		0x00000144
#define DDRSS_DDRCTL_ZQCTL0		0x00000180
#define DDRSS_DDRCTL_ZQCTL1		0x00000184
#define DDRSS_DDRCTL_ZQCTL2		0x00000188
#define DDRSS_DDRCTL_ZQSTAT		0x0000018C
#define DDRSS_DDRCTL_DFITMG0		0x00000190
#define DDRSS_DDRCTL_DFITMG1		0x00000194
#define DDRSS_DDRCTL_DFILPCFG0		0x00000198
#define DDRSS_DDRCTL_DFILPCFG1		0x0000019C
#define DDRSS_DDRCTL_DFIUPD0		0x000001A0
#define DDRSS_DDRCTL_DFIUPD1		0x000001A4
#define DDRSS_DDRCTL_DFIUPD2		0x000001A8
#define DDRSS_DDRCTL_DFIMISC		0x000001B0
#define DDRSS_DDRCTL_DFITMG2		0x000001B4
#define DDRSS_DDRCTL_DFITMG3		0x000001B8
#define DDRSS_DDRCTL_DFISTAT		0x000001BC
#define DDRSS_DDRCTL_DBICTL		0x000001C0
#define DDRSS_DDRCTL_DFIPHYMSTR		0x000001C4
#define DDRSS_DDRCTL_ADDRMAP0		0x00000200
#define DDRSS_DDRCTL_ADDRMAP1		0x00000204
#define DDRSS_DDRCTL_ADDRMAP2		0x00000208
#define DDRSS_DDRCTL_ADDRMAP3		0x0000020C
#define DDRSS_DDRCTL_ADDRMAP4		0x00000210
#define DDRSS_DDRCTL_ADDRMAP5		0x00000214
#define DDRSS_DDRCTL_ADDRMAP6		0x00000218
#define DDRSS_DDRCTL_ADDRMAP7		0x0000021C
#define DDRSS_DDRCTL_ADDRMAP8		0x00000220
#define DDRSS_DDRCTL_ADDRMAP9		0x00000224
#define DDRSS_DDRCTL_ADDRMAP10		0x00000228
#define DDRSS_DDRCTL_ADDRMAP11		0x0000022C
#define DDRSS_DDRCTL_ODTCFG		0x00000240
#define DDRSS_DDRCTL_ODTMAP		0x00000244
#define DDRSS_DDRCTL_SCHED		0x00000250
#define DDRSS_DDRCTL_SCHED1		0x00000254
#define DDRSS_DDRCTL_PERFHPR1		0x0000025C
#define DDRSS_DDRCTL_PERFLPR1		0x00000264
#define DDRSS_DDRCTL_PERFWR1		0x0000026C
#define DDRSS_DDRCTL_DQMAP0		0x00000280
#define DDRSS_DDRCTL_DQMAP1		0x00000284
#define DDRSS_DDRCTL_DQMAP4		0x00000290
#define DDRSS_DDRCTL_DQMAP5		0x00000294
#define DDRSS_DDRCTL_DBG0		0x00000300
#define DDRSS_DDRCTL_DBG1		0x00000304
#define DDRSS_DDRCTL_DBGCAM		0x00000308
#define DDRSS_DDRCTL_DBGCMD		0x0000030C
#define DDRSS_DDRCTL_DBGSTAT		0x00000310
#define DDRSS_DDRCTL_SWCTL		0x00000320
#define DDRSS_DDRCTL_SWSTAT		0x00000324
#define DDRSS_DDRCTL_ADVECCINDEX	0x00000374
#define DDRSS_DDRCTL_ECCPOISONPAT0	0x0000037C
#define DDRSS_DDRCTL_ECCPOISONPAT2	0x00000384
#define DDRSS_DDRCTL_CAPARPOISONCTL	0x000003A0
#define DDRSS_DDRCTL_CAPARPOISONSTAT	0x000003A4
#define DDRSS_DDRCTL_DERATEEN_SHDW	0x00002020
#define DDRSS_DDRCTL_DERATEINT_SHDW	0x00002024
#define DDRSS_DDRCTL_RFSHCTL0_SHDW	0x00002050
#define DDRSS_DDRCTL_RFSHTMG_SHDW	0x00002064
#define DDRSS_DDRCTL_INIT3_SHDW		0x000020DC
#define DDRSS_DDRCTL_INIT4_SHDW		0x000020E0
#define DDRSS_DDRCTL_INIT6_SHDW		0x000020E8
#define DDRSS_DDRCTL_INIT7_SHDW		0x000020EC
#define DDRSS_DDRCTL_DRAMTMG0_SHDW	0x00002100
#define DDRSS_DDRCTL_DRAMTMG1_SHDW	0x00002104
#define DDRSS_DDRCTL_DRAMTMG2_SHDW	0x00002108
#define DDRSS_DDRCTL_DRAMTMG3_SHDW	0x0000210C
#define DDRSS_DDRCTL_DRAMTMG4_SHDW	0x00002110
#define DDRSS_DDRCTL_DRAMTMG5_SHDW	0x00002114
#define DDRSS_DDRCTL_DRAMTMG6_SHDW	0x00002118
#define DDRSS_DDRCTL_DRAMTMG7_SHDW	0x0000211C
#define DDRSS_DDRCTL_DRAMTMG8_SHDW	0x00002120
#define DDRSS_DDRCTL_DRAMTMG9_SHDW	0x00002124
#define DDRSS_DDRCTL_DRAMTMG10_SHDW	0x00002128
#define DDRSS_DDRCTL_DRAMTMG11_SHDW	0x0000212C
#define DDRSS_DDRCTL_DRAMTMG12_SHDW	0x00002130
#define DDRSS_DDRCTL_DRAMTMG13_SHDW	0x00002134
#define DDRSS_DDRCTL_DRAMTMG14_SHDW	0x00002138
#define DDRSS_DDRCTL_DRAMTMG15_SHDW	0x0000213C
#define DDRSS_DDRCTL_ZQCTL0_SHDW	0x00002180
#define DDRSS_DDRCTL_DFITMG0_SHDW	0x00002190
#define DDRSS_DDRCTL_DFITMG1_SHDW	0x00002194
#define DDRSS_DDRCTL_DFITMG2_SHDW	0x000021B4
#define DDRSS_DDRCTL_DFITMG3_SHDW	0x000021B8
#define DDRSS_DDRCTL_ODTCFG_SHDW	0x00002240

#define MSTR_DDR_TYPE_MASK		GENMASK(5, 0)
#define DDR_TYPE_LPDDR4			0x20
#define DDR_TYPE_DDR4			0x10
#define DDR_TYPE_DDR3			0x1

#define DDR3_STAT_MODE_MASK		GENMASK(1, 0)
#define DDR4_STAT_MODE_MASK		GENMASK(2, 0)
#define DDR_MODE_NORMAL			0x1

/* DDRSS PHY configuration registers */
#define DDRSS_DDRPHY_RIDR		0x00000000
#define DDRSS_DDRPHY_PIR		0x00000004
#define DDRSS_DDRPHY_PGCR0		0x00000010
#define DDRSS_DDRPHY_PGCR1		0x00000014
#define DDRSS_DDRPHY_PGCR2		0x00000018
#define DDRSS_DDRPHY_PGCR3		0x0000001C
#define DDRSS_DDRPHY_PGCR4		0x00000020
#define DDRSS_DDRPHY_PGCR5		0x00000024
#define DDRSS_DDRPHY_PGCR6		0x00000028
#define DDRSS_DDRPHY_PGCR7		0x0000002C
#define DDRSS_DDRPHY_PGSR0		0x00000030
#define DDRSS_DDRPHY_PGSR1		0x00000034
#define DDRSS_DDRPHY_PGSR2		0x00000038
#define DDRSS_DDRPHY_PTR0		0x00000040
#define DDRSS_DDRPHY_PTR1		0x00000044
#define DDRSS_DDRPHY_PTR2		0x00000048
#define DDRSS_DDRPHY_PTR3		0x0000004C
#define DDRSS_DDRPHY_PTR4		0x00000050
#define DDRSS_DDRPHY_PTR5		0x00000054
#define DDRSS_DDRPHY_PTR6		0x00000058
#define DDRSS_DDRPHY_PLLCR0		0x00000068
#define DDRSS_DDRPHY_PLLCR1		0x0000006C
#define DDRSS_DDRPHY_PLLCR2		0x00000070
#define DDRSS_DDRPHY_PLLCR3		0x00000074
#define DDRSS_DDRPHY_PLLCR4		0x00000078
#define DDRSS_DDRPHY_PLLCR5		0x0000007C
#define DDRSS_DDRPHY_DXCCR		0x00000088
#define DDRSS_DDRPHY_DSGCR		0x00000090
#define DDRSS_DDRPHY_ODTCR		0x00000098
#define DDRSS_DDRPHY_AACR		0x000000A0
#define DDRSS_DDRPHY_GPR0		0x000000C0
#define DDRSS_DDRPHY_GPR1		0x000000C4
#define DDRSS_DDRPHY_DCR		0x00000100
#define DDRSS_DDRPHY_DTPR0		0x00000110
#define DDRSS_DDRPHY_DTPR1		0x00000114
#define DDRSS_DDRPHY_DTPR2		0x00000118
#define DDRSS_DDRPHY_DTPR3		0x0000011C
#define DDRSS_DDRPHY_DTPR4		0x00000120
#define DDRSS_DDRPHY_DTPR5		0x00000124
#define DDRSS_DDRPHY_DTPR6		0x00000128
#define DDRSS_DDRPHY_RDIMMGCR0		0x00000140
#define DDRSS_DDRPHY_RDIMMGCR1		0x00000144
#define DDRSS_DDRPHY_RDIMMGCR2		0x00000148
#define DDRSS_DDRPHY_RDIMMCR0		0x00000150
#define DDRSS_DDRPHY_RDIMMCR1		0x00000154
#define DDRSS_DDRPHY_RDIMMCR2		0x00000158
#define DDRSS_DDRPHY_RDIMMCR3		0x0000015C
#define DDRSS_DDRPHY_RDIMMCR4		0x00000160
#define DDRSS_DDRPHY_SCHCR0		0x00000168
#define DDRSS_DDRPHY_SCHCR1		0x0000016C
#define DDRSS_DDRPHY_MR0		0x00000180
#define DDRSS_DDRPHY_MR1		0x00000184
#define DDRSS_DDRPHY_MR2		0x00000188
#define DDRSS_DDRPHY_MR3		0x0000018C
#define DDRSS_DDRPHY_MR4		0x00000190
#define DDRSS_DDRPHY_MR5		0x00000194
#define DDRSS_DDRPHY_MR6		0x00000198
#define DDRSS_DDRPHY_MR7		0x0000019C
#define DDRSS_DDRPHY_MR11		0x000001AC
#define DDRSS_DDRPHY_MR12		0x000001B0
#define DDRSS_DDRPHY_MR13		0x000001B4
#define DDRSS_DDRPHY_MR14		0x000001B8
#define DDRSS_DDRPHY_MR22		0x000001D8
#define DDRSS_DDRPHY_DTCR0		0x00000200
#define DDRSS_DDRPHY_DTCR1		0x00000204
#define DDRSS_DDRPHY_DTAR0		0x00000208
#define DDRSS_DDRPHY_DTAR1		0x0000020C
#define DDRSS_DDRPHY_DTAR2		0x00000210
#define DDRSS_DDRPHY_DTDR0		0x00000218
#define DDRSS_DDRPHY_DTDR1		0x0000021C
#define DDRSS_DDRPHY_DTEDR0		0x00000230
#define DDRSS_DDRPHY_DTEDR1		0x00000234
#define DDRSS_DDRPHY_DTEDR2		0x00000238
#define DDRSS_DDRPHY_VTDR		0x0000023C
#define DDRSS_DDRPHY_CATR0		0x00000240
#define DDRSS_DDRPHY_CATR1		0x00000244
#define DDRSS_DDRPHY_PGCR8		0x00000248
#define DDRSS_DDRPHY_DQSDR0		0x00000250
#define DDRSS_DDRPHY_DQSDR1		0x00000254
#define DDRSS_DDRPHY_DQSDR2		0x00000258
#define DDRSS_DDRPHY_DCUAR		0x00000300
#define DDRSS_DDRPHY_DCUDR		0x00000304
#define DDRSS_DDRPHY_DCURR		0x00000308
#define DDRSS_DDRPHY_DCULR		0x0000030C
#define DDRSS_DDRPHY_DCUGCR		0x00000310
#define DDRSS_DDRPHY_DCUTPR		0x00000314
#define DDRSS_DDRPHY_DCUSR0		0x00000318
#define DDRSS_DDRPHY_DCUSR1		0x0000031C
#define DDRSS_DDRPHY_BISTRR		0x00000400
#define DDRSS_DDRPHY_BISTWCR		0x00000404
#define DDRSS_DDRPHY_BISTMSKR0		0x00000408
#define DDRSS_DDRPHY_BISTMSKR1		0x0000040C
#define DDRSS_DDRPHY_BISTMSKR2		0x00000410
#define DDRSS_DDRPHY_BISTLSR		0x00000414
#define DDRSS_DDRPHY_BISTAR0		0x00000418
#define DDRSS_DDRPHY_BISTAR1		0x0000041C
#define DDRSS_DDRPHY_BISTAR2		0x00000420
#define DDRSS_DDRPHY_BISTAR3		0x00000424
#define DDRSS_DDRPHY_BISTAR4		0x00000428
#define DDRSS_DDRPHY_BISTUDPR		0x0000042C
#define DDRSS_DDRPHY_BISTGSR		0x00000430
#define DDRSS_DDRPHY_BISTWER0		0x00000434
#define DDRSS_DDRPHY_BISTWER1		0x00000438
#define DDRSS_DDRPHY_BISTBER0		0x0000043C
#define DDRSS_DDRPHY_BISTBER1		0x00000440
#define DDRSS_DDRPHY_BISTBER2		0x00000444
#define DDRSS_DDRPHY_BISTBER3		0x00000448
#define DDRSS_DDRPHY_BISTBER4		0x0000044C
#define DDRSS_DDRPHY_BISTWCSR		0x00000450
#define DDRSS_DDRPHY_BISTFWR0		0x00000454
#define DDRSS_DDRPHY_BISTFWR1		0x00000458
#define DDRSS_DDRPHY_BISTFWR2		0x0000045C
#define DDRSS_DDRPHY_BISTBER5		0x00000460
#define DDRSS_DDRPHY_RANKIDR		0x000004DC
#define DDRSS_DDRPHY_RIOCR0		0x000004E0
#define DDRSS_DDRPHY_RIOCR1		0x000004E4
#define DDRSS_DDRPHY_RIOCR2		0x000004E8
#define DDRSS_DDRPHY_RIOCR3		0x000004EC
#define DDRSS_DDRPHY_RIOCR4		0x000004F0
#define DDRSS_DDRPHY_RIOCR5		0x000004F4
#define DDRSS_DDRPHY_ACIOCR0		0x00000500
#define DDRSS_DDRPHY_ACIOCR1		0x00000504
#define DDRSS_DDRPHY_ACIOCR2		0x00000508
#define DDRSS_DDRPHY_ACIOCR3		0x0000050C
#define DDRSS_DDRPHY_ACIOCR4		0x00000510
#define DDRSS_DDRPHY_ACIOCR5		0x00000514
#define DDRSS_DDRPHY_IOVCR0		0x00000520
#define DDRSS_DDRPHY_IOVCR1		0x00000524
#define DDRSS_DDRPHY_VTCR0		0x00000528
#define DDRSS_DDRPHY_VTCR1		0x0000052C
#define DDRSS_DDRPHY_ACBDLR0		0x00000540
#define DDRSS_DDRPHY_ACBDLR1		0x00000544
#define DDRSS_DDRPHY_ACBDLR2		0x00000548
#define DDRSS_DDRPHY_ACBDLR3		0x0000054C
#define DDRSS_DDRPHY_ACBDLR4		0x00000550
#define DDRSS_DDRPHY_ACBDLR5		0x00000554
#define DDRSS_DDRPHY_ACBDLR6		0x00000558
#define DDRSS_DDRPHY_ACBDLR7		0x0000055C
#define DDRSS_DDRPHY_ACBDLR8		0x00000560
#define DDRSS_DDRPHY_ACBDLR9		0x00000564
#define DDRSS_DDRPHY_ACBDLR10		0x00000568
#define DDRSS_DDRPHY_ACBDLR11		0x0000056C
#define DDRSS_DDRPHY_ACBDLR12		0x00000570
#define DDRSS_DDRPHY_ACBDLR13		0x00000574
#define DDRSS_DDRPHY_ACBDLR14		0x00000578
#define DDRSS_DDRPHY_ACBDLR15		0x0000057C
#define DDRSS_DDRPHY_ACBDLR16		0x00000580
#define DDRSS_DDRPHY_ACLCDLR		0x00000584
#define DDRSS_DDRPHY_ACMDLR0		0x000005A0
#define DDRSS_DDRPHY_ACMDLR1		0x000005A4
#define DDRSS_DDRPHY_ZQCR		0x00000680
#define DDRSS_DDRPHY_ZQ0PR0		0x00000684
#define DDRSS_DDRPHY_ZQ0PR1		0x00000688
#define DDRSS_DDRPHY_ZQ0DR0		0x0000068C
#define DDRSS_DDRPHY_ZQ0DR1		0x00000690
#define DDRSS_DDRPHY_ZQ0OR0		0x00000694
#define DDRSS_DDRPHY_ZQ0OR1		0x00000698
#define DDRSS_DDRPHY_ZQ0SR		0x0000069C
#define DDRSS_DDRPHY_ZQ1PR0		0x000006A4
#define DDRSS_DDRPHY_ZQ1PR1		0x000006A8
#define DDRSS_DDRPHY_ZQ1DR0		0x000006AC
#define DDRSS_DDRPHY_ZQ1DR1		0x000006B0
#define DDRSS_DDRPHY_ZQ1OR0		0x000006B4
#define DDRSS_DDRPHY_ZQ1OR1		0x000006B8
#define DDRSS_DDRPHY_ZQ1SR		0x000006BC
#define DDRSS_DDRPHY_ZQ2PR0		0x000006C4
#define DDRSS_DDRPHY_ZQ2PR1		0x000006C8
#define DDRSS_DDRPHY_ZQ2DR0		0x000006CC
#define DDRSS_DDRPHY_ZQ2DR1		0x000006D0
#define DDRSS_DDRPHY_ZQ2OR0		0x000006D4
#define DDRSS_DDRPHY_ZQ2OR1		0x000006D8
#define DDRSS_DDRPHY_ZQ2SR		0x000006DC
#define DDRSS_DDRPHY_ZQ3PR0		0x000006E4
#define DDRSS_DDRPHY_ZQ3PR1		0x000006E8
#define DDRSS_DDRPHY_ZQ3DR0		0x000006EC
#define DDRSS_DDRPHY_ZQ3DR1		0x000006F0
#define DDRSS_DDRPHY_ZQ3OR0		0x000006F4
#define DDRSS_DDRPHY_ZQ3OR1		0x000006F8
#define DDRSS_DDRPHY_ZQ3SR		0x000006FC
#define DDRSS_DDRPHY_DX0GCR0		0x00000700
#define DDRSS_DDRPHY_DX0GCR1		0x00000704
#define DDRSS_DDRPHY_DX0GCR2		0x00000708
#define DDRSS_DDRPHY_DX0GCR3		0x0000070C
#define DDRSS_DDRPHY_DX0GCR4		0x00000710
#define DDRSS_DDRPHY_DX0GCR5		0x00000714
#define DDRSS_DDRPHY_DX0GCR6		0x00000718
#define DDRSS_DDRPHY_DX0GCR7		0x0000071C
#define DDRSS_DDRPHY_DX0GCR8		0x00000720
#define DDRSS_DDRPHY_DX0GCR9		0x00000724
#define DDRSS_DDRPHY_DX0DQMAP0		0x00000728
#define DDRSS_DDRPHY_DX0DQMAP1		0x0000072C
#define DDRSS_DDRPHY_DX0BDLR0		0x00000740
#define DDRSS_DDRPHY_DX0BDLR1		0x00000744
#define DDRSS_DDRPHY_DX0BDLR2		0x00000748
#define DDRSS_DDRPHY_DX0BDLR3		0x00000750
#define DDRSS_DDRPHY_DX0BDLR4		0x00000754
#define DDRSS_DDRPHY_DX0BDLR5		0x00000758
#define DDRSS_DDRPHY_DX0BDLR6		0x00000760
#define DDRSS_DDRPHY_DX0BDLR7		0x00000764
#define DDRSS_DDRPHY_DX0BDLR8		0x00000768
#define DDRSS_DDRPHY_DX0BDLR9		0x0000076C
#define DDRSS_DDRPHY_DX0LCDLR0		0x00000780
#define DDRSS_DDRPHY_DX0LCDLR1		0x00000784
#define DDRSS_DDRPHY_DX0LCDLR2		0x00000788
#define DDRSS_DDRPHY_DX0LCDLR3		0x0000078C
#define DDRSS_DDRPHY_DX0LCDLR4		0x00000790
#define DDRSS_DDRPHY_DX0LCDLR5		0x00000794
#define DDRSS_DDRPHY_DX0MDLR0		0x000007A0
#define DDRSS_DDRPHY_DX0MDLR1		0x000007A4
#define DDRSS_DDRPHY_DX0GTR0		0x000007C0
#define DDRSS_DDRPHY_DX0RSR0		0x000007D0
#define DDRSS_DDRPHY_DX0RSR1		0x000007D4
#define DDRSS_DDRPHY_DX0RSR2		0x000007D8
#define DDRSS_DDRPHY_DX0RSR3		0x000007DC
#define DDRSS_DDRPHY_DX0GSR0		0x000007E0
#define DDRSS_DDRPHY_DX0GSR1		0x000007E4
#define DDRSS_DDRPHY_DX0GSR2		0x000007E8
#define DDRSS_DDRPHY_DX0GSR3		0x000007EC
#define DDRSS_DDRPHY_DX0GSR4		0x000007F0
#define DDRSS_DDRPHY_DX0GSR5		0x000007F4
#define DDRSS_DDRPHY_DX0GSR6		0x000007F8
#define DDRSS_DDRPHY_DX1GCR0		0x00000800
#define DDRSS_DDRPHY_DX1GCR1		0x00000804
#define DDRSS_DDRPHY_DX1GCR2		0x00000808
#define DDRSS_DDRPHY_DX1GCR3		0x0000080C
#define DDRSS_DDRPHY_DX1GCR4		0x00000810
#define DDRSS_DDRPHY_DX1GCR5		0x00000814
#define DDRSS_DDRPHY_DX1GCR6		0x00000818
#define DDRSS_DDRPHY_DX1GCR7		0x0000081C
#define DDRSS_DDRPHY_DX1GCR8		0x00000820
#define DDRSS_DDRPHY_DX1GCR9		0x00000824
#define DDRSS_DDRPHY_DX1DQMAP0		0x00000828
#define DDRSS_DDRPHY_DX1DQMAP1		0x0000082C
#define DDRSS_DDRPHY_DX1BDLR0		0x00000840
#define DDRSS_DDRPHY_DX1BDLR1		0x00000844
#define DDRSS_DDRPHY_DX1BDLR2		0x00000848
#define DDRSS_DDRPHY_DX1BDLR3		0x00000850
#define DDRSS_DDRPHY_DX1BDLR4		0x00000854
#define DDRSS_DDRPHY_DX1BDLR5		0x00000858
#define DDRSS_DDRPHY_DX1BDLR6		0x00000860
#define DDRSS_DDRPHY_DX1BDLR7		0x00000864
#define DDRSS_DDRPHY_DX1BDLR8		0x00000868
#define DDRSS_DDRPHY_DX1BDLR9		0x0000086C
#define DDRSS_DDRPHY_DX1LCDLR0		0x00000880
#define DDRSS_DDRPHY_DX1LCDLR1		0x00000884
#define DDRSS_DDRPHY_DX1LCDLR2		0x00000888
#define DDRSS_DDRPHY_DX1LCDLR3		0x0000088C
#define DDRSS_DDRPHY_DX1LCDLR4		0x00000890
#define DDRSS_DDRPHY_DX1LCDLR5		0x00000894
#define DDRSS_DDRPHY_DX1MDLR0		0x000008A0
#define DDRSS_DDRPHY_DX1MDLR1		0x000008A4
#define DDRSS_DDRPHY_DX1GTR0		0x000008C0
#define DDRSS_DDRPHY_DX1RSR0		0x000008D0
#define DDRSS_DDRPHY_DX1RSR1		0x000008D4
#define DDRSS_DDRPHY_DX1RSR2		0x000008D8
#define DDRSS_DDRPHY_DX1RSR3		0x000008DC
#define DDRSS_DDRPHY_DX1GSR0		0x000008E0
#define DDRSS_DDRPHY_DX1GSR1		0x000008E4
#define DDRSS_DDRPHY_DX1GSR2		0x000008E8
#define DDRSS_DDRPHY_DX1GSR3		0x000008EC
#define DDRSS_DDRPHY_DX1GSR4		0x000008F0
#define DDRSS_DDRPHY_DX1GSR5		0x000008F4
#define DDRSS_DDRPHY_DX1GSR6		0x000008F8
#define DDRSS_DDRPHY_DX2GCR0		0x00000900
#define DDRSS_DDRPHY_DX2GCR1		0x00000904
#define DDRSS_DDRPHY_DX2GCR2		0x00000908
#define DDRSS_DDRPHY_DX2GCR3		0x0000090C
#define DDRSS_DDRPHY_DX2GCR4		0x00000910
#define DDRSS_DDRPHY_DX2GCR5		0x00000914
#define DDRSS_DDRPHY_DX2GCR6		0x00000918
#define DDRSS_DDRPHY_DX2GCR7		0x0000091C
#define DDRSS_DDRPHY_DX2GCR8		0x00000920
#define DDRSS_DDRPHY_DX2GCR9		0x00000924
#define DDRSS_DDRPHY_DX2DQMAP0		0x00000928
#define DDRSS_DDRPHY_DX2DQMAP1		0x0000092C
#define DDRSS_DDRPHY_DX2BDLR0		0x00000940
#define DDRSS_DDRPHY_DX2BDLR1		0x00000944
#define DDRSS_DDRPHY_DX2BDLR2		0x00000948
#define DDRSS_DDRPHY_DX2BDLR3		0x00000950
#define DDRSS_DDRPHY_DX2BDLR4		0x00000954
#define DDRSS_DDRPHY_DX2BDLR5		0x00000958
#define DDRSS_DDRPHY_DX2BDLR6		0x00000960
#define DDRSS_DDRPHY_DX2BDLR7		0x00000964
#define DDRSS_DDRPHY_DX2BDLR8		0x00000968
#define DDRSS_DDRPHY_DX2BDLR9		0x0000096C
#define DDRSS_DDRPHY_DX2LCDLR0		0x00000980
#define DDRSS_DDRPHY_DX2LCDLR1		0x00000984
#define DDRSS_DDRPHY_DX2LCDLR2		0x00000988
#define DDRSS_DDRPHY_DX2LCDLR3		0x0000098C
#define DDRSS_DDRPHY_DX2LCDLR4		0x00000990
#define DDRSS_DDRPHY_DX2LCDLR5		0x00000994
#define DDRSS_DDRPHY_DX2MDLR0		0x000009A0
#define DDRSS_DDRPHY_DX2MDLR1		0x000009A4
#define DDRSS_DDRPHY_DX2GTR0		0x000009C0
#define DDRSS_DDRPHY_DX2RSR0		0x000009D0
#define DDRSS_DDRPHY_DX2RSR1		0x000009D4
#define DDRSS_DDRPHY_DX2RSR2		0x000009D8
#define DDRSS_DDRPHY_DX2RSR3		0x000009DC
#define DDRSS_DDRPHY_DX2GSR0		0x000009E0
#define DDRSS_DDRPHY_DX2GSR1		0x000009E4
#define DDRSS_DDRPHY_DX2GSR2		0x000009E8
#define DDRSS_DDRPHY_DX2GSR3		0x000009EC
#define DDRSS_DDRPHY_DX2GSR4		0x000009F0
#define DDRSS_DDRPHY_DX2GSR5		0x000009F4
#define DDRSS_DDRPHY_DX2GSR6		0x000009F8
#define DDRSS_DDRPHY_DX3GCR0		0x00000A00
#define DDRSS_DDRPHY_DX3GCR1		0x00000A04
#define DDRSS_DDRPHY_DX3GCR2		0x00000A08
#define DDRSS_DDRPHY_DX3GCR3		0x00000A0C
#define DDRSS_DDRPHY_DX3GCR4		0x00000A10
#define DDRSS_DDRPHY_DX3GCR5		0x00000A14
#define DDRSS_DDRPHY_DX3GCR6		0x00000A18
#define DDRSS_DDRPHY_DX3GCR7		0x00000A1C
#define DDRSS_DDRPHY_DX3GCR8		0x00000A20
#define DDRSS_DDRPHY_DX3GCR9		0x00000A24
#define DDRSS_DDRPHY_DX3DQMAP0		0x00000A28
#define DDRSS_DDRPHY_DX3DQMAP1		0x00000A2C
#define DDRSS_DDRPHY_DX3BDLR0		0x00000A40
#define DDRSS_DDRPHY_DX3BDLR1		0x00000A44
#define DDRSS_DDRPHY_DX3BDLR2		0x00000A48
#define DDRSS_DDRPHY_DX3BDLR3		0x00000A50
#define DDRSS_DDRPHY_DX3BDLR4		0x00000A54
#define DDRSS_DDRPHY_DX3BDLR5		0x00000A58
#define DDRSS_DDRPHY_DX3BDLR6		0x00000A60
#define DDRSS_DDRPHY_DX3BDLR7		0x00000A64
#define DDRSS_DDRPHY_DX3BDLR8		0x00000A68
#define DDRSS_DDRPHY_DX3BDLR9		0x00000A6C
#define DDRSS_DDRPHY_DX3LCDLR0		0x00000A80
#define DDRSS_DDRPHY_DX3LCDLR1		0x00000A84
#define DDRSS_DDRPHY_DX3LCDLR2		0x00000A88
#define DDRSS_DDRPHY_DX3LCDLR3		0x00000A8C
#define DDRSS_DDRPHY_DX3LCDLR4		0x00000A90
#define DDRSS_DDRPHY_DX3LCDLR5		0x00000A94
#define DDRSS_DDRPHY_DX3MDLR0		0x00000AA0
#define DDRSS_DDRPHY_DX3MDLR1		0x00000AA4
#define DDRSS_DDRPHY_DX3GTR0		0x00000AC0
#define DDRSS_DDRPHY_DX3RSR0		0x00000AD0
#define DDRSS_DDRPHY_DX3RSR1		0x00000AD4
#define DDRSS_DDRPHY_DX3RSR2		0x00000AD8
#define DDRSS_DDRPHY_DX3RSR3		0x00000ADC
#define DDRSS_DDRPHY_DX3GSR0		0x00000AE0
#define DDRSS_DDRPHY_DX3GSR1		0x00000AE4
#define DDRSS_DDRPHY_DX3GSR2		0x00000AE8
#define DDRSS_DDRPHY_DX3GSR3		0x00000AEC
#define DDRSS_DDRPHY_DX3GSR4		0x00000AF0
#define DDRSS_DDRPHY_DX3GSR5		0x00000AF4
#define DDRSS_DDRPHY_DX3GSR6		0x00000AF8
#define DDRSS_DDRPHY_DX4GCR0		0x00000B00
#define DDRSS_DDRPHY_DX4GCR1		0x00000B04
#define DDRSS_DDRPHY_DX4GCR2		0x00000B08
#define DDRSS_DDRPHY_DX4GCR3		0x00000B0C
#define DDRSS_DDRPHY_DX4GCR4		0x00000B10
#define DDRSS_DDRPHY_DX4GCR5		0x00000B14
#define DDRSS_DDRPHY_DX4GCR6		0x00000B18
#define DDRSS_DDRPHY_DX4GCR7		0x00000B1C
#define DDRSS_DDRPHY_DX4GCR8		0x00000B20
#define DDRSS_DDRPHY_DX4GCR9		0x00000B24
#define DDRSS_DDRPHY_DX4DQMAP0		0x00000B28
#define DDRSS_DDRPHY_DX4DQMAP1		0x00000B2C
#define DDRSS_DDRPHY_DX4BDLR0		0x00000B40
#define DDRSS_DDRPHY_DX4BDLR1		0x00000B44
#define DDRSS_DDRPHY_DX4BDLR2		0x00000B48
#define DDRSS_DDRPHY_DX4BDLR3		0x00000B50
#define DDRSS_DDRPHY_DX4BDLR4		0x00000B54
#define DDRSS_DDRPHY_DX4BDLR5		0x00000B58
#define DDRSS_DDRPHY_DX4BDLR6		0x00000B60
#define DDRSS_DDRPHY_DX4BDLR7		0x00000B64
#define DDRSS_DDRPHY_DX4BDLR8		0x00000B68
#define DDRSS_DDRPHY_DX4BDLR9		0x00000B6C
#define DDRSS_DDRPHY_DX4LCDLR0		0x00000B80
#define DDRSS_DDRPHY_DX4LCDLR1		0x00000B84
#define DDRSS_DDRPHY_DX4LCDLR2		0x00000B88
#define DDRSS_DDRPHY_DX4LCDLR3		0x00000B8C
#define DDRSS_DDRPHY_DX4LCDLR4		0x00000B90
#define DDRSS_DDRPHY_DX4LCDLR5		0x00000B94
#define DDRSS_DDRPHY_DX4MDLR0		0x00000BA0
#define DDRSS_DDRPHY_DX4MDLR1		0x00000BA4
#define DDRSS_DDRPHY_DX4GTR0		0x00000BC0
#define DDRSS_DDRPHY_DX4RSR0		0x00000BD0
#define DDRSS_DDRPHY_DX4RSR1		0x00000BD4
#define DDRSS_DDRPHY_DX4RSR2		0x00000BD8
#define DDRSS_DDRPHY_DX4RSR3		0x00000BDC
#define DDRSS_DDRPHY_DX4GSR0		0x00000BE0
#define DDRSS_DDRPHY_DX4GSR1		0x00000BE4
#define DDRSS_DDRPHY_DX4GSR2		0x00000BE8
#define DDRSS_DDRPHY_DX4GSR3		0x00000BEC
#define DDRSS_DDRPHY_DX4GSR4		0x00000BF0
#define DDRSS_DDRPHY_DX4GSR5		0x00000BF4
#define DDRSS_DDRPHY_DX4GSR6		0x00000BF8
#define DDRSS_DDRPHY_DX5GCR0		0x00000C00
#define DDRSS_DDRPHY_DX5GCR1		0x00000C04
#define DDRSS_DDRPHY_DX5GCR2		0x00000C08
#define DDRSS_DDRPHY_DX5GCR3		0x00000C0C
#define DDRSS_DDRPHY_DX5GCR4		0x00000C10
#define DDRSS_DDRPHY_DX5GCR5		0x00000C14
#define DDRSS_DDRPHY_DX5GCR6		0x00000C18
#define DDRSS_DDRPHY_DX5GCR7		0x00000C1C
#define DDRSS_DDRPHY_DX5GCR8		0x00000C20
#define DDRSS_DDRPHY_DX5GCR9		0x00000C24
#define DDRSS_DDRPHY_DX5DQMAP0		0x00000C28
#define DDRSS_DDRPHY_DX5DQMAP1		0x00000C2C
#define DDRSS_DDRPHY_DX5BDLR0		0x00000C40
#define DDRSS_DDRPHY_DX5BDLR1		0x00000C44
#define DDRSS_DDRPHY_DX5BDLR2		0x00000C48
#define DDRSS_DDRPHY_DX5BDLR3		0x00000C50
#define DDRSS_DDRPHY_DX5BDLR4		0x00000C54
#define DDRSS_DDRPHY_DX5BDLR5		0x00000C58
#define DDRSS_DDRPHY_DX5BDLR6		0x00000C60
#define DDRSS_DDRPHY_DX5BDLR7		0x00000C64
#define DDRSS_DDRPHY_DX5BDLR8		0x00000C68
#define DDRSS_DDRPHY_DX5BDLR9		0x00000C6C
#define DDRSS_DDRPHY_DX5LCDLR0		0x00000C80
#define DDRSS_DDRPHY_DX5LCDLR1		0x00000C84
#define DDRSS_DDRPHY_DX5LCDLR2		0x00000C88
#define DDRSS_DDRPHY_DX5LCDLR3		0x00000C8C
#define DDRSS_DDRPHY_DX5LCDLR4		0x00000C90
#define DDRSS_DDRPHY_DX5LCDLR5		0x00000C94
#define DDRSS_DDRPHY_DX5MDLR0		0x00000CA0
#define DDRSS_DDRPHY_DX5MDLR1		0x00000CA4
#define DDRSS_DDRPHY_DX5GTR0		0x00000CC0
#define DDRSS_DDRPHY_DX5RSR0		0x00000CD0
#define DDRSS_DDRPHY_DX5RSR1		0x00000CD4
#define DDRSS_DDRPHY_DX5RSR2		0x00000CD8
#define DDRSS_DDRPHY_DX5RSR3		0x00000CDC
#define DDRSS_DDRPHY_DX5GSR0		0x00000CE0
#define DDRSS_DDRPHY_DX5GSR1		0x00000CE4
#define DDRSS_DDRPHY_DX5GSR2		0x00000CE8
#define DDRSS_DDRPHY_DX5GSR3		0x00000CEC
#define DDRSS_DDRPHY_DX5GSR4		0x00000CF0
#define DDRSS_DDRPHY_DX5GSR5		0x00000CF4
#define DDRSS_DDRPHY_DX5GSR6		0x00000CF8
#define DDRSS_DDRPHY_DX6GCR0		0x00000D00
#define DDRSS_DDRPHY_DX6GCR1		0x00000D04
#define DDRSS_DDRPHY_DX6GCR2		0x00000D08
#define DDRSS_DDRPHY_DX6GCR3		0x00000D0C
#define DDRSS_DDRPHY_DX6GCR4		0x00000D10
#define DDRSS_DDRPHY_DX6GCR5		0x00000D14
#define DDRSS_DDRPHY_DX6GCR6		0x00000D18
#define DDRSS_DDRPHY_DX6GCR7		0x00000D1C
#define DDRSS_DDRPHY_DX6GCR8		0x00000D20
#define DDRSS_DDRPHY_DX6GCR9		0x00000D24
#define DDRSS_DDRPHY_DX6DQMAP0		0x00000D28
#define DDRSS_DDRPHY_DX6DQMAP1		0x00000D2C
#define DDRSS_DDRPHY_DX6BDLR0		0x00000D40
#define DDRSS_DDRPHY_DX6BDLR1		0x00000D44
#define DDRSS_DDRPHY_DX6BDLR2		0x00000D48
#define DDRSS_DDRPHY_DX6BDLR3		0x00000D50
#define DDRSS_DDRPHY_DX6BDLR4		0x00000D54
#define DDRSS_DDRPHY_DX6BDLR5		0x00000D58
#define DDRSS_DDRPHY_DX6BDLR6		0x00000D60
#define DDRSS_DDRPHY_DX6BDLR7		0x00000D64
#define DDRSS_DDRPHY_DX6BDLR8		0x00000D68
#define DDRSS_DDRPHY_DX6BDLR9		0x00000D6C
#define DDRSS_DDRPHY_DX6LCDLR0		0x00000D80
#define DDRSS_DDRPHY_DX6LCDLR1		0x00000D84
#define DDRSS_DDRPHY_DX6LCDLR2		0x00000D88
#define DDRSS_DDRPHY_DX6LCDLR3		0x00000D8C
#define DDRSS_DDRPHY_DX6LCDLR4		0x00000D90
#define DDRSS_DDRPHY_DX6LCDLR5		0x00000D94
#define DDRSS_DDRPHY_DX6MDLR0		0x00000DA0
#define DDRSS_DDRPHY_DX6MDLR1		0x00000DA4
#define DDRSS_DDRPHY_DX6GTR0		0x00000DC0
#define DDRSS_DDRPHY_DX6RSR0		0x00000DD0
#define DDRSS_DDRPHY_DX6RSR1		0x00000DD4
#define DDRSS_DDRPHY_DX6RSR2		0x00000DD8
#define DDRSS_DDRPHY_DX6RSR3		0x00000DDC
#define DDRSS_DDRPHY_DX6GSR0		0x00000DE0
#define DDRSS_DDRPHY_DX6GSR1		0x00000DE4
#define DDRSS_DDRPHY_DX6GSR2		0x00000DE8
#define DDRSS_DDRPHY_DX6GSR3		0x00000DEC
#define DDRSS_DDRPHY_DX6GSR4		0x00000DF0
#define DDRSS_DDRPHY_DX6GSR5		0x00000DF4
#define DDRSS_DDRPHY_DX6GSR6		0x00000DF8
#define DDRSS_DDRPHY_DX7GCR0		0x00000E00
#define DDRSS_DDRPHY_DX7GCR1		0x00000E04
#define DDRSS_DDRPHY_DX7GCR2		0x00000E08
#define DDRSS_DDRPHY_DX7GCR3		0x00000E0C
#define DDRSS_DDRPHY_DX7GCR4		0x00000E10
#define DDRSS_DDRPHY_DX7GCR5		0x00000E14
#define DDRSS_DDRPHY_DX7GCR6		0x00000E18
#define DDRSS_DDRPHY_DX7GCR7		0x00000E1C
#define DDRSS_DDRPHY_DX7GCR8		0x00000E20
#define DDRSS_DDRPHY_DX7GCR9		0x00000E24
#define DDRSS_DDRPHY_DX7DQMAP0		0x00000E28
#define DDRSS_DDRPHY_DX7DQMAP1		0x00000E2C
#define DDRSS_DDRPHY_DX7BDLR0		0x00000E40
#define DDRSS_DDRPHY_DX7BDLR1		0x00000E44
#define DDRSS_DDRPHY_DX7BDLR2		0x00000E48
#define DDRSS_DDRPHY_DX7BDLR3		0x00000E50
#define DDRSS_DDRPHY_DX7BDLR4		0x00000E54
#define DDRSS_DDRPHY_DX7BDLR5		0x00000E58
#define DDRSS_DDRPHY_DX7BDLR6		0x00000E60
#define DDRSS_DDRPHY_DX7BDLR7		0x00000E64
#define DDRSS_DDRPHY_DX7BDLR8		0x00000E68
#define DDRSS_DDRPHY_DX7BDLR9		0x00000E6C
#define DDRSS_DDRPHY_DX7LCDLR0		0x00000E80
#define DDRSS_DDRPHY_DX7LCDLR1		0x00000E84
#define DDRSS_DDRPHY_DX7LCDLR2		0x00000E88
#define DDRSS_DDRPHY_DX7LCDLR3		0x00000E8C
#define DDRSS_DDRPHY_DX7LCDLR4		0x00000E90
#define DDRSS_DDRPHY_DX7LCDLR5		0x00000E94
#define DDRSS_DDRPHY_DX7MDLR0		0x00000EA0
#define DDRSS_DDRPHY_DX7MDLR1		0x00000EA4
#define DDRSS_DDRPHY_DX7GTR0		0x00000EC0
#define DDRSS_DDRPHY_DX7RSR0		0x00000ED0
#define DDRSS_DDRPHY_DX7RSR1		0x00000ED4
#define DDRSS_DDRPHY_DX7RSR2		0x00000ED8
#define DDRSS_DDRPHY_DX7RSR3		0x00000EDC
#define DDRSS_DDRPHY_DX7GSR0		0x00000EE0
#define DDRSS_DDRPHY_DX7GSR1		0x00000EE4
#define DDRSS_DDRPHY_DX7GSR2		0x00000EE8
#define DDRSS_DDRPHY_DX7GSR3		0x00000EEC
#define DDRSS_DDRPHY_DX7GSR4		0x00000EF0
#define DDRSS_DDRPHY_DX7GSR5		0x00000EF4
#define DDRSS_DDRPHY_DX7GSR6		0x00000EF8
#define DDRSS_DDRPHY_DX8GCR0		0x00000F00
#define DDRSS_DDRPHY_DX8GCR1		0x00000F04
#define DDRSS_DDRPHY_DX8GCR2		0x00000F08
#define DDRSS_DDRPHY_DX8GCR3		0x00000F0C
#define DDRSS_DDRPHY_DX8GCR4		0x00000F10
#define DDRSS_DDRPHY_DX8GCR5		0x00000F14
#define DDRSS_DDRPHY_DX8GCR6		0x00000F18
#define DDRSS_DDRPHY_DX8GCR7		0x00000F1C
#define DDRSS_DDRPHY_DX8GCR8		0x00000F20
#define DDRSS_DDRPHY_DX8GCR9		0x00000F24
#define DDRSS_DDRPHY_DX8DQMAP0		0x00000F28
#define DDRSS_DDRPHY_DX8DQMAP1		0x00000F2C
#define DDRSS_DDRPHY_DX8BDLR0		0x00000F40
#define DDRSS_DDRPHY_DX8BDLR1		0x00000F44
#define DDRSS_DDRPHY_DX8BDLR2		0x00000F48
#define DDRSS_DDRPHY_DX8BDLR3		0x00000F50
#define DDRSS_DDRPHY_DX8BDLR4		0x00000F54
#define DDRSS_DDRPHY_DX8BDLR5		0x00000F58
#define DDRSS_DDRPHY_DX8BDLR6		0x00000F60
#define DDRSS_DDRPHY_DX8BDLR7		0x00000F64
#define DDRSS_DDRPHY_DX8BDLR8		0x00000F68
#define DDRSS_DDRPHY_DX8BDLR9		0x00000F6C
#define DDRSS_DDRPHY_DX8LCDLR0		0x00000F80
#define DDRSS_DDRPHY_DX8LCDLR1		0x00000F84
#define DDRSS_DDRPHY_DX8LCDLR2		0x00000F88
#define DDRSS_DDRPHY_DX8LCDLR3		0x00000F8C
#define DDRSS_DDRPHY_DX8LCDLR4		0x00000F90
#define DDRSS_DDRPHY_DX8LCDLR5		0x00000F94
#define DDRSS_DDRPHY_DX8MDLR0		0x00000FA0
#define DDRSS_DDRPHY_DX8MDLR1		0x00000FA4
#define DDRSS_DDRPHY_DX8GTR0		0x00000FC0
#define DDRSS_DDRPHY_DX8RSR0		0x00000FD0
#define DDRSS_DDRPHY_DX8RSR1		0x00000FD4
#define DDRSS_DDRPHY_DX8RSR2		0x00000FD8
#define DDRSS_DDRPHY_DX8RSR3		0x00000FDC
#define DDRSS_DDRPHY_DX8GSR0		0x00000FE0
#define DDRSS_DDRPHY_DX8GSR1		0x00000FE4
#define DDRSS_DDRPHY_DX8GSR2		0x00000FE8
#define DDRSS_DDRPHY_DX8GSR3		0x00000FEC
#define DDRSS_DDRPHY_DX8GSR4		0x00000FF0
#define DDRSS_DDRPHY_DX8GSR5		0x00000FF4
#define DDRSS_DDRPHY_DX8GSR6		0x00000FF8
#define DDRSS_DDRPHY_DX8SL0OSC		0x00001400
#define DDRSS_DDRPHY_DX8SL0PLLCR0	0x00001404
#define DDRSS_DDRPHY_DX8SL0PLLCR1	0x00001408
#define DDRSS_DDRPHY_DX8SL0PLLCR2	0x0000140C
#define DDRSS_DDRPHY_DX8SL0PLLCR3	0x00001410
#define DDRSS_DDRPHY_DX8SL0PLLCR4	0x00001414
#define DDRSS_DDRPHY_DX8SL0PLLCR5	0x00001418
#define DDRSS_DDRPHY_DX8SL0DQSCTL	0x0000141C
#define DDRSS_DDRPHY_DX8SL0TRNCTL	0x00001420
#define DDRSS_DDRPHY_DX8SL0DDLCTL	0x00001424
#define DDRSS_DDRPHY_DX8SL0DXCTL1	0x00001428
#define DDRSS_DDRPHY_DX8SL0DXCTL2	0x0000142C
#define DDRSS_DDRPHY_DX8SL0IOCR		0x00001430
#define DDRSS_DDRPHY_DX4SL0IOCR		0x00001434
#define DDRSS_DDRPHY_DX8SL1OSC		0x00001440
#define DDRSS_DDRPHY_DX8SL1PLLCR0	0x00001444
#define DDRSS_DDRPHY_DX8SL1PLLCR1	0x00001448
#define DDRSS_DDRPHY_DX8SL1PLLCR2	0x0000144C
#define DDRSS_DDRPHY_DX8SL1PLLCR3	0x00001450
#define DDRSS_DDRPHY_DX8SL1PLLCR4	0x00001454
#define DDRSS_DDRPHY_DX8SL1PLLCR5	0x00001458
#define DDRSS_DDRPHY_DX8SL1DQSCTL	0x0000145C
#define DDRSS_DDRPHY_DX8SL1TRNCTL	0x00001460
#define DDRSS_DDRPHY_DX8SL1DDLCTL	0x00001464
#define DDRSS_DDRPHY_DX8SL1DXCTL1	0x00001468
#define DDRSS_DDRPHY_DX8SL1DXCTL2	0x0000146C
#define DDRSS_DDRPHY_DX8SL1IOCR		0x00001470
#define DDRSS_DDRPHY_DX4SL1IOCR		0x00001474
#define DDRSS_DDRPHY_DX8SL2OSC		0x00001480
#define DDRSS_DDRPHY_DX8SL2PLLCR0	0x00001484
#define DDRSS_DDRPHY_DX8SL2PLLCR1	0x00001488
#define DDRSS_DDRPHY_DX8SL2PLLCR2	0x0000148C
#define DDRSS_DDRPHY_DX8SL2PLLCR3	0x00001490
#define DDRSS_DDRPHY_DX8SL2PLLCR4	0x00001494
#define DDRSS_DDRPHY_DX8SL2PLLCR5	0x00001498
#define DDRSS_DDRPHY_DX8SL2DQSCTL	0x0000149C
#define DDRSS_DDRPHY_DX8SL2TRNCTL	0x000014A0
#define DDRSS_DDRPHY_DX8SL2DDLCTL	0x000014A4
#define DDRSS_DDRPHY_DX8SL2DXCTL1	0x000014A8
#define DDRSS_DDRPHY_DX8SL2DXCTL2	0x000014AC
#define DDRSS_DDRPHY_DX8SL2IOCR		0x000014B0
#define DDRSS_DDRPHY_DX4SL2IOCR		0x000014B4
#define DDRSS_DDRPHY_DX8SL3OSC		0x000014C0
#define DDRSS_DDRPHY_DX8SL3PLLCR0	0x000014C4
#define DDRSS_DDRPHY_DX8SL3PLLCR1	0x000014C8
#define DDRSS_DDRPHY_DX8SL3PLLCR2	0x000014CC
#define DDRSS_DDRPHY_DX8SL3PLLCR3	0x000014D0
#define DDRSS_DDRPHY_DX8SL3PLLCR4	0x000014D4
#define DDRSS_DDRPHY_DX8SL3PLLCR5	0x000014D8
#define DDRSS_DDRPHY_DX8SL3DQSCTL	0x000014DC
#define DDRSS_DDRPHY_DX8SL3TRNCTL	0x000014E0
#define DDRSS_DDRPHY_DX8SL3DDLCTL	0x000014E4
#define DDRSS_DDRPHY_DX8SL3DXCTL1	0x000014E8
#define DDRSS_DDRPHY_DX8SL3DXCTL2	0x000014EC
#define DDRSS_DDRPHY_DX8SL3IOCR		0x000014F0
#define DDRSS_DDRPHY_DX4SL3IOCR		0x000014F4
#define DDRSS_DDRPHY_DX8SL4OSC		0x00001500
#define DDRSS_DDRPHY_DX8SL4PLLCR0	0x00001504
#define DDRSS_DDRPHY_DX8SL4PLLCR1	0x00001508
#define DDRSS_DDRPHY_DX8SL4PLLCR2	0x0000150C
#define DDRSS_DDRPHY_DX8SL4PLLCR3	0x00001510
#define DDRSS_DDRPHY_DX8SL4PLLCR4	0x00001514
#define DDRSS_DDRPHY_DX8SL4PLLCR5	0x00001518
#define DDRSS_DDRPHY_DX8SL4DQSCTL	0x0000151C
#define DDRSS_DDRPHY_DX8SL4TRNCTL	0x00001520
#define DDRSS_DDRPHY_DX8SL4DDLCTL	0x00001524
#define DDRSS_DDRPHY_DX8SL4DXCTL1	0x00001528
#define DDRSS_DDRPHY_DX8SL4DXCTL2	0x0000152C
#define DDRSS_DDRPHY_DX8SL4IOCR		0x00001530
#define DDRSS_DDRPHY_DX4SL4IOCR		0x00001534
#define DDRSS_DDRPHY_DX8SL5OSC		0x00001540
#define DDRSS_DDRPHY_DX8SL5PLLCR0	0x00001544
#define DDRSS_DDRPHY_DX8SL5PLLCR1	0x00001548
#define DDRSS_DDRPHY_DX8SL5PLLCR2	0x0000154C
#define DDRSS_DDRPHY_DX8SL5PLLCR3	0x00001550
#define DDRSS_DDRPHY_DX8SL5PLLCR4	0x00001554
#define DDRSS_DDRPHY_DX8SL5PLLCR5	0x00001558
#define DDRSS_DDRPHY_DX8SL5DQSCTL	0x0000155C
#define DDRSS_DDRPHY_DX8SL5TRNCTL	0x00001560
#define DDRSS_DDRPHY_DX8SL5DDLCTL	0x00001564
#define DDRSS_DDRPHY_DX8SL5DXCTL1	0x00001568
#define DDRSS_DDRPHY_DX8SL5DXCTL2	0x0000156C
#define DDRSS_DDRPHY_DX8SL5IOCR		0x00001570
#define DDRSS_DDRPHY_DX4SL5IOCR		0x00001574
#define DDRSS_DDRPHY_DX8SL6OSC		0x00001580
#define DDRSS_DDRPHY_DX8SL6PLLCR0	0x00001584
#define DDRSS_DDRPHY_DX8SL6PLLCR1	0x00001588
#define DDRSS_DDRPHY_DX8SL6PLLCR2	0x0000158C
#define DDRSS_DDRPHY_DX8SL6PLLCR3	0x00001590
#define DDRSS_DDRPHY_DX8SL6PLLCR4	0x00001594
#define DDRSS_DDRPHY_DX8SL6PLLCR5	0x00001598
#define DDRSS_DDRPHY_DX8SL6DQSCTL	0x0000159C
#define DDRSS_DDRPHY_DX8SL6TRNCTL	0x000015A0
#define DDRSS_DDRPHY_DX8SL6DDLCTL	0x000015A4
#define DDRSS_DDRPHY_DX8SL6DXCTL1	0x000015A8
#define DDRSS_DDRPHY_DX8SL6DXCTL2	0x000015AC
#define DDRSS_DDRPHY_DX8SL6IOCR		0x000015B0
#define DDRSS_DDRPHY_DX4SL6IOCR		0x000015B4
#define DDRSS_DDRPHY_DX8SL7OSC		0x000015C0
#define DDRSS_DDRPHY_DX8SL7PLLCR0	0x000015C4
#define DDRSS_DDRPHY_DX8SL7PLLCR1	0x000015C8
#define DDRSS_DDRPHY_DX8SL7PLLCR2	0x000015CC
#define DDRSS_DDRPHY_DX8SL7PLLCR3	0x000015D0
#define DDRSS_DDRPHY_DX8SL7PLLCR4	0x000015D4
#define DDRSS_DDRPHY_DX8SL7PLLCR5	0x000015D8
#define DDRSS_DDRPHY_DX8SL7DQSCTL	0x000015DC
#define DDRSS_DDRPHY_DX8SL7TRNCTL	0x000015E0
#define DDRSS_DDRPHY_DX8SL7DDLCTL	0x000015E4
#define DDRSS_DDRPHY_DX8SL7DXCTL1	0x000015E8
#define DDRSS_DDRPHY_DX8SL7DXCTL2	0x000015EC
#define DDRSS_DDRPHY_DX8SL7IOCR		0x000015F0
#define DDRSS_DDRPHY_DX4SL7IOCR		0x000015F4
#define DDRSS_DDRPHY_DX8SL8OSC		0x00001600
#define DDRSS_DDRPHY_DX8SL8PLLCR0	0x00001604
#define DDRSS_DDRPHY_DX8SL8PLLCR1	0x00001608
#define DDRSS_DDRPHY_DX8SL8PLLCR2	0x0000160C
#define DDRSS_DDRPHY_DX8SL8PLLCR3	0x00001610
#define DDRSS_DDRPHY_DX8SL8PLLCR4	0x00001614
#define DDRSS_DDRPHY_DX8SL8PLLCR5	0x00001618
#define DDRSS_DDRPHY_DX8SL8DQSCTL	0x0000161C
#define DDRSS_DDRPHY_DX8SL8TRNCTL	0x00001620
#define DDRSS_DDRPHY_DX8SL8DDLCTL	0x00001624
#define DDRSS_DDRPHY_DX8SL8DXCTL1	0x00001628
#define DDRSS_DDRPHY_DX8SL8DXCTL2	0x0000162C
#define DDRSS_DDRPHY_DX8SL8IOCR		0x00001630
#define DDRSS_DDRPHY_DX4SL8IOCR		0x00001634
#define DDRSS_DDRPHY_DX8SLBOSC		0x000017C0
#define DDRSS_DDRPHY_DX8SLBPLLCR0	0x000017C4
#define DDRSS_DDRPHY_DX8SLBPLLCR1	0x000017C8
#define DDRSS_DDRPHY_DX8SLBPLLCR2	0x000017CC
#define DDRSS_DDRPHY_DX8SLBPLLCR3	0x000017D0
#define DDRSS_DDRPHY_DX8SLBPLLCR4	0x000017D4
#define DDRSS_DDRPHY_DX8SLBPLLCR5	0x000017D8
#define DDRSS_DDRPHY_DX8SLBDQSCTL	0x000017DC
#define DDRSS_DDRPHY_DX8SLBTRNCTL	0x000017E0
#define DDRSS_DDRPHY_DX8SLBDDLCTL	0x000017E4
#define DDRSS_DDRPHY_DX8SLBDXCTL1	0x000017E8
#define DDRSS_DDRPHY_DX8SLBDXCTL2	0x000017EC
#define DDRSS_DDRPHY_DX8SLBIOCR		0x000017F0
#define DDRSS_DDRPHY_DX4SLBIOCR		0x000017F4

#define PIR_INIT_SHIFT			0
#define PIR_INIT_MASK			BIT(PIR_INIT_SHIFT)
#define PIR_ZCAL_SHIFT			1
#define PIR_ZCAL_MASK			BIT(PIR_ZCAL_SHIFT)
#define PIR_CA_SHIFT			2
#define PIR_CA_MASK			BIT(PIR_CA_SHIFT)
#define PIR_PLLINIT_SHIFT		4
#define PIR_PLLINIT_MASK		BIT(PIR_PLLINIT_SHIFT)
#define PIR_DCAL_SHIFT			5
#define PIR_DCAL_MASK			BIT(PIR_DCAL_SHIFT)
#define PIR_PHYRST_SHIFT		6
#define PIR_PHYRST_MASK			BIT(PIR_PHYRST_SHIFT)
#define PIR_DRAMRST_SHIFT		7
#define PIR_DRAMRST_MASK		BIT(PIR_DRAMRST_SHIFT)
#define PIR_DRAMINIT_SHIFT		8
#define PIR_DRAMINIT_MASK		BIT(PIR_DRAMINIT_SHIFT)
#define PIR_WL_SHIFT			9
#define PIR_WL_MASK			BIT(PIR_WL_SHIFT)
#define PIR_QSGATE_SHIFT		10
#define PIR_QSGATE_MASK			BIT(PIR_QSGATE_SHIFT)
#define PIR_WLADJ_SHIFT			11
#define PIR_WLADJ_MASK			BIT(PIR_WLADJ_SHIFT)
#define PIR_RDDSKW_SHIFT		12
#define PIR_RDDSKW_MASK			BIT(PIR_RDDSKW_SHIFT)
#define PIR_WRDSKW_SHIFT		13
#define PIR_WRDSKW_MASK			BIT(PIR_WRDSKW_SHIFT)
#define PIR_RDEYE_SHIFT			14
#define PIR_RDEYE_MASK			BIT(PIR_RDEYE_SHIFT)
#define PIR_WREYE_SHIFT			15
#define PIR_WREYE_MASK			BIT(PIR_WREYE_SHIFT)
#define PIR_SRD_SHIFT			16
#define PIR_SRD_MASK			BIT(PIR_SRD_SHIFT)
#define PIR_VREF_SHIFT			17
#define PIR_VREF_MASK			BIT(PIR_VREF_SHIFT)
#define PIR_CTLDINIT_SHIFT		18
#define PIR_CTLDINIT_MASK		BIT(PIR_CTLDINIT_SHIFT)
#define PIR_RDIMMINIT_SHIFT		19
#define PIR_RDIMMINIT_MASK		BIT(PIR_RDIMMINIT_SHIFT)
#define PIR_DQS2DQ_SHIFT		20
#define PIR_DQS2DQ_MASK			BIT(PIR_DQS2DQ_SHIFT)
#define PIR_DCALPSE_SHIFT		29
#define PIR_DCALPSE_MASK		BIT(PIR_DCALPSE_SHIFT)
#define PIR_ZCALBYP_SHIFT		30
#define PIR_ZCALBYP_MASK		BIT(PIR_ZCALBYP_SHIFT)

#define PIR_PHY_INIT			(PIR_ZCAL_MASK | PIR_PLLINIT_MASK | \
					PIR_DCAL_MASK | PIR_PHYRST_MASK)
#define PIR_DRAM_INIT			(PIR_DRAMRST_MASK | PIR_DRAMINIT_MASK)
#define PIR_DATA_TR_INIT		(PIR_WL_MASK | PIR_QSGATE_MASK | \
					PIR_WLADJ_MASK | PIR_RDDSKW_MASK | \
					PIR_WRDSKW_MASK | PIR_RDEYE_MASK \
					PIR_WREYE_MASK)

#define PGSR0_IDONE_SHIFT		0
#define PGSR0_IDONE_MASK		BIT(PGSR0_IDONE_SHIFT)
#define PGSR0_PLDONE_SHIFT		1
#define PGSR0_PLDONE_MASK		BIT(PGSR0_PLDONE_SHIFT)
#define PGSR0_DCDONE_SHIFT		2
#define PGSR0_DCDONE_MASK		BIT(PGSR0_DCDONE_SHIFT)
#define PGSR0_ZCDONE_SHIFT		3
#define PGSR0_ZCDONE_MASK		BIT(PGSR0_ZCDONE_SHIFT)
#define PGSR0_DIDONE_SHIFT		4
#define PGSR0_DIDONE_MASK		BIT(PGSR0_DIDONE_SHIFT)
#define PGSR0_WLDONE_SHIFT		5
#define PGSR0_WLDONE_MASK		BIT(PGSR0_WLDONE_SHIFT)
#define PGSR0_QSGDONE_SHIFT		6
#define PGSR0_QSGDONE_MASK		BIT(PGSR0_QSGDONE_SHIFT)
#define PGSR0_WLADONE_SHIFT		7
#define PGSR0_WLADONE_MASK		BIT(PGSR0_WLADONE_SHIFT)
#define PGSR0_RDDONE_SHIFT		8
#define PGSR0_RDDONE_MASK		BIT(PGSR0_RDDONE_SHIFT)
#define PGSR0_WDDONE_SHIFT		9
#define PGSR0_WDDONE_MASK		BIT(PGSR0_WDDONE_SHIFT)
#define PGSR0_REDONE_SHIFT		10
#define PGSR0_REDONE_MASK		BIT(PGSR0_REDONE_SHIFT)
#define PGSR0_WEDONE_SHIFT		11
#define PGSR0_WEDONE_MASK		BIT(PGSR0_WEDONE_SHIFT)
#define PGSR0_CADONE_SHIFT		12
#define PGSR0_CADONE_MASK		BIT(PGSR0_CADONE_SHIFT)
#define PGSR0_SRDDONE_SHIFT		13
#define PGSR0_SRDDONE_MASK		BIT(PGSR0_SRDDONE_SHIFT)
#define PGSR0_VDONE_SHIFT		14
#define PGSR0_VDONE_MASK		BIT(PGSR0_VDONE_SHIFT)
#define PGSR0_DQS2DQDONE_SHIFT		15
#define PGSR0_DQS2DQDONE_MASK		BIT(PGSR0_DQS2DQDONE_SHIFT)
#define PGSR0_DQS2DQERR_SHIFT		18
#define PGSR0_DQS2DQERR_MASK		BIT(PGSR0_DQS2DQERR_SHIFT)
#define PGSR0_VERR_SHIFT		19
#define PGSR0_VERR_MASK			BIT(PGSR0_VERR_SHIFT)
#define PGSR0_ZCERR_SHIFT		20
#define PGSR0_ZCERR_MASK		BIT(PGSR0_ZCERR_SHIFT)
#define PGSR0_WLERR_SHIFT		21
#define PGSR0_WLERR_MASK		BIT(PGSR0_WLERR_SHIFT)
#define PGSR0_QSGERR_SHIFT		22
#define PGSR0_QSGERR_MASK		BIT(PGSR0_QSGERR_SHIFT)
#define PGSR0_WLAERR_SHIFT		23
#define PGSR0_WLAERR_MASK		BIT(PGSR0_WLAERR_SHIFT)
#define PGSR0_RDERR_SHIFT		24
#define PGSR0_RDERR_MASK		BIT(PGSR0_RDERR_SHIFT)
#define PGSR0_WDERR_SHIFT		25
#define PGSR0_WDERR_MASK		BIT(PGSR0_WDERR_SHIFT)
#define PGSR0_REERR_SHIFT		26
#define PGSR0_REERR_MASK		BIT(PGSR0_REERR_SHIFT)
#define PGSR0_WEERR_SHIFT		27
#define PGSR0_WEERR_MASK		BIT(PGSR0_WEERR_SHIFT)
#define PGSR0_CAERR_SHIFT		28
#define PGSR0_CAERR_MASK		BIT(PGSR0_CAERR_SHIFT)
#define PGSR0_CAWRN_SHIFT		29
#define PGSR0_CAWRN_MASK		BIT(PGSR0_CAWRN_SHIFT)
#define PGSR0_SRDERR_SHIFT		30
#define PGSR0_SRDERR_MASK		BIT(PGSR0_SRDERR_SHIFT)
#define PGSR0_APLOCK_SHIFT		31
#define PGSR0_APLOCK_MASK		BIT(PGSR0_APLOCK_SHIFT)

#define PGSR0_PHY_INIT_MASK		(PGSR0_IDONE_MASK | PGSR0_PLDONE_MASK |\
					PGSR0_DCDONE_MASK | PGSR0_ZCDONE_MASK |\
					PGSR0_APLOCK_MASK)
#define PGSR0_DRAM_INIT_MASK		(PGSR0_PHY_INIT_MASK | \
					PGSR0_DIDONE_MASK)
#define PGSR0_DATA_TR_INIT_MASK		(PGSR0_DRAM_INIT_MASK)

struct ddrss_ss_reg_params {
	u32 ddrss_v2h_ctl_reg;
};

struct ddrss_ddrctl_reg_params {
	u32 ddrctl_dfimisc;
	u32 ddrctl_dfitmg0;
	u32 ddrctl_dfitmg1;
	u32 ddrctl_dfitmg2;
	u32 ddrctl_init0;
	u32 ddrctl_init1;
	u32 ddrctl_init3;
	u32 ddrctl_init4;
	u32 ddrctl_init5;
	u32 ddrctl_init6;
	u32 ddrctl_init7;
	u32 ddrctl_mstr;
	u32 ddrctl_odtcfg;
	u32 ddrctl_odtmap;
	u32 ddrctl_rankctl;
	u32 ddrctl_rfshctl0;
	u32 ddrctl_rfshtmg;
	u32 ddrctl_zqctl0;
	u32 ddrctl_zqctl1;
};

struct ddrss_ddrctl_crc_params {
	u32 ddrctl_crcparctl0;
	u32 ddrctl_crcparctl1;
	u32 ddrctl_crcparctl2;
};

struct ddrss_ddrctl_ecc_params {
	u32 ddrctl_ecccfg0;
};

struct ddrss_ddrctl_map_params {
	u32 ddrctl_addrmap0;
	u32 ddrctl_addrmap1;
	u32 ddrctl_addrmap2;
	u32 ddrctl_addrmap3;
	u32 ddrctl_addrmap4;
	u32 ddrctl_addrmap5;
	u32 ddrctl_addrmap6;
	u32 ddrctl_addrmap7;
	u32 ddrctl_addrmap8;
	u32 ddrctl_addrmap9;
	u32 ddrctl_addrmap10;
	u32 ddrctl_addrmap11;
	u32 ddrctl_dqmap0;
	u32 ddrctl_dqmap1;
	u32 ddrctl_dqmap4;
	u32 ddrctl_dqmap5;
};

struct ddrss_ddrctl_pwr_params {
	u32 ddrctl_pwrctl;
};

struct ddrss_ddrctl_timing_params {
	u32 ddrctl_dramtmg0;
	u32 ddrctl_dramtmg1;
	u32 ddrctl_dramtmg2;
	u32 ddrctl_dramtmg3;
	u32 ddrctl_dramtmg4;
	u32 ddrctl_dramtmg5;
	u32 ddrctl_dramtmg6;
	u32 ddrctl_dramtmg7;
	u32 ddrctl_dramtmg8;
	u32 ddrctl_dramtmg9;
	u32 ddrctl_dramtmg11;
	u32 ddrctl_dramtmg12;
	u32 ddrctl_dramtmg13;
	u32 ddrctl_dramtmg14;
	u32 ddrctl_dramtmg15;
	u32 ddrctl_dramtmg17;
};

struct ddrss_ddrphy_cfg_params {
	u32 ddrphy_dcr;
	u32 ddrphy_dsgcr;
	u32 ddrphy_dx0gcr0;
	u32 ddrphy_dx0gcr1;
	u32 ddrphy_dx0gcr2;
	u32 ddrphy_dx0gcr3;
	u32 ddrphy_dx0gcr4;
	u32 ddrphy_dx0gcr5;
	u32 ddrphy_dx0gtr0;
	u32 ddrphy_dx1gcr0;
	u32 ddrphy_dx1gcr1;
	u32 ddrphy_dx1gcr2;
	u32 ddrphy_dx1gcr3;
	u32 ddrphy_dx1gcr4;
	u32 ddrphy_dx1gcr5;
	u32 ddrphy_dx1gtr0;
	u32 ddrphy_dx2gcr0;
	u32 ddrphy_dx2gcr1;
	u32 ddrphy_dx2gcr2;
	u32 ddrphy_dx2gcr3;
	u32 ddrphy_dx2gcr4;
	u32 ddrphy_dx2gcr5;
	u32 ddrphy_dx2gtr0;
	u32 ddrphy_dx3gcr0;
	u32 ddrphy_dx3gcr1;
	u32 ddrphy_dx3gcr2;
	u32 ddrphy_dx3gcr3;
	u32 ddrphy_dx3gcr4;
	u32 ddrphy_dx3gcr5;
	u32 ddrphy_dx3gtr0;
	u32 ddrphy_dx4gcr0;
	u32 ddrphy_dx4gcr1;
	u32 ddrphy_dx4gcr2;
	u32 ddrphy_dx4gcr3;
	u32 ddrphy_dx4gcr4;
	u32 ddrphy_dx4gcr5;
	u32 ddrphy_dx4gtr0;
	u32 ddrphy_dx8sl0dxctl2;
	u32 ddrphy_dx8sl0iocr;
	u32 ddrphy_dx8sl0pllcr0;
	u32 ddrphy_dx8sl0dqsctl;
	u32 ddrphy_dx8sl1dxctl2;
	u32 ddrphy_dx8sl1iocr;
	u32 ddrphy_dx8sl1pllcr0;
	u32 ddrphy_dx8sl1dqsctl;
	u32 ddrphy_dx8sl2dxctl2;
	u32 ddrphy_dx8sl2iocr;
	u32 ddrphy_dx8sl2pllcr0;
	u32 ddrphy_dx8sl2dqsctl;
	u32 ddrphy_dxccr;
	u32 ddrphy_odtcr;
	u32 ddrphy_pgcr0;
	u32 ddrphy_pgcr1;
	u32 ddrphy_pgcr2;
	u32 ddrphy_pgcr3;
	u32 ddrphy_pgcr5;
	u32 ddrphy_pgcr6;
};

struct ddrss_ddrphy_ctrl_params {
	u32 ddrphy_dtcr0;
	u32 ddrphy_dtcr1;
	u32 ddrphy_mr0;
	u32 ddrphy_mr1;
	u32 ddrphy_mr2;
	u32 ddrphy_mr3;
	u32 ddrphy_mr4;
	u32 ddrphy_mr5;
	u32 ddrphy_mr6;
	u32 ddrphy_mr11;
	u32 ddrphy_mr12;
	u32 ddrphy_mr13;
	u32 ddrphy_mr14;
	u32 ddrphy_mr22;
	u32 ddrphy_pllcr0;
	u32 ddrphy_vtcr0;
};

struct ddrss_ddrphy_ioctl_params {
	u32 ddrphy_aciocr0;
	u32 ddrphy_aciocr3;
	u32 ddrphy_aciocr5;
	u32 ddrphy_iovcr0;
};

struct ddrss_ddrphy_timing_params {
	u32 ddrphy_dtpr0;
	u32 ddrphy_dtpr1;
	u32 ddrphy_dtpr2;
	u32 ddrphy_dtpr3;
	u32 ddrphy_dtpr4;
	u32 ddrphy_dtpr5;
	u32 ddrphy_dtpr6;
	u32 ddrphy_ptr2;
	u32 ddrphy_ptr3;
	u32 ddrphy_ptr4;
	u32 ddrphy_ptr5;
	u32 ddrphy_ptr6;
};

struct ddrss_ddrphy_zq_params {
	u32 ddrphy_zq0pr0;
	u32 ddrphy_zq1pr0;
	u32 ddrphy_zqcr;
};

struct ddrss_params {
	struct ddrss_ss_reg_params ss_reg;
	struct ddrss_ddrctl_reg_params ctl_reg;
	struct ddrss_ddrctl_crc_params ctl_crc;
	struct ddrss_ddrctl_ecc_params ctl_ecc;
	struct ddrss_ddrctl_map_params ctl_map;
	struct ddrss_ddrctl_pwr_params ctl_pwr;
	struct ddrss_ddrctl_timing_params ctl_timing;
	struct ddrss_ddrphy_cfg_params phy_cfg;
	struct ddrss_ddrphy_ctrl_params phy_ctrl;
	struct ddrss_ddrphy_ioctl_params phy_ioctl;
	struct ddrss_ddrphy_timing_params phy_timing;
	struct ddrss_ddrphy_zq_params phy_zq;
};

#endif /* __K3_AM654_DDRSS_H */
