/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef UPMPREPROCESSOR_H
#define UPMPREPROCESSOR_H

#include <QDir>
#include <QDebug>
#include <QObject>
#include <QSettings>
#include <QGSettings>
#include <QTextStream>
#include <QStandardPaths>

class UpmPreprocessor : public QObject
{
    Q_OBJECT
public:
    UpmPreprocessor(QObject *parent = nullptr);
    ~UpmPreprocessor();
    void start();
    bool i2cEnable();
    bool pciEnable();
    bool sataEnable();
    QString getBrightnessNode();
private:
    void preprocessPowerMode();
    void readModalias();
    void readCpuType();
    bool checkConf(QString file, QString group, QString key);
    QVariant readConfig(QString file, QString group, QString key);
private:
    QString m_modalias = "";
    QString m_cpuType = "";
};

#endif // UPMPREPROCESSOR_H
