/* valavapigen.c generated by valac, the Vala compiler
 * generated from valavapigen.vala, do not modify */

/* valavapigen.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib-object.h>
#include <vala.h>
#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <valagee.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>

#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_vapi_gen_unref0(var) ((var == NULL) ? NULL : (var = (vala_vapi_gen_unref (var), NULL)))
typedef struct _ValaParamSpecVAPIGen ValaParamSpecVAPIGen;

struct _ValaVAPIGen {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaVAPIGenPrivate * priv;
};

struct _ValaVAPIGenClass {
	GTypeClass parent_class;
	void (*finalize) (ValaVAPIGen *self);
};

struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};

struct _ValaParamSpecVAPIGen {
	GParamSpec parent_instance;
};

static gint ValaVAPIGen_private_offset;
static gpointer vala_vapi_gen_parent_class = NULL;
static gchar** vala_vapi_gen_vapi_directories;
static gchar** vala_vapi_gen_gir_directories;
static gchar** vala_vapi_gen_metadata_directories;
static gboolean vala_vapi_gen_nostdpkg;
static gchar** vala_vapi_gen_packages;
static gchar* vala_vapi_gen_library;
static gchar* vala_vapi_gen_directory;
static gboolean vala_vapi_gen_disable_warnings;
static gboolean vala_vapi_gen_version;
static gboolean vala_vapi_gen_quiet_mode;
static gchar** vala_vapi_gen_sources;
static gchar* vala_vapi_gen_directory = NULL;
static gboolean vala_vapi_gen_version = FALSE;
static gboolean vala_vapi_gen_quiet_mode = FALSE;
static gboolean vala_vapi_gen_disable_warnings = FALSE;
static gchar** vala_vapi_gen_sources = NULL;
static gchar** vala_vapi_gen_vapi_directories = NULL;
static gchar** vala_vapi_gen_gir_directories = NULL;
static gchar** vala_vapi_gen_metadata_directories = NULL;
static gchar* vala_vapi_gen_library = NULL;
static gchar** vala_vapi_gen_packages = NULL;
static gboolean vala_vapi_gen_nostdpkg = FALSE;

G_GNUC_INTERNAL gpointer vala_vapi_gen_ref (gpointer instance);
G_GNUC_INTERNAL void vala_vapi_gen_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_vapi_gen (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_vapi_gen (GValue* value,
                              gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_vapi_gen (GValue* value,
                               gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_vapi_gen (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_vapi_gen_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaVAPIGen, vala_vapi_gen_unref)
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaGIdlParser, vala_code_visitor_unref)
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
void vala_gidl_parser_parse (ValaGIdlParser* self,
                             ValaCodeContext* context);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gint stack_length,
                                      const gchar* needle);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gint vala_vapi_gen_main (gchar** args,
                         gint args_length1);
G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_new (void);
G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_construct (GType object_type);
static void vala_vapi_gen_finalize (ValaVAPIGen * obj);
static GType vala_vapi_gen_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_VAPI_GEN_options[12] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_gir_directories, "Look for GIR bindings in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_nostdpkg, "Do not include standard packages", NULL}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_disable_warnings, "Disable warnings", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_vapi_gen_quiet_mode, "Do not print messages to the console", NULL}, {G_OPTION_REMAINING, (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};

static inline gpointer
vala_vapi_gen_get_instance_private (ValaVAPIGen* self)
{
	return G_STRUCT_MEMBER_P (self, ValaVAPIGen_private_offset);
}

static gint
vala_vapi_gen_quit (ValaVAPIGen* self)
{
	ValaCodeContext* _tmp0_;
	ValaReport* _tmp1_;
	ValaReport* _tmp2_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->context;
	_tmp1_ = vala_code_context_get_report (_tmp0_);
	_tmp2_ = _tmp1_;
	if (vala_report_get_errors (_tmp2_) == 0) {
		if (!vala_vapi_gen_quiet_mode) {
			FILE* _tmp3_;
			ValaCodeContext* _tmp4_;
			ValaReport* _tmp5_;
			ValaReport* _tmp6_;
			_tmp3_ = stdout;
			_tmp4_ = self->priv->context;
			_tmp5_ = vala_code_context_get_report (_tmp4_);
			_tmp6_ = _tmp5_;
			fprintf (_tmp3_, "Generation succeeded - %d warning(s)\n", vala_report_get_warnings (_tmp6_));
		}
		vala_code_context_pop ();
		result = 0;
		return result;
	} else {
		if (!vala_vapi_gen_quiet_mode) {
			FILE* _tmp7_;
			ValaCodeContext* _tmp8_;
			ValaReport* _tmp9_;
			ValaReport* _tmp10_;
			ValaCodeContext* _tmp11_;
			ValaReport* _tmp12_;
			ValaReport* _tmp13_;
			_tmp7_ = stdout;
			_tmp8_ = self->priv->context;
			_tmp9_ = vala_code_context_get_report (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->context;
			_tmp12_ = vala_code_context_get_report (_tmp11_);
			_tmp13_ = _tmp12_;
			fprintf (_tmp7_, "Generation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (_tmp10_), vala_report_get_warnings (_tmp13_));
		}
		vala_code_context_pop ();
		result = 1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gint stack_length,
                             const gchar* needle)
{
	gint i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gint
vala_vapi_gen_run (ValaVAPIGen* self)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaCodeContext* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValaCodeContext* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	ValaCodeContext* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	ValaCodeContext* _tmp9_;
	ValaReport* _tmp10_;
	ValaReport* _tmp11_;
	ValaCodeContext* _tmp12_;
	ValaReport* _tmp13_;
	ValaReport* _tmp14_;
	ValaCodeContext* _tmp15_;
	ValaCodeContext* _tmp16_;
	ValaCodeContext* _tmp19_;
	ValaReport* _tmp20_;
	ValaReport* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	ValaCodeContext* _tmp37_;
	ValaReport* _tmp38_;
	ValaReport* _tmp39_;
	const gchar* _tmp40_;
	ValaCodeContext* _tmp45_;
	ValaReport* _tmp46_;
	ValaReport* _tmp47_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	ValaCodeContext* _tmp53_;
	ValaReport* _tmp54_;
	ValaReport* _tmp55_;
	gchar** _tmp56_;
	gint _tmp56__length1;
	ValaCodeContext* _tmp68_;
	ValaReport* _tmp69_;
	ValaReport* _tmp70_;
	ValaParser* parser = NULL;
	ValaParser* _tmp71_;
	ValaParser* _tmp72_;
	ValaCodeContext* _tmp73_;
	ValaCodeContext* _tmp74_;
	ValaReport* _tmp75_;
	ValaReport* _tmp76_;
	ValaGirParser* girparser = NULL;
	ValaGirParser* _tmp77_;
	ValaGirParser* _tmp78_;
	ValaCodeContext* _tmp79_;
	ValaCodeContext* _tmp80_;
	ValaReport* _tmp81_;
	ValaReport* _tmp82_;
	ValaGIdlParser* gidlparser = NULL;
	ValaGIdlParser* _tmp83_;
	ValaGIdlParser* _tmp84_;
	ValaCodeContext* _tmp85_;
	ValaCodeContext* _tmp86_;
	ValaReport* _tmp87_;
	ValaReport* _tmp88_;
	ValaCodeContext* _tmp89_;
	ValaCodeContext* _tmp90_;
	ValaReport* _tmp91_;
	ValaReport* _tmp92_;
	gchar** package_names = NULL;
	gchar** _tmp93_;
	gint package_names_length1;
	gint _package_names_size_;
	gchar* library_name = NULL;
	const gchar* _tmp137_;
	gchar* _tmp138_;
	gboolean _tmp139_ = FALSE;
	gchar** _tmp140_;
	gint _tmp140__length1;
	ValaCodeWriter* interface_writer = NULL;
	ValaCodeWriter* _tmp149_;
	gchar* vapi_filename = NULL;
	const gchar* _tmp150_;
	gchar* _tmp151_;
	const gchar* _tmp152_;
	ValaCodeWriter* _tmp156_;
	ValaCodeContext* _tmp157_;
	const gchar* _tmp158_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_set_profile (_tmp1_, VALA_PROFILE_GOBJECT);
	_tmp2_ = self->priv->context;
	vala_code_context_add_define (_tmp2_, "GOBJECT");
	_tmp3_ = self->priv->context;
	_tmp4_ = vala_vapi_gen_vapi_directories;
	_tmp4__length1 = _vala_array_length (vala_vapi_gen_vapi_directories);
	vala_code_context_set_vapi_directories (_tmp3_, _tmp4_, _tmp4__length1);
	_tmp5_ = self->priv->context;
	_tmp6_ = vala_vapi_gen_gir_directories;
	_tmp6__length1 = _vala_array_length (vala_vapi_gen_gir_directories);
	vala_code_context_set_gir_directories (_tmp5_, _tmp6_, _tmp6__length1);
	_tmp7_ = self->priv->context;
	_tmp8_ = vala_vapi_gen_metadata_directories;
	_tmp8__length1 = _vala_array_length (vala_vapi_gen_metadata_directories);
	vala_code_context_set_metadata_directories (_tmp7_, _tmp8_, _tmp8__length1);
	_tmp9_ = self->priv->context;
	_tmp10_ = vala_code_context_get_report (_tmp9_);
	_tmp11_ = _tmp10_;
	vala_report_set_enable_warnings (_tmp11_, !vala_vapi_gen_disable_warnings);
	_tmp12_ = self->priv->context;
	_tmp13_ = vala_code_context_get_report (_tmp12_);
	_tmp14_ = _tmp13_;
	vala_report_set_verbose_errors (_tmp14_, !vala_vapi_gen_quiet_mode);
	_tmp15_ = self->priv->context;
	vala_code_context_push (_tmp15_);
	_tmp16_ = self->priv->context;
	vala_code_context_set_nostdpkg (_tmp16_, vala_vapi_gen_nostdpkg);
	if (!vala_vapi_gen_nostdpkg) {
		ValaCodeContext* _tmp17_;
		ValaCodeContext* _tmp18_;
		_tmp17_ = self->priv->context;
		vala_code_context_add_external_package (_tmp17_, "glib-2.0");
		_tmp18_ = self->priv->context;
		vala_code_context_add_external_package (_tmp18_, "gobject-2.0");
	}
	_tmp19_ = self->priv->context;
	_tmp20_ = vala_code_context_get_report (_tmp19_);
	_tmp21_ = _tmp20_;
	if (vala_report_get_errors (_tmp21_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp22_ = vala_vapi_gen_sources;
	_tmp22__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp22_;
		source_collection_length1 = _tmp22__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp23_;
			gchar* source = NULL;
			_tmp23_ = g_strdup (source_collection[source_it]);
			source = _tmp23_;
			{
				const gchar* _tmp24_;
				gchar* depsfile = NULL;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				ValaCodeContext* _tmp35_;
				const gchar* _tmp36_;
				_tmp24_ = source;
				if (!g_str_has_suffix (_tmp24_, ".gi")) {
					_g_free0 (source);
					continue;
				}
				_tmp25_ = source;
				_tmp26_ = source;
				_tmp27_ = strlen (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = strlen ("gi");
				_tmp30_ = _tmp29_;
				_tmp31_ = string_substring (_tmp25_, (glong) 0, (glong) (_tmp28_ - _tmp30_));
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strconcat (_tmp32_, "deps", NULL);
				_tmp34_ = _tmp33_;
				_g_free0 (_tmp32_);
				depsfile = _tmp34_;
				_tmp35_ = self->priv->context;
				_tmp36_ = depsfile;
				vala_code_context_add_packages_from_file (_tmp35_, _tmp36_);
				_g_free0 (depsfile);
				_g_free0 (source);
			}
		}
	}
	_tmp37_ = self->priv->context;
	_tmp38_ = vala_code_context_get_report (_tmp37_);
	_tmp39_ = _tmp38_;
	if (vala_report_get_errors (_tmp39_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp40_ = vala_vapi_gen_library;
	if (_tmp40_ != NULL) {
		gchar* depsfile = NULL;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		ValaCodeContext* _tmp43_;
		const gchar* _tmp44_;
		_tmp41_ = vala_vapi_gen_library;
		_tmp42_ = g_strconcat (_tmp41_, ".deps", NULL);
		depsfile = _tmp42_;
		_tmp43_ = self->priv->context;
		_tmp44_ = depsfile;
		vala_code_context_add_packages_from_file (_tmp43_, _tmp44_);
		_g_free0 (depsfile);
	} else {
		vala_report_error (NULL, "--library option must be specified");
	}
	_tmp45_ = self->priv->context;
	_tmp46_ = vala_code_context_get_report (_tmp45_);
	_tmp47_ = _tmp46_;
	if (vala_report_get_errors (_tmp47_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp48_ = vala_vapi_gen_packages;
	_tmp48__length1 = _vala_array_length (vala_vapi_gen_packages);
	if (_tmp48_ != NULL) {
		gchar** _tmp49_;
		gint _tmp49__length1;
		_tmp49_ = vala_vapi_gen_packages;
		_tmp49__length1 = _vala_array_length (vala_vapi_gen_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp49_;
			package_collection_length1 = _tmp49__length1;
			for (package_it = 0; package_it < package_collection_length1; package_it = package_it + 1) {
				gchar* _tmp50_;
				gchar* package = NULL;
				_tmp50_ = g_strdup (package_collection[package_it]);
				package = _tmp50_;
				{
					ValaCodeContext* _tmp51_;
					const gchar* _tmp52_;
					_tmp51_ = self->priv->context;
					_tmp52_ = package;
					vala_code_context_add_external_package (_tmp51_, _tmp52_);
					_g_free0 (package);
				}
			}
		}
		vala_vapi_gen_packages = (_vala_array_free (vala_vapi_gen_packages, _vala_array_length (vala_vapi_gen_packages), (GDestroyNotify) g_free), NULL);
		vala_vapi_gen_packages = NULL;
	}
	_tmp53_ = self->priv->context;
	_tmp54_ = vala_code_context_get_report (_tmp53_);
	_tmp55_ = _tmp54_;
	if (vala_report_get_errors (_tmp55_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp56_ = vala_vapi_gen_sources;
	_tmp56__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp56_;
		source_collection_length1 = _tmp56__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp57_;
			gchar* source = NULL;
			_tmp57_ = g_strdup (source_collection[source_it]);
			source = _tmp57_;
			{
				const gchar* _tmp58_;
				_tmp58_ = source;
				if (g_file_test (_tmp58_, G_FILE_TEST_EXISTS)) {
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp59_;
					const gchar* _tmp60_;
					ValaSourceFile* _tmp61_;
					ValaSourceFile* _tmp62_;
					ValaCodeContext* _tmp63_;
					ValaSourceFile* _tmp64_;
					_tmp59_ = self->priv->context;
					_tmp60_ = source;
					_tmp61_ = vala_source_file_new (_tmp59_, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp60_, NULL, FALSE);
					source_file = _tmp61_;
					_tmp62_ = source_file;
					vala_source_file_set_from_commandline (_tmp62_, TRUE);
					_tmp63_ = self->priv->context;
					_tmp64_ = source_file;
					vala_code_context_add_source_file (_tmp63_, _tmp64_);
					_vala_source_file_unref0 (source_file);
				} else {
					const gchar* _tmp65_;
					gchar* _tmp66_;
					gchar* _tmp67_;
					_tmp65_ = source;
					_tmp66_ = g_strdup_printf ("%s not found", _tmp65_);
					_tmp67_ = _tmp66_;
					vala_report_error (NULL, _tmp67_);
					_g_free0 (_tmp67_);
				}
				_g_free0 (source);
			}
		}
	}
	_tmp68_ = self->priv->context;
	_tmp69_ = vala_code_context_get_report (_tmp68_);
	_tmp70_ = _tmp69_;
	if (vala_report_get_errors (_tmp70_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp71_ = vala_parser_new ();
	parser = _tmp71_;
	_tmp72_ = parser;
	_tmp73_ = self->priv->context;
	vala_parser_parse (_tmp72_, _tmp73_);
	_tmp74_ = self->priv->context;
	_tmp75_ = vala_code_context_get_report (_tmp74_);
	_tmp76_ = _tmp75_;
	if (vala_report_get_errors (_tmp76_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp77_ = vala_gir_parser_new ();
	girparser = _tmp77_;
	_tmp78_ = girparser;
	_tmp79_ = self->priv->context;
	vala_gir_parser_parse (_tmp78_, _tmp79_);
	_tmp80_ = self->priv->context;
	_tmp81_ = vala_code_context_get_report (_tmp80_);
	_tmp82_ = _tmp81_;
	if (vala_report_get_errors (_tmp82_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp83_ = vala_gidl_parser_new ();
	gidlparser = _tmp83_;
	_tmp84_ = gidlparser;
	_tmp85_ = self->priv->context;
	vala_gidl_parser_parse (_tmp84_, _tmp85_);
	_tmp86_ = self->priv->context;
	_tmp87_ = vala_code_context_get_report (_tmp86_);
	_tmp88_ = _tmp87_;
	if (vala_report_get_errors (_tmp88_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp89_ = self->priv->context;
	vala_code_context_check (_tmp89_);
	_tmp90_ = self->priv->context;
	_tmp91_ = vala_code_context_get_report (_tmp90_);
	_tmp92_ = _tmp91_;
	if (vala_report_get_errors (_tmp92_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp93_ = g_new0 (gchar*, 0 + 1);
	package_names = _tmp93_;
	package_names_length1 = 0;
	_package_names_size_ = package_names_length1;
	{
		ValaList* _file_list = NULL;
		ValaCodeContext* _tmp94_;
		ValaList* _tmp95_;
		ValaList* _tmp96_;
		gint _file_size = 0;
		ValaList* _tmp97_;
		gint _tmp98_;
		gint _tmp99_;
		gint _file_index = 0;
		_tmp94_ = self->priv->context;
		_tmp95_ = vala_code_context_get_source_files (_tmp94_);
		_tmp96_ = _vala_iterable_ref0 (_tmp95_);
		_file_list = _tmp96_;
		_tmp97_ = _file_list;
		_tmp98_ = vala_collection_get_size ((ValaCollection*) _tmp97_);
		_tmp99_ = _tmp98_;
		_file_size = _tmp99_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp100_;
			gint _tmp101_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp102_;
			gpointer _tmp103_;
			ValaSourceFile* _tmp104_;
			const gchar* _tmp105_;
			const gchar* _tmp106_;
			ValaSourceFile* _tmp107_;
			const gchar* _tmp108_;
			const gchar* _tmp109_;
			gchar** _tmp110_;
			gint _tmp110__length1;
			_file_index = _file_index + 1;
			_tmp100_ = _file_index;
			_tmp101_ = _file_size;
			if (!(_tmp100_ < _tmp101_)) {
				break;
			}
			_tmp102_ = _file_list;
			_tmp103_ = vala_list_get (_tmp102_, _file_index);
			file = (ValaSourceFile*) _tmp103_;
			_tmp104_ = file;
			_tmp105_ = vala_source_file_get_filename (_tmp104_);
			_tmp106_ = _tmp105_;
			if (g_str_has_suffix (_tmp106_, ".vapi")) {
				_vala_source_file_unref0 (file);
				continue;
			}
			_tmp107_ = file;
			_tmp108_ = vala_source_file_get_filename (_tmp107_);
			_tmp109_ = _tmp108_;
			_tmp110_ = vala_vapi_gen_sources;
			_tmp110__length1 = _vala_array_length (vala_vapi_gen_sources);
			if (_vala_string_array_contains (_tmp110_, _tmp110__length1, _tmp109_)) {
				ValaSourceFile* _tmp111_;
				ValaSourceFile* _tmp112_;
				const gchar* _tmp113_;
				const gchar* _tmp114_;
				_tmp111_ = file;
				vala_source_file_set_file_type (_tmp111_, VALA_SOURCE_FILE_TYPE_SOURCE);
				_tmp112_ = file;
				_tmp113_ = vala_source_file_get_filename (_tmp112_);
				_tmp114_ = _tmp113_;
				if (g_str_has_suffix (_tmp114_, ".gir")) {
					gchar* metadata_filename = NULL;
					ValaCodeContext* _tmp115_;
					ValaSourceFile* _tmp116_;
					const gchar* _tmp117_;
					const gchar* _tmp118_;
					gchar* _tmp119_;
					const gchar* _tmp120_;
					gboolean _tmp126_ = FALSE;
					ValaSourceFile* _tmp127_;
					gboolean _tmp128_;
					gboolean _tmp129_;
					_tmp115_ = self->priv->context;
					_tmp116_ = file;
					_tmp117_ = vala_source_file_get_filename (_tmp116_);
					_tmp118_ = _tmp117_;
					_tmp119_ = vala_code_context_get_metadata_path (_tmp115_, _tmp118_);
					metadata_filename = _tmp119_;
					_tmp120_ = metadata_filename;
					if (_tmp120_ != NULL) {
						ValaSourceFile* metadata_file = NULL;
						ValaCodeContext* _tmp121_;
						const gchar* _tmp122_;
						ValaSourceFile* _tmp123_;
						ValaSourceFile* _tmp124_;
						_tmp121_ = self->priv->context;
						_tmp122_ = metadata_filename;
						_tmp123_ = vala_code_context_get_source_file (_tmp121_, _tmp122_);
						metadata_file = _tmp123_;
						_tmp124_ = metadata_file;
						if (_tmp124_ != NULL) {
							ValaSourceFile* _tmp125_;
							_tmp125_ = metadata_file;
							vala_source_file_set_file_type (_tmp125_, VALA_SOURCE_FILE_TYPE_SOURCE);
						}
					}
					_tmp127_ = file;
					_tmp128_ = vala_source_file_get_from_commandline (_tmp127_);
					_tmp129_ = _tmp128_;
					if (_tmp129_) {
						ValaSourceFile* _tmp130_;
						const gchar* _tmp131_;
						const gchar* _tmp132_;
						_tmp130_ = file;
						_tmp131_ = vala_source_file_get_package_name (_tmp130_);
						_tmp132_ = _tmp131_;
						_tmp126_ = _tmp132_ != NULL;
					} else {
						_tmp126_ = FALSE;
					}
					if (_tmp126_) {
						ValaSourceFile* _tmp133_;
						const gchar* _tmp134_;
						const gchar* _tmp135_;
						gchar* _tmp136_;
						_tmp133_ = file;
						_tmp134_ = vala_source_file_get_package_name (_tmp133_);
						_tmp135_ = _tmp134_;
						_tmp136_ = g_strdup (_tmp135_);
						_vala_array_add1 (&package_names, &package_names_length1, &_package_names_size_, _tmp136_);
					}
					_g_free0 (metadata_filename);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp137_ = vala_vapi_gen_library;
	_tmp138_ = g_path_get_basename (_tmp137_);
	library_name = _tmp138_;
	_tmp140_ = package_names;
	_tmp140__length1 = package_names_length1;
	if (_tmp140__length1 > 0) {
		const gchar* _tmp141_;
		gchar** _tmp142_;
		gint _tmp142__length1;
		_tmp141_ = library_name;
		_tmp142_ = package_names;
		_tmp142__length1 = package_names_length1;
		_tmp139_ = !_vala_string_array_contains (_tmp142_, _tmp142__length1, _tmp141_);
	} else {
		_tmp139_ = FALSE;
	}
	if (_tmp139_) {
		const gchar* _tmp143_;
		gchar** _tmp144_;
		gint _tmp144__length1;
		gchar* _tmp145_;
		gchar* _tmp146_;
		gchar* _tmp147_;
		gchar* _tmp148_;
		_tmp143_ = library_name;
		_tmp144_ = package_names;
		_tmp144__length1 = package_names_length1;
		_tmp145_ = g_strjoin ("', `", _tmp144_, NULL);
		_tmp146_ = _tmp145_;
		_tmp147_ = g_strdup_printf ("Given library name `%s' does not match pkg-config name `%s'", _tmp143_, _tmp146_);
		_tmp148_ = _tmp147_;
		vala_report_warning (NULL, _tmp148_);
		_g_free0 (_tmp148_);
		_g_free0 (_tmp146_);
	}
	_tmp149_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_VAPIGEN);
	interface_writer = _tmp149_;
	_tmp150_ = vala_vapi_gen_library;
	_tmp151_ = g_strdup_printf ("%s.vapi", _tmp150_);
	vapi_filename = _tmp151_;
	_tmp152_ = vala_vapi_gen_directory;
	if (_tmp152_ != NULL) {
		const gchar* _tmp153_;
		const gchar* _tmp154_;
		gchar* _tmp155_;
		_tmp153_ = vala_vapi_gen_directory;
		_tmp154_ = vapi_filename;
		_tmp155_ = g_build_path ("/", _tmp153_, _tmp154_, NULL);
		_g_free0 (vapi_filename);
		vapi_filename = _tmp155_;
	}
	_tmp156_ = interface_writer;
	_tmp157_ = self->priv->context;
	_tmp158_ = vapi_filename;
	vala_code_writer_write_file (_tmp156_, _tmp157_, _tmp158_);
	_g_free0 (vala_vapi_gen_library);
	vala_vapi_gen_library = NULL;
	result = vala_vapi_gen_quit (self);
	_g_free0 (vapi_filename);
	_vala_code_visitor_unref0 (interface_writer);
	_g_free0 (library_name);
	package_names = (_vala_array_free (package_names, package_names_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_visitor_unref0 (gidlparser);
	_vala_code_visitor_unref0 (girparser);
	_vala_code_visitor_unref0 (parser);
	return result;
}

static gint
vala_vapi_gen_main (gchar** args,
                    gint args_length1)
{
	gchar** _tmp12_;
	gint _tmp12__length1;
	ValaVAPIGen* vapigen = NULL;
	ValaVAPIGen* _tmp14_;
	ValaVAPIGen* _tmp15_;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	setlocale (LC_ALL, "");
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("- Vala API Generator");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, VALA_VAPI_GEN_options, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stdout;
		_tmp9_ = args[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp10_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	if (vala_vapi_gen_version) {
		FILE* _tmp11_;
		_tmp11_ = stdout;
		fprintf (_tmp11_, "Vala API Generator %s\n", VALA_BUILD_VERSION);
		result = 0;
		return result;
	}
	_tmp12_ = vala_vapi_gen_sources;
	_tmp12__length1 = _vala_array_length (vala_vapi_gen_sources);
	if (_tmp12_ == NULL) {
		FILE* _tmp13_;
		_tmp13_ = stderr;
		fprintf (_tmp13_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp14_ = vala_vapi_gen_new ();
	vapigen = _tmp14_;
	_tmp15_ = vapigen;
	result = vala_vapi_gen_run (_tmp15_);
	_vala_vapi_gen_unref0 (vapigen);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return vala_vapi_gen_main (argv, argc);
}

G_GNUC_INTERNAL ValaVAPIGen*
vala_vapi_gen_construct (GType object_type)
{
	ValaVAPIGen* self = NULL;
	self = (ValaVAPIGen*) g_type_create_instance (object_type);
	return self;
}

G_GNUC_INTERNAL ValaVAPIGen*
vala_vapi_gen_new (void)
{
	return vala_vapi_gen_construct (VALA_TYPE_VAPI_GEN);
}

static void
vala_value_vapi_gen_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_vapi_gen_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_vapi_gen_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_vapi_gen_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_vapi_gen_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_vapi_gen_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_vapi_gen_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaVAPIGen * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_vapi_gen_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_vapi_gen_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	ValaVAPIGen ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_vapi_gen_ref (value->data[0].v_pointer);
	}
	return NULL;
}

G_GNUC_INTERNAL GParamSpec*
vala_param_spec_vapi_gen (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ValaParamSpecVAPIGen* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_VAPI_GEN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

G_GNUC_INTERNAL gpointer
vala_value_get_vapi_gen (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN), NULL);
	return value->data[0].v_pointer;
}

G_GNUC_INTERNAL void
vala_value_set_vapi_gen (GValue* value,
                         gpointer v_object)
{
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_vapi_gen_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}

G_GNUC_INTERNAL void
vala_value_take_vapi_gen (GValue* value,
                          gpointer v_object)
{
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}

static void
vala_vapi_gen_class_init (ValaVAPIGenClass * klass,
                          gpointer klass_data)
{
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	((ValaVAPIGenClass *) klass)->finalize = vala_vapi_gen_finalize;
	g_type_class_adjust_private_offset (klass, &ValaVAPIGen_private_offset);
}

static void
vala_vapi_gen_instance_init (ValaVAPIGen * self,
                             gpointer klass)
{
	self->priv = vala_vapi_gen_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_vapi_gen_finalize (ValaVAPIGen * obj)
{
	ValaVAPIGen * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_VAPI_GEN, ValaVAPIGen);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}

static GType
vala_vapi_gen_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_vapi_gen_init, vala_value_vapi_gen_free_value, vala_value_vapi_gen_copy_value, vala_value_vapi_gen_peek_pointer, "p", vala_value_vapi_gen_collect_value, "p", vala_value_vapi_gen_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_vapi_gen_type_id;
	vala_vapi_gen_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaVAPIGen", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaVAPIGen_private_offset = g_type_add_instance_private (vala_vapi_gen_type_id, sizeof (ValaVAPIGenPrivate));
	return vala_vapi_gen_type_id;
}

G_GNUC_INTERNAL GType
vala_vapi_gen_get_type (void)
{
	static volatile gsize vala_vapi_gen_type_id__volatile = 0;
	if (g_once_init_enter (&vala_vapi_gen_type_id__volatile)) {
		GType vala_vapi_gen_type_id;
		vala_vapi_gen_type_id = vala_vapi_gen_get_type_once ();
		g_once_init_leave (&vala_vapi_gen_type_id__volatile, vala_vapi_gen_type_id);
	}
	return vala_vapi_gen_type_id__volatile;
}

G_GNUC_INTERNAL gpointer
vala_vapi_gen_ref (gpointer instance)
{
	ValaVAPIGen * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

G_GNUC_INTERNAL void
vala_vapi_gen_unref (gpointer instance)
{
	ValaVAPIGen * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_VAPI_GEN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

