# Метаданные маршрутов

Вы можете добавить поле `meta` при определении маршрута:

```js
const router = new VueRouter({
  routes: [
    {
      path: '/foo',
      component: Foo,
      children: [
        {
          path: 'bar',
          component: Bar,
          // метаданные
          meta: { requiresAuth: true }
        }
      ]
    }
  ]
})
```

Как получить к нему доступ?

Прежде всего, каждый объект маршрута в конфигурации `routes` называется **записью маршрута**. Записи маршрутов могут быть вложенными. Поэтому, при совпадении маршрута, потенциально могут быть активированы несколько записей маршрутов.

Например, для конфигурации выше, URL `/foo/bar` совпадёт как с родительской, так и с дочерней записями маршрутов.

Все совпавшие записи маршрутов оказываются доступны через объект `$route` (а также через объекты маршрутов в сторожевых хуках), в виде массива `$route.matched`. Таким образом, для проверки метаданных в записях маршрутов нам понадобится обойти `$route.matched` в цикле.

В качестве примера можно привести проверку метаданных в глобальном навигационном хуке:

```js
router.beforeEach((to, from, next) => {
  if (to.matched.some(record => record.meta.requiresAuth)) {
    // этот путь требует авторизации, проверяем залогинен ли
    // пользователь, и если нет, перенаправляем на страницу логина
    if (!auth.loggedIn()) {
      next({
        path: '/login',
        query: { redirect: to.fullPath }
      })
    } else {
      next()
    }
  } else {
    next() // всегда так или иначе нужно вызвать next()!
  }
})
```
