# Copyright 2021-2022, B-Open Solutions srl and the xarray-sentinel authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

try:
    # NOTE: the `version.py` file must not be present in the git repository
    #   as it is generated by setuptools at install time
    from .version import __version__
except ImportError:  # pragma: no cover
    # Local copy or not installed with setuptools
    __version__ = "999"

from .esa_safe import make_stac_item
from .sentinel1 import (
    calibrate_amplitude,
    calibrate_intensity,
    crop_burst_dataset,
    get_footprint_linestring,
    ground_range_to_slant_range_time,
    mosaic_slc_iw,
    open_sentinel1_dataset,
    slant_range_time_to_ground_range,
)

__all__ = [
    "__version__",
    "calibrate_amplitude",
    "calibrate_intensity",
    "crop_burst_dataset",
    "get_footprint_linestring",
    "ground_range_to_slant_range_time",
    "make_stac_item",
    "mosaic_slc_iw",
    "open_sentinel1_dataset",
    "slant_range_time_to_ground_range",
]
