#!/usr/bin/env python3




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
from xpdeint.Features.Transforms._MMT import _MMT
from xpdeint.Geometry.NonUniformDimensionRepresentation import NonUniformDimensionRepresentation
from xpdeint.CallOnceGuards import callOnceGuard

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.2.3'
__CHEETAH_versionTuple__ = (3, 2, 3, 'final', 0)
__CHEETAH_genTime__ = 1558054970.865697
__CHEETAH_genTimestamp__ = 'Fri May 17 11:02:50 2019'
__CHEETAH_src__ = '/home/mattias/xmds-2.2.3/admin/staging/xmds-3.0.0/xpdeint/Features/Transforms/MMT.tmpl'
__CHEETAH_srcLastModified__ = 'Thu Apr  4 16:29:24 2019'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class MMT(_MMT):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(MMT, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def description(self, **KWS):



        ## Generated from @def description: MMT at line 28, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''MMT''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def includes(self, **KWS):



        ## CHEETAH: generated from @def includes at line 33, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(MMT, self).includes()
        if _v is not None: write(_filter(_v))
        # 
        write('''#if   defined(CBLAS_MKL)
  #include <mkl.h>
#elif defined(CBLAS_VECLIB)
  #include <Accelerate/Accelerate.h>
#elif defined(CBLAS_ATLAS)
''')
        #  ATLAS CBLAS usually isn't wrapped by an extern "C" block, so we need to.
        write('''  extern "C" {
    #include <cblas.h>
  }
#elif defined(CBLAS_GSL)
  #include <gsl/gsl_cblas.h>
#endif
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def mainBegin(self, dict, **KWS):



        ## CHEETAH: generated from @def mainBegin($dict) at line 52, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write('''
''')
        if 'mpi' in VFFSL(SL,"simulationBuildVariant",True): # generated from line 55, col 3
            write('''#if defined(CBLAS_VECLIB)
// We are using MPI. If we let vecLib spawn threads then overall performance will suffer
  setenv("VECLIB_MAXIMUM_THREADS", "1", 1);
#endif
''')
        # 
        for dimName, basisDict in VFN(VFFSL(SL,"basisMap",True),"items",False)(): # generated from line 62, col 3
            for field in [field for field in VFFSL(SL,"fields",True) if field.hasDimensionName(dimName)]: # generated from line 63, col 5
                if field == VFFSL(SL,"geometry",True): # generated from line 64, col 7
                    continue
                for (fieldDimRep, geometryDimRep) in zip(field.dimensionWithName(dimName).representations, VFN(VFN(VFFSL(SL,"geometry",True),"dimensionWithName",False)(dimName),"representations",True)): # generated from line 67, col 7
                    if not fieldDimRep or not isinstance(fieldDimRep, NonUniformDimensionRepresentation) or geometryDimRep.arrayName == fieldDimRep.arrayName: # generated from line 68, col 9
                        continue
                    if geometryDimRep.runtimeLattice == fieldDimRep.runtimeLattice: # generated from line 71, col 9
                        write('''memcpy(''')
                        _v = VFFSL(SL,"fieldDimRep.arrayName",True) # '${fieldDimRep.arrayName}' on line 72, col 8
                        if _v is not None: write(_filter(_v, rawExpr='${fieldDimRep.arrayName}')) # from line 72, col 8.
                        write(''', ''')
                        _v = VFFSL(SL,"geometryDimRep.arrayName",True) # '${geometryDimRep.arrayName}' on line 72, col 34
                        if _v is not None: write(_filter(_v, rawExpr='${geometryDimRep.arrayName}')) # from line 72, col 34.
                        write(''', sizeof(real)*''')
                        _v = VFFSL(SL,"geometryDimRep.globalLattice",True) # '${geometryDimRep.globalLattice}' on line 72, col 76
                        if _v is not None: write(_filter(_v, rawExpr='${geometryDimRep.globalLattice}')) # from line 72, col 76.
                        write(''');
memcpy(''')
                        _v = VFFSL(SL,"fieldDimRep.stepSizeArrayName",True) # '${fieldDimRep.stepSizeArrayName}' on line 73, col 8
                        if _v is not None: write(_filter(_v, rawExpr='${fieldDimRep.stepSizeArrayName}')) # from line 73, col 8.
                        write(''', ''')
                        _v = VFFSL(SL,"geometryDimRep.stepSizeArrayName",True) # '${geometryDimRep.stepSizeArrayName}' on line 73, col 42
                        if _v is not None: write(_filter(_v, rawExpr='${geometryDimRep.stepSizeArrayName}')) # from line 73, col 42.
                        write(''', sizeof(real) * ''')
                        _v = VFFSL(SL,"geometryDimRep.globalLattice",True) # '${geometryDimRep.globalLattice}' on line 73, col 94
                        if _v is not None: write(_filter(_v, rawExpr='${geometryDimRep.globalLattice}')) # from line 73, col 94.
                        write(''');
''')
                    else: # generated from line 74, col 9
                        write('''for (long _i0=0; _i0 < ''')
                        _v = VFFSL(SL,"fieldDimRep.globalLattice",True) # '$fieldDimRep.globalLattice' on line 75, col 24
                        if _v is not None: write(_filter(_v, rawExpr='$fieldDimRep.globalLattice')) # from line 75, col 24.
                        write('''; _i0++) {
  ''')
                        _v = VFFSL(SL,"fieldDimRep.arrayName",True) # '${fieldDimRep.arrayName}' on line 76, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldDimRep.arrayName}')) # from line 76, col 3.
                        write('''[_i0] = ''')
                        _v = VFFSL(SL,"geometryDimRep.arrayName",True) # '${geometryDimRep.arrayName}' on line 76, col 35
                        if _v is not None: write(_filter(_v, rawExpr='${geometryDimRep.arrayName}')) # from line 76, col 35.
                        write('''[_i0 * (''')
                        _v = VFFSL(SL,"geometryDimRep.globalLattice",True) # '$geometryDimRep.globalLattice' on line 76, col 70
                        if _v is not None: write(_filter(_v, rawExpr='$geometryDimRep.globalLattice')) # from line 76, col 70.
                        write(''' / ''')
                        _v = VFFSL(SL,"fieldDimRep.globalLattice",True) # '$fieldDimRep.globalLattice' on line 76, col 102
                        if _v is not None: write(_filter(_v, rawExpr='$fieldDimRep.globalLattice')) # from line 76, col 102.
                        write(''')];
  ''')
                        _v = VFFSL(SL,"fieldDimRep.stepSizeArrayName",True) # '${fieldDimRep.stepSizeArrayName}' on line 77, col 3
                        if _v is not None: write(_filter(_v, rawExpr='${fieldDimRep.stepSizeArrayName}')) # from line 77, col 3.
                        write('''[_i0] = ''')
                        _v = VFFSL(SL,"geometryDimRep.stepSizeArrayName",True) # '${geometryDimRep.stepSizeArrayName}' on line 77, col 43
                        if _v is not None: write(_filter(_v, rawExpr='${geometryDimRep.stepSizeArrayName}')) # from line 77, col 43.
                        write('''[_i0 * (''')
                        _v = VFFSL(SL,"geometryDimRep.globalLattice",True) # '$geometryDimRep.globalLattice' on line 77, col 86
                        if _v is not None: write(_filter(_v, rawExpr='$geometryDimRep.globalLattice')) # from line 77, col 86.
                        write(''' / ''')
                        _v = VFFSL(SL,"fieldDimRep.globalLattice",True) # '$fieldDimRep.globalLattice' on line 77, col 118
                        if _v is not None: write(_filter(_v, rawExpr='$fieldDimRep.globalLattice')) # from line 77, col 118.
                        write(''')];
}
''')
            write('''
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
''')
        # 
        # MMT.tmpl
        # 
        # Created by Graham Dennis on 2008-12-12.
        # 
        # Copyright (c) 2008-2012, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write('''





''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    uselib = ['cblas']

    _mainCheetahMethod_for_MMT = 'writeBody'

## END CLASS DEFINITION

if not hasattr(MMT, '_initCheetahAttributes'):
    templateAPIClass = getattr(MMT,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(MMT)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=MMT()).run()


