
package ONVIF::Media::Elements::MetadataConfiguration;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/schema' }

__PACKAGE__->__set_name('MetadataConfiguration');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();
use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    ONVIF::Media::Types::MetadataConfiguration
);

}

1;


=pod

=head1 NAME

ONVIF::Media::Elements::MetadataConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
MetadataConfiguration from the namespace http://www.onvif.org/ver10/schema.







=head1 METHODS

=head2 new

 my $element = ONVIF::Media::Elements::MetadataConfiguration->new($data);

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::MetadataConfiguration
   PTZStatus =>  { # ONVIF::Media::Types::PTZFilter
     Status =>  $some_value, # boolean
     Position =>  $some_value, # boolean
   },
   Analytics =>  $some_value, # boolean
   Multicast =>  { # ONVIF::Media::Types::MulticastConfiguration
     Address =>  { # ONVIF::Media::Types::IPAddress
       Type => $some_value, # IPType
       IPv4Address => $some_value, # IPv4Address
       IPv6Address => $some_value, # IPv6Address
     },
     Port =>  $some_value, # int
     TTL =>  $some_value, # int
     AutoStart =>  $some_value, # boolean
   },
   SessionTimeout =>  $some_value, # duration
   AnalyticsEngineConfiguration =>  { # ONVIF::Media::Types::AnalyticsEngineConfiguration
     AnalyticsModule =>  { # ONVIF::Media::Types::Config
       Parameters =>  { # ONVIF::Media::Types::ItemList
         SimpleItem => ,
         ElementItem =>  {
         },
         Extension =>  { # ONVIF::Media::Types::ItemListExtension
         },
       },
     },
     Extension =>  { # ONVIF::Media::Types::AnalyticsEngineConfigurationExtension
     },
   },
   Extension =>  { # ONVIF::Media::Types::MetadataConfigurationExtension
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

