# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.


# Copyright (c) 2019-2020, NVIDIA CORPORATION. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#  * Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#  * Neither the name of NVIDIA CORPORATION nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.



from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _NvRules
else:
    import _NvRules

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



def require_metrics(handle, metrics):
    ev = get_evaluator(handle)
    for metric in metrics:
        ev.require_metric(metric)

def require_rules(handle, rules):
    ev = get_evaluator(handle)
    for rule in rules:
        ev.require_rule(rule)

def metric_instances(metric):
    instances = []

    for idx in range(metric.num_instances()):
        kind = metric.kind(idx)
        if (kind == IMetric.ValueKind_FLOAT) or (kind == IMetric.ValueKind_DOUBLE):
            instances.append(metric.as_double(idx))
        elif (kind == IMetric.ValueKind_UINT64) or (kind == IMetric.ValueKind_UINT32):
            instances.append(metric.as_uint64(idx))
        else:
            instances.append(metric.as_string(idx))

    return instances


def get_context(h):
    r"""
    get_context(NV::Rules::ContextHandle h) -> IContext

    Parameters
    ----------
    h: NV::Rules::ContextHandle

    """
    return _NvRules.get_context(h)

def get_evaluator(h):
    r"""
    get_evaluator(NV::Rules::ContextHandle h) -> IEvaluator

    Parameters
    ----------
    h: NV::Rules::ContextHandle

    """
    return _NvRules.get_evaluator(h)

def raise_exception(h, msg):
    r"""
    raise_exception(IBaseContext h, char const * msg)

    Parameters
    ----------
    h: NV::Rules::IBaseContext *
    msg: char const *

    """
    return _NvRules.raise_exception(h, msg)
RuleKind_DEFAULT = _NvRules.RuleKind_DEFAULT

RuleKind_GUIDED = _NvRules.RuleKind_GUIDED

class IMetric(object):
    r"""Proxy of C++ NV::Rules::IMetric class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    ValueKind_UNKNOWN = _NvRules.IMetric_ValueKind_UNKNOWN
    
    ValueKind_ANY = _NvRules.IMetric_ValueKind_ANY
    
    ValueKind_STRING = _NvRules.IMetric_ValueKind_STRING
    
    ValueKind_FLOAT = _NvRules.IMetric_ValueKind_FLOAT
    
    ValueKind_DOUBLE = _NvRules.IMetric_ValueKind_DOUBLE
    
    ValueKind_UINT32 = _NvRules.IMetric_ValueKind_UINT32
    
    ValueKind_UINT64 = _NvRules.IMetric_ValueKind_UINT64
    
    __swig_destroy__ = _NvRules.delete_IMetric

    def name(self):
        r"""name(IMetric self) -> char const *"""
        return _NvRules.IMetric_name(self)

    def kind(self, *args):
        r"""
        kind(IMetric self) -> NV::Rules::IMetric::ValueKind
        kind(IMetric self, size_t instance) -> NV::Rules::IMetric::ValueKind

        Parameters
        ----------
        instance: size_t

        """
        return _NvRules.IMetric_kind(self, *args)

    def has_value(self, value_kind):
        r"""
        has_value(IMetric self, NV::Rules::IMetric::ValueKind value_kind) -> bool

        Parameters
        ----------
        value_kind: enum NV::Rules::IMetric::ValueKind

        """
        return _NvRules.IMetric_has_value(self, value_kind)

    def as_double(self, *args):
        r"""
        as_double(IMetric self) -> double
        as_double(IMetric self, size_t instance) -> double

        Parameters
        ----------
        instance: size_t

        """
        return _NvRules.IMetric_as_double(self, *args)

    def as_uint64(self, *args):
        r"""
        as_uint64(IMetric self) -> uint64_t
        as_uint64(IMetric self, size_t instance) -> uint64_t

        Parameters
        ----------
        instance: size_t

        """
        return _NvRules.IMetric_as_uint64(self, *args)

    def as_string(self, *args):
        r"""
        as_string(IMetric self) -> char const
        as_string(IMetric self, size_t instance) -> char const *

        Parameters
        ----------
        instance: size_t

        """
        return _NvRules.IMetric_as_string(self, *args)

    def num_instances(self):
        r"""num_instances(IMetric self) -> size_t"""
        return _NvRules.IMetric_num_instances(self)

    def has_correlation_ids(self):
        r"""has_correlation_ids(IMetric self) -> bool"""
        return _NvRules.IMetric_has_correlation_ids(self)

    def correlation_ids(self):
        r"""correlation_ids(IMetric self) -> IMetric"""
        return _NvRules.IMetric_correlation_ids(self)

# Register IMetric in _NvRules:
_NvRules.IMetric_swigregister(IMetric)

class ISourceInfo(object):
    r"""Proxy of C++ NV::Rules::ISourceInfo class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_ISourceInfo

    def file_name(self):
        r"""file_name(ISourceInfo self) -> char const *"""
        return _NvRules.ISourceInfo_file_name(self)

    def line(self):
        r"""line(ISourceInfo self) -> uint32_t"""
        return _NvRules.ISourceInfo_line(self)

# Register ISourceInfo in _NvRules:
_NvRules.ISourceInfo_swigregister(ISourceInfo)

class IAction(object):
    r"""Proxy of C++ NV::Rules::IAction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IAction

    def name(self):
        r"""name(IAction self) -> char const *"""
        return _NvRules.IAction_name(self)

    def metric_by_name(self, metric_name):
        r"""
        metric_by_name(IAction self, char const * metric_name) -> IMetric

        Parameters
        ----------
        metric_name: char const *

        """
        return _NvRules.IAction_metric_by_name(self, metric_name)

    def add_integer_metric(self, value_name, value_kind, value):
        r"""
        add_integer_metric(IAction self, char const * value_name, NV::Rules::IMetric::ValueKind value_kind, uint64_t value) -> IMetric

        Parameters
        ----------
        value_name: char const *
        value_kind: enum NV::Rules::IMetric::ValueKind
        value: uint64_t

        """
        return _NvRules.IAction_add_integer_metric(self, value_name, value_kind, value)

    def add_double_metric(self, value_name, value_kind, value):
        r"""
        add_double_metric(IAction self, char const * value_name, NV::Rules::IMetric::ValueKind value_kind, double value) -> IMetric

        Parameters
        ----------
        value_name: char const *
        value_kind: enum NV::Rules::IMetric::ValueKind
        value: double

        """
        return _NvRules.IAction_add_double_metric(self, value_name, value_kind, value)

    def add_string_metric(self, value_name, value_kind, value):
        r"""
        add_string_metric(IAction self, char const * value_name, NV::Rules::IMetric::ValueKind value_kind, char const * value) -> IMetric

        Parameters
        ----------
        value_name: char const *
        value_kind: enum NV::Rules::IMetric::ValueKind
        value: char const *

        """
        return _NvRules.IAction_add_string_metric(self, value_name, value_kind, value)

    def source_info(self, address):
        r"""
        source_info(IAction self, uint64_t address) -> ISourceInfo

        Parameters
        ----------
        address: uint64_t

        """
        return _NvRules.IAction_source_info(self, address)

# Register IAction in _NvRules:
_NvRules.IAction_swigregister(IAction)

class IRange(object):
    r"""Proxy of C++ NV::Rules::IRange class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IRange

    def num_actions(self):
        r"""num_actions(IRange self) -> size_t"""
        return _NvRules.IRange_num_actions(self)

    def action_by_idx(self, idx):
        r"""
        action_by_idx(IRange self, size_t idx) -> IAction

        Parameters
        ----------
        idx: size_t

        """
        return _NvRules.IRange_action_by_idx(self, idx)

# Register IRange in _NvRules:
_NvRules.IRange_swigregister(IRange)

class IFrontend(object):
    r"""Proxy of C++ NV::Rules::IFrontend class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    MsgType_MSG_NONE = _NvRules.IFrontend_MsgType_MSG_NONE
    
    MsgType_MSG_OK = _NvRules.IFrontend_MsgType_MSG_OK
    
    MsgType_MSG_WARNING = _NvRules.IFrontend_MsgType_MSG_WARNING
    
    MsgType_MSG_ERROR = _NvRules.IFrontend_MsgType_MSG_ERROR
    
    __swig_destroy__ = _NvRules.delete_IFrontend

    def message(self, *args):
        r"""
        message(IFrontend self, char const * str)

        Parameters
        ----------
        str: char const *

        message(IFrontend self, NV::Rules::IFrontend::MsgType type, char const * str)

        Parameters
        ----------
        type: enum NV::Rules::IFrontend::MsgType
        str: char const *

        """
        return _NvRules.IFrontend_message(self, *args)

    def load_chart_from_file(self, filename):
        r"""
        load_chart_from_file(IFrontend self, char const * filename)

        Parameters
        ----------
        filename: char const *

        """
        return _NvRules.IFrontend_load_chart_from_file(self, filename)

# Register IFrontend in _NvRules:
_NvRules.IFrontend_swigregister(IFrontend)

class IBaseContext(object):
    r"""Proxy of C++ NV::Rules::IBaseContext class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IBaseContext

    def handle_exception(self, msg):
        r"""
        handle_exception(IBaseContext self, char const * msg) -> bool

        Parameters
        ----------
        msg: char const *

        """
        return _NvRules.IBaseContext_handle_exception(self, msg)

# Register IBaseContext in _NvRules:
_NvRules.IBaseContext_swigregister(IBaseContext)

class IController(object):
    r"""Proxy of C++ NV::Rules::IController class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IController

    def propose_rule(self, rule):
        r"""
        propose_rule(IController self, char const * rule)

        Parameters
        ----------
        rule: char const *

        """
        return _NvRules.IController_propose_rule(self, rule)

# Register IController in _NvRules:
_NvRules.IController_swigregister(IController)

class IEvaluator(IBaseContext):
    r"""Proxy of C++ NV::Rules::IEvaluator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IEvaluator

    def require_metric(self, metric):
        r"""
        require_metric(IEvaluator self, char const * metric)

        Parameters
        ----------
        metric: char const *

        """
        return _NvRules.IEvaluator_require_metric(self, metric)

    def require_rule(self, rule):
        r"""
        require_rule(IEvaluator self, char const * rule)

        Parameters
        ----------
        rule: char const *

        """
        return _NvRules.IEvaluator_require_rule(self, rule)

# Register IEvaluator in _NvRules:
_NvRules.IEvaluator_swigregister(IEvaluator)

class IContext(IBaseContext):
    r"""Proxy of C++ NV::Rules::IContext class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IContext

    def controller(self):
        r"""controller(IContext self) -> IController"""
        return _NvRules.IContext_controller(self)

    def frontend(self):
        r"""frontend(IContext self) -> IFrontend"""
        return _NvRules.IContext_frontend(self)

    def num_ranges(self):
        r"""num_ranges(IContext self) -> size_t"""
        return _NvRules.IContext_num_ranges(self)

    def range_by_idx(self, idx):
        r"""
        range_by_idx(IContext self, size_t idx) -> IRange

        Parameters
        ----------
        idx: size_t

        """
        return _NvRules.IContext_range_by_idx(self, idx)

# Register IContext in _NvRules:
_NvRules.IContext_swigregister(IContext)



